/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementParameterMapping;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.scostore.AbstractListStore;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.store.rdbms.scostore.FKListStoreSpecialization;
import org.datanucleus.store.rdbms.scostore.RDBMSFKListStoreSpecialization;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSFKListStore
extends AbstractListStore {
    private final int ownerFieldNumber;
    private String iteratorStmtLocked = null;
    private String iteratorStmtUnlocked = null;
    private StatementClassMapping iteratorMappingDef = null;
    private StatementParameterMapping iteratorMappingParams = null;

    public RDBMSFKListStore(AbstractMemberMetaData mmd, MappedStoreManager storeMgr, ClassLoaderResolver clr) {
        super((StoreManager)storeMgr, clr, new RDBMSFKListStoreSpecialization(LOCALISER, clr, (RDBMSStoreManager)storeMgr));
        this.setOwner(mmd, clr);
        CollectionMetaData colmd = mmd.getCollection();
        if (colmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056001", (Object)mmd.getFullFieldName()));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType((Class)element_class)) {
            this.emd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
            if (this.emd != null) {
                this.elementType = this.emd.getFullClassName();
            }
        } else {
            this.emd = storeMgr.getNucleusContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new NucleusUserException(LOCALISER.msg("056003", (Object)element_class.getName(), (Object)mmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo != null && this.elementInfo.length > 1) {
            throw new NucleusUserException(LOCALISER.msg("056031", (Object)this.ownerMemberMetaData.getFullFieldName()));
        }
        if (this.elementInfo == null || this.elementInfo.length == 0) {
            throw new NucleusUserException(LOCALISER.msg("056075", (Object)this.ownerMemberMetaData.getFullFieldName(), (Object)this.elementType));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIdMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        String mappedByFieldName = mmd.getMappedBy();
        if (mappedByFieldName != null) {
            AbstractMemberMetaData eofmd = this.emd.getMetaDataForMember(mappedByFieldName);
            if (eofmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056024", (Object)mmd.getFullFieldName(), (Object)mappedByFieldName, (Object)element_class.getName()));
            }
            if (!clr.isAssignableFrom(eofmd.getType(), mmd.getAbstractClassMetaData().getFullClassName())) {
                throw new NucleusUserException(LOCALISER.msg("056025", (Object)mmd.getFullFieldName(), (Object)eofmd.getFullFieldName(), (Object)eofmd.getTypeName(), (Object)mmd.getAbstractClassMetaData().getFullClassName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerFieldNumber = this.emd.getAbsolutePositionOfMember(ownerFieldName);
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getMemberMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056029", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.elementType, (Object)ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new NucleusUserException(LOCALISER.msg("056026", (Object)ownerFieldName, (Object)this.elementType, (Object)eofmd.getTypeName(), (Object)mmd.getClassName()));
            }
        } else {
            this.ownerFieldNumber = -1;
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 5);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056030", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.elementType));
            }
        }
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 4);
        if (mmd.getOrderMetaData() != null && !mmd.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (this.orderMapping == null && this.indexedList) {
            throw new NucleusUserException(LOCALISER.msg("056041", (Object)mmd.getAbstractClassMetaData().getFullClassName(), (Object)mmd.getName(), (Object)this.elementType));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(mmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = mmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = mmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (mmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.containerTable) {
            this.containerTable = this.ownerMapping.getDatastoreContainer();
        }
    }

    private FKListStoreSpecialization getSpecialization() {
        return (FKListStoreSpecialization)this.specialization;
    }

    public Object set(ObjectProvider sm, int index, Object element, boolean allowDependentField) {
        this.validateElementForWriting(sm, element, -1);
        Object o = this.get(sm, index);
        return this.getSpecialization().set(sm, index, element, allowDependentField, this, o);
    }

    private boolean updateElementFk(ObjectProvider sm, Object element, Object owner, int index) {
        if (element == null) {
            return false;
        }
        ExecutionContext ec = sm.getExecutionContext();
        return this.getSpecialization().updateElementFk(sm, element, owner, index, ec, this);
    }

    public void update(ObjectProvider sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        ArrayList existing = new ArrayList();
        Iterator elemIter = this.iterator(sm);
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (((Object)existing).equals(coll)) {
            return;
        }
        this.clear(sm);
        this.addAll(sm, coll, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalAdd(ObjectProvider sm, int startAt, boolean atEnd, Collection c, int size) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int currentListSize = 0;
        currentListSize = size < 0 ? this.size(sm) : size;
        boolean shiftingElements = true;
        if (atEnd || startAt == currentListSize) {
            shiftingElements = false;
            startAt = currentListSize;
        }
        boolean elementsNeedPositioning = false;
        int position = startAt;
        Iterator elementIter = c.iterator();
        while (elementIter.hasNext()) {
            boolean inserted;
            if (shiftingElements) {
                position = -1;
            }
            if (!(inserted = this.validateElementForWriting(sm, elementIter.next(), position)) || shiftingElements) {
                elementsNeedPositioning = true;
            }
            if (shiftingElements) continue;
            ++position;
        }
        if (shiftingElements) {
            try {
                int shift = c.size();
                ExecutionContext ec = sm.getExecutionContext();
                ManagedConnection mconn = this.storeMgr.getConnection(ec);
                try {
                    for (int i = currentListSize - 1; i >= startAt; --i) {
                        this.getSpecialization().internalShift(sm, mconn, false, i, shift, true, this);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (MappedDatastoreException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)e.getMessage()), e.getCause());
            }
        }
        if (shiftingElements || elementsNeedPositioning) {
            for (Object element : c) {
                this.updateElementFk(sm, element, sm.getObject(), startAt);
                ++startAt;
            }
        }
        return true;
    }

    protected boolean internalRemove(ObjectProvider sm, Object element, int size) {
        if (this.indexedList) {
            int index = this.indexOf(sm, element);
            if (index == -1) {
                return false;
            }
            this.removeAt(sm, index, size);
        } else if (this.ownerMapping.isNullable()) {
            ExecutionContext ec = sm.getExecutionContext();
            ObjectProvider elementSM = ec.findObjectProvider(element);
            if (this.relationType == 4) {
                elementSM.replaceFieldMakeDirty(this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr)[0].getAbsoluteFieldNumber(), null);
                if (sm.getExecutionContext().isFlushing()) {
                    elementSM.flush();
                }
            } else {
                this.updateElementFk(sm, element, null, -1);
            }
        } else {
            sm.getExecutionContext().deleteObjectInternal(element);
        }
        return true;
    }

    protected void manageRemovalOfElement(ObjectProvider ownerSM, Object element) {
    }

    protected void removeAt(ObjectProvider sm, int index, int size) {
        if (!this.indexedList) {
            throw new NucleusUserException("Cannot remove an element from a particular position with an ordered list since no indexes exist");
        }
        boolean nullify = false;
        if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056043"));
            nullify = true;
        } else {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056042"));
        }
        this.getSpecialization().removeAt(sm, index, size, nullify, this);
    }

    public void clear(ObjectProvider ownerSM) {
        boolean deleteElements = false;
        ExecutionContext ec = ownerSM.getExecutionContext();
        boolean dependent = this.ownerMemberMetaData.getCollection().isDependentElement();
        if (this.ownerMemberMetaData.isCascadeRemoveOrphans()) {
            dependent = true;
        }
        if (dependent) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056034"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping == null) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056036"));
            deleteElements = false;
        } else if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056036"));
            deleteElements = false;
        } else {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056035"));
            deleteElements = true;
        }
        if (deleteElements) {
            Iterator elementsIter = this.iterator(ownerSM);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    if (ec.getApiAdapter().isPersistable(element) && ec.getApiAdapter().isDeleted(element)) {
                        ObjectProvider objSM = ec.findObjectProvider(element);
                        objSM.flush();
                        continue;
                    }
                    ec.deleteObjectInternal(element);
                }
            }
        } else {
            this.getSpecialization().clearWithoutDelete(ec, ownerSM, this);
        }
    }

    protected boolean validateElementForWriting(final ObjectProvider sm, Object element, final int index) {
        final Object newOwner = sm.getObject();
        boolean inserted = super.validateElementForWriting(sm.getExecutionContext(), element, new FieldValues(){

            public void fetchFields(ObjectProvider esm) {
                AbstractClassMetaData[] managingCmds;
                boolean isPersistentInterface = RDBMSFKListStore.this.storeMgr.getNucleusContext().getMetaDataManager().isPersistentInterface(RDBMSFKListStore.this.elementType);
                DatastoreClass elementTable = null;
                elementTable = isPersistentInterface ? RDBMSFKListStore.this.storeMgr.getDatastoreClass(RDBMSFKListStore.this.storeMgr.getNucleusContext().getMetaDataManager().getImplementationNameForPersistentInterface(RDBMSFKListStore.this.elementType), RDBMSFKListStore.this.clr) : RDBMSFKListStore.this.storeMgr.getDatastoreClass(RDBMSFKListStore.this.elementType, RDBMSFKListStore.this.clr);
                if (elementTable == null && (managingCmds = RDBMSFKListStore.this.storeMgr.getClassesManagingTableForClass(RDBMSFKListStore.this.emd, RDBMSFKListStore.this.clr)) != null && managingCmds.length > 0) {
                    for (int i = 0; i < managingCmds.length; ++i) {
                        Class tblCls = RDBMSFKListStore.this.clr.classForName(managingCmds[i].getFullClassName());
                        if (!tblCls.isAssignableFrom(esm.getObject().getClass())) continue;
                        elementTable = RDBMSFKListStore.this.storeMgr.getDatastoreClass(managingCmds[i].getFullClassName(), RDBMSFKListStore.this.clr);
                        break;
                    }
                }
                if (elementTable != null) {
                    JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(RDBMSFKListStore.this.ownerMemberMetaData, 5);
                    if (externalFKMapping != null) {
                        esm.setAssociatedValue((Object)externalFKMapping, sm.getObject());
                    }
                    if (RDBMSFKListStore.this.relationDiscriminatorMapping != null) {
                        esm.setAssociatedValue((Object)RDBMSFKListStore.this.relationDiscriminatorMapping, (Object)RDBMSFKListStore.this.relationDiscriminatorValue);
                    }
                    if (RDBMSFKListStore.this.orderMapping != null && index >= 0) {
                        if (RDBMSFKListStore.this.ownerMemberMetaData.getOrderMetaData() != null && RDBMSFKListStore.this.ownerMemberMetaData.getOrderMetaData().getMappedBy() != null) {
                            Number indexValue = null;
                            indexValue = RDBMSFKListStore.this.orderMapping.getMemberMetaData().getTypeName().equals(ClassNameConstants.JAVA_LANG_LONG) || RDBMSFKListStore.this.orderMapping.getMemberMetaData().getTypeName().equals(ClassNameConstants.LONG) ? (Number)Long.valueOf(index) : (Number)index;
                            esm.replaceFieldMakeDirty(RDBMSFKListStore.this.orderMapping.getMemberMetaData().getAbsoluteFieldNumber(), (Object)indexValue);
                        } else {
                            esm.setAssociatedValue((Object)RDBMSFKListStore.this.orderMapping, (Object)index);
                        }
                    }
                }
                if (RDBMSFKListStore.this.ownerFieldNumber >= 0) {
                    Object currentOwner = esm.provideField(RDBMSFKListStore.this.ownerFieldNumber);
                    if (currentOwner == null) {
                        NucleusLogger.PERSISTENCE.info((Object)BaseContainerStore.LOCALISER.msg("056037", (Object)sm.toPrintableID(), (Object)RDBMSFKListStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)esm.getObject())));
                        esm.replaceFieldMakeDirty(RDBMSFKListStore.this.ownerFieldNumber, newOwner);
                    } else if (currentOwner != newOwner && sm.getReferencedPC() == null) {
                        throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056038", (Object)sm.toPrintableID(), (Object)RDBMSFKListStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)esm.getObject()), (Object)StringUtils.toJVMIDString((Object)currentOwner)));
                    }
                }
            }

            public void fetchNonLoadedFields(ObjectProvider sm2) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        });
        return inserted;
    }

    /*
     * Exception decompiling
     */
    protected ListIterator listIterator(ObjectProvider ownerSM, int startIdx, int endIdx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected SQLStatement getSQLStatementForIterator(ObjectProvider ownerSM, int startIdx, int endIdx, StatementClassMapping resultMapping, StatementParameterMapping paramMapping) {
        SQLExpression[] orderExprs;
        if (this.elementInfo == null || this.elementInfo.length == 0) {
            return null;
        }
        SQLStatement sqlStmt = null;
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.storeMgr;
        ClassLoaderResolver clr = ownerSM.getExecutionContext().getClassLoaderResolver();
        if (this.elementInfo.length == 1 && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            String elementType = this.ownerMemberMetaData.getCollection().getElementType();
            if (ClassUtils.isReferenceType((Class)clr.classForName(elementType))) {
                String[] clsNames = storeMgr.getNucleusContext().getMetaDataManager().getClassesImplementingInterface(elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                sqlStmt = new DiscriminatorStatementGenerator(storeMgr, clr, cls, true, null, null).getStatement();
            } else {
                sqlStmt = new DiscriminatorStatementGenerator(storeMgr, clr, clr.classForName(this.elementInfo[0].getClassName()), true, null, null).getStatement();
            }
            this.iterateUsingDiscriminator = true;
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, resultMapping, ownerSM.getExecutionContext().getFetchPlan(), sqlStmt.getPrimaryTable(), this.emd, 0);
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                Class elementCls = clr.classForName(this.elementInfo[i].getClassName());
                UnionStatementGenerator stmtGen = new UnionStatementGenerator(storeMgr, clr, elementCls, true, null, null);
                stmtGen.setOption("selectNucleusType");
                resultMapping.setNucleusTypeColumnName("NUCLEUS_TYPE");
                SQLStatement subStmt = stmtGen.getStatement();
                if (sqlStmt == null) {
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, resultMapping, ownerSM.getExecutionContext().getFetchPlan(), subStmt.getPrimaryTable(), this.emd, 0);
                } else {
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(subStmt, null, ownerSM.getExecutionContext().getFetchPlan(), subStmt.getPrimaryTable(), this.emd, 0);
                }
                if (sqlStmt == null) {
                    sqlStmt = subStmt;
                    continue;
                }
                sqlStmt.union(subStmt);
            }
        }
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            SQLTable distSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.relationDiscriminatorMapping);
            SQLExpression distExpr = exprFactory.newExpression(sqlStmt, distSqlTbl, this.relationDiscriminatorMapping);
            SQLExpression distVal = exprFactory.newLiteral(sqlStmt, this.relationDiscriminatorMapping, this.relationDiscriminatorValue);
            sqlStmt.whereAnd(distExpr.eq(distVal), true);
        }
        if (this.indexedList) {
            SQLExpression indexVal;
            SQLExpression indexExpr;
            boolean needsOrdering = true;
            if (startIdx == -1 && endIdx == -1) {
                indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, 0);
                sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
            } else if (startIdx >= 0 && endIdx == startIdx) {
                needsOrdering = false;
                indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, startIdx);
                sqlStmt.whereAnd(indexExpr.eq(indexVal), true);
            } else {
                if (startIdx >= 0) {
                    indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, startIdx);
                    sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
                } else {
                    indexExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    indexVal = exprFactory.newLiteral(sqlStmt, this.orderMapping, 0);
                    sqlStmt.whereAnd(indexExpr.ge(indexVal), true);
                }
                if (endIdx >= 0) {
                    SQLExpression indexExpr2 = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                    SQLExpression indexVal2 = exprFactory.newLiteral(sqlStmt, this.orderMapping, endIdx);
                    sqlStmt.whereAnd(indexExpr2.lt(indexVal2), true);
                }
            }
            if (needsOrdering) {
                SQLTable orderSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.orderMapping);
                orderExprs = new SQLExpression[this.orderMapping.getNumberOfDatastoreMappings()];
                boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreMappings()];
                orderExprs[0] = exprFactory.newExpression(sqlStmt, orderSqlTbl, this.orderMapping);
                sqlStmt.setOrdering(orderExprs, descendingOrder);
            }
        } else {
            DatastoreClass elementTbl = this.elementInfo[0].getDatastoreClass();
            OrderMetaData.FieldOrder[] orderComponents = this.ownerMemberMetaData.getOrderMetaData().getFieldOrders();
            orderExprs = new SQLExpression[orderComponents.length];
            boolean[] orderDirs = new boolean[orderComponents.length];
            for (int i = 0; i < orderComponents.length; ++i) {
                String fieldName = orderComponents[i].getFieldName();
                JavaTypeMapping fieldMapping = elementTbl.getMemberMapping(this.elementInfo[0].getAbstractClassMetaData().getMetaDataForMember(fieldName));
                orderDirs[i] = !orderComponents[i].isForward();
                SQLTable fieldSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), fieldMapping);
                orderExprs[i] = exprFactory.newExpression(sqlStmt, fieldSqlTbl, fieldMapping);
            }
            sqlStmt.setOrdering(orderExprs, orderDirs);
        }
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < this.ownerMapping.getNumberOfDatastoreMappings(); ++k) {
                    paramPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(paramPositions);
            }
        } else {
            int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
            for (int k = 0; k < this.ownerMapping.getNumberOfDatastoreMappings(); ++k) {
                paramPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(paramPositions);
        }
        paramMapping.addMappingForParameter("owner", ownerIdx);
        return sqlStmt;
    }
}

