/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.exceptions.NullValueException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.StringUtils;

public class SmallIntRDBMSMapping
extends RDBMSMapping {
    protected SmallIntRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public SmallIntRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            Object[] validValues;
            this.column.checkPrimitive();
            JavaTypeMapping m = this.getJavaTypeMapping();
            if (m instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)m).getValidValues(0)) != null) {
                String constraints = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
            if (this.getJavaTypeMapping().getJavaType() == Boolean.class) {
                StringBuffer constraints = new StringBuffer("CHECK (" + this.column.getIdentifier() + " IN (0,1)");
                if (this.column.isNullable()) {
                    constraints.append(" OR " + this.column.getIdentifier() + " IS NULL");
                }
                constraints.append(')');
                this.column.setConstraints(constraints.toString());
            }
        }
        this.initTypeInfo();
    }

    public boolean isIntegerBased() {
        return true;
    }

    public SQLTypeInfo getTypeInfo() {
        return this.storeMgr.getSQLTypeInfoForJDBCType(5);
    }

    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setInt(param, value ? 1 : 0);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"boolean", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public boolean getBoolean(Object rs, int param) {
        boolean value;
        try {
            int intValue = ((ResultSet)rs).getInt(param);
            if (intValue == 0) {
                value = false;
            } else if (intValue == 1) {
                value = true;
            } else {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055006", (Object)"Types.SMALLINT", (Object)("" + intValue)));
            }
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Boolean", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setShort(Object ps, int param, short value) {
        try {
            ((PreparedStatement)ps).setShort(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"short", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public short getShort(Object rs, int param) {
        short value;
        try {
            value = ((ResultSet)rs).getShort(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"short", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"int", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"int", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setLong(Object ps, int param, long value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"short", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public long getLong(Object rs, int param) {
        long value;
        try {
            value = ((ResultSet)rs).getShort(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"short", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setByte(Object ps, int param, byte value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"byte", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public byte getByte(Object rs, int param) {
        byte value;
        try {
            value = ((ResultSet)rs).getByte(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"byte", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        block12: {
            try {
                if (value == null) {
                    if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null && !StringUtils.isWhitespace((String)this.column.getDefaultValue().toString())) {
                        ((PreparedStatement)ps).setInt(param, Integer.valueOf(this.column.getDefaultValue().toString()));
                    } else {
                        ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                    }
                    break block12;
                }
                Class<?> type = value.getClass();
                if (type == Integer.class) {
                    ((PreparedStatement)ps).setShort(param, ((Integer)value).shortValue());
                    break block12;
                }
                if (type == Short.class) {
                    ((PreparedStatement)ps).setShort(param, (Short)value);
                    break block12;
                }
                if (type == Byte.class) {
                    ((PreparedStatement)ps).setShort(param, ((Byte)value).shortValue());
                    break block12;
                }
                if (type == Character.class) {
                    ((PreparedStatement)ps).setShort(param, (short)((Character)value).charValue());
                    break block12;
                }
                if (type == Boolean.class) {
                    ((PreparedStatement)ps).setShort(param, (short)((Boolean)value != false ? 1 : 0));
                    break block12;
                }
                if (type == BigInteger.class) {
                    ((PreparedStatement)ps).setShort(param, ((BigInteger)value).shortValue());
                    break block12;
                }
                if (type == Long.class) {
                    ((PreparedStatement)ps).setShort(param, ((Long)value).shortValue());
                    break block12;
                }
                throw new NucleusException("SmallIntRDBMSMapping.setObject called for " + StringUtils.toJVMIDString((Object)value) + " but not supported");
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
    }

    public Object getObject(Object rs, int param) {
        Comparable<Short> value;
        try {
            short d = ((ResultSet)rs).getShort(param);
            Class type = this.getJavaTypeMapping().getJavaType();
            value = type == Short.class ? (((ResultSet)rs).wasNull() ? null : Short.valueOf(d)) : (type == Integer.class ? (((ResultSet)rs).wasNull() ? null : Integer.valueOf(d)) : (type == Byte.class ? (((ResultSet)rs).wasNull() ? null : Byte.valueOf((byte)d)) : (type == BigInteger.class ? (((ResultSet)rs).wasNull() ? null : BigInteger.valueOf(d)) : (type == Boolean.class ? (Comparable<Boolean>)(((ResultSet)rs).wasNull() ? null : (d == 1 ? Boolean.TRUE : Boolean.FALSE)) : (Comparable<Boolean>)(((ResultSet)rs).wasNull() ? null : Short.valueOf(d))))));
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

