/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.ArrayExpression;
import org.datanucleus.query.expression.ClassExpression;
import org.datanucleus.query.expression.CreatorExpression;
import org.datanucleus.query.expression.DyadicExpression;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.InvokeExpression;
import org.datanucleus.query.expression.JoinExpression;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.query.expression.SubqueryExpression;
import org.datanucleus.query.expression.VariableExpression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementNewObjectMapping;
import org.datanucleus.store.mapped.StatementResultMapping;
import org.datanucleus.store.mapped.mapping.AbstractContainerMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.mapped.mapping.PersistableIdMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.StringMapping;
import org.datanucleus.store.mapped.mapping.TemporalMapping;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.query.QueryGenerator;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.CaseExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NewObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.ParameterLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.SubqueryExpressionComponent;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.ElementContainerTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryToSQLMapper
extends AbstractExpressionEvaluator
implements QueryGenerator {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    public static final String OPTION_CASE_INSENSITIVE = "CASE_INSENSITIVE";
    public static final String OPTION_EXPLICIT_JOINS = "EXPLICIT_JOINS";
    public static final String OPTION_BULK_UPDATE_VERSION = "BULK_UPDATE_VERSION";
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final QueryCompilation compilation;
    final Map parameters;
    Map<String, Object> parameterValueByName = null;
    Map<Integer, String> paramNameByPosition = null;
    int positionalParamNumber = -1;
    Map<String, Object> extensionsByName = null;
    final SQLStatement stmt;
    final StatementClassMapping resultDefinitionForClass;
    final StatementResultMapping resultDefinition;
    Map<Object, SQLExpression> expressionForParameter;
    final RDBMSStoreManager storeMgr;
    final FetchPlan fetchPlan;
    final SQLExpressionFactory exprFactory;
    ExecutionContext ec;
    ClassLoaderResolver clr;
    Imports importsDefinition = null;
    Map<String, Object> compileProperties = new HashMap<String, Object>();
    CompilationComponent compileComponent;
    Stack<SQLExpression> stack = new Stack();
    Map<String, SQLTableMapping> sqlTableByPrimary = new HashMap<String, SQLTableMapping>();
    Map<String, String> explicitJoinPrimaryByAlias = null;
    Map<String, JavaTypeMapping> paramMappingForName = new HashMap<String, JavaTypeMapping>();
    Set<String> options = new HashSet<String>();
    public QueryToSQLMapper parentMapper = null;
    SQLJoin.JoinType defaultJoinType = null;
    boolean precompilable = true;

    public QueryToSQLMapper(SQLStatement stmt, QueryCompilation compilation, Map parameters, StatementClassMapping resultDefForClass, StatementResultMapping resultDef, AbstractClassMetaData cmd, FetchPlan fetchPlan, ExecutionContext ec, Imports importsDefinition, Set<String> options, Map<String, Object> extensions) {
        this.parameters = parameters;
        this.compilation = compilation;
        this.stmt = stmt;
        this.resultDefinitionForClass = resultDefForClass;
        this.resultDefinition = resultDef;
        this.candidateAlias = compilation.getCandidateAlias();
        this.fetchPlan = fetchPlan;
        this.storeMgr = stmt.getRDBMSManager();
        this.exprFactory = stmt.getRDBMSManager().getSQLExpressionFactory();
        this.candidateCmd = cmd;
        this.ec = ec;
        this.clr = ec.getClassLoaderResolver();
        this.importsDefinition = importsDefinition;
        if (options != null) {
            this.options.addAll(options);
        }
        this.extensionsByName = extensions;
        this.stmt.setQueryGenerator(this);
        SQLTableMapping tblMapping = new SQLTableMapping(stmt.getPrimaryTable(), this.candidateCmd, stmt.getPrimaryTable().getTable().getIdMapping());
        this.setSQLTableMappingForAlias(this.candidateAlias, tblMapping);
    }

    void setDefaultJoinType(SQLJoin.JoinType joinType) {
        this.defaultJoinType = joinType;
    }

    void setParentMapper(QueryToSQLMapper parent) {
        this.parentMapper = parent;
    }

    @Override
    public String getQueryLanguage() {
        return this.compilation.getQueryLanguage();
    }

    @Override
    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    @Override
    public CompilationComponent getCompilationComponent() {
        return this.compileComponent;
    }

    @Override
    public ExecutionContext getObjectManager() {
        return this.ec;
    }

    @Override
    public Object getProperty(String name) {
        return this.compileProperties.get(name);
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    public Map<Integer, String> getParameterNameByPosition() {
        return this.paramNameByPosition;
    }

    public void compile() {
        this.compileFrom();
        this.compileFilter();
        if (this.compilation.getResultDistinct()) {
            this.stmt.setDistinct(true);
        } else if (!this.options.contains(OPTION_EXPLICIT_JOINS) && this.compilation.getExprResult() == null && this.stmt.getNumberOfTableGroups() > 1) {
            this.stmt.setDistinct(true);
        }
        this.compileResult();
        this.compileGrouping();
        this.compileHaving();
        this.compileOrdering();
        Collection symbols = this.compilation.getSymbolTable().getSymbolNames();
        Iterator symIter = symbols.iterator();
        while (symIter.hasNext()) {
            Symbol sym = this.compilation.getSymbolTable().getSymbol((String)symIter.next());
            if (sym.getType() != 2 || this.compilation.getCompilationForSubquery(sym.getQualifiedName()) != null || this.hasSQLTableMappingForAlias(sym.getQualifiedName())) continue;
            throw new QueryCompilerSyntaxException("Query has variable \"" + sym.getQualifiedName() + "\" which is not bound to the query");
        }
    }

    protected void compileFrom() {
        if (this.compilation.getExprFrom() != null) {
            this.compileComponent = CompilationComponent.FROM;
            Expression[] fromExprs = this.compilation.getExprFrom();
            for (int i = 0; i < fromExprs.length; ++i) {
                ClassExpression clsExpr = (ClassExpression)fromExprs[i];
                this.compileFromClassExpression(clsExpr);
            }
            this.compileComponent = null;
        }
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            if (QueryUtils.expressionHasOrOperator((Expression)this.compilation.getExprFilter())) {
                this.compileProperties.put("Filter.OR", true);
            }
            if (QueryUtils.expressionHasNotOperator((Expression)this.compilation.getExprFilter())) {
                this.compileProperties.put("Filter.NOT", true);
            }
            BooleanExpression filterExpr = (BooleanExpression)this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
            filterExpr = this.getBooleanExpressionForUseInFilter(filterExpr);
            this.stmt.whereAnd(filterExpr, true);
            this.compileComponent = null;
        }
    }

    protected void compileResult() {
        if (this.compilation.getExprUpdate() != null) {
            this.compileComponent = CompilationComponent.UPDATE;
            Expression[] updateExprs = this.compilation.getExprUpdate();
            SQLExpression[] updateSqlExprs = new SQLExpression[updateExprs.length];
            for (int i = 0; i < updateExprs.length; ++i) {
                DyadicExpression updateExpr = (DyadicExpression)updateExprs[i];
                SQLExpression leftSqlExpr = null;
                if (!(updateExpr.getLeft() instanceof PrimaryExpression)) {
                    throw new NucleusException("Dont currently support update clause containing left expression of type " + updateExpr.getLeft());
                }
                this.processPrimaryExpression((PrimaryExpression)updateExpr.getLeft());
                leftSqlExpr = this.stack.pop();
                SQLExpression rightSqlExpr = null;
                if (updateExpr.getRight() instanceof Literal) {
                    this.processLiteral((Literal)updateExpr.getRight());
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)updateExpr.getRight());
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)updateExpr.getRight());
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof DyadicExpression) {
                    updateExpr.getRight().evaluate((ExpressionEvaluator)this);
                    rightSqlExpr = this.stack.pop();
                } else if (updateExpr.getRight() instanceof org.datanucleus.query.expression.CaseExpression) {
                    updateExpr.getRight().evaluate((ExpressionEvaluator)this);
                    rightSqlExpr = this.stack.pop();
                } else {
                    throw new NucleusException("Dont currently support update clause containing right expression of type " + updateExpr.getRight());
                }
                if (leftSqlExpr == null || rightSqlExpr == null) continue;
                updateSqlExprs[i] = leftSqlExpr.eq(rightSqlExpr);
            }
            if (this.candidateCmd.hasVersionStrategy() && this.options.contains(OPTION_BULK_UPDATE_VERSION)) {
                BooleanExpression updateSqlExpr = null;
                ClassTable table = (ClassTable)this.stmt.getPrimaryTable().getTable();
                JavaTypeMapping verMapping = table.getVersionMapping(true);
                ClassTable verTable = table.getTableManagingMapping(verMapping);
                VersionMetaData vermd = this.candidateCmd.getVersionMetaData();
                if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                    SQLTable verSqlTbl = this.stmt.getTable(verTable, this.stmt.getPrimaryTable().getGroupName());
                    NumericExpression verExpr = new NumericExpression(this.stmt, verSqlTbl, verMapping);
                    SQLExpression incrExpr = ((SQLExpression)verExpr).add(new IntegerLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Integer.class, false), new Integer(1), null));
                    updateSqlExpr = ((SQLExpression)verExpr).eq(incrExpr);
                    SQLExpression[] oldArray = updateSqlExprs;
                    updateSqlExprs = new SQLExpression[oldArray.length + 1];
                    System.arraycopy(oldArray, 0, updateSqlExprs, 0, oldArray.length);
                    updateSqlExprs[oldArray.length] = updateSqlExpr;
                } else if (vermd.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                    SQLTable verSqlTbl = this.stmt.getTable(verTable, this.stmt.getPrimaryTable().getGroupName());
                    NumericExpression verExpr = new NumericExpression(this.stmt, verSqlTbl, verMapping);
                    Object newVersion = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), null);
                    JavaTypeMapping valMapping = this.stmt.getSQLExpressionFactory().getMappingForType(newVersion.getClass(), false);
                    TemporalLiteral valExpr = new TemporalLiteral(this.stmt, valMapping, newVersion, null);
                    updateSqlExpr = ((SQLExpression)verExpr).eq(valExpr);
                    SQLExpression[] oldArray = updateSqlExprs;
                    updateSqlExprs = new SQLExpression[oldArray.length + 1];
                    System.arraycopy(oldArray, 0, updateSqlExprs, 0, oldArray.length);
                    updateSqlExprs[oldArray.length] = updateSqlExpr;
                }
            }
            this.stmt.setUpdates(updateSqlExprs);
        } else if (this.compilation.getExprResult() != null) {
            this.compileComponent = CompilationComponent.RESULT;
            Expression[] resultExprs = this.compilation.getExprResult();
            for (int i = 0; i < resultExprs.length; ++i) {
                int[] cols;
                StatementMappingIndex idx;
                int[] cols2;
                SQLExpression sqlExpr;
                String alias = resultExprs[i].getAlias();
                if (resultExprs[i] instanceof InvokeExpression) {
                    this.processInvokeExpression((InvokeExpression)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    cols2 = this.stmt.select(sqlExpr, alias);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(cols2);
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof PrimaryExpression) {
                    StatementMappingIndex idx2;
                    PrimaryExpression primExpr = (PrimaryExpression)resultExprs[i];
                    if (primExpr.getId().equals(this.candidateAlias)) {
                        StatementClassMapping map = new StatementClassMapping(this.candidateCmd.getFullClassName(), null);
                        SQLStatementHelper.selectFetchPlanOfCandidateInStatement(this.stmt, map, this.candidateCmd, this.fetchPlan, 1);
                        this.resultDefinition.addMappingForResultExpression(i, map);
                        continue;
                    }
                    this.processPrimaryExpression(primExpr);
                    SQLExpression sqlExpr2 = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr2);
                    if (sqlExpr2 instanceof SQLLiteral) {
                        cols = this.stmt.select(sqlExpr2, alias);
                        idx2 = new StatementMappingIndex(sqlExpr2.getJavaTypeMapping());
                        idx2.setColumnPositions(cols);
                        if (alias != null) {
                            idx2.setColumnAlias(alias);
                        }
                        this.resultDefinition.addMappingForResultExpression(i, idx2);
                        continue;
                    }
                    cols = this.stmt.select(sqlExpr2.getSQLTable(), sqlExpr2.getJavaTypeMapping(), alias);
                    idx2 = new StatementMappingIndex(sqlExpr2.getJavaTypeMapping());
                    idx2.setColumnPositions(cols);
                    if (alias != null) {
                        idx2.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx2);
                    continue;
                }
                if (resultExprs[i] instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)resultExprs[i], true);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    cols2 = this.stmt.select(sqlExpr, alias);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(cols2);
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof VariableExpression) {
                    this.processVariableExpression((VariableExpression)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    if (sqlExpr instanceof UnboundExpression) {
                        this.processUnboundExpression((UnboundExpression)sqlExpr);
                        sqlExpr = this.stack.pop();
                        NucleusLogger.QUERY.debug((Object)">> QueryToSQL.exprResult variable was still unbound, so binding via cross-join");
                    }
                    StatementMappingIndex idx3 = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    cols = this.stmt.select(sqlExpr, alias);
                    idx3.setColumnPositions(cols);
                    if (alias != null) {
                        idx3.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx3);
                    continue;
                }
                if (resultExprs[i] instanceof Literal) {
                    this.processLiteral((Literal)resultExprs[i]);
                    sqlExpr = this.stack.pop();
                    this.validateExpressionForResult(sqlExpr);
                    cols2 = this.stmt.select(sqlExpr, alias);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(cols2);
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof CreatorExpression) {
                    this.processCreatorExpression((CreatorExpression)resultExprs[i]);
                    sqlExpr = (NewObjectExpression)this.stack.pop();
                    StatementNewObjectMapping stmtMap = this.getStatementMappingForNewObjectExpression((NewObjectExpression)sqlExpr);
                    this.resultDefinition.addMappingForResultExpression(i, stmtMap);
                    continue;
                }
                if (resultExprs[i] instanceof DyadicExpression) {
                    resultExprs[i].evaluate((ExpressionEvaluator)this);
                    sqlExpr = this.stack.pop();
                    cols2 = this.stmt.select(sqlExpr, alias);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(cols2);
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                if (resultExprs[i] instanceof org.datanucleus.query.expression.CaseExpression) {
                    resultExprs[i].evaluate((ExpressionEvaluator)this);
                    sqlExpr = this.stack.pop();
                    cols2 = this.stmt.select(sqlExpr, alias);
                    idx = new StatementMappingIndex(sqlExpr.getJavaTypeMapping());
                    idx.setColumnPositions(cols2);
                    if (alias != null) {
                        idx.setColumnAlias(alias);
                    }
                    this.resultDefinition.addMappingForResultExpression(i, idx);
                    continue;
                }
                throw new NucleusException("Dont currently support result clause containing expression of type " + resultExprs[i]);
            }
            if (this.stmt.getNumberOfSelects() == 0) {
                this.stmt.select(this.exprFactory.newLiteral(this.stmt, this.storeMgr.getMappingManager().getMapping(Integer.class), 1), null);
            }
        } else {
            this.compileComponent = CompilationComponent.RESULT;
            if (this.candidateCmd.getIdentityType() == IdentityType.NONDURABLE) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER_RDBMS.msg("052520", (Object)this.candidateCmd.getFullClassName()));
                }
                this.fetchPlan.setGroup("all");
            }
            if (this.stmt.allUnionsForSamePrimaryTable()) {
                SQLStatementHelper.selectFetchPlanOfCandidateInStatement(this.stmt, this.resultDefinitionForClass, this.candidateCmd, this.fetchPlan, this.parentMapper == null ? 1 : 0);
            } else {
                SQLStatementHelper.selectIdentityOfCandidateInStatement(this.stmt, this.resultDefinitionForClass, this.candidateCmd);
            }
        }
        this.compileComponent = null;
    }

    protected void validateExpressionForResult(SQLExpression sqlExpr) {
        JavaTypeMapping m = sqlExpr.getJavaTypeMapping();
        if (m != null && m instanceof AbstractContainerMapping) {
            throw new NucleusUserException(LOCALISER.msg("021213"));
        }
    }

    protected void compileGrouping() {
        if (this.compilation.getExprGrouping() != null) {
            this.compileComponent = CompilationComponent.GROUPING;
            Expression[] groupExprs = this.compilation.getExprGrouping();
            for (int i = 0; i < groupExprs.length; ++i) {
                Expression groupExpr = groupExprs[i];
                SQLExpression sqlGroupExpr = (SQLExpression)groupExpr.evaluate((ExpressionEvaluator)this);
                this.stmt.addGroupingExpression(sqlGroupExpr);
            }
            this.compileComponent = null;
        }
    }

    protected void compileHaving() {
        if (this.compilation.getExprHaving() != null) {
            this.compileComponent = CompilationComponent.HAVING;
            Expression havingExpr = this.compilation.getExprHaving();
            Object havingEval = havingExpr.evaluate((ExpressionEvaluator)this);
            if (!(havingEval instanceof BooleanExpression)) {
                throw new NucleusUserException(LOCALISER.msg("021051", (Object)havingExpr));
            }
            this.stmt.setHaving((BooleanExpression)havingEval);
            this.compileComponent = null;
        }
    }

    protected void compileOrdering() {
        if (this.compilation.getExprOrdering() != null) {
            this.compileComponent = CompilationComponent.ORDERING;
            Expression[] orderingExpr = this.compilation.getExprOrdering();
            SQLExpression[] orderSqlExprs = new SQLExpression[orderingExpr.length];
            boolean[] directions = new boolean[orderingExpr.length];
            for (int i = 0; i < orderingExpr.length; ++i) {
                OrderExpression orderExpr = (OrderExpression)orderingExpr[i];
                orderSqlExprs[i] = (SQLExpression)orderExpr.getLeft().evaluate((ExpressionEvaluator)this);
                String orderDir = orderExpr.getSortOrder();
                directions[i] = orderDir != null && !orderDir.equals("ascending");
            }
            this.stmt.setOrdering(orderSqlExprs, directions);
            this.compileComponent = null;
        }
    }

    protected void compileFromClassExpression(ClassExpression clsExpr) {
        SQLTable joinSqlTbl;
        ElementContainerTable joinTbl;
        Symbol clsExprSym = clsExpr.getSymbol();
        Class baseCls = clsExprSym != null ? clsExprSym.getValueType() : null;
        SQLTable candSqlTbl = this.stmt.getPrimaryTable();
        MetaDataManager mmgr = this.storeMgr.getMetaDataManager();
        AbstractClassMetaData cmd = mmgr.getMetaDataForClass(baseCls, this.clr);
        if (baseCls != null && baseCls != this.compilation.getCandidateClass()) {
            DatastoreClass candTbl = this.storeMgr.getDatastoreClass(baseCls.getName(), this.clr);
            candSqlTbl = this.stmt.crossJoin((DatastoreContainerObject)candTbl, clsExpr.getAlias(), null);
            SQLTableMapping tblMapping = new SQLTableMapping(candSqlTbl, cmd, candTbl.getIdMapping());
            this.setSQLTableMappingForAlias(clsExpr.getAlias(), tblMapping);
        }
        if (clsExpr.getCandidateExpression() != null && this.parentMapper != null) {
            String[] tokens = StringUtils.split((String)clsExpr.getCandidateExpression(), (String)".");
            String leftAlias = tokens[0];
            SQLTableMapping outerSqlTblMapping = this.parentMapper.getSQLTableMappingForAlias(leftAlias);
            AbstractClassMetaData leftCmd = outerSqlTblMapping.cmd;
            AbstractMemberMetaData[] leftMmds = new AbstractMemberMetaData[tokens.length - 1];
            AbstractMemberMetaData[] rightMmds = new AbstractMemberMetaData[tokens.length - 1];
            for (int i = 0; i < tokens.length - 1; ++i) {
                String joinedField = tokens[i + 1];
                AbstractMemberMetaData leftMmd = leftCmd.getMetaDataForMember(joinedField);
                AbstractMemberMetaData rightMmd = null;
                AbstractClassMetaData rightCmd = null;
                int relationType = leftMmd.getRelationType(this.clr);
                switch (relationType) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: {
                        rightMmd = leftMmd.getRelatedMemberMetaData(this.clr)[0];
                        rightCmd = rightMmd.getAbstractClassMetaData();
                        break;
                    }
                    case 1: {
                        rightCmd = mmgr.getMetaDataForClass(leftMmd.getType(), this.clr);
                        rightMmd = null;
                        break;
                    }
                    case 3: {
                        if (leftMmd.hasCollection()) {
                            rightCmd = mmgr.getMetaDataForClass(leftMmd.getCollection().getElementType(), this.clr);
                            break;
                        }
                        if (!leftMmd.hasMap()) break;
                        rightCmd = mmgr.getMetaDataForClass(leftMmd.getMap().getValueType(), this.clr);
                        break;
                    }
                    default: {
                        throw new NucleusUserException("Subquery has been specified with a candidate-expression that includes \"" + tokens[i] + "\" that isnt a relation field!!");
                    }
                }
                leftMmds[i] = leftMmd;
                rightMmds[i] = rightMmd;
                leftCmd = rightCmd;
            }
            SQLTable rSqlTbl = candSqlTbl;
            SQLTable outerSqlTbl = outerSqlTblMapping.table;
            for (int i = leftMmds.length - 1; i >= 0; --i) {
                AbstractMemberMetaData leftMmd = leftMmds[i];
                AbstractMemberMetaData rightMmd = rightMmds[i];
                DatastoreClass leftTbl = this.storeMgr.getDatastoreClass(leftMmd.getClassName(true), this.clr);
                SQLTable lSqlTbl = null;
                int relationType = leftMmd.getRelationType(this.clr);
                switch (relationType) {
                    case 1: {
                        SQLExpression rightExpr;
                        SQLExpression outerExpr3;
                        if (i == 0) {
                            outerExpr3 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                            rightExpr = this.exprFactory.newExpression(this.stmt, rSqlTbl, rSqlTbl.getTable().getIdMapping());
                            this.stmt.whereAnd(outerExpr3.eq(rightExpr), false);
                            break;
                        }
                        JavaTypeMapping leftMapping = leftTbl.getMemberMapping(leftMmd);
                        lSqlTbl = this.stmt.innerJoin(rSqlTbl, rSqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)leftTbl, null, leftMapping, null, null);
                        break;
                    }
                    case 2: {
                        SQLExpression rightExpr;
                        SQLExpression outerExpr3;
                        if (leftMmd.getMappedBy() != null) {
                            JavaTypeMapping rightMapping = rSqlTbl.getTable().getMemberMapping(rightMmd);
                            if (i == 0) {
                                SQLExpression outerExpr2 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                                SQLExpression rightExpr2 = this.exprFactory.newExpression(this.stmt, rSqlTbl, rightMapping);
                                this.stmt.whereAnd(outerExpr2.eq(rightExpr2), false);
                                break;
                            }
                            lSqlTbl = this.stmt.innerJoin(rSqlTbl, rightMapping, (DatastoreContainerObject)leftTbl, null, leftTbl.getIdMapping(), null, null);
                            break;
                        }
                        if (i == 0) {
                            outerExpr3 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                            rightExpr = this.exprFactory.newExpression(this.stmt, rSqlTbl, rSqlTbl.getTable().getIdMapping());
                            this.stmt.whereAnd(outerExpr3.eq(rightExpr), false);
                            break;
                        }
                        lSqlTbl = this.stmt.innerJoin(rSqlTbl, rSqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)leftTbl, null, leftTbl.getMemberMapping(leftMmd), null, null);
                        break;
                    }
                    case 3: {
                        SQLExpression joinExpr;
                        SQLExpression outerExpr;
                        SQLExpression rightExpr;
                        SQLExpression outerExpr3;
                        if (leftMmd.getJoinMetaData() != null || rightMmd.getJoinMetaData() != null) {
                            joinTbl = (ElementContainerTable)this.storeMgr.getDatastoreContainerObject(leftMmd);
                            joinSqlTbl = this.stmt.innerJoin(rSqlTbl, rSqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                            if (i == 0) {
                                outerExpr = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                                joinExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getOwnerMapping());
                                this.stmt.whereAnd(outerExpr.eq(joinExpr), false);
                                break;
                            }
                            lSqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getOwnerMapping(), (DatastoreContainerObject)leftTbl, null, leftTbl.getIdMapping(), null, null);
                            break;
                        }
                        if (i == 0) {
                            outerExpr3 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                            rightExpr = this.exprFactory.newExpression(this.stmt, rSqlTbl, rSqlTbl.getTable().getMemberMapping(rightMmd));
                            this.stmt.whereAnd(outerExpr3.eq(rightExpr), false);
                            break;
                        }
                        lSqlTbl = this.stmt.innerJoin(rSqlTbl, rSqlTbl.getTable().getMemberMapping(rightMmd), (DatastoreContainerObject)leftTbl, null, leftTbl.getIdMapping(), null, null);
                        break;
                    }
                    case 4: {
                        SQLExpression joinExpr;
                        SQLExpression outerExpr;
                        SQLExpression rightExpr;
                        SQLExpression outerExpr3;
                        if (leftMmd.getJoinMetaData() != null || rightMmd.getJoinMetaData() != null) {
                            joinTbl = (ElementContainerTable)this.storeMgr.getDatastoreContainerObject(leftMmd);
                            joinSqlTbl = this.stmt.innerJoin(rSqlTbl, rSqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                            if (i == 0) {
                                outerExpr = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                                joinExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getOwnerMapping());
                                this.stmt.whereAnd(outerExpr.eq(joinExpr), false);
                                break;
                            }
                            lSqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getOwnerMapping(), (DatastoreContainerObject)leftTbl, null, leftTbl.getIdMapping(), null, null);
                            break;
                        }
                        if (i == 0) {
                            outerExpr3 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getIdMapping());
                            rightExpr = this.exprFactory.newExpression(this.stmt, rSqlTbl, rSqlTbl.getTable().getMemberMapping(rightMmd));
                            this.stmt.whereAnd(outerExpr3.eq(rightExpr), false);
                            break;
                        }
                        lSqlTbl = this.stmt.innerJoin(rSqlTbl, rSqlTbl.getTable().getMemberMapping(rightMmd), (DatastoreContainerObject)leftTbl, null, leftTbl.getIdMapping(), null, null);
                        break;
                    }
                    case 6: {
                        SQLExpression joinExpr;
                        SQLExpression outerExpr;
                        SQLExpression rightExpr;
                        SQLExpression outerExpr3;
                        if (leftMmd.getJoinMetaData() != null || rightMmd.getJoinMetaData() != null) {
                            joinTbl = (ElementContainerTable)this.storeMgr.getDatastoreContainerObject(leftMmd);
                            joinSqlTbl = this.stmt.innerJoin(rSqlTbl, rSqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                            if (i == 0) {
                                outerExpr = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                                joinExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getElementMapping());
                                this.stmt.whereAnd(outerExpr.eq(joinExpr), false);
                                break;
                            }
                            lSqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)leftTbl, null, leftTbl.getIdMapping(), null, null);
                            break;
                        }
                        if (i == 0) {
                            outerExpr3 = this.exprFactory.newExpression(outerSqlTbl.getSQLStatement(), outerSqlTbl, outerSqlTbl.getTable().getMemberMapping(leftMmd));
                            rightExpr = this.exprFactory.newExpression(this.stmt, rSqlTbl, rSqlTbl.getTable().getIdMapping());
                            this.stmt.whereAnd(outerExpr3.eq(rightExpr), false);
                            break;
                        }
                        lSqlTbl = this.stmt.innerJoin(rSqlTbl, rSqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)leftTbl, null, leftTbl.getMemberMapping(leftMmd), null, null);
                    }
                }
                rSqlTbl = lSqlTbl;
            }
        }
        SQLTable sqlTbl = candSqlTbl;
        for (Expression rightExpr = clsExpr.getRight(); rightExpr != null; rightExpr = rightExpr.getRight()) {
            if (!(rightExpr instanceof JoinExpression)) continue;
            JoinExpression joinExpr = (JoinExpression)rightExpr;
            JoinExpression.JoinType joinType = joinExpr.getType();
            String joinAlias = joinExpr.getAlias();
            PrimaryExpression joinPrimExpr = joinExpr.getPrimaryExpression();
            Iterator iter = joinPrimExpr.getTuples().iterator();
            String rootId = (String)iter.next();
            String joinTableGroupName = null;
            if (rootId.equalsIgnoreCase(this.candidateAlias)) {
                joinTableGroupName = joinPrimExpr.getId();
            } else {
                SQLTableMapping sqlTblMapping = this.getSQLTableMappingForAlias(rootId);
                if (sqlTblMapping != null) {
                    cmd = sqlTblMapping.cmd;
                    joinTableGroupName = sqlTblMapping.table.getGroupName();
                    sqlTbl = sqlTblMapping.table;
                } else {
                    throw new NucleusUserException("Query has " + joinPrimExpr.getId() + " yet the first component " + rootId + " is unknown!");
                }
            }
            while (iter.hasNext()) {
                String id = (String)iter.next();
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(id);
                int relationType = mmd.getRelationType(this.clr);
                DatastoreClass relTable = null;
                AbstractMemberMetaData relMmd = null;
                switch (relationType) {
                    case 1: {
                        relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                        cmd = mmgr.getMetaDataForClass(mmd.getType(), this.clr);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                        break;
                    }
                    case 2: {
                        relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                        cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.clr);
                        if (mmd.getMappedBy() != null) {
                            relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, joinTableGroupName);
                                break;
                            }
                            sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, joinTableGroupName);
                            break;
                        }
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getMemberMapping(mmd), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                        break;
                    }
                    case 4: {
                        relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                        cmd = mmd.getCollection().getElementClassMetaData(this.clr, mmgr);
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                            joinTbl = (ElementContainerTable)this.storeMgr.getDatastoreContainerObject(mmd);
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                                sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                                break;
                            }
                            joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                            sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, joinTableGroupName);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relTable.getMemberMapping(relMmd), null, joinTableGroupName);
                        break;
                    }
                    case 3: {
                        relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                        cmd = mmd.getCollection().getElementClassMetaData(this.clr, mmgr);
                        if (mmd.getJoinMetaData() != null) {
                            joinTbl = (ElementContainerTable)this.storeMgr.getDatastoreContainerObject(mmd);
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                                sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                                break;
                            }
                            joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                            sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        JavaTypeMapping relMapping = relTable.getExternalMapping(mmd, 5);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relMapping, null, joinTableGroupName);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), (DatastoreContainerObject)relTable, null, relMapping, null, joinTableGroupName);
                        break;
                    }
                    case 5: {
                        relTable = this.storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                        cmd = mmd.getCollection().getElementClassMetaData(this.clr, mmgr);
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        joinTbl = (CollectionTable)this.storeMgr.getDatastoreContainerObject(mmd);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                            sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                        sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                        break;
                    }
                    case 6: {
                        relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                        cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.clr);
                        relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                            joinTbl = (CollectionTable)this.storeMgr.getDatastoreContainerObject(relMmd);
                            if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                                joinSqlTbl = this.stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                                sqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getOwnerMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                                break;
                            }
                            joinSqlTbl = this.stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                            sqlTbl = this.stmt.leftOuterJoin(joinSqlTbl, joinTbl.getOwnerMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        JavaTypeMapping fkMapping = sqlTbl.getTable().getMemberMapping(mmd);
                        if (joinType == JoinExpression.JoinType.JOIN_INNER || joinType == JoinExpression.JoinType.JOIN_INNER_FETCH) {
                            sqlTbl = this.stmt.innerJoin(sqlTbl, fkMapping, (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                            break;
                        }
                        sqlTbl = this.stmt.leftOuterJoin(sqlTbl, fkMapping, (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, joinTableGroupName);
                        break;
                    }
                }
            }
            if (joinAlias != null) {
                if (this.explicitJoinPrimaryByAlias == null) {
                    this.explicitJoinPrimaryByAlias = new HashMap<String, String>();
                }
                this.explicitJoinPrimaryByAlias.put(joinAlias, joinPrimExpr.getId());
            }
            SQLTableMapping tblMapping = new SQLTableMapping(sqlTbl, cmd, sqlTbl.getTable().getIdMapping());
            this.setSQLTableMappingForAlias(joinAlias, tblMapping);
        }
    }

    protected StatementNewObjectMapping getStatementMappingForNewObjectExpression(NewObjectExpression expr) {
        List<SQLExpression> argExprs = expr.getConstructorArgExpressions();
        StatementNewObjectMapping stmtMap = new StatementNewObjectMapping(expr.getNewClass());
        if (argExprs != null) {
            Iterator<SQLExpression> argIter = argExprs.iterator();
            int j = 0;
            while (argIter.hasNext()) {
                SQLExpression argExpr = argIter.next();
                if (argExpr instanceof SQLLiteral) {
                    stmtMap.addConstructorArgMapping(j, ((SQLLiteral)((Object)argExpr)).getValue());
                } else if (argExpr instanceof NewObjectExpression) {
                    stmtMap.addConstructorArgMapping(j, (Object)this.getStatementMappingForNewObjectExpression((NewObjectExpression)argExpr));
                } else {
                    StatementMappingIndex idx = new StatementMappingIndex(argExpr.getJavaTypeMapping());
                    int[] cols = this.stmt.select(argExpr, null);
                    idx.setColumnPositions(cols);
                    stmtMap.addConstructorArgMapping(j, (Object)idx);
                }
                ++j;
            }
        }
        return stmtMap;
    }

    protected Object processAndExpression(Expression expr) {
        SQLExpression rightExpr = this.stack.pop();
        SQLExpression leftExpr = this.stack.pop();
        if (!(rightExpr instanceof BooleanExpression)) {
            throw new NucleusUserException("Query has clause " + rightExpr + " used with AND. This is illegal, and should be a boolean expression");
        }
        if (!(leftExpr instanceof BooleanExpression)) {
            throw new NucleusUserException("Query has clause " + leftExpr + " used with AND. This is illegal, and should be a boolean expression");
        }
        BooleanExpression right = (BooleanExpression)rightExpr;
        BooleanExpression left = (BooleanExpression)leftExpr;
        if (left.getSQLStatement() != null && right.getSQLStatement() != null && left.getSQLStatement() != right.getSQLStatement()) {
            if (left.getSQLStatement() == this.stmt && right.getSQLStatement().isChildStatementOf(this.stmt)) {
                right.getSQLStatement().whereAnd(right, true);
                this.stack.push(left);
                return left;
            }
            if (right.getSQLStatement() == this.stmt && left.getSQLStatement().isChildStatementOf(this.stmt)) {
                left.getSQLStatement().whereAnd(left, true);
                this.stack.push(right);
                return right;
            }
        }
        if (this.compileComponent == CompilationComponent.FILTER) {
            left = this.getBooleanExpressionForUseInFilter(left);
            right = this.getBooleanExpressionForUseInFilter(right);
        }
        BooleanExpression opExpr = left.and(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processOrExpression(Expression expr) {
        SQLExpression rightExpr = this.stack.pop();
        SQLExpression leftExpr = this.stack.pop();
        if (!(rightExpr instanceof BooleanExpression)) {
            throw new NucleusUserException("Query has clause " + rightExpr + " used with AND. This is illegal, and should be a boolean expression");
        }
        if (!(leftExpr instanceof BooleanExpression)) {
            throw new NucleusUserException("Query has clause " + leftExpr + " used with AND. This is illegal, and should be a boolean expression");
        }
        BooleanExpression right = (BooleanExpression)rightExpr;
        BooleanExpression left = (BooleanExpression)leftExpr;
        if (left.getSQLStatement() != null && right.getSQLStatement() != null && left.getSQLStatement() != right.getSQLStatement()) {
            if (left.getSQLStatement() == this.stmt && right.getSQLStatement().isChildStatementOf(this.stmt)) {
                right.getSQLStatement().whereAnd(right, true);
                this.stack.push(left);
                return left;
            }
            if (right.getSQLStatement() == this.stmt && left.getSQLStatement().isChildStatementOf(this.stmt)) {
                left.getSQLStatement().whereAnd(left, true);
                this.stack.push(right);
                return right;
            }
        }
        if (this.compileComponent == CompilationComponent.FILTER) {
            left = this.getBooleanExpressionForUseInFilter(left);
            right = this.getBooleanExpressionForUseInFilter(right);
        }
        left.encloseInParentheses();
        right.encloseInParentheses();
        BooleanExpression opExpr = left.ior(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processEqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter() && right.isParameter()) {
            if (left.isParameter() && left instanceof SQLLiteral && ((SQLLiteral)((Object)left)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)left));
            }
            if (right.isParameter() && right instanceof SQLLiteral && ((SQLLiteral)((Object)right)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)right));
            }
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        if (!this.options.contains(OPTION_EXPLICIT_JOINS)) {
            String varName;
            SQLJoin.JoinType joinType;
            boolean rightIsCrossJoin;
            boolean leftIsCrossJoin = this.stmt.getJoinTypeForTable(left.getSQLTable()) == SQLJoin.JoinType.CROSS_JOIN;
            boolean bl = rightIsCrossJoin = this.stmt.getJoinTypeForTable(right.getSQLTable()) == SQLJoin.JoinType.CROSS_JOIN;
            if (leftIsCrossJoin && !rightIsCrossJoin && !(right instanceof SQLLiteral)) {
                String varName2 = this.getAliasForSQLTable(left.getSQLTable());
                SQLJoin.JoinType joinType2 = this.getRequiredJoinTypeForAlias(varName2);
                if (joinType2 != null) {
                    NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.eq variable " + varName2 + " is mapped to table " + left.getSQLTable() + " was previously bound as CROSS JOIN but changing to " + (Object)((Object)joinType2)));
                    String leftTblAlias = this.stmt.removeCrossJoin(left.getSQLTable());
                    if (joinType2 == SQLJoin.JoinType.LEFT_OUTER_JOIN) {
                        this.stmt.leftOuterJoin(right.getSQLTable(), right.getJavaTypeMapping(), left.getSQLTable().getTable(), leftTblAlias, left.getJavaTypeMapping(), null, left.getSQLTable().getGroupName());
                    } else {
                        this.stmt.innerJoin(right.getSQLTable(), right.getJavaTypeMapping(), left.getSQLTable().getTable(), leftTblAlias, left.getJavaTypeMapping(), null, left.getSQLTable().getGroupName());
                    }
                    JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
                    BooleanExpression opExpr = this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
                    this.stack.push(opExpr);
                    return opExpr;
                }
            } else if (!leftIsCrossJoin && rightIsCrossJoin && !(left instanceof SQLLiteral) && (joinType = this.getRequiredJoinTypeForAlias(varName = this.getAliasForSQLTable(right.getSQLTable()))) != null) {
                NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.eq variable " + varName + " is mapped to table " + right.getSQLTable() + " was previously bound as CROSS JOIN but changing to " + (Object)((Object)joinType)));
                String rightTblAlias = this.stmt.removeCrossJoin(right.getSQLTable());
                if (joinType == SQLJoin.JoinType.LEFT_OUTER_JOIN) {
                    this.stmt.leftOuterJoin(left.getSQLTable(), left.getJavaTypeMapping(), right.getSQLTable().getTable(), rightTblAlias, right.getJavaTypeMapping(), null, right.getSQLTable().getGroupName());
                } else {
                    this.stmt.innerJoin(left.getSQLTable(), left.getJavaTypeMapping(), right.getSQLTable().getTable(), rightTblAlias, right.getJavaTypeMapping(), null, right.getSQLTable().getGroupName());
                }
                JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
                BooleanExpression opExpr = this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
                this.stack.push(opExpr);
                return opExpr;
            }
        }
        BooleanExpression opExpr = left.eq(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processNoteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        if (left.isParameter() && right.isParameter()) {
            if (left.isParameter() && left instanceof SQLLiteral && ((SQLLiteral)((Object)left)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)left));
            }
            if (right.isParameter() && right instanceof SQLLiteral && ((SQLLiteral)((Object)right)).getValue() != null) {
                this.useParameterExpressionAsLiteral((SQLLiteral)((Object)right));
            }
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.ne(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processGteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.ge(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processGtExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.gt(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLteqExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.le(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLtExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        ExpressionUtils.checkAndCorrectExpressionMappingsForBooleanComparison(left, right);
        if (left instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)left);
            left = this.stack.pop();
        }
        if (right instanceof UnboundExpression) {
            this.processUnboundExpression((UnboundExpression)right);
            right = this.stack.pop();
        }
        BooleanExpression opExpr = left.lt(right);
        this.stack.push(opExpr);
        return opExpr;
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        if (litValue instanceof Class) {
            litValue = ((Class)litValue).getName();
        }
        JavaTypeMapping m = null;
        if (litValue != null) {
            m = this.exprFactory.getMappingForType(litValue.getClass(), false);
        }
        SQLExpression sqlExpr = this.exprFactory.newLiteral(this.stmt, m, litValue);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        SQLExpression sqlExpr = null;
        if (expr.getLeft() != null) {
            if (expr.getLeft() instanceof DyadicExpression && expr.getLeft().getOperator() == Expression.OP_CAST) {
                expr.getLeft().evaluate((ExpressionEvaluator)this);
                sqlExpr = this.stack.pop();
                Literal castLitExpr = (Literal)expr.getLeft().getRight();
                AbstractClassMetaData castCmd = this.ec.getMetaDataManager().getMetaDataForClass(this.resolveClass((String)castLitExpr.getLiteral()), this.clr);
                String exprCastName = null;
                if (expr.getLeft().getLeft() instanceof PrimaryExpression) {
                    exprCastName = "CAST_" + ((PrimaryExpression)expr.getLeft().getLeft()).getId();
                } else if (expr.getLeft().getLeft() instanceof VariableExpression) {
                    exprCastName = "CAST_" + ((VariableExpression)expr.getLeft().getLeft()).getId();
                } else if (expr.getLeft().getLeft() instanceof InvokeExpression) {
                    exprCastName = "CAST_" + expr.getLeft().getLeft();
                } else {
                    throw new NucleusException("Don't currently support cast of " + expr.getLeft().getLeft());
                }
                SQLTableMapping tblMapping = new SQLTableMapping(sqlExpr.getSQLTable(), castCmd, sqlExpr.getJavaTypeMapping());
                this.setSQLTableMappingForAlias(exprCastName, tblMapping);
                SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(this.stmt, exprCastName, expr, Boolean.FALSE);
                if (sqlMapping == null) {
                    throw new NucleusException("PrimaryExpression " + expr + " is not yet supported");
                }
                sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof ParameterExpression) {
                this.precompilable = false;
                ParameterExpression paramExpr = (ParameterExpression)expr.getLeft();
                Symbol paramSym = this.compilation.getSymbolTable().getSymbol(paramExpr.getId());
                if (paramSym.getValueType() != null && paramSym.getValueType().isArray()) {
                    String first = (String)expr.getTuples().get(0);
                    this.processParameterExpression(paramExpr, true);
                    SQLExpression paramSqlExpr = this.stack.pop();
                    sqlExpr = this.exprFactory.invokeMethod(this.stmt, "ARRAY", first, paramSqlExpr, null);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                this.processParameterExpression(paramExpr, true);
                SQLExpression paramSqlExpr = this.stack.pop();
                SQLLiteral lit = (SQLLiteral)((Object)paramSqlExpr);
                Object paramValue = lit.getValue();
                List tuples = expr.getTuples();
                Iterator tuplesIter = tuples.iterator();
                Object objValue = paramValue;
                while (tuplesIter.hasNext()) {
                    String fieldName = (String)tuplesIter.next();
                    objValue = this.getValueForObjectField(objValue, fieldName);
                    this.precompilable = false;
                    if (objValue != null) continue;
                    break;
                }
                if (objValue == null) {
                    sqlExpr = this.exprFactory.newLiteral(this.stmt, null, null);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                JavaTypeMapping m = this.exprFactory.getMappingForType(objValue.getClass(), false);
                sqlExpr = this.exprFactory.newLiteral(this.stmt, m, objValue);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof VariableExpression) {
                VariableExpression varExpr = (VariableExpression)expr.getLeft();
                this.processVariableExpression(varExpr);
                SQLExpression varSqlExpr = this.stack.pop();
                if (varSqlExpr instanceof UnboundExpression) {
                    this.processUnboundExpression((UnboundExpression)varSqlExpr);
                    varSqlExpr = this.stack.pop();
                }
                Class varType = this.clr.classForName(varSqlExpr.getJavaTypeMapping().getType());
                if (varSqlExpr.getSQLStatement() == this.stmt.getParentStatement()) {
                    SQLTableMapping sqlMapping = this.parentMapper.getSQLTableMappingForPrimaryExpression(this.stmt, null, expr, Boolean.FALSE);
                    if (sqlMapping == null) {
                        throw new NucleusException("PrimaryExpression " + expr.getId() + " is not yet supported");
                    }
                    sqlExpr = this.exprFactory.newExpression(varSqlExpr.getSQLStatement(), sqlMapping.table, sqlMapping.mapping);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                SQLTableMapping varTblMapping = this.getSQLTableMappingForAlias(varExpr.getId());
                if (varTblMapping == null) {
                    throw new NucleusUserException("Variable " + varExpr.getId() + " is not yet bound, so cannot get field " + expr.getId());
                }
                if (varTblMapping.cmd == null) {
                    throw new NucleusUserException("Variable " + varExpr.getId() + " of type " + varType.getName() + " cannot evaluate " + expr.getId());
                }
                SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(varSqlExpr.getSQLStatement(), varExpr.getId(), expr, Boolean.FALSE);
                sqlExpr = this.exprFactory.newExpression(sqlMapping.table.getSQLStatement(), sqlMapping.table, sqlMapping.mapping);
                this.stack.push(sqlExpr);
                return sqlExpr;
            }
            if (expr.getLeft() instanceof InvokeExpression) {
                this.processInvokeExpression((InvokeExpression)expr.getLeft());
                SQLExpression invokeSqlExpr = this.stack.pop();
                DatastoreContainerObject tbl = invokeSqlExpr.getSQLTable().getTable();
                if (tbl instanceof DatastoreClass) {
                    if (expr.getTuples().size() > 1) {
                        throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr);
                    }
                    JavaTypeMapping mapping = ((DatastoreClass)tbl).getMemberMapping(expr.getId());
                    if (mapping == null) {
                        throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr + ". The field " + expr.getId() + " doesnt exist in table " + tbl);
                    }
                    sqlExpr = this.exprFactory.newExpression(this.stmt, invokeSqlExpr.getSQLTable(), mapping);
                    this.stack.push(sqlExpr);
                    return sqlExpr;
                }
                throw new NucleusUserException("Dont currently support evaluating " + expr.getId() + " on " + invokeSqlExpr + " with invoke having table of " + tbl);
            }
            throw new NucleusUserException("Dont currently support PrimaryExpression with 'left' of " + expr.getLeft());
        }
        SQLTableMapping sqlMapping = this.getSQLTableMappingForPrimaryExpression(this.stmt, null, expr, null);
        if (sqlMapping == null) {
            throw new NucleusException("PrimaryExpression " + expr.getId() + " is not yet supported");
        }
        sqlExpr = this.exprFactory.newExpression(this.stmt, sqlMapping.table, sqlMapping.mapping);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    private SQLTableMapping getSQLTableMappingForPrimaryExpression(SQLStatement theStmt, String exprName, PrimaryExpression primExpr, Boolean forceJoin) {
        if (forceJoin == null && primExpr.getParent() != null && (primExpr.getParent().getOperator() == Expression.OP_IS || primExpr.getParent().getOperator() == Expression.OP_ISNOT)) {
            forceJoin = Boolean.TRUE;
        }
        SQLTableMapping sqlMapping = null;
        List tuples = primExpr.getTuples();
        Iterator iter = tuples.iterator();
        String first = (String)tuples.get(0);
        String primaryName = null;
        if (exprName != null) {
            sqlMapping = this.getSQLTableMappingForAlias(exprName);
            primaryName = exprName;
        } else {
            if (this.hasSQLTableMappingForAlias(first)) {
                sqlMapping = this.getSQLTableMappingForAlias(first);
                primaryName = first;
                iter.next();
            }
            if (sqlMapping == null && this.parentMapper != null && this.parentMapper.hasSQLTableMappingForAlias(first)) {
                sqlMapping = this.parentMapper.getSQLTableMappingForAlias(first);
                primaryName = first;
                iter.next();
                theStmt = sqlMapping.table.getSQLStatement();
            }
            if (sqlMapping == null) {
                sqlMapping = this.getSQLTableMappingForAlias(this.candidateAlias);
                primaryName = this.candidateAlias;
            }
        }
        AbstractClassMetaData cmd = sqlMapping.cmd;
        JavaTypeMapping mapping = sqlMapping.mapping;
        while (iter.hasNext()) {
            String component = (String)iter.next();
            SQLTableMapping sqlMappingNew = this.getSQLTableMappingForAlias(primaryName = primaryName + "." + component);
            if (sqlMappingNew == null) {
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(component);
                if (mmd == null) {
                    throw new NucleusUserException(LOCALISER.msg("021062", (Object)component, (Object)cmd.getFullClassName()));
                }
                if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " is not marked as persistent so cannot be queried");
                }
                SQLTable sqlTbl = null;
                if (mapping instanceof EmbeddedMapping) {
                    sqlTbl = sqlMapping.table;
                    mapping = ((EmbeddedMapping)mapping).getJavaTypeMapping(component);
                } else {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(cmd.getFullClassName(), this.clr);
                    if (table == null) {
                        AbstractClassMetaData[] subCmds = this.storeMgr.getClassesManagingTableForClass(cmd, this.clr);
                        if (subCmds.length == 1) {
                            table = this.storeMgr.getDatastoreClass(subCmds[0].getFullClassName(), this.clr);
                        } else {
                            throw new NucleusUserException("Unable to find table for primary " + primaryName + " since the class " + cmd.getFullClassName() + " is managed in multiple tables");
                        }
                    }
                    mapping = table.getMemberMapping(mmd);
                    sqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(theStmt, sqlMapping.table, mapping);
                }
                int relationType = mmd.getRelationType(this.clr);
                switch (relationType) {
                    case 0: {
                        sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, mapping);
                        cmd = sqlMappingNew.cmd;
                        this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                        break;
                    }
                    case 1: 
                    case 2: {
                        DatastoreClass relTable;
                        AbstractMemberMetaData relMmd;
                        if (mmd.getMappedBy() != null) {
                            relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                            if (relMmd.getAbstractClassMetaData().isEmbeddedOnly()) {
                                sqlMappingNew = sqlMapping;
                                cmd = relMmd.getAbstractClassMetaData();
                                break;
                            }
                            relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                            JavaTypeMapping relMapping = relTable.getMemberMapping(relMmd);
                            sqlTbl = theStmt.getTable((DatastoreContainerObject)relTable, primaryName);
                            if (sqlTbl == null) {
                                sqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(theStmt, sqlMapping.table.getTable().getIdMapping(), sqlMapping.table, relMapping, (DatastoreContainerObject)relTable, null, null, primaryName, this.defaultJoinType);
                            }
                            if (iter.hasNext()) {
                                sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIdMapping());
                                cmd = sqlMappingNew.cmd;
                                break;
                            }
                            sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, relTable.getIdMapping());
                            cmd = sqlMappingNew.cmd;
                            break;
                        }
                        if (forceJoin == null && !iter.hasNext() && primExpr.getParent() != null && primExpr.getParent().getOperator() == Expression.OP_CAST && !(mapping instanceof ReferenceMapping)) {
                            forceJoin = Boolean.TRUE;
                        }
                        if (iter.hasNext() || Boolean.TRUE.equals(forceJoin)) {
                            AbstractClassMetaData relCmd = null;
                            JavaTypeMapping relMapping = null;
                            DatastoreClass relTable2 = null;
                            if (relationType == 2) {
                                AbstractMemberMetaData relMmd2 = mmd.getRelatedMemberMetaData(this.clr)[0];
                                relCmd = relMmd2.getAbstractClassMetaData();
                            } else {
                                relCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getTypeName(), this.clr);
                            }
                            if (relCmd != null && relCmd.isEmbeddedOnly()) {
                                sqlMappingNew = sqlMapping;
                                cmd = relCmd;
                                break;
                            }
                            relTable2 = this.storeMgr.getDatastoreClass(relCmd.getFullClassName(), this.clr);
                            relMapping = relTable2.getIdMapping();
                            sqlTbl = theStmt.getTable((DatastoreContainerObject)relTable2, primaryName);
                            if (sqlTbl == null) {
                                sqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(theStmt, mapping, sqlMapping.table, relMapping, (DatastoreContainerObject)relTable2, null, null, primaryName, this.defaultJoinType);
                            }
                            sqlMappingNew = new SQLTableMapping(sqlTbl, relCmd, relMapping);
                            cmd = sqlMappingNew.cmd;
                            this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                            break;
                        }
                        sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, mapping);
                        cmd = sqlMappingNew.cmd;
                        break;
                    }
                    case 6: {
                        AbstractMemberMetaData relMmd = mmd.getRelatedMemberMetaData(this.clr)[0];
                        DatastoreClass relTable = this.storeMgr.getDatastoreClass(mmd.getTypeName(), this.clr);
                        if (mmd.getJoinMetaData() != null || relMmd.getJoinMetaData() != null) {
                            sqlTbl = theStmt.getTable((DatastoreContainerObject)relTable, primaryName);
                            if (sqlTbl == null) {
                                SQLTable joinSqlTbl;
                                CollectionTable joinTbl = (CollectionTable)this.storeMgr.getDatastoreContainerObject(relMmd);
                                if (this.defaultJoinType == SQLJoin.JoinType.INNER_JOIN) {
                                    joinSqlTbl = theStmt.innerJoin(sqlMapping.table, sqlMapping.table.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                                    sqlTbl = theStmt.innerJoin(joinSqlTbl, joinTbl.getOwnerMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, primaryName);
                                } else if (this.defaultJoinType == SQLJoin.JoinType.LEFT_OUTER_JOIN || this.defaultJoinType == null) {
                                    joinSqlTbl = theStmt.leftOuterJoin(sqlMapping.table, sqlMapping.table.getTable().getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                                    sqlTbl = theStmt.leftOuterJoin(joinSqlTbl, joinTbl.getOwnerMapping(), (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, primaryName);
                                }
                            }
                            sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIdMapping());
                            cmd = sqlMappingNew.cmd;
                            this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                            break;
                        }
                        sqlTbl = theStmt.getTable((DatastoreContainerObject)relTable, primaryName);
                        if (sqlTbl == null) {
                            Expression.Operator op;
                            Expression.Operator operator = op = primExpr.getParent() != null ? primExpr.getParent().getOperator() : null;
                            if (!(iter.hasNext() || op != Expression.OP_EQ && op != Expression.OP_GT && op != Expression.OP_LT && op != Expression.OP_GTEQ && op != Expression.OP_LTEQ && op != Expression.OP_NOTEQ)) {
                                sqlMappingNew = new SQLTableMapping(sqlMapping.table, relMmd.getAbstractClassMetaData(), mapping);
                                break;
                            }
                            if (this.defaultJoinType == SQLJoin.JoinType.INNER_JOIN) {
                                sqlTbl = theStmt.innerJoin(sqlMapping.table, mapping, (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, primaryName);
                            } else if (this.defaultJoinType == SQLJoin.JoinType.LEFT_OUTER_JOIN || this.defaultJoinType == null) {
                                sqlTbl = theStmt.leftOuterJoin(sqlMapping.table, mapping, (DatastoreContainerObject)relTable, null, relTable.getIdMapping(), null, primaryName);
                            }
                            sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIdMapping());
                            cmd = sqlMappingNew.cmd;
                            this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                            break;
                        }
                        sqlMappingNew = new SQLTableMapping(sqlTbl, relMmd.getAbstractClassMetaData(), relTable.getIdMapping());
                        cmd = sqlMappingNew.cmd;
                        this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        sqlMappingNew = new SQLTableMapping(sqlTbl, cmd, mapping);
                        cmd = sqlMappingNew.cmd;
                        this.setSQLTableMappingForAlias(primaryName, sqlMappingNew);
                        break;
                    }
                }
            } else {
                cmd = sqlMappingNew.cmd;
            }
            sqlMapping = sqlMappingNew;
        }
        return sqlMapping;
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        return this.processParameterExpression(expr, false);
    }

    protected Object processParameterExpression(ParameterExpression expr, boolean asLiteral) {
        JavaTypeMapping m;
        if (this.compileComponent == CompilationComponent.ORDERING) {
            asLiteral = true;
        }
        if (expr.getPosition() >= 0) {
            if (this.paramNameByPosition == null) {
                this.paramNameByPosition = new HashMap<Integer, String>();
            }
            this.paramNameByPosition.put(expr.getPosition(), expr.getId());
        }
        if (asLiteral) {
            if (this.precompilable) {
                NucleusLogger.QUERY.debug((Object)("Parameter " + expr + " is being resolved as a literal, so the query is no longer precompilable"));
            }
            this.precompilable = false;
        }
        Object paramValue = null;
        boolean paramValueSet = false;
        if (this.parameters != null && this.parameters.size() > 0) {
            if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else if (this.parameterValueByName != null && this.parameterValueByName.containsKey(expr.getId())) {
                paramValue = this.parameterValueByName.get(expr.getId());
                paramValueSet = true;
            } else {
                int position = this.positionalParamNumber;
                if (this.positionalParamNumber < 0) {
                    position = 0;
                }
                if (this.parameters.containsKey(position)) {
                    paramValue = this.parameters.get(position);
                    paramValueSet = true;
                    this.positionalParamNumber = position + 1;
                    if (this.parameterValueByName == null) {
                        this.parameterValueByName = new HashMap<String, Object>();
                    }
                    this.parameterValueByName.put(expr.getId(), paramValue);
                }
            }
        }
        if ((m = this.paramMappingForName.get(expr.getId())) == null) {
            if (paramValue != null) {
                AbstractClassMetaData cmd;
                String className = this.storeMgr.getClassNameForObjectID(paramValue, this.clr, this.ec);
                if (className != null && (cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, this.clr)).getIdentityType() == IdentityType.APPLICATION) {
                    Class cls = this.clr.classForName(className);
                    m = this.exprFactory.getMappingForType(cls, false);
                    m = new PersistableIdMapping((PersistableMapping)m);
                }
                if (m == null) {
                    m = this.exprFactory.getMappingForType(paramValue.getClass(), false);
                }
                if (expr.getSymbol() != null && expr.getSymbol().getValueType() != null) {
                    if (!QueryUtils.queryParameterTypesAreCompatible((Class)expr.getSymbol().getValueType(), paramValue.getClass())) {
                        throw new QueryCompilerSyntaxException(LOCALISER.msg("021118", (Object)expr.getId(), (Object)expr.getSymbol().getValueType().getName(), (Object)paramValue.getClass().getName()));
                    }
                    if (expr.getSymbol().getValueType() != paramValue.getClass()) {
                        this.precompilable = false;
                    }
                }
            } else if (expr.getSymbol() != null && expr.getSymbol().getValueType() != null) {
                m = this.exprFactory.getMappingForType(expr.getSymbol().getValueType(), false);
            }
        }
        if (paramValue == null && expr.getSymbol() != null) {
            this.precompilable = false;
        }
        SQLExpression sqlExpr = null;
        if (paramValueSet && asLiteral) {
            if (paramValue == null) {
                m = null;
            }
            sqlExpr = this.exprFactory.newLiteral(this.stmt, m, paramValue);
        } else if (paramValueSet && paramValue == null) {
            m = null;
            sqlExpr = this.exprFactory.newLiteral(this.stmt, m, paramValue);
        } else {
            sqlExpr = this.exprFactory.newLiteralParameter(this.stmt, m, paramValue, expr.getId());
            if (sqlExpr instanceof ParameterLiteral) {
                ((ParameterLiteral)sqlExpr).setName(expr.getId());
            }
            if (this.expressionForParameter == null) {
                this.expressionForParameter = new HashMap<Object, SQLExpression>();
            }
            this.expressionForParameter.put(expr.getId(), sqlExpr);
            this.paramMappingForName.put(expr.getId(), m);
        }
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processInvokeExpression(InvokeExpression expr) {
        Expression invokedExpr = expr.getLeft();
        SQLExpression invokedSqlExpr = null;
        if (invokedExpr != null) {
            if (invokedExpr instanceof PrimaryExpression) {
                this.processPrimaryExpression((PrimaryExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof Literal) {
                this.processLiteral((Literal)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof ParameterExpression) {
                this.processParameterExpression((ParameterExpression)invokedExpr, true);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof InvokeExpression) {
                this.processInvokeExpression((InvokeExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof VariableExpression) {
                this.processVariableExpression((VariableExpression)invokedExpr);
                invokedSqlExpr = this.stack.pop();
            } else if (invokedExpr instanceof ArrayExpression) {
                ArrayExpression arrExpr = (ArrayExpression)invokedExpr;
                SQLExpression[] arrSqlExprs = new SQLExpression[arrExpr.getArraySize()];
                for (int i = 0; i < arrExpr.getArraySize(); ++i) {
                    Expression arrElemExpr = arrExpr.getElement(i);
                    arrElemExpr.evaluate((ExpressionEvaluator)this);
                    arrSqlExprs[i] = this.stack.pop();
                }
                JavaTypeMapping m = this.exprFactory.getMappingForType(Object[].class, false);
                invokedSqlExpr = new org.datanucleus.store.rdbms.sql.expression.ArrayExpression(this.stmt, m, arrSqlExprs);
            } else {
                throw new NucleusException("Dont currently support invoke expression " + invokedExpr);
            }
        }
        String operation = expr.getOperation();
        List args = expr.getArguments();
        ArrayList<SQLExpression> sqlExprArgs = null;
        if (args != null) {
            sqlExprArgs = new ArrayList<SQLExpression>();
            for (Expression argExpr : args) {
                if (argExpr instanceof PrimaryExpression) {
                    this.processPrimaryExpression((PrimaryExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof ParameterExpression) {
                    this.processParameterExpression((ParameterExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof InvokeExpression) {
                    this.processInvokeExpression((InvokeExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof Literal) {
                    this.processLiteral((Literal)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof DyadicExpression) {
                    argExpr.evaluate((ExpressionEvaluator)this);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                if (argExpr instanceof VariableExpression) {
                    this.processVariableExpression((VariableExpression)argExpr);
                    sqlExprArgs.add(this.stack.pop());
                    continue;
                }
                throw new NucleusException("Dont currently support invoke expression argument " + argExpr);
            }
            if (expr.getOperation() != null && expr.getOperation().equals("INDEX")) {
                String joinAlias;
                List indexArgs = expr.getArguments();
                if (indexArgs == null || indexArgs.size() > 1) {
                    throw new NucleusException("Can only use INDEX with single argument");
                }
                PrimaryExpression indexExpr = (PrimaryExpression)indexArgs.get(0);
                String collExprName = joinAlias = indexExpr.getId();
                if (this.explicitJoinPrimaryByAlias != null && (collExprName = this.explicitJoinPrimaryByAlias.get(joinAlias)) == null) {
                    throw new NucleusException("Unable to locate primary expression for alias " + joinAlias);
                }
                ArrayList<String> tuples = new ArrayList<String>();
                StringTokenizer primTokenizer = new StringTokenizer(collExprName, ".");
                while (primTokenizer.hasMoreTokens()) {
                    String token = primTokenizer.nextToken();
                    tuples.add(token);
                }
                PrimaryExpression collPrimExpr = new PrimaryExpression(tuples);
                this.processPrimaryExpression(collPrimExpr);
                SQLExpression collSqlExpr = this.stack.pop();
                sqlExprArgs.add(collSqlExpr);
            }
        }
        SQLExpression sqlExpr = null;
        sqlExpr = invokedSqlExpr != null ? invokedSqlExpr.invoke(operation, sqlExprArgs) : this.exprFactory.invokeMethod(this.stmt, null, operation, null, sqlExprArgs);
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processSubqueryExpression(SubqueryExpression expr) {
        String keyword = expr.getKeyword();
        Expression subqueryExpr = expr.getRight();
        if (subqueryExpr instanceof VariableExpression) {
            this.processVariableExpression((VariableExpression)subqueryExpr);
            SQLExpression subquerySqlExpr = this.stack.pop();
            if (keyword != null && keyword.equals("EXISTS")) {
                if (subquerySqlExpr instanceof org.datanucleus.store.rdbms.sql.expression.SubqueryExpression) {
                    SQLStatement subStmt = ((org.datanucleus.store.rdbms.sql.expression.SubqueryExpression)subquerySqlExpr).getSubqueryStatement();
                    subquerySqlExpr = new BooleanSubqueryExpression(this.stmt, keyword, subStmt);
                } else {
                    SQLStatement subStmt = ((SubqueryExpressionComponent)((Object)subquerySqlExpr)).getSubqueryStatement();
                    subquerySqlExpr = new BooleanSubqueryExpression(this.stmt, keyword, subStmt);
                }
            } else if (subquerySqlExpr instanceof org.datanucleus.store.rdbms.sql.expression.SubqueryExpression) {
                SQLStatement subStmt = ((org.datanucleus.store.rdbms.sql.expression.SubqueryExpression)subquerySqlExpr).getSubqueryStatement();
                subquerySqlExpr = new BooleanSubqueryExpression(this.stmt, keyword, subStmt);
            } else if (subquerySqlExpr instanceof NumericSubqueryExpression) {
                ((NumericSubqueryExpression)subquerySqlExpr).setKeyword(keyword);
            }
            this.stack.push(subquerySqlExpr);
            return subquerySqlExpr;
        }
        throw new NucleusException("Dont currently support SubqueryExpression " + keyword + " for type " + subqueryExpr);
    }

    protected Object processAddExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        SQLExpression resultExpr = left.add(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processDivExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.div(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processMulExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.mul(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processSubExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        if (left instanceof ParameterLiteral && !(right instanceof ParameterLiteral)) {
            left = this.replaceParameterLiteral((ParameterLiteral)left, right.getJavaTypeMapping());
        } else if (right instanceof ParameterLiteral && !(left instanceof ParameterLiteral)) {
            right = this.replaceParameterLiteral((ParameterLiteral)right, left.getJavaTypeMapping());
        }
        SQLExpression resultExpr = left.sub(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processDistinctExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        sqlExpr.distinct();
        this.stack.push(sqlExpr);
        return sqlExpr;
    }

    protected Object processComExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        SQLExpression resultExpr = sqlExpr.com();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processModExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression resultExpr = left.mod(right);
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processNegExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        SQLExpression resultExpr = sqlExpr.neg();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processNotExpression(Expression expr) {
        SQLExpression sqlExpr = this.stack.pop();
        BooleanExpression resultExpr = sqlExpr.not();
        this.stack.push(resultExpr);
        return resultExpr;
    }

    protected Object processCastExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        SQLExpression castExpr = left.cast(right);
        this.stack.push(castExpr);
        return castExpr;
    }

    protected Object processCaseExpression(org.datanucleus.query.expression.CaseExpression expr) {
        Map conditions = expr.getConditions();
        Iterator whenExprIter = conditions.entrySet().iterator();
        SQLExpression[] whenSqlExprs = new SQLExpression[conditions.size()];
        SQLExpression[] actionSqlExprs = new SQLExpression[conditions.size()];
        int i = 0;
        while (whenExprIter.hasNext()) {
            Map.Entry entry = whenExprIter.next();
            Expression whenExpr = (Expression)entry.getKey();
            whenExpr.evaluate((ExpressionEvaluator)this);
            whenSqlExprs[i] = this.stack.pop();
            Expression actionExpr = (Expression)entry.getValue();
            actionExpr.evaluate((ExpressionEvaluator)this);
            actionSqlExprs[i] = this.stack.pop();
            ++i;
        }
        Expression elseExpr = expr.getElseExpression();
        elseExpr.evaluate((ExpressionEvaluator)this);
        SQLExpression elseSqlExpr = this.stack.pop();
        CaseExpression caseSqlExpr = new CaseExpression(whenSqlExprs, actionSqlExprs, elseSqlExpr);
        this.stack.push(caseSqlExpr);
        return caseSqlExpr;
    }

    protected Object processIsExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        BooleanExpression instanceofExpr = left.is(right, false);
        this.stack.push(instanceofExpr);
        return instanceofExpr;
    }

    protected Object processIsnotExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        BooleanExpression instanceofExpr = left.is(right, true);
        this.stack.push(instanceofExpr);
        return instanceofExpr;
    }

    protected Object processInExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        BooleanExpression inExpr = left.in(right, false);
        this.stack.push(inExpr);
        return inExpr;
    }

    protected Object processNotInExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        BooleanExpression inExpr = left.in(right, true);
        this.stack.push(inExpr);
        return inExpr;
    }

    protected Object processCreatorExpression(CreatorExpression expr) {
        Class cls;
        String className;
        block5: {
            className = expr.getId();
            cls = null;
            try {
                cls = this.clr.classForName(className);
            }
            catch (ClassNotResolvedException cnre) {
                if (this.importsDefinition == null) break block5;
                cls = this.importsDefinition.resolveClassDeclaration(className, this.clr, null);
            }
        }
        ArrayList<SQLExpression> ctrArgExprs = null;
        List args = expr.getArguments();
        if (args != null) {
            Object[] ctrArgTypes = new Class[args.size()];
            ctrArgExprs = new ArrayList<SQLExpression>(args.size());
            Iterator iter = args.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Expression argExpr = (Expression)iter.next();
                SQLExpression sqlExpr = (SQLExpression)this.evaluate(argExpr);
                ctrArgExprs.add(sqlExpr);
                ctrArgTypes[i] = sqlExpr instanceof NewObjectExpression ? ((NewObjectExpression)sqlExpr).getNewClass() : (sqlExpr.getJavaTypeMapping() instanceof OIDMapping ? this.clr.classForName(sqlExpr.getJavaTypeMapping().getType()) : sqlExpr.getJavaTypeMapping().getJavaType());
                ++i;
            }
            Constructor ctr = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])ctrArgTypes);
            if (ctr == null) {
                throw new NucleusUserException(LOCALISER.msg("021033", (Object)className, (Object)StringUtils.objectArrayToString((Object[])ctrArgTypes)));
            }
        }
        NewObjectExpression newExpr = new NewObjectExpression(this.stmt, cls, ctrArgExprs);
        this.stack.push(newExpr);
        return newExpr;
    }

    protected Object processLikeExpression(Expression expr) {
        SQLExpression right = this.stack.pop();
        SQLExpression left = this.stack.pop();
        ArrayList<SQLExpression> args = new ArrayList<SQLExpression>();
        args.add(right);
        SQLExpression likeExpr = this.exprFactory.invokeMethod(this.stmt, String.class.getName(), "like", left, args);
        this.stack.push(likeExpr);
        return likeExpr;
    }

    protected Object processVariableExpression(VariableExpression expr) {
        Symbol varSym = expr.getSymbol();
        String varName = varSym.getQualifiedName();
        if (this.hasSQLTableMappingForAlias(varName)) {
            SQLTableMapping tblMapping = this.getSQLTableMappingForAlias(varName);
            SQLExpression sqlExpr = this.exprFactory.newExpression(tblMapping.table.getSQLStatement(), tblMapping.table, tblMapping.mapping);
            this.stack.push(sqlExpr);
            return sqlExpr;
        }
        if (this.compilation.getCompilationForSubquery(varName) != null) {
            QueryCompilation subCompilation = this.compilation.getCompilationForSubquery(varName);
            AbstractClassMetaData subCmd = this.ec.getMetaDataManager().getMetaDataForClass(subCompilation.getCandidateClass(), this.ec.getClassLoaderResolver());
            String subAlias = null;
            if (subCompilation.getCandidateAlias() != null && !subCompilation.getCandidateAlias().equals(this.candidateAlias)) {
                subAlias = subCompilation.getCandidateAlias();
            }
            StatementResultMapping subqueryResultMapping = new StatementResultMapping();
            SQLStatement subStmt = RDBMSQueryUtils.getStatementForCandidates(this.stmt, subCmd, null, this.ec, subCompilation.getCandidateClass(), true, "avg(something)", subAlias, null);
            QueryToSQLMapper sqlMapper = new QueryToSQLMapper(subStmt, subCompilation, this.parameters, null, subqueryResultMapping, subCmd, this.fetchPlan, this.ec, this.importsDefinition, this.options, this.extensionsByName);
            sqlMapper.setParentMapper(this);
            sqlMapper.compile();
            if (subqueryResultMapping.getNumberOfResultExpressions() > 1) {
                throw new NucleusUserException("Number of result expressions in subquery should be 1");
            }
            SQLExpression subExpr = null;
            if (subqueryResultMapping.getNumberOfResultExpressions() == 0) {
                subExpr = new org.datanucleus.store.rdbms.sql.expression.SubqueryExpression(this.stmt, subStmt);
            } else {
                JavaTypeMapping subMapping = ((StatementMappingIndex)subqueryResultMapping.getMappingForResultExpression(0)).getMapping();
                subExpr = subMapping instanceof TemporalMapping ? new TemporalSubqueryExpression(this.stmt, subStmt) : (subMapping instanceof StringMapping ? new StringSubqueryExpression(this.stmt, subStmt) : new NumericSubqueryExpression(this.stmt, subStmt));
                if (subExpr.getJavaTypeMapping() == null) {
                    subExpr.setJavaTypeMapping(subMapping);
                }
            }
            this.stack.push(subExpr);
            return subExpr;
        }
        if (this.stmt.getParentStatement() != null && this.parentMapper != null && this.parentMapper.candidateAlias != null && this.parentMapper.candidateAlias.equals(varName)) {
            SQLExpression varExpr = this.exprFactory.newExpression(this.stmt.getParentStatement(), this.stmt.getParentStatement().getPrimaryTable(), this.stmt.getParentStatement().getPrimaryTable().getTable().getIdMapping());
            this.stack.push(varExpr);
            return varExpr;
        }
        NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.processVariable (unbound) variable=" + varName + " is not yet bound so returning UnboundExpression"));
        UnboundExpression unbExpr = new UnboundExpression(this.stmt, varName);
        this.stack.push(unbExpr);
        return unbExpr;
    }

    protected SQLExpression processUnboundExpression(UnboundExpression expr) {
        String varName = expr.getVariableName();
        Symbol varSym = this.compilation.getSymbolTable().getSymbol(varName);
        SQLExpression sqlExpr = this.bindVariable(expr, varSym.getValueType());
        if (sqlExpr != null) {
            this.stack.push(sqlExpr);
            return sqlExpr;
        }
        throw new NucleusUserException("Variable " + varName + " is unbound and cannot be determined");
    }

    protected SQLExpression replaceParameterLiteral(ParameterLiteral paramLit, JavaTypeMapping mapping) {
        return this.exprFactory.newLiteralParameter(this.stmt, mapping, paramLit.getValue(), paramLit.getParameterName());
    }

    @Override
    public void useParameterExpressionAsLiteral(SQLLiteral paramLiteral) {
        paramLiteral.setNotParameter();
        this.precompilable = false;
    }

    @Override
    public boolean hasExtension(String key) {
        return this.extensionsByName == null ? false : this.extensionsByName.containsKey(key);
    }

    @Override
    public Object getValueForExtension(String key) {
        return this.extensionsByName == null ? null : this.extensionsByName.get(key);
    }

    public SQLJoin.JoinType getRequiredJoinTypeForAlias(String alias) {
        if (alias == null) {
            return null;
        }
        if (alias.equals(this.candidateAlias)) {
            return null;
        }
        String extensionName = "datanucleus.query.jdoql." + alias + ".join";
        SQLJoin.JoinType joinType = null;
        if (this.hasExtension(extensionName)) {
            String joinValue = (String)this.getValueForExtension(extensionName);
            if (joinValue.equalsIgnoreCase("INNERJOIN")) {
                joinType = SQLJoin.JoinType.INNER_JOIN;
            } else if (joinValue.equalsIgnoreCase("LEFTOUTERJOIN")) {
                joinType = SQLJoin.JoinType.LEFT_OUTER_JOIN;
            }
        }
        return joinType;
    }

    protected Object getValueForObjectField(Object obj, String fieldName) {
        if (obj != null) {
            Object paramFieldValue = null;
            if (this.ec.getApiAdapter().isPersistable(obj)) {
                ObjectProvider paramSM = this.ec.findObjectProvider(obj);
                AbstractClassMetaData paramCmd = this.ec.getMetaDataManager().getMetaDataForClass(obj.getClass(), this.clr);
                AbstractMemberMetaData paramFieldMmd = paramCmd.getMetaDataForMember(fieldName);
                if (paramSM != null) {
                    this.ec.getApiAdapter().isLoaded(paramSM, paramFieldMmd.getAbsoluteFieldNumber());
                    paramFieldValue = paramSM.provideField(paramFieldMmd.getAbsoluteFieldNumber());
                } else {
                    paramFieldValue = ClassUtils.getValueOfFieldByReflection((Object)obj, (String)fieldName);
                }
            } else {
                paramFieldValue = ClassUtils.getValueOfFieldByReflection((Object)obj, (String)fieldName);
            }
            return paramFieldValue;
        }
        return null;
    }

    protected SQLTableMapping getSQLTableMappingForAlias(String alias) {
        if (alias == null) {
            return null;
        }
        if (this.options.contains(OPTION_CASE_INSENSITIVE)) {
            return this.sqlTableByPrimary.get(alias.toUpperCase());
        }
        return this.sqlTableByPrimary.get(alias);
    }

    @Override
    public SQLTable getSQLTableForAlias(String alias) {
        SQLTableMapping tblMapping = this.getSQLTableMappingForAlias(alias);
        return tblMapping != null ? tblMapping.table : null;
    }

    public String getAliasForSQLTable(SQLTable tbl) {
        Iterator<Map.Entry<String, SQLTableMapping>> iter = this.sqlTableByPrimary.entrySet().iterator();
        String alias = null;
        while (iter.hasNext()) {
            Map.Entry<String, SQLTableMapping> entry = iter.next();
            if (entry.getValue().table != tbl) continue;
            if (alias == null) {
                alias = entry.getKey();
                continue;
            }
            if (entry.getKey().length() >= alias.length()) continue;
            alias = entry.getKey();
        }
        return alias;
    }

    protected void setSQLTableMappingForAlias(String alias, SQLTableMapping mapping) {
        if (alias == null) {
            return;
        }
        if (this.options.contains(OPTION_CASE_INSENSITIVE)) {
            this.sqlTableByPrimary.put(alias.toUpperCase(), mapping);
        } else {
            this.sqlTableByPrimary.put(alias, mapping);
        }
    }

    protected boolean hasSQLTableMappingForAlias(String alias) {
        if (this.options.contains(OPTION_CASE_INSENSITIVE)) {
            return this.sqlTableByPrimary.containsKey(alias.toUpperCase());
        }
        return this.sqlTableByPrimary.containsKey(alias);
    }

    @Override
    public void bindVariable(String varName, AbstractClassMetaData cmd, SQLTable sqlTbl, JavaTypeMapping mapping) {
        SQLTableMapping m = this.getSQLTableMappingForAlias(varName);
        if (m != null) {
            throw new NucleusException("Variable " + varName + " is already bound to " + m.table + " yet attempting to bind to " + sqlTbl);
        }
        NucleusLogger.QUERY.debug((Object)(">> QueryToSQL.bindVariable variable " + varName + " being bound to table=" + sqlTbl + " mapping=" + mapping));
        m = new SQLTableMapping(sqlTbl, cmd, mapping);
        this.setSQLTableMappingForAlias(varName, m);
    }

    @Override
    public SQLExpression bindVariable(UnboundExpression expr, Class type) {
        AbstractClassMetaData cmd;
        String varName = expr.getVariableName();
        Symbol varSym = this.compilation.getSymbolTable().getSymbol(varName);
        if (varSym.getValueType() == null) {
            varSym.setValueType(type);
        }
        if ((cmd = this.ec.getMetaDataManager().getMetaDataForClass(type, this.clr)) != null) {
            DatastoreClass varTable = this.storeMgr.getDatastoreClass(varSym.getValueType().getName(), this.clr);
            SQLTable varSqlTbl = this.stmt.crossJoin((DatastoreContainerObject)varTable, "VAR_" + varName, null);
            SQLTableMapping varSqlTblMapping = new SQLTableMapping(varSqlTbl, cmd, varTable.getIdMapping());
            this.setSQLTableMappingForAlias(varName, varSqlTblMapping);
            return this.exprFactory.newExpression(this.stmt, varSqlTbl, varTable.getIdMapping());
        }
        return null;
    }

    @Override
    public void bindParameter(String paramName, Class type) {
        Symbol paramSym = this.compilation.getSymbolTable().getSymbol(paramName);
        if (paramSym != null && paramSym.getValueType() == null) {
            paramSym.setValueType(type);
        }
    }

    @Override
    public Class getTypeOfVariable(String varName) {
        Symbol sym = this.compilation.getSymbolTable().getSymbol(varName);
        if (sym != null && sym.getValueType() != null) {
            return sym.getValueType();
        }
        return null;
    }

    @Override
    public boolean hasExplicitJoins() {
        return this.options.contains(OPTION_EXPLICIT_JOINS);
    }

    protected BooleanExpression getBooleanExpressionForUseInFilter(BooleanExpression expr) {
        if (this.compileComponent != CompilationComponent.FILTER) {
            return expr;
        }
        if (!expr.hasClosure()) {
            return new BooleanExpression(expr, Expression.OP_EQ, new BooleanLiteral(this.stmt, expr.getJavaTypeMapping(), Boolean.TRUE, null));
        }
        return expr;
    }

    @Override
    public Class resolveClass(String className) {
        Class cls;
        block2: {
            cls = null;
            try {
                cls = this.clr.classForName(className);
            }
            catch (ClassNotResolvedException cnre) {
                if (this.importsDefinition == null) break block2;
                cls = this.importsDefinition.resolveClassDeclaration(className, this.clr, null);
            }
        }
        return cls;
    }

    static class SQLTableMapping {
        SQLTable table;
        AbstractClassMetaData cmd;
        JavaTypeMapping mapping;

        public SQLTableMapping(SQLTable tbl, AbstractClassMetaData cmd, JavaTypeMapping m) {
            this.table = tbl;
            this.cmd = cmd;
            this.mapping = m;
        }

        public String toString() {
            return "SQLTableMapping: tbl=" + this.table + " class=" + (this.cmd != null ? this.cmd.getFullClassName() : "null") + " mapping=" + this.mapping;
        }
    }
}

