/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementParameterMapping;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.MapEntrySetStore;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.scostore.MapStore;

class RDBMSMapEntrySetStore
extends MapEntrySetStore {
    private String sizeStmt;
    private String iteratorStmtLocked = null;
    private String iteratorStmtUnlocked = null;
    private StatementParameterMapping iteratorMappingParams = null;
    private int[] iteratorKeyResultCols = null;
    private int[] iteratorValueResultCols = null;

    RDBMSMapEntrySetStore(MapTable mapTable, MapStore mapStore, ClassLoaderResolver clr) {
        super((DatastoreContainerObject)mapTable, mapTable.getOwnerMemberMetaData(), mapTable.getOwnerMapping(), mapTable.getKeyMapping(), mapTable.getValueMapping(), mapStore, clr);
    }

    RDBMSMapEntrySetStore(DatastoreContainerObject mapTable, MapStore mapStore, ClassLoaderResolver clr, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, AbstractMemberMetaData ownerMmd) {
        super(mapTable, ownerMmd, ownerMapping, keyMapping, valueMapping, mapStore, clr);
    }

    RDBMSStoreManager getStoreMgr() {
        return (RDBMSStoreManager)this.storeMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(ObjectProvider sm) {
        int numRows;
        String stmt = this.getSizeStmt();
        try {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.getStoreMgr().getConnection(ec);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, (BaseContainerStore)this);
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new NucleusDataStoreException("Size request returned no result row: " + stmt);
                        }
                        numRows = rs.getInt(1);
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Size request failed: " + stmt, (Throwable)e);
        }
        return numRows;
    }

    private String getSizeStmt() {
        if (this.sizeStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("SELECT COUNT(*) FROM ");
            stmt.append(this.mapTable.toString());
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (this.keyMapping != null) {
                for (i = 0; i < this.keyMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(this.keyMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" IS NOT NULL");
                }
            }
            this.sizeStmt = stmt.toString();
        }
        return this.sizeStmt;
    }

    /*
     * Exception decompiling
     */
    public Iterator iterator(ObjectProvider ownerSM) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected SQLStatement getSQLStatementForIterator(ObjectProvider ownerSM) {
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.storeMgr;
        SQLStatement sqlStmt = new SQLStatement(storeMgr, this.mapTable, null, null);
        sqlStmt.setClassLoaderResolver(this.clr);
        this.iteratorKeyResultCols = sqlStmt.select(sqlStmt.getPrimaryTable(), this.keyMapping, null);
        this.iteratorValueResultCols = sqlStmt.select(sqlStmt.getPrimaryTable(), this.valueMapping, null);
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        SQLExpression keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
        SQLExpression nullExpr = exprFactory.newLiteral(sqlStmt, null, null);
        sqlStmt.whereAnd(keyExpr.ne(nullExpr), true);
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
                for (int k = 0; k < this.ownerMapping.getNumberOfDatastoreMappings(); ++k) {
                    paramPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(paramPositions);
            }
        } else {
            int[] paramPositions = new int[this.ownerMapping.getNumberOfDatastoreMappings()];
            for (int k = 0; k < this.ownerMapping.getNumberOfDatastoreMappings(); ++k) {
                paramPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(paramPositions);
        }
        this.iteratorMappingParams = new StatementParameterMapping();
        this.iteratorMappingParams.addMappingForParameter("owner", ownerIdx);
        return sqlStmt;
    }

    private static class EntryImpl
    implements Map.Entry {
        private final ObjectProvider sm;
        private final Object key;
        private final Object value;
        private final MapStore mapStore;

        public EntryImpl(ObjectProvider sm, Object key, Object value, MapStore mapStore) {
            this.sm = sm;
            this.key = key;
            this.value = value;
            this.mapStore = mapStore;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return this.mapStore.put(this.sm, this.key, value);
        }
    }

    public static abstract class SetIterator
    implements Iterator {
        private final ObjectProvider sm;
        private final ExecutionContext ec;
        private final Iterator delegate;
        private Map.Entry lastElement = null;
        private final MapEntrySetStore setStore;

        protected SetIterator(ObjectProvider sm, MapEntrySetStore setStore, AbstractMemberMetaData ownerMmd, Object rs, int[] keyResultCols, int[] valueResultCols) throws MappedDatastoreException {
            this.sm = sm;
            this.ec = sm.getExecutionContext();
            this.setStore = setStore;
            ArrayList<EntryImpl> results = new ArrayList<EntryImpl>();
            while (this.next(rs)) {
                JavaTypeMapping keyMapping;
                Object key = null;
                Object value = null;
                int ownerFieldNum = -1;
                if (ownerMmd != null) {
                    ownerFieldNum = ownerMmd.getAbsoluteFieldNumber();
                }
                key = (keyMapping = setStore.getKeyMapping()) instanceof EmbeddedKeyPCMapping || keyMapping instanceof SerialisedPCMapping || keyMapping instanceof SerialisedReferenceMapping ? keyMapping.getObject(this.ec, rs, keyResultCols, sm, ownerFieldNum) : keyMapping.getObject(this.ec, rs, keyResultCols);
                JavaTypeMapping valueMapping = setStore.getValueMapping();
                value = valueMapping instanceof EmbeddedValuePCMapping || valueMapping instanceof SerialisedPCMapping || valueMapping instanceof SerialisedReferenceMapping ? valueMapping.getObject(this.ec, rs, valueResultCols, sm, ownerFieldNum) : valueMapping.getObject(this.ec, rs, valueResultCols);
                results.add(new EntryImpl(sm, key, value, setStore.getMapStore()));
            }
            this.delegate = results.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = (Map.Entry)this.delegate.next();
            return this.lastElement;
        }

        public synchronized void remove() {
            if (this.lastElement == null) {
                throw new IllegalStateException("No entry to remove");
            }
            this.setStore.getMapStore().remove(this.sm, this.lastElement.getKey());
            this.delegate.remove();
            this.lastElement = null;
        }

        protected abstract boolean next(Object var1) throws MappedDatastoreException;
    }
}

