/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public final class ForwardQueryResult
extends AbstractRDBMSQueryResult {
    protected boolean moreResultSetRows;
    protected List resultObjs = new ArrayList();
    protected List resultIds = null;
    private Collection candidates;

    public ForwardQueryResult(Query query, ResultObjectFactory rof, ResultSet rs, Collection candidates) throws SQLException {
        super(query, rof, rs);
        if (query.useResultsCaching()) {
            this.resultIds = new ArrayList();
        }
        if (candidates != null) {
            this.candidates = new ArrayList(candidates);
        }
        this.moreResultSetRows = rs.next();
        if (this.applyRangeChecks()) {
            int i = 0;
            while ((long)i < query.getRangeFromIncl()) {
                this.moreResultSetRows = rs.next();
                if (!this.moreResultSetRows) break;
                ++i;
            }
        }
        int fetchSize = query.getFetchPlan().getFetchSize();
        if (!this.moreResultSetRows) {
            this.closeResults();
        } else if (!query.getObjectManager().getTransaction().isActive() || fetchSize == -1) {
            this.advanceToEndOfResultSet();
        } else if (fetchSize > 0) {
            this.processNumberOfResults(fetchSize);
        }
    }

    public boolean handlesResultRange() {
        boolean handleRange;
        return this.query == null || (handleRange = this.query.getBooleanExtensionProperty("datanucleus.processRangeInQueryResult", true));
    }

    private void processNumberOfResults(int number) {
        Iterator iter = this.iterator();
        if (number < 0) {
            while (iter.hasNext()) {
                iter.next();
            }
        } else {
            for (int i = 0; i < number; ++i) {
                if (!iter.hasNext()) continue;
                iter.next();
            }
        }
    }

    private void advanceToEndOfResultSet() {
        this.processNumberOfResults(-1);
    }

    protected Object nextResultSetElement() {
        if (this.rof == null) {
            return null;
        }
        ExecutionContext ec = this.query.getObjectManager();
        Object nextElement = this.rof.getObject(ec, (Object)this.rs);
        JDBCUtils.logWarnings(this.rs);
        this.resultObjs.add(nextElement);
        if (this.resultIds != null) {
            this.resultIds.add(ec.getApiAdapter().getIdForObject(nextElement));
        }
        try {
            this.moreResultSetRows = this.rs.next();
            if (this.applyRangeChecks()) {
                int maxElements = (int)(this.query.getRangeToExcl() - this.query.getRangeFromIncl());
                if (this.resultObjs.size() == maxElements) {
                    this.moreResultSetRows = false;
                }
            }
            if (!this.moreResultSetRows) {
                this.closeResults();
            }
        }
        catch (SQLException e) {
            throw ec.getApiAdapter().getDataStoreExceptionForException(LOCALISER.msg("052601", (Object)e.getMessage()), (Exception)e);
        }
        return nextElement;
    }

    protected void closeResults() {
        super.closeResults();
        if (this.resultIds != null) {
            this.query.getQueryManager().addDatastoreQueryResult(this.query, this.query.getInputParameters(), this.resultIds);
            this.resultIds = null;
        }
    }

    public synchronized void close() {
        this.moreResultSetRows = false;
        this.resultObjs.clear();
        if (this.resultIds != null) {
            this.resultIds.clear();
        }
        super.close();
    }

    protected void closingConnection() {
        if (this.loadResultsAtCommit && this.isOpen() && this.moreResultSetRows) {
            NucleusLogger.QUERY.info((Object)LOCALISER.msg("052606", (Object)this.query.toString()));
            try {
                this.advanceToEndOfResultSet();
            }
            catch (RuntimeException re) {
                if (re instanceof NucleusUserException) {
                    NucleusLogger.QUERY.warn((Object)("Exception thrown while loading remaining rows of query : " + re.getMessage()));
                }
                throw this.query.getObjectManager().getApiAdapter().getUserExceptionForException("Exception thrown while loading remaining rows of query", (Exception)re);
            }
        }
    }

    public Iterator iterator() {
        return new QueryResultIterator();
    }

    public ListIterator listIterator() {
        return new QueryResultIterator();
    }

    public synchronized boolean contains(Object o) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.contains(o);
    }

    public synchronized boolean containsAll(Collection c) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.containsAll(c);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ForwardQueryResult)) {
            return false;
        }
        ForwardQueryResult other = (ForwardQueryResult)((Object)o);
        if (this.rs != null) {
            return other.rs == this.rs;
        }
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString((Object)((Object)other)).equals(StringUtils.toJVMIDString((Object)((Object)this)));
    }

    public synchronized Object get(int index) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        if (index < 0 || index >= this.resultObjs.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.resultObjs.get(index);
    }

    public synchronized boolean isEmpty() {
        this.assertIsOpen();
        return this.resultObjs.isEmpty() && !this.moreResultSetRows;
    }

    protected int getSizeUsingMethod() {
        long sizeEnd;
        long sizeStart;
        if (this.resultSizeMethod.equalsIgnoreCase("LAST")) {
            this.advanceToEndOfResultSet();
            return this.resultObjs.size();
        }
        long size = super.getSizeUsingMethod();
        if (this.applyRangeChecks() && this.resultSizeMethod.equalsIgnoreCase("COUNT") && (size -= (sizeStart = this.query.getRangeFromIncl())) > (sizeEnd = this.query.getRangeToExcl()) - sizeStart) {
            size = sizeEnd - sizeStart;
        }
        return (int)size;
    }

    public synchronized Object[] toArray() {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.toArray(a);
    }

    private class QueryResultIterator
    extends AbstractQueryResultIterator {
        private int nextRowNum = 0;
        Object currentElement = null;

        private QueryResultIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            ForwardQueryResult forwardQueryResult = ForwardQueryResult.this;
            synchronized (forwardQueryResult) {
                int maxElements;
                if (!ForwardQueryResult.this.isOpen()) {
                    return false;
                }
                if (ForwardQueryResult.this.applyRangeChecks() && this.nextRowNum == (maxElements = (int)(ForwardQueryResult.this.query.getRangeToExcl() - ForwardQueryResult.this.query.getRangeFromIncl()))) {
                    ForwardQueryResult.this.moreResultSetRows = false;
                    ForwardQueryResult.this.closeResults();
                    return false;
                }
                if (this.nextRowNum < ForwardQueryResult.this.resultObjs.size()) {
                    return true;
                }
                if (ForwardQueryResult.this.candidates != null && this.currentElement != null && !ForwardQueryResult.this.moreResultSetRows) {
                    return ForwardQueryResult.this.candidates.contains(this.currentElement);
                }
                return ForwardQueryResult.this.moreResultSetRows;
            }
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object next() {
            ForwardQueryResult forwardQueryResult = ForwardQueryResult.this;
            synchronized (forwardQueryResult) {
                if (!ForwardQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(LOCALISER.msg("052600"));
                }
                if (ForwardQueryResult.this.candidates != null && this.currentElement != null && ForwardQueryResult.this.candidates.remove(this.currentElement)) {
                    ForwardQueryResult.this.resultObjs.add(this.currentElement);
                    return this.currentElement;
                }
                if (this.nextRowNum < ForwardQueryResult.this.resultObjs.size()) {
                    this.currentElement = ForwardQueryResult.this.resultObjs.get(this.nextRowNum);
                    ++this.nextRowNum;
                    return this.currentElement;
                }
                if (ForwardQueryResult.this.moreResultSetRows) {
                    this.currentElement = ForwardQueryResult.this.nextResultSetElement();
                    ++this.nextRowNum;
                    if (ForwardQueryResult.this.candidates != null) {
                        ForwardQueryResult.this.candidates.remove(this.currentElement);
                    }
                    return this.currentElement;
                }
                throw new NoSuchElementException(LOCALISER.msg("052602"));
            }
        }

        public int nextIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object previous() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int previousIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

