/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.query.JDOQLQueryHelper;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.AggregateExpression;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.ClassExpression;
import org.datanucleus.store.mapped.expression.CollectionExpression;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.MapExpression;
import org.datanucleus.store.mapped.expression.NewObjectExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.UnboundVariable;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.rdbms.query.legacy.JDOQLQuery;
import org.datanucleus.store.rdbms.query.legacy.Parser;
import org.datanucleus.store.rdbms.query.legacy.QueryResultsMetaData;
import org.datanucleus.store.rdbms.query.legacy.ResultExpressionsQueryable;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.store.rdbms.table.ElementContainerTable;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class QueryCompiler
implements UnboundVariable.VariableBinder {
    public static final int COMPILE_EXPLICIT_PARAMETERS = 1;
    public static final int COMPILE_EXPLICIT_VARIABLES = 2;
    public static final int COMPILE_SYNTAX = 3;
    public static final int COMPILE_EXECUTION = 4;
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    protected String language;
    protected Query query;
    protected Imports imports;
    protected Map parameters;
    protected boolean executionCompile = true;
    protected Class candidateClass = null;
    protected String candidateAlias = "this";
    protected List<String> parameterNames = null;
    protected Map<String, Class> parameterTypesByName = null;
    protected List<String> variableNames = null;
    protected Map<String, Class> variableTypesByName = null;
    List<ScalarExpression> fieldExpressions = new ArrayList<ScalarExpression>();
    protected QueryResultsMetaData resultMetaData;
    protected QueryExpression qs = null;
    protected QueryExpression parentExpr;
    protected Map<String, ScalarExpression> expressionsByVariableName = new HashMap<String, ScalarExpression>();
    protected Parser p = null;
    protected AbstractClassMetaData candidateCmd = null;
    protected Queryable candidates = null;
    protected Class resultClass = null;
    protected long rangeFromIncl = -1L;
    protected long rangeToExcl = -1L;
    protected String subqueryCandidateExpr;
    protected AliasJoinInformation subqueryCandidateExprRootAliasInfo = null;
    protected static transient Map userDefinedScalarExpressions = new Hashtable();

    public QueryCompiler(Query query, Imports imports, Map parameters) {
        if (userDefinedScalarExpressions.isEmpty()) {
            this.registerScalarExpressions(query.getObjectManager().getOMFContext().getPluginManager(), query.getObjectManager().getClassLoaderResolver());
        }
        this.query = query;
        this.imports = imports;
        this.parameters = parameters;
        this.candidateClass = query.getCandidateClass();
        this.candidates = ((JDOQLQuery)query).getCandidates();
        this.resultClass = query.getResultClass();
        this.rangeFromIncl = query.getRangeFromIncl();
        this.rangeToExcl = query.getRangeToExcl();
    }

    public void close() {
        this.query = null;
        this.imports = null;
        this.variableNames = null;
        this.parameterNames = null;
        this.variableTypesByName = null;
        this.parameterTypesByName = null;
        this.parameters = null;
        this.expressionsByVariableName = null;
        this.qs = null;
        this.fieldExpressions = null;
    }

    public Object compile(int type) {
        switch (type) {
            case 3: {
                this.compile(1);
                this.compile(2);
                this.preCompile();
                return null;
            }
            case 4: {
                this.compile(1);
                this.compile(2);
                return this.executionCompile();
            }
            case 1: {
                this.compileExplicitParameters();
                return null;
            }
            case 2: {
                this.compileExplicitVariables();
                return null;
            }
        }
        throw new NucleusException("Query Compiler doesnt support compilation of type " + type);
    }

    protected void preCompile() {
        this.executionCompile = false;
        this.compileCandidates();
        MappedStoreManager storeMgr = (MappedStoreManager)this.query.getObjectManager().getStoreManager();
        DatastoreIdentifier candidateAliasId = storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, this.candidateAlias);
        this.qs = this.candidates.newQueryStatement(this.candidateClass, candidateAliasId);
        if (this.parentExpr != null) {
            this.qs.setParent(this.parentExpr);
        }
        this.qs.setCandidateInformation(this.candidateClass, this.candidateAlias);
        this.performCompile(this.qs);
        this.executionCompile = true;
    }

    protected QueryExpression executionCompile() {
        String type;
        this.compileCandidates();
        if (this.candidates instanceof ResultExpressionsQueryable) {
            ((ResultExpressionsQueryable)this.candidates).setHasAggregatedExpressionsOnly(QueryUtils.resultHasOnlyAggregates((String)this.query.getResult()));
        }
        MappedStoreManager storeMgr = (MappedStoreManager)this.query.getObjectManager().getStoreManager();
        DatastoreIdentifier candidateAliasId = storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, this.candidateAlias);
        this.qs = this.candidates.newQueryStatement(this.candidateClass, candidateAliasId);
        if (this.parentExpr != null) {
            this.qs.setParent(this.parentExpr);
        }
        this.qs.setCandidateInformation(this.candidateClass, this.candidateAlias);
        PersistenceConfiguration config = this.query.getObjectManager().getOMFContext().getPersistenceConfiguration();
        String propName = "datanucleus.rdbms.jdoql.joinType";
        String joinType = config.getStringProperty(propName);
        if (this.query.getExtension(propName) != null && ((type = (String)this.query.getExtension(propName)).toUpperCase().equals("INNER") || type.toUpperCase().equals("LEFT OUTER"))) {
            joinType = type.toUpperCase();
        }
        if (joinType != null) {
            this.qs.addExtension(propName, (Object)joinType);
        }
        propName = "datanucleus.rdbms.jdoql.existsIncludesConstraints";
        boolean existsIncludes = config.getBooleanProperty(propName);
        if (this.query.getExtension(propName) != null) {
            existsIncludes = Boolean.valueOf((String)this.query.getExtension(propName));
            this.qs.addExtension(propName, (Object)("" + existsIncludes));
        }
        if (existsIncludes) {
            this.qs.addExtension(propName, (Object)"true");
        }
        propName = "datanucleus.rdbms.query.containsUsesExistsAlways";
        boolean existsAlways = config.getBooleanProperty(propName);
        if (this.query.getExtension(propName) != null) {
            existsAlways = Boolean.valueOf((String)this.query.getExtension(propName));
            this.qs.addExtension(propName, (Object)("" + existsAlways));
        }
        if (existsAlways) {
            this.qs.addExtension(propName, (Object)"true");
        }
        this.performCompile(this.qs);
        return this.qs;
    }

    protected abstract void performCompile(QueryExpression var1);

    protected abstract void compileCandidates();

    public QueryResultsMetaData getResultMetaData() {
        return this.resultMetaData;
    }

    public Queryable getCandidates() {
        return this.candidates;
    }

    public Class getResultClass() {
        return this.resultClass;
    }

    public long getRangeFromIncl() {
        return this.rangeFromIncl;
    }

    public long getRangeToExcl() {
        return this.rangeToExcl;
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public String getCandidateAlias() {
        return this.candidateAlias;
    }

    public String[] getParameterNames() {
        if (this.parameterNames == null) {
            return null;
        }
        return this.parameterNames.toArray(new String[this.parameterNames.size()]);
    }

    public Map getParameterTypesByName() {
        return this.parameterTypesByName;
    }

    protected void compileExplicitParameters() {
        this.parameterNames = new ArrayList<String>();
        this.parameterTypesByName = new HashMap<String, Class>();
        String explicitParameters = this.query.getExplicitParameters();
        if (explicitParameters != null && explicitParameters.length() > 0) {
            StringTokenizer t1 = new StringTokenizer(explicitParameters, ",");
            while (t1.hasMoreTokens()) {
                StringTokenizer t2 = new StringTokenizer(t1.nextToken(), " ");
                if (t2.countTokens() != 2) {
                    throw new NucleusUserException(LOCALISER.msg("021101", (Object)explicitParameters));
                }
                String classDecl = t2.nextToken();
                String parameterName = t2.nextToken();
                if (!JDOQLQueryHelper.isValidJavaIdentifierForJDOQL((String)parameterName)) {
                    throw new NucleusUserException(LOCALISER.msg("021102", (Object)parameterName));
                }
                if (this.parameterNames.contains(parameterName)) {
                    throw new NucleusUserException(LOCALISER.msg("021103", (Object)parameterName));
                }
                this.parameterNames.add(parameterName);
                this.parameterTypesByName.put(parameterName, this.query.resolveClassDeclaration(classDecl));
            }
        }
    }

    protected void compileExplicitVariables() {
        this.variableNames = new ArrayList<String>();
        this.variableTypesByName = new HashMap<String, Class>();
        String explicitVariables = this.query.getExplicitVariables();
        if (explicitVariables != null && explicitVariables.length() > 0) {
            StringTokenizer t1 = new StringTokenizer(explicitVariables, ";");
            while (t1.hasMoreTokens()) {
                StringTokenizer t2 = new StringTokenizer(t1.nextToken(), " ");
                if (t2.countTokens() != 2) {
                    throw new NucleusUserException(LOCALISER.msg("021104", (Object)explicitVariables));
                }
                String classDecl = t2.nextToken();
                String variableName = t2.nextToken();
                if (!JDOQLQueryHelper.isValidJavaIdentifierForJDOQL((String)variableName)) {
                    throw new NucleusUserException(LOCALISER.msg("021105", (Object)variableName));
                }
                if (this.parameterNames.contains(variableName)) {
                    throw new NucleusUserException(LOCALISER.msg("021106", (Object)variableName));
                }
                if (this.variableNames.contains(variableName)) {
                    throw new NucleusUserException(LOCALISER.msg("021107", (Object)variableName));
                }
                this.variableNames.add(variableName);
                this.variableTypesByName.put(variableName, this.query.resolveClassDeclaration(classDecl));
            }
        }
    }

    protected void compileSubqueryCandidateExpression(boolean caseSensitive) {
        if (this.subqueryCandidateExpr != null) {
            String[] tokens = StringUtils.split((String)this.subqueryCandidateExpr, (String)".");
            if (caseSensitive && !tokens[0].equals(this.parentExpr.getCandidateAlias())) {
                throw new NucleusUserException("Subquery has been specified with a candidate-expression that doesnt start with \"" + this.parentExpr.getCandidateAlias() + "\"." + " All candidate expressions must start with that to relate them back to the outer query");
            }
            Class cls = this.subqueryCandidateExprRootAliasInfo != null ? this.subqueryCandidateExprRootAliasInfo.cls : this.parentExpr.getCandidateClass();
            ClassLoaderResolver clr = this.query.getObjectManager().getClassLoaderResolver();
            MetaDataManager mmgr = this.query.getObjectManager().getMetaDataManager();
            MappedStoreManager storeMgr = (MappedStoreManager)this.query.getStoreManager();
            AbstractClassMetaData leftCmd = mmgr.getMetaDataForClass(cls, clr);
            LogicSetExpression leftTblExpr = this.subqueryCandidateExprRootAliasInfo != null ? this.subqueryCandidateExprRootAliasInfo.tableExpression : this.parentExpr.getMainTableExpression();
            String leftAlias = this.subqueryCandidateExprRootAliasInfo != null ? this.subqueryCandidateExprRootAliasInfo.alias : this.parentExpr.getCandidateAlias();
            DatastoreClass leftTable = (DatastoreClass)leftTblExpr.getMainTable();
            for (int i = 1; i < tokens.length; ++i) {
                DatastoreIdentifier joinTblAlias;
                JoinTable joinTbl;
                LogicSetExpression joinTblExpr;
                ScalarExpression rightCentreExpr;
                ScalarExpression leftCentreExpr;
                ScalarExpression rightExpr;
                ScalarExpression leftExpr;
                String rightAlias;
                DatastoreClass rightTable;
                DatastoreIdentifier rightTblAlias;
                LogicSetExpression rightTblExpr;
                AbstractMemberMetaData leftMmd = leftCmd.getMetaDataForMember(tokens[i]);
                AbstractClassMetaData rightCmd = null;
                int relationType = leftMmd.getRelationType(clr);
                AbstractMemberMetaData rightMmd = null;
                if (relationType == 2 || relationType == 4 || relationType == 5 || relationType == 6) {
                    rightMmd = leftMmd.getRelatedMemberMetaData(clr)[0];
                }
                if (i == tokens.length - 1) {
                    cls = this.candidateClass;
                } else if (relationType == 2 || relationType == 1 || relationType == 6) {
                    cls = leftMmd.getType();
                    rightCmd = mmgr.getMetaDataForClass(cls, clr);
                } else if (relationType == 4 || relationType == 3 || relationType == 5) {
                    if (leftMmd.hasCollection()) {
                        cls = clr.classForName(leftMmd.getCollection().getElementType());
                        rightCmd = mmgr.getMetaDataForClass(cls, clr);
                    } else if (leftMmd.hasMap()) {
                        cls = clr.classForName(leftMmd.getMap().getValueType());
                        rightCmd = mmgr.getMetaDataForClass(cls, clr);
                    }
                } else {
                    throw new NucleusUserException("Subquery has been specified with a candidate-expression that includes \"" + tokens[i] + "\" that isnt a relation field!!");
                }
                if (i == tokens.length - 1) {
                    rightTblExpr = this.qs.getMainTableExpression();
                    rightTblAlias = this.qs.getMainTableAlias();
                    rightTable = (DatastoreClass)rightTblExpr.getMainTable();
                    rightAlias = this.candidateAlias;
                } else {
                    rightTable = storeMgr.getDatastoreClass(cls.getName(), clr);
                    rightAlias = "T" + i;
                    rightTblAlias = storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, rightAlias);
                    rightTblExpr = this.qs.newTableExpression((DatastoreContainerObject)rightTable, rightTblAlias);
                }
                if (relationType == 1 || relationType == 2 && leftMmd.getMappedBy() == null || relationType == 6 && leftMmd.getJoinMetaData() == null && rightMmd.getJoinMetaData() == null) {
                    leftExpr = leftTblExpr.newFieldExpression(tokens[i]);
                    rightExpr = rightTable.getIdMapping().newScalarExpression(this.qs, rightTblExpr);
                    if (i == 1) {
                        this.qs.andCondition(leftExpr.eq(rightExpr), true);
                    } else {
                        this.qs.innerJoin(rightExpr, leftExpr, leftTblExpr, true, true);
                    }
                } else if (relationType == 2 && leftMmd.getMappedBy() != null) {
                    leftExpr = leftTable.getIdMapping().newScalarExpression(this.qs, leftTblExpr);
                    rightExpr = rightTblExpr.newFieldExpression(rightMmd.getName());
                    if (i == 1) {
                        this.qs.andCondition(leftExpr.eq(rightExpr), true);
                    } else {
                        this.qs.innerJoin(rightExpr, leftExpr, leftTblExpr, true, true);
                    }
                } else if (relationType == 3 && leftMmd.getJoinMetaData() == null || relationType == 4 && leftMmd.getJoinMetaData() == null && rightMmd.getJoinMetaData() == null) {
                    leftExpr = leftTable.getIdMapping().newScalarExpression(this.qs, leftTblExpr);
                    rightExpr = rightTblExpr.newFieldExpression(rightMmd.getName());
                    if (i == 1) {
                        this.qs.andCondition(leftExpr.eq(rightExpr), true);
                    } else {
                        this.qs.innerJoin(rightExpr, leftExpr, leftTblExpr, true, true);
                    }
                } else if (relationType == 3 && leftMmd.getJoinMetaData() != null) {
                    leftExpr = leftTable.getIdMapping().newScalarExpression(this.qs, leftTblExpr);
                    rightExpr = rightTable.getIdMapping().newScalarExpression(this.qs, rightTblExpr);
                    leftCentreExpr = null;
                    rightCentreExpr = null;
                    joinTblExpr = null;
                    if (leftMmd.hasCollection()) {
                        joinTbl = (CollectionTable)storeMgr.getDatastoreContainerObject(leftMmd);
                        joinTblAlias = storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, leftAlias + "." + rightAlias);
                        joinTblExpr = this.qs.newTableExpression((DatastoreContainerObject)joinTbl, joinTblAlias);
                        leftCentreExpr = joinTbl.getOwnerMapping().newScalarExpression(this.qs, joinTblExpr);
                        rightCentreExpr = ((ElementContainerTable)joinTbl).getElementMapping().newScalarExpression(this.qs, joinTblExpr);
                    } else if (leftMmd.hasMap()) {
                        joinTbl = (MapTable)storeMgr.getDatastoreContainerObject(leftMmd);
                        joinTblAlias = storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, leftAlias + "." + rightAlias);
                        joinTblExpr = this.qs.newTableExpression((DatastoreContainerObject)joinTbl, joinTblAlias);
                        leftCentreExpr = joinTbl.getOwnerMapping().newScalarExpression(this.qs, joinTblExpr);
                        rightCentreExpr = ((MapTable)joinTbl).getValueMapping().newScalarExpression(this.qs, joinTblExpr);
                    }
                    if (i == 1) {
                        this.qs.andCondition(leftExpr.eq(leftCentreExpr), true);
                    } else {
                        this.qs.innerJoin(leftCentreExpr, leftExpr, leftTblExpr, true, true);
                    }
                    this.qs.innerJoin(rightExpr, rightCentreExpr, joinTblExpr, true, true);
                } else if (relationType == 4 && (leftMmd.getJoinMetaData() != null || rightMmd.getJoinMetaData() != null) || relationType == 6 && (leftMmd.getJoinMetaData() != null || rightMmd.getJoinMetaData() != null) || relationType == 5) {
                    leftExpr = leftTable.getIdMapping().newScalarExpression(this.qs, leftTblExpr);
                    rightExpr = rightTable.getIdMapping().newScalarExpression(this.qs, rightTblExpr);
                    leftCentreExpr = null;
                    rightCentreExpr = null;
                    joinTblExpr = null;
                    if (leftMmd.hasCollection() || rightMmd.hasCollection()) {
                        joinTbl = (CollectionTable)storeMgr.getDatastoreContainerObject(leftMmd);
                        joinTblAlias = storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, leftAlias + "." + rightAlias);
                        joinTblExpr = this.qs.newTableExpression((DatastoreContainerObject)joinTbl, joinTblAlias);
                        leftCentreExpr = joinTbl.getOwnerMapping().newScalarExpression(this.qs, joinTblExpr);
                        rightCentreExpr = ((ElementContainerTable)joinTbl).getElementMapping().newScalarExpression(this.qs, joinTblExpr);
                    } else if (leftMmd.hasMap() || rightMmd.hasMap()) {
                        joinTbl = (MapTable)storeMgr.getDatastoreContainerObject(leftMmd);
                        joinTblAlias = storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, leftAlias + "." + rightAlias);
                        joinTblExpr = this.qs.newTableExpression((DatastoreContainerObject)joinTbl, joinTblAlias);
                        leftCentreExpr = joinTbl.getOwnerMapping().newScalarExpression(this.qs, joinTblExpr);
                        rightCentreExpr = ((MapTable)joinTbl).getValueMapping().newScalarExpression(this.qs, joinTblExpr);
                    }
                    if (i == 1) {
                        this.qs.andCondition(leftExpr.eq(leftCentreExpr), true);
                    } else {
                        this.qs.innerJoin(leftCentreExpr, leftExpr, leftTblExpr, true, true);
                    }
                    this.qs.innerJoin(rightExpr, rightCentreExpr, joinTblExpr, true, true);
                } else {
                    throw new NucleusUserException("<candidate-expression>=" + this.subqueryCandidateExpr + " has token " + tokens[i] + " and relationType=" + relationType + " NOT SUPPORTED");
                }
                if (i >= tokens.length - 1) continue;
                leftTblExpr = rightTblExpr;
                leftCmd = rightCmd;
                leftTable = rightTable;
                leftAlias = rightAlias;
            }
        } else if (this.query.getFrom() != null) {
            NucleusLogger.QUERY.info((Object)(">> performCompile : TODO Add joins for from=" + this.query.getFrom() + " for real candidate of " + this.candidateClass.getName()));
        }
    }

    protected void compileFilter(QueryExpression qs, String filter) {
        if (filter != null && filter.length() > 0) {
            ScalarExpression expr = this.compileExpressionFromString(filter);
            if (!(expr instanceof BooleanExpression)) {
                throw new NucleusUserException(LOCALISER.msg("021050", (Object)filter));
            }
            if (qs != null) {
                qs.andCondition((BooleanExpression)expr, true);
            }
        }
    }

    protected void compileResult(QueryExpression qs, String result) {
        ScalarExpression[] resultExprs;
        if (result != null) {
            String resultDefinition = result;
            resultExprs = this.compileExpressionsFromString(resultDefinition);
            ((ResultExpressionsQueryable)this.candidates).setResultExpressions(resultExprs);
            Class[] resultTypes = new Class[resultExprs.length];
            for (int i = 0; i < resultExprs.length; ++i) {
                if (resultExprs[i] instanceof CollectionExpression) {
                    throw new NucleusUserException(resultExprs[i].toStatementText(ScalarExpression.PROJECTION) + " is of type java.util.Collection and cannot be in the result.");
                }
                if (resultExprs[i] instanceof MapExpression) {
                    throw new NucleusUserException(resultExprs[i].toStatementText(ScalarExpression.PROJECTION) + " is of type java.util.Map and cannot be in the result.");
                }
                if (resultExprs[i].getMapping() == null) continue;
                resultTypes[i] = resultExprs[i].getMapping().getType() != null ? this.query.resolveClassDeclaration(resultExprs[i].getMapping().getType()) : resultExprs[i].getMapping().getJavaType();
            }
            this.resultMetaData = new QueryResultsMetaData(resultTypes);
        } else {
            this.resultMetaData = new QueryResultsMetaData(new Class[]{this.candidateClass});
            resultExprs = null;
        }
        String resultClassName = this.query.getResultClassName();
        if (this.resultClass == null && resultClassName != null) {
            ScalarExpression expr = this.compileExpressionFromString(resultClassName);
            this.resultClass = ((ClassExpression)expr).getCls();
        }
        if (this.resultClass != null && resultExprs != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (QueryUtils.resultClassIsSimple((String)QueryCompiler.this.resultClass.getName())) {
                        Class resultClassPrimitive;
                        if (resultExprs.length > 1) {
                            throw new NucleusUserException(LOCALISER.msg("021201", (Object)QueryCompiler.this.resultClass.getName()));
                        }
                        Class exprType = resultExprs[0].getMapping().getJavaType();
                        boolean typeConsistent = false;
                        if (exprType == QueryCompiler.this.resultClass) {
                            typeConsistent = true;
                        } else if (exprType.isPrimitive() && (resultClassPrimitive = ClassUtils.getPrimitiveTypeForType((Class)QueryCompiler.this.resultClass)) == exprType) {
                            typeConsistent = true;
                        }
                        if (!typeConsistent) {
                            throw new NucleusUserException(LOCALISER.msg("021202", (Object)QueryCompiler.this.resultClass.getName(), (Object)exprType));
                        }
                    } else if (QueryUtils.resultClassIsUserType((String)QueryCompiler.this.resultClass.getName())) {
                        Class[] ctrTypes = new Class[resultExprs.length];
                        for (int i = 0; i < ctrTypes.length; ++i) {
                            ctrTypes[i] = resultExprs[i].getMapping().getJavaType();
                        }
                        Constructor ctr = ClassUtils.getConstructorWithArguments((Class)QueryCompiler.this.resultClass, (Class[])ctrTypes);
                        if (ctr == null && !ClassUtils.hasDefaultConstructor((Class)QueryCompiler.this.resultClass)) {
                            throw new NucleusUserException(LOCALISER.msg("021205", (Object)QueryCompiler.this.resultClass.getName()));
                        }
                        if (ctr == null) {
                            for (int i = 0; i < resultExprs.length; ++i) {
                                Method putMethod;
                                Method setMethod;
                                String fieldName = resultExprs[i].getAlias();
                                Class fieldType = resultExprs[i].getMapping().getJavaType();
                                if (fieldName == null && resultExprs[i].getMapping().getMemberMetaData() != null) {
                                    fieldName = resultExprs[i].getMapping().getMemberMetaData().getName();
                                }
                                if (fieldName == null) continue;
                                Class<?> resultFieldType = null;
                                boolean publicField = true;
                                try {
                                    Field fld = QueryCompiler.this.resultClass.getDeclaredField(fieldName);
                                    resultFieldType = fld.getType();
                                    if (!ClassUtils.typesAreCompatible((Class)fieldType, resultFieldType) && !ClassUtils.typesAreCompatible(resultFieldType, (Class)fieldType)) {
                                        throw new NucleusUserException(LOCALISER.msg("021211", (Object)fieldName, (Object)fieldType.getName(), (Object)resultFieldType.getName()));
                                    }
                                    if (!Modifier.isPublic(fld.getModifiers())) {
                                        publicField = false;
                                    }
                                }
                                catch (NoSuchFieldException nsfe) {
                                    publicField = false;
                                }
                                if (publicField || (setMethod = QueryUtils.getPublicSetMethodForFieldOfResultClass((Class)QueryCompiler.this.resultClass, (String)fieldName, resultFieldType)) != null || (putMethod = QueryUtils.getPublicPutMethodForResultClass((Class)QueryCompiler.this.resultClass)) != null) continue;
                                throw new NucleusUserException(LOCALISER.msg("021212", (Object)QueryCompiler.this.resultClass.getName(), (Object)fieldName));
                            }
                        }
                    }
                    return null;
                }
            });
        }
    }

    protected void compileGrouping(QueryExpression qs, String groupingClause) {
        ScalarExpression[] groupExprs;
        if (groupingClause != null && groupingClause.length() > 0 && (groupExprs = this.compileExpressionsFromString(groupingClause)) != null && qs != null) {
            for (int i = 0; i < groupExprs.length; ++i) {
                qs.addGroupingExpression(groupExprs[i]);
            }
        }
    }

    protected void compileHaving(QueryExpression qs, String havingClause) {
        if (havingClause != null && havingClause.length() > 0) {
            ScalarExpression havingExpr = this.compileExpressionFromString(havingClause);
            if (qs != null) {
                if (!(havingExpr instanceof BooleanExpression)) {
                    throw new NucleusUserException(LOCALISER.msg("021051", (Object)havingExpr));
                }
                qs.setHaving((BooleanExpression)havingExpr);
            }
        }
    }

    protected void compileRange(QueryExpression qs) {
        String range = this.query.getRange();
        if (range != null) {
            ScalarExpression[] exprs = this.compileExpressionsFromString(range);
            if (exprs.length > 0) {
                if (!(exprs[0] instanceof Literal)) {
                    throw new NucleusUserException(LOCALISER.msg("021064", (Object)"FROM", (Object)exprs[0]));
                }
                if (!(((Literal)exprs[0]).getValue() instanceof Number)) {
                    throw new NucleusUserException(LOCALISER.msg("021065", (Object)"FROM", (Object)exprs[0]));
                }
                this.rangeFromIncl = ((Number)((Literal)exprs[0]).getValue()).longValue();
            }
            if (exprs.length > 1) {
                if (!(exprs[1] instanceof Literal)) {
                    throw new NucleusUserException(LOCALISER.msg("021064", (Object)"TO", (Object)exprs[1]));
                }
                if (!(((Literal)exprs[1]).getValue() instanceof Number)) {
                    throw new NucleusUserException(LOCALISER.msg("021065", (Object)"TO", (Object)exprs[1]));
                }
                this.rangeToExcl = ((Number)((Literal)exprs[1]).getValue()).longValue();
            }
        }
        if (qs != null && (this.rangeFromIncl > 0L || this.rangeToExcl != Long.MAX_VALUE)) {
            qs.setRangeConstraint(this.rangeFromIncl, this.rangeToExcl != Long.MAX_VALUE ? this.rangeToExcl - this.rangeFromIncl : -1L);
        }
    }

    protected void checkExpressionsAgainstGrouping(ScalarExpression[] exprs, ScalarExpression[] groupExprs, String localiserErrorString) {
        if (exprs == null) {
            return;
        }
        for (int i = 0; i < exprs.length; ++i) {
            boolean exists = false;
            for (int j = 0; j < groupExprs.length; ++j) {
                if (!exprs[i].equals((Object)groupExprs[j])) continue;
                exists = true;
                break;
            }
            if (exprs[i] instanceof AggregateExpression || exists) continue;
            throw new NucleusUserException(LOCALISER.msg(localiserErrorString, (Object)exprs[i]));
        }
    }

    public void bindVariable(String name, ScalarExpression expr) {
        ScalarExpression previousExpr = this.expressionsByVariableName.put(name, expr);
        if (previousExpr != null) {
            throw new NucleusException(LOCALISER.msg("021060", (Object)name, (Object)expr, (Object)previousExpr)).setFatal();
        }
    }

    protected void checkVariableBinding() {
        for (int i = 0; i < this.variableNames.size(); ++i) {
            String variableName = this.variableNames.get(i);
            if (this.expressionsByVariableName.get(variableName) != null) continue;
            boolean foundInResult = false;
            if (this.candidates instanceof ResultExpressionsQueryable) {
                ScalarExpression[] exprs = ((ResultExpressionsQueryable)this.candidates).getResultExpressions();
                for (int j = 0; j < exprs.length; ++j) {
                    if (!(exprs[j] instanceof UnboundVariable) || !((UnboundVariable)exprs[j]).getVariableName().equals(variableName)) continue;
                    foundInResult = true;
                }
            }
            if (foundInResult) continue;
            throw new NucleusUserException(LOCALISER.msg("021061", (Object)variableName));
        }
    }

    protected ScalarExpression[] compileExpressionsFromString(String str) {
        String[] exprList = QueryUtils.getExpressionsFromString((String)str);
        if (exprList != null && exprList.length > 0) {
            ScalarExpression[] exprs = new ScalarExpression[exprList.length];
            for (int i = 0; i < exprs.length; ++i) {
                exprs[i] = this.compileExpressionFromString(exprList[i]);
            }
            return exprs;
        }
        return null;
    }

    protected abstract ScalarExpression compileExpressionFromString(String var1);

    protected abstract ScalarExpression compileExpression();

    protected ScalarExpression compileAdditiveExpression() {
        ScalarExpression expr = this.compileMultiplicativeExpression();
        while (true) {
            if (this.p.parseChar('+')) {
                expr = expr.add(this.compileMultiplicativeExpression());
                continue;
            }
            if (!this.p.parseChar('-')) break;
            expr = expr.sub(this.compileMultiplicativeExpression());
        }
        return expr;
    }

    protected ScalarExpression compileMultiplicativeExpression() {
        ScalarExpression expr = this.compileUnaryExpression();
        while (true) {
            if (this.p.parseChar('*')) {
                expr = expr.mul(this.compileUnaryExpression());
                continue;
            }
            if (this.p.parseChar('/')) {
                expr = expr.div(this.compileUnaryExpression());
                continue;
            }
            if (!this.p.parseChar('%')) break;
            expr = expr.mod(this.compileUnaryExpression());
        }
        return expr;
    }

    protected ScalarExpression compileUnaryExpression() {
        if (this.p.parseString("++")) {
            throw new NucleusUserException("Unsupported operator '++'");
        }
        if (this.p.parseString("--")) {
            throw new NucleusUserException("Unsupported operator '--'");
        }
        ScalarExpression expr = this.p.parseChar('+') ? this.compileUnaryExpression() : (this.p.parseChar('-') ? this.compileUnaryExpression().neg() : this.compileUnaryExpressionNotPlusMinus());
        return expr;
    }

    protected ScalarExpression compileUnaryExpressionNotPlusMinus() {
        ScalarExpression expr;
        if (this.p.parseChar('~')) {
            expr = this.compileUnaryExpression().com();
        } else if (this.p.parseChar('!')) {
            expr = this.compileUnaryExpression().not();
        } else {
            expr = this.compileCastExpression();
            if (expr == null) {
                expr = this.compilePrimary();
            }
        }
        return expr;
    }

    protected ScalarExpression compileCastExpression() {
        Class type = this.p.parseCast(this.qs == null ? this.query.getObjectManager().getClassLoaderResolver() : this.qs.getClassLoaderResolver(), this.candidateClass == null ? null : this.candidateClass.getClassLoader());
        if (type == null) {
            return null;
        }
        return this.compileUnaryExpression().cast(type);
    }

    protected abstract ScalarExpression compilePrimary();

    protected ScalarExpression compileLiteral() {
        Object litValue;
        Class litType;
        boolean single_quote_next = this.p.nextIsSingleQuote();
        String sLiteral = this.p.parseStringLiteral();
        if (sLiteral != null) {
            if (sLiteral.length() == 1 && single_quote_next) {
                litType = Character.class;
                litValue = new Character(sLiteral.charAt(0));
            } else {
                litType = String.class;
                litValue = sLiteral;
            }
        } else {
            BigDecimal fLiteral = this.p.parseFloatingPointLiteral();
            if (fLiteral != null) {
                litType = BigDecimal.class;
                litValue = fLiteral;
            } else {
                BigInteger iLiteral = this.p.parseIntegerLiteral();
                if (iLiteral != null) {
                    litType = Long.class;
                    litValue = iLiteral.longValue();
                } else {
                    Boolean bLiteral = this.p.parseBooleanLiteral();
                    if (bLiteral != null) {
                        litType = Boolean.class;
                        litValue = bLiteral;
                    } else {
                        if (this.p.parseNullLiteral()) {
                            return new NullLiteral(this.qs);
                        }
                        return null;
                    }
                }
            }
        }
        JavaTypeMapping m = this.qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(litType, false, false, this.qs.getClassLoaderResolver());
        return m.newLiteral(this.qs, litValue);
    }

    protected ScalarExpression compileNewObject() {
        String newClsName = this.p.parseName();
        Class newCls = null;
        try {
            newCls = this.query.resolveClassDeclaration(newClsName);
        }
        catch (NucleusUserException jpue) {
            throw new NucleusUserException(LOCALISER.msg("021057", (Object)this.language, (Object)newClsName));
        }
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        if (this.p.parseChar('(')) {
            if (!this.p.parseChar(')')) {
                do {
                    ScalarExpression argExpr = this.compileExpression();
                    args.add(argExpr);
                    this.fieldExpressions.add(argExpr);
                } while (this.p.parseChar(','));
                if (!this.p.parseChar(')')) {
                    throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                }
            }
        } else {
            throw new NucleusUserException(LOCALISER.msg("021058", (Object)this.language, (Object)((AbstractJavaQuery)this.query).getSingleStringQuery()));
        }
        return new NewObjectExpression(this.qs, newCls, args);
    }

    protected ScalarExpression compileExplicitVariable(String id) {
        ScalarExpression expr = this.expressionsByVariableName.get(id);
        if (expr == null) {
            expr = new UnboundVariable(this.qs, id, this.variableTypesByName.get(id), (UnboundVariable.VariableBinder)this);
        }
        this.fieldExpressions.add(expr);
        return expr;
    }

    protected ScalarExpression callUserDefinedScalarExpression(String method) {
        String className = method.substring(0, method.lastIndexOf(46));
        String methodName = method.substring(method.lastIndexOf(46) + 1);
        if (!userDefinedScalarExpressions.containsKey(className)) {
            Class cls = this.query.resolveClassDeclaration(className);
            className = cls.getName();
        }
        if (userDefinedScalarExpressions.containsKey(className)) {
            ScalarExpression expr = this.newScalarExpression((Class)userDefinedScalarExpressions.get(className));
            if (this.p.parseChar('(')) {
                ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
                if (!this.p.parseChar(')')) {
                    do {
                        args.add(this.compileExpression());
                    } while (this.p.parseChar(','));
                    if (!this.p.parseChar(')')) {
                        throw new QueryCompilerSyntaxException("')' expected", this.p.getIndex(), this.p.getInput());
                    }
                }
                return expr.callMethod(methodName, args);
            }
        }
        return null;
    }

    private ScalarExpression newScalarExpression(Class cls) {
        try {
            return (ScalarExpression)cls.getConstructor(QueryExpression.class).newInstance(this.qs);
        }
        catch (IllegalArgumentException e) {
            throw new NucleusException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), (Throwable)e).setFatal();
        }
        catch (SecurityException e) {
            throw new NucleusException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), (Throwable)e).setFatal();
        }
        catch (InstantiationException e) {
            throw new NucleusException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), (Throwable)e).setFatal();
        }
        catch (IllegalAccessException e) {
            throw new NucleusException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), (Throwable)e).setFatal();
        }
        catch (InvocationTargetException e) {
            throw new NucleusException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), (Throwable)e).setFatal();
        }
        catch (NoSuchMethodException e) {
            throw new NucleusException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), (Throwable)e).setFatal();
        }
    }

    protected void registerScalarExpressions(PluginManager pluginMgr, ClassLoaderResolver clr) {
        Extension[] ex = pluginMgr.getExtensionPoint("org.datanucleus.store.rdbms.rdbms_scalarexpression").getExtensions();
        for (int i = 0; i < ex.length; ++i) {
            ConfigurationElement[] confElm = ex[i].getConfigurationElements();
            for (int c = 0; c < confElm.length; ++c) {
                Class literalClass = null;
                if (confElm[c].getAttribute("literal-class") != null) {
                    literalClass = pluginMgr.loadClass(confElm[c].getExtension().getPlugin().getSymbolicName(), confElm[c].getAttribute("literal-class"));
                }
                Class scalarExpression = null;
                if (confElm[c].getAttribute("scalar-expression-class") != null) {
                    scalarExpression = pluginMgr.loadClass(confElm[c].getExtension().getPlugin().getSymbolicName(), confElm[c].getAttribute("scalar-expression-class"));
                }
                QueryCompiler.registerScalarExpression(literalClass, scalarExpression, confElm[c].getAttribute("name"));
            }
        }
    }

    public static void registerScalarExpression(Class literal, Class scalarExpressionClass, String name) {
        userDefinedScalarExpressions.put(name == null ? literal.getName() : name, scalarExpressionClass);
    }

    public static Map getUserDefinedScalarExpressions() {
        return userDefinedScalarExpressions;
    }

    class AliasJoinInformation {
        String alias;
        Class cls;
        LogicSetExpression tableExpression;
        boolean candidate;

        public AliasJoinInformation(String alias, Class cls, LogicSetExpression tblExpr, boolean candidate) {
            this.alias = alias;
            this.cls = cls;
            this.tableExpression = tblExpr;
            this.candidate = candidate;
        }

        public String toString() {
            return "Alias=" + this.alias + " class=" + this.cls + " tableExpr=" + this.tableExpression + (this.candidate ? "[CANDIDATE]" : "");
        }
    }
}

