/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.mapped.scostore.FKListStore;
import org.datanucleus.store.mapped.scostore.FKListStoreSpecialization;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractListStoreSpecialization;
import org.datanucleus.util.Localiser;

public class RDBMSFKListStoreSpecialization
extends RDBMSAbstractListStoreSpecialization
implements FKListStoreSpecialization {
    private String unsetStmt;
    private String removeAtNullifyStmt;
    private String clearNullifyStmt;
    private String updateFkStmt;

    RDBMSFKListStoreSpecialization(Localiser localiser, ClassLoaderResolver clr, RDBMSStoreManager storeMgr) {
        super(localiser, clr, storeMgr);
    }

    protected String getSetStmt(ElementContainerStore ecs) {
        if (this.setStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
            JavaTypeMapping orderMapping = ecs.getOrderMapping();
            DatastoreContainerObject containerTable = ecs.getContainerTable();
            JavaTypeMapping elementMapping = ecs.getElementMapping();
            JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            stmt.append(containerTable.toString());
            stmt.append(" SET ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (orderMapping != null) {
                for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(orderMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < elementMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(elementMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)elementMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            this.setStmt = stmt.toString();
        }
        return this.setStmt;
    }

    protected String getUnsetStmt(ElementContainerStore ecs) {
        if (this.unsetStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
            JavaTypeMapping orderMapping = ecs.getOrderMapping();
            DatastoreContainerObject containerTable = ecs.getContainerTable();
            JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            stmt.append(containerTable.toString());
            stmt.append(" SET ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = NULL");
            }
            if (orderMapping != null) {
                for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(orderMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append("=-1");
                }
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (orderMapping != null) {
                for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(orderMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.unsetStmt = stmt.toString();
        }
        return this.unsetStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(ObjectProvider sm, int index, Object element, boolean allowDependentField, ElementContainerStore ecs, Object obj) {
        String setStmt = this.getSetStmt(ecs);
        String unsetStmt = this.getUnsetStmt(ecs);
        JavaTypeMapping orderMapping = ecs.getOrderMapping();
        JavaTypeMapping elementMapping = ecs.getElementMapping();
        JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
        try {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = ecs.getStoreManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, unsetStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, (BaseContainerStore)ecs);
                    if (orderMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, orderMapping);
                    }
                    if (relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, ecs);
                    }
                    sqlControl.executeStatementUpdate(mconn, unsetStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
                PreparedStatement ps2 = sqlControl.getStatementForUpdate(mconn, setStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps2, jdbcPosition, (BaseContainerStore)ecs);
                    if (orderMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps2, index, jdbcPosition, orderMapping);
                    }
                    if (relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps2, jdbcPosition, ecs);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps2, element, jdbcPosition, elementMapping);
                    sqlControl.executeStatementUpdate(mconn, setStmt, ps2, true);
                }
                finally {
                    ps2.close();
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056015", (Object)setStmt), (Throwable)e);
        }
        if (ecs.getOwnerMemberMetaData().getCollection().isDependentElement() && allowDependentField && obj != null) {
            sm.getExecutionContext().deleteObjectInternal(obj);
        }
        return obj;
    }

    private String getUpdateFkStmt(ElementContainerStore ecs) {
        if (this.updateFkStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
            JavaTypeMapping orderMapping = ecs.getOrderMapping();
            DatastoreContainerObject containerTable = ecs.getContainerTable();
            JavaTypeMapping elementMapping = ecs.getElementMapping();
            ElementContainerStore.ElementInfo[] elementInfo = ecs.getElementInfo();
            JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(containerTable.toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (orderMapping != null) {
                for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(orderMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(",");
                    stmt.append(relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < elementMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(elementMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)elementMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            this.updateFkStmt = stmt.toString();
        }
        return this.updateFkStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateElementFk(ObjectProvider sm, Object element, Object owner, int index, ExecutionContext ec, ElementContainerStore ecs) {
        boolean retval;
        JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
        JavaTypeMapping orderMapping = ecs.getOrderMapping();
        JavaTypeMapping elementMapping = ecs.getElementMapping();
        ElementContainerStore.ElementInfo[] elementInfo = ecs.getElementInfo();
        JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
        AbstractMemberMetaData ownerMemberMetaData = ecs.getOwnerMemberMetaData();
        String updateFkStmt = this.getUpdateFkStmt(ecs);
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (elementInfo.length > 1) {
                        this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                    }
                    if (owner == null) {
                        if (ownerMemberMetaData != null) {
                            ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)ownerMapping), null);
                        } else {
                            ownerMapping.setObject(ec, (Object)ps, MappingHelper.getMappingIndices((int)jdbcPosition, (JavaTypeMapping)ownerMapping), null, sm, ownerMemberMetaData.getAbsoluteFieldNumber());
                        }
                        jdbcPosition += ownerMapping.getNumberOfDatastoreMappings();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, ec, ps, jdbcPosition, (BaseContainerStore)ecs);
                    }
                    if (orderMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateOrderInStatement(ec, ps, index, jdbcPosition, orderMapping);
                    }
                    if (relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, ecs);
                    }
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(ec, ps, element, jdbcPosition, elementMapping);
                    sqlControl.executeStatementUpdate(mconn, updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056027", (Object)updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    protected String getRemoveAtNullifyStmt(ElementContainerStore ecs) {
        if (this.removeAtNullifyStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
            JavaTypeMapping orderMapping = ecs.getOrderMapping();
            DatastoreContainerObject containerTable = ecs.getContainerTable();
            ElementContainerStore.ElementInfo[] elementInfo = ecs.getElementInfo();
            JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(containerTable.toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString() + "=NULL");
            }
            if (orderMapping != null) {
                for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(", ");
                    stmt.append(orderMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString() + "=-1");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (orderMapping != null) {
                for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(orderMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)orderMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.removeAtNullifyStmt = stmt.toString();
        }
        return this.removeAtNullifyStmt;
    }

    protected String getClearNullifyStmt(ElementContainerStore ecs) {
        if (this.clearNullifyStmt == null) {
            int i;
            JavaTypeMapping ownerMapping = ecs.getOwnerMapping();
            JavaTypeMapping orderMapping = ecs.getOrderMapping();
            DatastoreContainerObject containerTable = ecs.getContainerTable();
            ElementContainerStore.ElementInfo[] elementInfo = ecs.getElementInfo();
            JavaTypeMapping relationDiscriminatorMapping = ecs.getRelationDiscriminatorMapping();
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(containerTable.toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString() + "=NULL");
            }
            if (orderMapping != null) {
                for (i = 0; i < orderMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(", ");
                    stmt.append(orderMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString() + "=-1");
                }
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(", ");
                    stmt.append(relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append("=NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)ownerMapping.getDatastoreMapping(i)).getUpdateInputParameter());
            }
            if (relationDiscriminatorMapping != null) {
                for (i = 0; i < relationDiscriminatorMapping.getNumberOfDatastoreMappings(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(relationDiscriminatorMapping.getDatastoreMapping(i).getDatastoreField().getIdentifier().toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)relationDiscriminatorMapping.getDatastoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.clearNullifyStmt = stmt.toString();
        }
        return this.clearNullifyStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWithoutDelete(ExecutionContext ec, ObjectProvider ownerSM, ElementContainerStore ecs) {
        String clearNullifyStmt = this.getClearNullifyStmt(ecs);
        try {
            ManagedConnection mconn = ecs.getStoreManager().getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearNullifyStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(ownerSM, ec, ps, jdbcPosition, (BaseContainerStore)ecs);
                    if (ecs.getRelationDiscriminatorMapping() != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, ecs);
                    }
                    sqlControl.executeStatementUpdate(mconn, clearNullifyStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.localiser.msg("056013", (Object)clearNullifyStmt), (Throwable)e);
        }
    }

    public void removeAt(ObjectProvider sm, int index, int size, boolean nullify, FKListStore fkListStore) {
        String stmt = nullify ? this.getRemoveAtNullifyStmt((ElementContainerStore)fkListStore) : this.getRemoveAtStmt((ElementContainerStore)fkListStore);
        this.internalRemoveAt(sm, index, stmt, size, (ElementContainerStore)fkListStore);
    }
}

