/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InterfaceMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues2;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.Type;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;
import org.datanucleus.util.StringUtils;

public final class PersistentClassROF
implements ResultObjectFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSStoreManager.class.getClassLoader());
    protected final AbstractClassMetaData acmd;
    private Class persistentClass;
    protected StatementClassMapping stmtMapping = null;
    protected final FetchPlan fetchPlan;
    private final boolean ignoreCache;
    private Map resolvedClasses = new SoftValueMap();

    public PersistentClassROF(AbstractClassMetaData acmd, StatementClassMapping mappingDefinition, boolean ignoreCache, FetchPlan fetchPlan, Class persistentClass) {
        if (mappingDefinition == null) {
            throw new NucleusException("Attempt to create PersistentIDROF with null mappingDefinition");
        }
        this.stmtMapping = mappingDefinition;
        this.acmd = acmd;
        this.ignoreCache = ignoreCache;
        this.fetchPlan = fetchPlan;
        this.persistentClass = persistentClass;
    }

    public void setPersistentClass(Class cls) {
        this.persistentClass = cls;
    }

    public Object getObject(ExecutionContext ec, Object rs) {
        int[] mappedFieldNumbers;
        StatementClassMapping mappingDefinition;
        AbstractClassMetaData cmd;
        Object[] subclasses;
        String className = null;
        boolean requiresInheritanceCheck = true;
        StatementMappingIndex discrimMapIdx = this.stmtMapping.getMappingForMemberPosition(StatementClassMapping.MEMBER_DISCRIMINATOR);
        if (discrimMapIdx != null) {
            try {
                String discrimValue = ((ResultSet)rs).getString(discrimMapIdx.getColumnPositions()[0]);
                if (discrimValue == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)"Value of discriminator is null so assuming object is null");
                    return null;
                }
                JavaTypeMapping discrimMapping = discrimMapIdx.getMapping();
                DiscriminatorMetaData dismd = discrimMapping != null ? discrimMapping.getDatastoreContainer().getDiscriminatorMetaData() : null;
                className = MetaDataUtils.getClassNameFromDiscriminatorValue((String)discrimValue, (DiscriminatorMetaData)dismd, (ExecutionContext)ec);
            }
            catch (SQLException sqle) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)("Exception obtaining value of discriminator : " + sqle.getMessage()));
            }
        } else if (this.stmtMapping.getNucleusTypeColumnName() != null) {
            try {
                className = ((ResultSet)rs).getString(this.stmtMapping.getNucleusTypeColumnName()).trim();
                if (className == null) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)"Value of determiner column is null so assuming object is null");
                    return null;
                }
            }
            catch (SQLException sqle) {
                // empty catch block
            }
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        Class pcClassForObject = this.persistentClass;
        if (className != null) {
            Class cls = (Class)this.resolvedClasses.get(className);
            if (cls != null) {
                pcClassForObject = cls;
            } else {
                pcClassForObject = this.persistentClass.getName().equals(className) ? this.persistentClass : clr.classForName(className, this.persistentClass.getClassLoader());
                this.resolvedClasses.put(className, pcClassForObject);
            }
            requiresInheritanceCheck = false;
        }
        String warnMsg = null;
        if (Modifier.isAbstract(pcClassForObject.getModifiers()) && (subclasses = ec.getMetaDataManager().getSubclassesForClass(pcClassForObject.getName(), false)) != null) {
            Class concreteSubclass = null;
            int numConcreteSubclasses = 0;
            for (int i = 0; i < subclasses.length; ++i) {
                Class subcls = clr.classForName(subclasses[i]);
                if (Modifier.isAbstract(subcls.getModifiers())) continue;
                ++numConcreteSubclasses;
                concreteSubclass = subcls;
            }
            if (numConcreteSubclasses == 1) {
                pcClassForObject = concreteSubclass;
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)LOCALISER.msg("052300", (Object)pcClassForObject.getName(), (Object)concreteSubclass.getName()));
            } else {
                if (numConcreteSubclasses == 0) {
                    throw new NucleusUserException(LOCALISER.msg("052301", (Object)pcClassForObject.getName()));
                }
                warnMsg = "Found type=" + pcClassForObject + " but abstract and more than 1 concrete subclass (" + StringUtils.objectArrayToString((Object[])subclasses) + "). Really you need a discriminator " + " to help identifying the type. Choosing " + concreteSubclass;
                pcClassForObject = concreteSubclass;
                requiresInheritanceCheck = true;
            }
        }
        if ((cmd = ec.getMetaDataManager().getMetaDataForClass(pcClassForObject, clr)) == null) {
            return null;
        }
        int[] fieldNumbers = this.stmtMapping.getMemberNumbers();
        if (this.acmd instanceof InterfaceMetaData) {
            mappingDefinition = new StatementClassMapping();
            mappingDefinition.setNucleusTypeColumnName(this.stmtMapping.getNucleusTypeColumnName());
            mappedFieldNumbers = new int[fieldNumbers.length];
            for (int i = 0; i < fieldNumbers.length; ++i) {
                AbstractMemberMetaData mmd = this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                mappedFieldNumbers[i] = cmd.getAbsolutePositionOfMember(mmd.getName());
                mappingDefinition.addMappingForMember(mappedFieldNumbers[i], this.stmtMapping.getMappingForMemberPosition(fieldNumbers[i]));
            }
        } else {
            mappingDefinition = this.stmtMapping;
            mappedFieldNumbers = fieldNumbers;
        }
        Object obj = null;
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkNumbers = cmd.getPKMemberPositions();
            ResultSet resultSet = (ResultSet)rs;
            boolean nullObject = true;
            block8: for (int i = 0; i < pkNumbers.length; ++i) {
                StatementMappingIndex pkIdx = mappingDefinition.getMappingForMemberPosition(pkNumbers[i]);
                if (pkIdx == null) {
                    throw new NucleusException("You have just executed an SQL statement yet the information  for the primary key column(s) is not available! Please generate a testcase and report this issue");
                }
                int[] colPositions = pkIdx.getColumnPositions();
                for (int j = 0; j < colPositions.length; ++j) {
                    try {
                        Object pkObj = resultSet.getObject(colPositions[j]);
                        if (pkObj != null) {
                            nullObject = false;
                            continue block8;
                        }
                    }
                    catch (SQLException sqle) {
                        NucleusLogger.DATASTORE_RETRIEVE.warn((Object)"Exception thrown while retrieving results ", (Throwable)sqle);
                    }
                    if (!nullObject) continue block8;
                }
            }
            if (nullObject) {
                obj = null;
            } else {
                if (warnMsg != null) {
                    NucleusLogger.DATASTORE_RETRIEVE.warn((Object)warnMsg);
                }
                obj = this.getObjectForApplicationId(ec, rs, mappingDefinition, mappedFieldNumbers, pcClassForObject, requiresInheritanceCheck);
            }
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            StatementMappingIndex datastoreIdMapping = this.stmtMapping.getMappingForMemberPosition(StatementClassMapping.MEMBER_DATASTORE_ID);
            JavaTypeMapping mapping = datastoreIdMapping.getMapping();
            OID oid = (OID)mapping.getObject(ec, rs, datastoreIdMapping.getColumnPositions());
            if (oid != null) {
                OID id = oid;
                if (!pcClassForObject.getName().equals(oid.getPcClass())) {
                    id = OIDFactory.getInstance((OMFContext)ec.getOMFContext(), (String)pcClassForObject.getName(), (Object)oid.getKeyValue());
                }
                if (warnMsg != null) {
                    NucleusLogger.DATASTORE_RETRIEVE.warn((Object)warnMsg);
                }
                obj = mappedFieldNumbers == null ? ec.findObject((Object)id, false, requiresInheritanceCheck, null) : this.getObjectForDatastoreId(ec, rs, mappingDefinition, mappedFieldNumbers, id, requiresInheritanceCheck ? null : pcClassForObject);
            } else {
                obj = null;
            }
        } else if (cmd.getIdentityType() == IdentityType.NONDURABLE) {
            Object id = ec.newObjectId(className, null);
            obj = mappedFieldNumbers == null ? ec.findObject(id, false, requiresInheritanceCheck, null) : this.getObjectForDatastoreId(ec, rs, mappingDefinition, mappedFieldNumbers, id, pcClassForObject);
        }
        if (obj != null) {
            StatementMappingIndex versionMapping;
            ObjectProvider objSM;
            Object verFieldValue;
            int versionFieldNumber = -1;
            VersionMetaData vermd = cmd.getVersionMetaData();
            if (vermd != null && vermd.getFieldName() != null && this.stmtMapping.getMappingForMemberPosition(versionFieldNumber = this.acmd.getMetaDataForMember(vermd.getFieldName()).getAbsoluteFieldNumber()) != null && (verFieldValue = (objSM = ec.findObjectProvider(obj)).provideField(versionFieldNumber)) != null) {
                objSM.setVersion(verFieldValue);
            }
            if ((versionMapping = this.stmtMapping.getMappingForMemberPosition(StatementClassMapping.MEMBER_VERSION)) != null) {
                JavaTypeMapping mapping = versionMapping.getMapping();
                Object version = mapping.getObject(ec, rs, versionMapping.getColumnPositions());
                ObjectProvider objSM2 = ec.findObjectProvider(obj);
                objSM2.setVersion(version);
            }
        }
        return obj;
    }

    private Object getObjectForApplicationId(ExecutionContext ec, final Object resultSet, final StatementClassMapping mappingDefinition, final int[] fieldNumbers, Class pcClass, boolean requiresInheritanceCheck) {
        final MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
        return ec.findObjectUsingAID(new Type(pcClass), new FieldValues2(){

            public void fetchFields(ObjectProvider sm) {
                FieldManager fm = storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceFields(fieldNumbers, fm, false);
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                FieldManager fm = storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentClassROF.this.fetchPlan;
            }
        }, this.ignoreCache, requiresInheritanceCheck);
    }

    private Object getObjectForDatastoreId(ExecutionContext ec, final Object resultSet, final StatementClassMapping mappingDefinition, final int[] fieldNumbers, Object oid, Class pcClass) {
        if (oid == null) {
            return null;
        }
        final MappedStoreManager storeMgr = (MappedStoreManager)ec.getStoreManager();
        return ec.findObject(oid, new FieldValues2(){

            public void fetchFields(ObjectProvider sm) {
                FieldManager fm = storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceFields(fieldNumbers, fm, false);
            }

            public void fetchNonLoadedFields(ObjectProvider sm) {
                FieldManager fm = storeMgr.getFieldManagerForResultProcessing(sm, resultSet, mappingDefinition);
                sm.replaceNonLoadedFields(fieldNumbers, fm);
            }

            public FetchPlan getFetchPlanForLoading() {
                return PersistentClassROF.this.fetchPlan;
            }
        }, pcClass, this.ignoreCache);
    }
}

