/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.ForeignKeyInfo;
import org.datanucleus.store.rdbms.schema.PostgresqlTypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.NucleusLogger;

public class PostgreSQLAdapter
extends DatabaseAdapter {
    public static final String POSTGRESQL_RESERVED_WORDS = "ALL,ANALYSE,ANALYZE,DO,FREEZE,ILIKE,ISNULL,OFFSET,PLACING,VERBOSE";
    protected Hashtable psqlTypes;

    public PostgreSQLAdapter(DatabaseMetaData metadata) {
        super(metadata);
        if (this.datastoreMajorVersion < 7) {
            throw new NucleusDataStoreException("PostgreSQL version is " + this.datastoreMajorVersion + '.' + this.datastoreMinorVersion + ", 7.0 or later required");
        }
        if (this.datastoreMajorVersion == 7 && this.datastoreMinorVersion <= 2) {
            --this.maxTableNameLength;
            --this.maxConstraintNameLength;
            --this.maxIndexNameLength;
        }
        this.reservedKeywords.addAll(this.parseKeywordList(POSTGRESQL_RESERVED_WORDS));
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.remove("AutoIncrementColumnTypeSpecification");
        this.supportedOptions.remove("AutoIncrementNullSpecification");
        this.supportedOptions.remove("DistinctWithSelectForUpdate");
        this.supportedOptions.remove("PersistOfUnassignedChar");
        if (this.datastoreMajorVersion < 7 || this.datastoreMajorVersion == 7 && this.datastoreMinorVersion < 2) {
            this.supportedOptions.remove("AlterTableDropConstraint_Syntax");
        } else {
            this.supportedOptions.add("AlterTableDropConstraint_Syntax");
        }
        this.supportedOptions.add("BitIsReallyBoolean");
        this.supportedOptions.add("CharColumnsPaddedWithSpaces");
        this.supportedOptions.remove("TxIsolationNone");
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        PostgresqlTypeInfo sqlType = new PostgresqlTypeInfo("char", 1, 65000, null, null, null, 0, false, 3, false, false, false, "char", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)1, sqlType, true);
        sqlType = new PostgresqlTypeInfo("text", 2005, 9, null, null, null, 0, false, 3, false, false, false, null, 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        sqlType = new PostgresqlTypeInfo("BYTEA", 2004, 9, null, null, null, 0, false, 3, false, false, false, null, 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2004, sqlType, true);
    }

    public String getVendorID() {
        return "postgresql";
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        Object obj;
        PostgresqlTypeInfo info = new PostgresqlTypeInfo(rs);
        if (this.psqlTypes == null) {
            this.psqlTypes = new Hashtable();
            this.psqlTypes.put("-7", "bool");
            this.psqlTypes.put("93", "timestamptz");
            this.psqlTypes.put("-5", "int8");
            this.psqlTypes.put("1", "char");
            this.psqlTypes.put("91", "date");
            this.psqlTypes.put("8", "float8");
            this.psqlTypes.put("4", "int4");
            this.psqlTypes.put("-1", "text");
            this.psqlTypes.put("2005", "text");
            this.psqlTypes.put("2004", "bytea");
            this.psqlTypes.put("2", "numeric");
            this.psqlTypes.put("7", "float4");
            this.psqlTypes.put("5", "int2");
            this.psqlTypes.put("92", "time");
            this.psqlTypes.put("12", "varchar");
            this.psqlTypes.put("1111", "***TOTALRUBBISH***");
        }
        if ((obj = this.psqlTypes.get("" + info.getDataType())) != null) {
            String psql_type_name = (String)obj;
            if (!info.getTypeName().equalsIgnoreCase(psql_type_name)) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("051007", (Object)info.getTypeName(), (Object)JDBCUtils.getNameForJDBCType(info.getDataType())));
                return null;
            }
        }
        return info;
    }

    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        int decimalDigits;
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        String typeName = info.getTypeName();
        if (typeName.equalsIgnoreCase("text")) {
            info.setDataType((short)-1);
        } else if (typeName.equalsIgnoreCase("bytea")) {
            info.setDataType((short)-4);
        }
        int columnSize = info.getColumnSize();
        if (columnSize > 65000) {
            info.setColumnSize(-1);
        }
        if ((decimalDigits = info.getDecimalDigits()) > 65000) {
            info.setDecimalDigits(-1);
        }
        return info;
    }

    public ForeignKeyInfo newFKInfo(ResultSet rs) {
        ForeignKeyInfo info = super.newFKInfo(rs);
        String fkName = (String)info.getProperty("fk_name");
        int firstBackslashIdx = fkName.indexOf(92);
        if (firstBackslashIdx > 0) {
            info.addProperty("fk_name", fkName.substring(0, firstBackslashIdx));
        }
        return info;
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (DEFAULT)";
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        if (this.datastoreMajorVersion < 7 || this.datastoreMajorVersion == 7 && this.datastoreMinorVersion < 3) {
            return "DROP TABLE " + table.toString();
        }
        return "DROP TABLE " + table.toString() + " CASCADE";
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        String tableName;
        boolean quoted;
        StringBuffer stmt = new StringBuffer("SELECT currval('");
        if (table.getSchemaName() != null) {
            stmt.append(table.getSchemaName().replace(this.getIdentifierQuoteString(), ""));
            stmt.append(this.getCatalogSeparator());
        }
        if (quoted = (tableName = table.getIdentifier().toString()).startsWith(this.getIdentifierQuoteString())) {
            stmt.append(this.getIdentifierQuoteString());
        }
        stmt.append(tableName.replace(this.getIdentifierQuoteString(), ""));
        stmt.append("_");
        stmt.append(columnName.replace(this.getIdentifierQuoteString(), ""));
        stmt.append("_seq");
        if (quoted) {
            stmt.append(this.getIdentifierQuoteString());
        }
        stmt.append("')");
        return stmt.toString();
    }

    public String getAutoIncrementKeyword() {
        return "SERIAL";
    }

    public String getSequenceCreateStmt(String sequence_name, Integer min, Integer max, Integer start, Integer increment, Integer cache_size) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        if (min != null) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cache_size != null) {
            stmt.append(" CACHE " + cache_size);
        } else {
            stmt.append(" CACHE 1");
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuffer stmt = new StringBuffer("SELECT nextval('");
        stmt.append(sequence_name);
        stmt.append("')");
        return stmt.toString();
    }

    public boolean supportsQueryFetchSize(int size) {
        return this.driverMajorVersion > 7;
    }

    public String getRangeByLimitWhereClause(long offset, long count) {
        String str = "";
        if (count > 0L) {
            str = str + "LIMIT " + count + " ";
        }
        if (offset >= 0L) {
            str = str + "OFFSET " + offset + " ";
        }
        return str;
    }

    public String getEscapePatternExpression() {
        return "ESCAPE '\\\\'";
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(BigInteger.class, source).newLiteral(source.getQueryExpression(), (Object)BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(source);
        args.add(str);
        if (from != null) {
            throw new NucleusUserException("PostgreSQL doesnt currently provide a function for providing indexOf(str, from). Your workaround is to miss off the 'from' position");
        }
        NumericExpression locateExpr = new NumericExpression("STRPOS", args);
        return new NumericExpression((ScalarExpression)locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    public NumericExpression getNumericExpressionForMethod(String method, ScalarExpression expr) {
        if (method.equalsIgnoreCase("hour")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            JavaTypeMapping m = this.getMapping(String.class, expr);
            ScalarExpression submethodLiteral = m.newLiteral(expr.getQueryExpression(), (Object)"hour");
            args.add(submethodLiteral);
            args.add(expr);
            return new NumericExpression("date_part", args);
        }
        if (method.equalsIgnoreCase("minute")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            JavaTypeMapping m = this.getMapping(String.class, expr);
            ScalarExpression submethodLiteral = m.newLiteral(expr.getQueryExpression(), (Object)"minute");
            args.add(submethodLiteral);
            args.add(expr);
            return new NumericExpression("date_part", args);
        }
        if (method.equalsIgnoreCase("second")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            JavaTypeMapping m = this.getMapping(String.class, expr);
            ScalarExpression submethodLiteral = m.newLiteral(expr.getQueryExpression(), (Object)"second");
            args.add(submethodLiteral);
            args.add(expr);
            return new NumericExpression("date_part", args);
        }
        if (method.equalsIgnoreCase("year")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            JavaTypeMapping m = this.getMapping(String.class, expr);
            ScalarExpression submethodLiteral = m.newLiteral(expr.getQueryExpression(), (Object)"year");
            args.add(submethodLiteral);
            args.add(expr);
            return new NumericExpression("date_part", args);
        }
        if (method.equalsIgnoreCase("month")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            JavaTypeMapping m = this.getMapping(String.class, expr);
            ScalarExpression submethodLiteral = m.newLiteral(expr.getQueryExpression(), (Object)"month");
            args.add(submethodLiteral);
            args.add(expr);
            JavaTypeMapping m2 = this.getMapping(BigInteger.class, expr);
            ScalarExpression integerLiteral = m2.newLiteral(expr.getQueryExpression(), (Object)BigInteger.ONE);
            NumericExpression numExpr = new NumericExpression((ScalarExpression)new NumericExpression("date_part", args), ScalarExpression.OP_SUB, integerLiteral);
            numExpr.encloseWithInParentheses();
            return numExpr;
        }
        if (method.equalsIgnoreCase("day")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            JavaTypeMapping m = this.getMapping(String.class, expr);
            ScalarExpression submethodLiteral = m.newLiteral(expr.getQueryExpression(), (Object)"day");
            args.add(submethodLiteral);
            args.add(expr);
            return new NumericExpression("date_part", args);
        }
        return super.getNumericExpressionForMethod(method, expr);
    }
}

