/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.Extent;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.Queryable;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.query.PersistentClassROF;
import org.datanucleus.store.rdbms.query.legacy.CollectionCandidates;
import org.datanucleus.store.rdbms.query.legacy.JDOQLQueryCompiler;
import org.datanucleus.store.rdbms.query.legacy.QueryCompiler;
import org.datanucleus.store.rdbms.query.legacy.QueryResultsMetaData;
import org.datanucleus.store.rdbms.query.legacy.SQLEvaluator;
import org.datanucleus.util.Imports;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOQLQuery
extends AbstractJDOQLQuery {
    protected transient QueryExpression queryStmt = null;
    protected transient Queryable candidates = null;
    protected transient ResultObjectFactory rof = null;
    protected transient boolean isCompiled = false;
    protected transient QueryResultsMetaData resultMetaData;

    public JDOQLQuery(ObjectManager om) {
        this(om, (JDOQLQuery)null);
    }

    public JDOQLQuery(ObjectManager om, JDOQLQuery q) {
        super(om, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(ObjectManager om, String query) {
        super(om, query);
    }

    public Queryable getCandidates() {
        return this.candidates;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof JDOQLQuery && super.equals(obj);
    }

    protected void discardCompiled() {
        this.isCompiled = false;
        this.rof = null;
        this.queryStmt = null;
        super.discardCompiled();
    }

    protected boolean isCompiled() {
        return this.isCompiled;
    }

    protected void compileInternal(boolean forExecute, Map parameterValues) {
        if (this.isCompiled) {
            return;
        }
        try {
            if (forExecute) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021044", (Object)this.getLanguage(), (Object)this.getSingleStringQuery()));
                }
                JDOQLQueryCompiler c = new JDOQLQueryCompiler(this, this.getParsedImports(), parameterValues);
                this.queryStmt = (QueryExpression)c.compile(4);
                if (this.resultDistinct) {
                    this.queryStmt.setDistinctResults(true);
                }
                this.resultMetaData = c.getResultMetaData();
                this.candidateClass = c.getCandidateClass();
                this.candidates = c.getCandidates();
                this.resultClass = c.getResultClass();
                this.fromInclNo = c.getRangeFromIncl();
                this.toExclNo = c.getRangeToExcl();
                c.close();
                c = null;
            } else {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021044", (Object)this.getLanguage(), (Object)this.getSingleStringQuery()));
                }
                JDOQLQueryCompiler c = new JDOQLQueryCompiler(this, this.getParsedImports(), null);
                c.compile(3);
                this.resultMetaData = c.getResultMetaData();
                this.candidateClass = c.getCandidateClass();
                this.candidates = c.getCandidates();
                this.resultClass = c.getResultClass();
                this.fromInclNo = c.getRangeFromIncl();
                this.toExclNo = c.getRangeToExcl();
                c.close();
                c = null;
            }
            this.isCompiled = true;
        }
        catch (NucleusException jpe) {
            this.discardCompiled();
            this.isCompiled = false;
            throw jpe;
        }
    }

    public QueryResultsMetaData getResultSetMetaData() {
        if (this.resultMetaData == null) {
            throw new NucleusUserException("You must compile the query before calling this method.");
        }
        return this.resultMetaData;
    }

    protected Object executeQuery(Map parameters) {
        this.discardCompiled();
        return super.executeQuery(parameters);
    }

    protected Object performExecute(Map parameters) {
        if (this.candidates.isEmpty()) {
            return new ArrayList();
        }
        if (this.candidates instanceof CollectionCandidates) {
            ((CollectionCandidates)this.candidates).getFetchPlan().setGroups((Collection)this.getFetchPlan().getGroups());
        } else if (this.candidates instanceof Extent) {
            ((Extent)this.candidates).getFetchPlan().setGroups((Collection)this.getFetchPlan().getGroups());
        }
        this.rof = this.candidates.newResultObjectFactory(this.queryStmt, this.getIgnoreCache(), this.resultClass, this.useFetchPlan());
        if (this.rof instanceof PersistentClassROF) {
            ((PersistentClassROF)this.rof).setPersistentClass(this.candidateClass);
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)this.getLanguage(), (Object)this.getSingleStringQuery()));
        }
        SQLEvaluator eval = new SQLEvaluator((Query)this, this.rof, this.candidateCollection);
        QueryResult qr = (QueryResult)eval.evaluate(this.queryStmt);
        this.queryResults.add(qr);
        return qr;
    }

    protected long performDeletePersistentAll(Map parameters) {
        this.discardCompiled();
        return super.performDeletePersistentAll(parameters);
    }

    protected boolean applyRangeChecks() {
        if (this.range == null) {
            return false;
        }
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.om.getStoreManager();
        RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        boolean using_limit_select_clause = dba.getRangeByLimitSelectClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_limit_where_clause = dba.getRangeByLimitWhereClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_rownum = dba.getRangeByRowNumberColumn().length() > 0;
        return this.range != null && !using_limit_select_clause && !using_limit_where_clause && !using_rownum;
    }

    public Set<String> getSupportedExtensions() {
        Set supported = super.getSupportedExtensions();
        supported.add("datanucleus.rdbms.query.resultSetType");
        supported.add("datanucleus.rdbms.query.resultSetConcurrency");
        supported.add("datanucleus.rdbms.query.useUpdateLock");
        supported.add("datanucleus.rdbms.query.fetchDirection");
        supported.add("datanucleus.rdbms.jdoql.joinType");
        supported.add("datanucleus.rdbms.jdoql.existsIncludesConstraints");
        supported.add("datanucleus.rdbms.query.containsUsesExistsAlways");
        return supported;
    }

    public Imports getParsedImports() {
        if (this.parsedImports == null) {
            super.getParsedImports();
            Iterator it = QueryCompiler.getUserDefinedScalarExpressions().keySet().iterator();
            while (it.hasNext()) {
                this.parsedImports.importClass((String)it.next());
            }
        }
        return this.parsedImports;
    }
}

