/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.Collection;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.util.NucleusLogger;

public class CollectionContainsMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(LOCALISER.msg("060016", (Object)"contains", (Object)"CollectionExpression", (Object)1));
        }
        CollectionExpression collExpr = (CollectionExpression)expr;
        SQLExpression elemExpr = (SQLExpression)args.get(0);
        if (expr instanceof CollectionLiteral) {
            CollectionLiteral lit = (CollectionLiteral)expr;
            Collection coll = (Collection)lit.getValue();
            JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
            if (coll == null || coll.isEmpty()) {
                return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, false));
            }
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = lit.getElementExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                bExpr = bExpr == null ? elementExprs.get(i).eq(elemExpr) : ((BooleanExpression)bExpr).ior(elementExprs.get(i).eq(elemExpr));
            }
            bExpr.encloseInParentheses();
            return bExpr;
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER) {
            Boolean hasNOT;
            boolean needsSubquery = false;
            Boolean hasOR = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.OR");
            if (hasOR != null && hasOR.booleanValue()) {
                needsSubquery = true;
            }
            if ((hasNOT = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.NOT")) != null && hasNOT.booleanValue()) {
                needsSubquery = true;
            }
            if (needsSubquery) {
                NucleusLogger.QUERY.debug((Object)("CollectionContains cmpt=" + this.stmt.getQueryGenerator().getCompilationComponent() + " expr=" + collExpr + "(" + elemExpr + ") using SUBQUERY"));
                return this.containsAsSubquery(collExpr, elemExpr);
            }
            NucleusLogger.QUERY.debug((Object)("CollectionContains cmpt=" + this.stmt.getQueryGenerator().getCompilationComponent() + " expr=" + collExpr + "(" + elemExpr + ") using INNERJOIN"));
            return this.containsAsInnerJoin(collExpr, elemExpr);
        }
        NucleusLogger.QUERY.debug((Object)("CollectionContains cmpt=" + this.stmt.getQueryGenerator().getCompilationComponent() + " expr=" + collExpr + "(" + elemExpr + ") using SUBQUERY"));
        return this.containsAsSubquery(collExpr, elemExpr);
    }

    protected SQLExpression containsAsInnerJoin(CollectionExpression collExpr, SQLExpression elemExpr) {
        DatastoreClass elemTbl;
        AbstractMemberMetaData mmd;
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        CollectionTable joinTbl = (CollectionTable)storeMgr.getDatastoreContainerObject(mmd = collExpr.getJavaTypeMapping().getMemberMetaData());
        if (joinTbl != null) {
            if (mmd.getCollection().getElementClassMetaData(this.clr, storeMgr.getMetaDataManager()) == null) {
                SQLTable joinSqlTbl = this.stmt.innerJoin(collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getElementMapping());
                this.stmt.whereAnd(elemIdExpr.eq(elemExpr), true);
            } else {
                elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                SQLTable joinSqlTbl = this.stmt.innerJoin(collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                SQLTable elemSqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)elemTbl, null, elemTbl.getIdMapping(), null, null);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, elemSqlTbl, elemTbl.getIdMapping());
                this.stmt.whereAnd(elemIdExpr.eq(elemExpr), true);
            }
        } else {
            elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? elemTbl.getMemberMapping(mmd.getRelatedMemberMetaData(this.clr)[0]) : elemTbl.getExternalMapping(mmd, 5);
            SQLTable elemSqlTbl = this.stmt.innerJoin(collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), (DatastoreContainerObject)elemTbl, null, ownerMapping, null, null);
            SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, elemSqlTbl, elemTbl.getIdMapping());
            this.stmt.whereAnd(elemIdExpr.eq(elemExpr), true);
        }
        JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
        return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
    }

    protected SQLExpression containsAsSubquery(CollectionExpression collExpr, SQLExpression elemExpr) {
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        AbstractMemberMetaData mmd = collExpr.getJavaTypeMapping().getMemberMetaData();
        CollectionTable joinTbl = (CollectionTable)storeMgr.getDatastoreContainerObject(mmd);
        SQLStatement subStmt = null;
        if (joinTbl != null) {
            if (mmd.getCollection().getElementClassMetaData(this.clr, storeMgr.getMetaDataManager()) == null) {
                subStmt = new SQLStatement(this.stmt, storeMgr, joinTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getElementMapping());
                subStmt.whereAnd(elemIdExpr.eq(elemExpr), true);
            } else {
                DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)elemTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), elemTbl.getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                subStmt.whereAnd(elemIdExpr.eq(elemExpr), true);
            }
        } else {
            DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
            subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)elemTbl, null, null);
            subStmt.setClassLoaderResolver(this.clr);
            JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
            subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? elemTbl.getMemberMapping(mmd.getRelatedMemberMetaData(this.clr)[0]) : elemTbl.getExternalMapping(mmd, 5);
            SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
            SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
            subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
            SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
            subStmt.whereAnd(elemIdExpr.eq(elemExpr), true);
        }
        return new BooleanSubqueryExpression(this.stmt, "EXISTS", subStmt);
    }
}

