/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class TimeRDBMSMapping
extends RDBMSMapping {
    protected TimeRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public TimeRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    public SQLTypeInfo getTypeInfo() {
        return ((RDBMSStoreManager)this.storeMgr).getSQLTypeInfoForJDBCType(92);
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
            } else {
                ((PreparedStatement)ps).setTime(param, (Time)value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"java.sql.Time", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    protected Time getTime(Object rs, int param) {
        Time value;
        try {
            value = ((ResultSet)rs).getTime(param);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"java.sql.Time", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public Object getObject(Object rs, int param) {
        Time value = this.getTime(rs, param);
        if (value == null) {
            return null;
        }
        return value;
    }
}

