/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.ByteLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalExpression;

public class StringExpression
extends SQLExpression {
    public StringExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public StringExpression(Expression.MonadicOperator op, SQLExpression expr1) {
        super(op, expr1);
    }

    public StringExpression(SQLExpression expr1, Expression.DyadicOperator op, SQLExpression expr2) {
        super(expr1, op, expr2);
    }

    public StringExpression(JavaTypeMapping mapping, String functionName, List args) {
        super(mapping, functionName, args, null);
    }

    public StringExpression(JavaTypeMapping mapping, String functionName, List args, List types) {
        super(mapping, functionName, args, types);
    }

    public BooleanExpression eq(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_EQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_EQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_EQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.ne(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_NOTEQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_NOTEQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_NOTEQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof TemporalExpression) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        return super.ne(expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.lt(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_LT, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_LT, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_LT, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.le(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_LTEQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_LTEQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_LTEQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        return super.le(expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.gt(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_GT, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_GT, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_GT, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        if (this.isParameter() || expr.isParameter()) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof NullLiteral) {
            return expr.ge(this);
        }
        if (expr instanceof CharacterLiteral) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof StringExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof ByteLiteral) {
            int value = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_GTEQ, literal);
        }
        if (expr instanceof IntegerLiteral) {
            int value = ((Number)((IntegerLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_GTEQ, literal);
        }
        if (expr instanceof FloatingPointLiteral) {
            int value = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).intValue();
            CharacterLiteral literal = new CharacterLiteral(this.stmt, this.mapping, String.valueOf((char)value), null);
            return new BooleanExpression(this, Expression.OP_GTEQ, literal);
        }
        if (expr instanceof NumericExpression) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        return super.ge(expr);
    }

    public SQLExpression add(SQLExpression expr) {
        if (this instanceof SQLLiteral && this.isParameter() && expr instanceof SQLLiteral && expr.isParameter()) {
            this.stmt.getQueryGenerator().useParameterExpressionAsLiteral((SQLLiteral)((Object)this));
            this.stmt.getQueryGenerator().useParameterExpressionAsLiteral((SQLLiteral)((Object)expr));
            return new StringExpression(this, Expression.OP_CONCAT, expr).encloseInParentheses();
        }
        if (expr.isParameter()) {
            return new StringExpression(this, Expression.OP_CONCAT, expr).encloseInParentheses();
        }
        if (expr instanceof StringLiteral) {
            return new StringExpression(this, Expression.OP_CONCAT, new StringLiteral(this.stmt, expr.mapping, ((StringLiteral)expr).getValue(), null)).encloseInParentheses();
        }
        if (expr instanceof StringExpression) {
            return new StringExpression(this, Expression.OP_CONCAT, expr).encloseInParentheses();
        }
        if (expr instanceof CharacterExpression) {
            return new StringExpression(this, Expression.OP_CONCAT, expr).encloseInParentheses();
        }
        if (expr instanceof NumericExpression) {
            StringExpression strExpr = (StringExpression)this.stmt.getSQLExpressionFactory().invokeOperation("numericToString", expr, null).encloseInParentheses();
            return new StringExpression(this, Expression.OP_CONCAT, strExpr);
        }
        if (expr instanceof NullLiteral) {
            return expr;
        }
        return new StringExpression(this, Expression.OP_CONCAT, expr).encloseInParentheses();
    }

    public BooleanExpression in(SQLExpression expr) {
        return new BooleanExpression(this, Expression.OP_IN, expr);
    }

    public SQLExpression invoke(String methodName, List args) {
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, String.class.getName(), methodName, this, args);
    }
}

