/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OIDFactory;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.BigDecimalMapping;
import org.datanucleus.store.mapped.mapping.BigIntegerMapping;
import org.datanucleus.store.mapped.mapping.BooleanMapping;
import org.datanucleus.store.mapped.mapping.ByteMapping;
import org.datanucleus.store.mapped.mapping.CharacterMapping;
import org.datanucleus.store.mapped.mapping.DateMapping;
import org.datanucleus.store.mapped.mapping.DiscriminatorMapping;
import org.datanucleus.store.mapped.mapping.DoubleMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.FloatMapping;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.LongMapping;
import org.datanucleus.store.mapped.mapping.PersistableIdMapping;
import org.datanucleus.store.mapped.mapping.PersistableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.ShortMapping;
import org.datanucleus.store.mapped.mapping.SqlDateMapping;
import org.datanucleus.store.mapped.mapping.SqlTimeMapping;
import org.datanucleus.store.mapped.mapping.SqlTimestampMapping;
import org.datanucleus.store.mapped.mapping.StringMapping;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.ByteLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.ExpressionUtils;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.store.rdbms.sql.expression.TemporalLiteral;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class ObjectExpression
extends SQLExpression {
    protected static final Localiser LOCALISER_CORE = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());

    public ObjectExpression(SQLStatement stmt, SQLTable table, JavaTypeMapping mapping) {
        super(stmt, table, mapping);
    }

    public void useFirstColumnOnly() {
        if (this.mapping.getNumberOfDatastoreFields() <= 1) {
            return;
        }
        this.subExprs = new SQLExpression.ColumnExpressionList();
        ColumnExpression colExpr = new ColumnExpression(this.stmt, this.table, (Column)this.mapping.getDataStoreMapping(0).getDatastoreField());
        this.subExprs.addExpression(colExpr);
        this.st.clearStatement();
        this.st.append(this.subExprs.toString());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BooleanExpression eq(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        this.addSubexpressionsToRelatedExpression(expr);
        if (this.mapping instanceof PersistableIdMapping && expr instanceof StringLiteral && (oidString = (String)((StringLiteral)expr).getValue()) != null) {
            cmd = this.stmt.getRDBMSManager().getMetaDataManager().getMetaDataForClass(this.mapping.getType(), this.stmt.getQueryGenerator().getClassLoaderResolver());
            if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                try {
                    oid = OIDFactory.getInstance((ObjectManager)this.stmt.getQueryGenerator().getObjectManager(), (String)oidString);
                    if (oid == null) ** GOTO lbl14
                }
                catch (IllegalArgumentException iae) {
                    throw new QueryCompilerSyntaxException("Impossible comparison of " + this + " and " + expr + " since the former is a datastore-identity and the latter is of incorrect form (" + oidString + ")");
                }
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                // empty if block
            }
        }
lbl14:
        // 7 sources

        bExpr = null;
        if (!this.isParameter() && !expr.isParameter()) {
            if (!(expr instanceof NullLiteral)) {
                if (this.literalIsValidForSimpleComparison(expr)) {
                    if (this.subExprs.size() > 1) {
                        return super.eq(expr);
                    }
                    return new BooleanExpression(this, Expression.OP_EQ, expr);
                }
                if (expr instanceof ObjectExpression) {
                    return ExpressionUtils.getEqualityExpressionForObjectExpressions(this, (ObjectExpression)expr, true);
                }
                return super.eq(expr);
            }
        } else {
            if (this.subExprs.size() <= 1) {
                return new BooleanExpression(this, Expression.OP_EQ, expr);
            }
            i = 0;
            while (true) {
                if (i >= this.subExprs.size()) {
                    return bExpr;
                }
                subexpr = this.subExprs.getExpression(i).eq(((ObjectExpression)expr).subExprs.getExpression(i));
                bExpr = bExpr == null ? subexpr : bExpr.and(subexpr);
                ++i;
            }
        }
        i = 0;
        while (true) {
            if (i >= this.subExprs.size()) {
                return bExpr;
            }
            subexpr = expr.eq(this.subExprs.getExpression(i));
            bExpr = bExpr == null ? subexpr : bExpr.and(subexpr);
            ++i;
        }
    }

    public BooleanExpression ne(SQLExpression expr) {
        this.checkForAndCorrectParameterComparison(expr);
        this.addSubexpressionsToRelatedExpression(expr);
        SQLExpression bExpr = null;
        if (this.isParameter() || expr.isParameter()) {
            if (this.subExprs.size() > 1) {
                for (int i = 0; i < this.subExprs.size(); ++i) {
                    BooleanExpression subexpr = this.subExprs.getExpression(i).eq(((ObjectExpression)expr).subExprs.getExpression(i));
                    bExpr = bExpr == null ? subexpr : ((BooleanExpression)bExpr).and(subexpr);
                }
                return new BooleanExpression(Expression.OP_NOT, bExpr.encloseInParentheses());
            }
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof NullLiteral) {
            for (int i = 0; i < this.subExprs.size(); ++i) {
                BooleanExpression subexpr = expr.eq(this.subExprs.getExpression(i));
                bExpr = bExpr == null ? subexpr : ((BooleanExpression)bExpr).and(subexpr);
            }
            return new BooleanExpression(Expression.OP_NOT, bExpr.encloseInParentheses());
        }
        if (this.literalIsValidForSimpleComparison(expr)) {
            if (this.subExprs.size() > 1) {
                return super.ne(expr);
            }
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof ObjectExpression) {
            return ExpressionUtils.getEqualityExpressionForObjectExpressions(this, (ObjectExpression)expr, false);
        }
        return super.ne(expr);
    }

    protected void addSubexpressionsToRelatedExpression(SQLExpression expr) {
        if (expr.subExprs == null) {
            expr.subExprs = new SQLExpression.ColumnExpressionList();
            for (int i = 0; i < this.subExprs.size(); ++i) {
                expr.subExprs.addExpression(new ColumnExpression(this.stmt, expr.parameterName, expr.mapping, null, i));
            }
        }
    }

    private boolean literalIsValidForSimpleComparison(SQLExpression expr) {
        return expr instanceof BooleanLiteral && this.mapping instanceof BooleanMapping || expr instanceof ByteLiteral && this.mapping instanceof ByteMapping || expr instanceof CharacterLiteral && this.mapping instanceof CharacterMapping || expr instanceof FloatingPointLiteral && (this.mapping instanceof FloatMapping || this.mapping instanceof DoubleMapping || this.mapping instanceof BigDecimalMapping) || expr instanceof IntegerLiteral && (this.mapping instanceof IntegerMapping || this.mapping instanceof LongMapping || this.mapping instanceof BigIntegerMapping) || this.mapping instanceof ShortMapping || expr instanceof TemporalLiteral && (this.mapping instanceof DateMapping || this.mapping instanceof SqlDateMapping || this.mapping instanceof SqlTimeMapping || this.mapping instanceof SqlTimestampMapping) || expr instanceof StringLiteral && (this.mapping instanceof StringMapping || this.mapping instanceof CharacterMapping);
    }

    public BooleanExpression in(SQLExpression expr) {
        return new BooleanExpression(this, Expression.OP_IN, expr);
    }

    public SQLExpression cast(SQLExpression expr) {
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        Class type = null;
        String castClassName = (String)((StringLiteral)expr).getValue();
        try {
            type = clr.classForName(castClassName);
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusUserException(LOCALISER_CORE.msg("037017", (Object)castClassName));
        }
        SQLExpressionFactory exprFactory = this.stmt.getSQLExpressionFactory();
        Class memberType = clr.classForName(this.mapping.getType());
        if (!memberType.isAssignableFrom(type) && !type.isAssignableFrom(memberType)) {
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, false).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        if (memberType == type) {
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, true).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        if (this.mapping instanceof EmbeddedMapping) {
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, false).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        if (this.mapping instanceof PersistableMapping || this.mapping instanceof ReferenceMapping) {
            DatastoreClass castTable = storeMgr.getDatastoreClass(type.getName(), clr);
            SQLTable castSqlTbl = this.stmt.getTable((DatastoreContainerObject)castTable, this.table.getGroupName());
            if (castSqlTbl == null) {
                castSqlTbl = this.stmt.leftOuterJoin(this.table, this.table.getTable().getIDMapping(), (DatastoreContainerObject)castTable, null, castTable.getIDMapping(), null, this.table.getGroupName());
            }
            return exprFactory.newExpression(this.stmt, castSqlTbl, castTable.getIDMapping());
        }
        throw new NucleusUserException("Dont currently support ObjectExpression.cast(" + type + ")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BooleanExpression is(SQLExpression expr) {
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        Class type = null;
        try {
            type = clr.classForName((String)((StringLiteral)expr).getValue());
        }
        catch (ClassNotResolvedException cnre) {
            throw new NucleusUserException(LOCALISER_CORE.msg("037016", (Object)expr));
        }
        SQLExpressionFactory exprFactory = this.stmt.getSQLExpressionFactory();
        Class memberType = clr.classForName(this.mapping.getType());
        if (!memberType.isAssignableFrom(type) && !type.isAssignableFrom(memberType)) {
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, false).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        if (memberType == type) {
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, true).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        if (this.mapping instanceof EmbeddedMapping) {
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, false).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        if (!(this.mapping instanceof PersistableMapping) && !(this.mapping instanceof ReferenceMapping)) throw new NucleusException("Dont currently support " + this + " instanceof " + type.getName());
        AbstractClassMetaData fieldCmd = storeMgr.getMetaDataManager().getMetaDataForClass(this.mapping.getType(), clr);
        DatastoreClass memberTable = null;
        if (fieldCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
            AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(fieldCmd, clr);
            if (cmds == null) throw new NucleusUserException(LOCALISER_CORE.msg("037005", (Object)this.mapping.getMemberMetaData().getFullFieldName()));
            if (cmds.length > 1) {
                NucleusLogger.QUERY.warn((Object)LOCALISER_CORE.msg("037006", (Object)this.mapping.getMemberMetaData().getFullFieldName(), (Object)cmds[0].getFullClassName()));
            }
            memberTable = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr);
        } else {
            memberTable = storeMgr.getDatastoreClass(this.mapping.getType(), clr);
        }
        DiscriminatorMetaData dismd = memberTable.getDiscriminatorMetaData();
        DiscriminatorMapping discMapping = (DiscriminatorMapping)memberTable.getDiscriminatorMapping(false);
        if (discMapping != null) {
            SQLTable targetSqlTbl = null;
            if (this.mapping.getDatastoreContainer() != memberTable) {
                targetSqlTbl = this.stmt.getTable((DatastoreContainerObject)memberTable, null);
                if (targetSqlTbl == null) {
                    targetSqlTbl = this.stmt.innerJoin(this.getSQLTable(), this.mapping, (DatastoreContainerObject)memberTable, null, memberTable.getIDMapping(), null, null);
                }
            } else {
                targetSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(this.stmt, this.getSQLTable(), (JavaTypeMapping)discMapping);
            }
            SQLTable discSqlTbl = targetSqlTbl;
            BooleanExpression discExpr = SQLStatementHelper.getExpressionForDiscriminatorForClass(this.stmt, type.getName(), dismd, (JavaTypeMapping)discMapping, discSqlTbl);
            Iterator subclassIter = storeMgr.getSubClassesForClass(type.getName(), true, clr).iterator();
            boolean hasSubclass = false;
            while (subclassIter.hasNext()) {
                String subclassName = (String)subclassIter.next();
                BooleanExpression discExprSub = SQLStatementHelper.getExpressionForDiscriminatorForClass(this.stmt, subclassName, dismd, (JavaTypeMapping)discMapping, discSqlTbl);
                discExpr = discExpr.ior(discExprSub);
                hasSubclass = true;
            }
            if (!hasSubclass) return discExpr;
            discExpr.encloseInParentheses();
            return discExpr;
        }
        DatastoreClass table = null;
        if (fieldCmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
            AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(fieldCmd, clr);
            if (cmds == null) throw new NucleusUserException(LOCALISER_CORE.msg("037005", (Object)this.mapping.getMemberMetaData().getFullFieldName()));
            if (cmds.length > 1) {
                NucleusLogger.QUERY.warn((Object)LOCALISER_CORE.msg("037006", (Object)this.mapping.getMemberMetaData().getFullFieldName(), (Object)cmds[0].getFullClassName()));
            }
            table = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr);
        } else {
            table = storeMgr.getDatastoreClass(this.mapping.getType(), clr);
        }
        if (table.managesClass(type.getName())) {
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
            return exprFactory.newLiteral(this.stmt, m, true).eq(exprFactory.newLiteral(this.stmt, m, true));
        }
        DatastoreClass instanceofTable = storeMgr.getDatastoreClass(type.getName(), clr);
        if (this.stmt.getNumberOfUnions() > 0) {
            NucleusLogger.QUERY.debug((Object)("InstanceOf for " + table + " but no discriminator so adding inner join to " + instanceofTable + " : in some cases with UNIONs this may fail"));
        }
        this.stmt.innerJoin(this.table, this.table.getTable().getIDMapping(), (DatastoreContainerObject)instanceofTable, null, instanceofTable.getIDMapping(), null, this.table.getGroupName());
        JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, true);
        return exprFactory.newLiteral(this.stmt, m, true).eq(exprFactory.newLiteral(this.stmt, m, true));
    }

    public SQLExpression invoke(String methodName, List args) {
        return this.stmt.getRDBMSManager().getSQLExpressionFactory().invokeMethod(this.stmt, Object.class.getName(), methodName, this, args);
    }
}

