/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementParameterMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.mapped.mapping.SerialisedMapping;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.mapped.scostore.AbstractMapStore;
import org.datanucleus.store.mapped.scostore.AbstractMapStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.FKMapStore;
import org.datanucleus.store.mapped.scostore.MapEntrySetStore;
import org.datanucleus.store.mapped.scostore.MapKeySetStore;
import org.datanucleus.store.mapped.scostore.MapValueSetStore;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractMapStoreSpecialization;
import org.datanucleus.store.rdbms.scostore.RDBMSMapEntrySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapKeySetStore;
import org.datanucleus.store.rdbms.scostore.RDBMSMapValueSetStore;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class RDBMSFKMapStore
extends FKMapStore {
    private String updateFkStmt;
    private String getStmtLocked = null;
    private String getStmtUnlocked = null;
    private StatementClassMapping getMappingDef = null;
    private StatementParameterMapping getMappingParams = null;

    public RDBMSFKMapStore(AbstractMemberMetaData mmd, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(mmd, (MappedStoreManager)storeMgr, clr, (AbstractMapStoreSpecialization)new RDBMSAbstractMapStoreSpecialization(LOCALISER, clr, storeMgr));
        this.specialization.initialise((AbstractMapStore)this);
    }

    protected void initialise() {
        this.updateFkStmt = this.getUpdateFkStmt();
    }

    private RDBMSStoreManager getStoreMgr() {
        return (RDBMSStoreManager)this.storeMgr;
    }

    private String getUpdateFkStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.getMapTable().toString());
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        if (this.keyFieldNumber >= 0) {
            for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        } else {
            for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateValueFkInternal(StateManager sm, Object value, Object owner) {
        boolean retval;
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)1, (JavaTypeMapping)this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)1, (JavaTypeMapping)this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    }
                    jdbcPosition = BackingStoreHelper.populateValueInStatement(om, ps, value, jdbcPosition, this.valueMapping);
                    sqlControl.executeStatementUpdate(mconn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateKeyFkInternal(StateManager sm, Object key, Object owner) {
        boolean retval;
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)1, (JavaTypeMapping)this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(om, (Object)ps, MappingHelper.getMappingIndices((int)1, (JavaTypeMapping)this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    }
                    jdbcPosition = BackingStoreHelper.populateKeyInStatement(om, ps, key, jdbcPosition, this.keyMapping);
                    sqlControl.executeStatementUpdate(mconn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue(StateManager ownerSM, Object key) throws NoSuchElementException {
        Transaction tx;
        if (!this.validateKeyForReading(ownerSM, key)) {
            return null;
        }
        ObjectManager om = ownerSM.getObjectManager();
        if (this.getStmtLocked == null) {
            RDBMSFKMapStore rDBMSFKMapStore = this;
            synchronized (rDBMSFKMapStore) {
                SQLStatement sqlStmt = this.getSQLStatementForGet(ownerSM);
                this.getStmtUnlocked = sqlStmt.getSelectStatement().toSQL();
                sqlStmt.addExtension("lock-for-update", true);
                this.getStmtLocked = sqlStmt.getSelectStatement().toSQL();
            }
        }
        String stmt = (tx = om.getTransaction()).lockReadObjects() ? this.getStmtLocked : this.getStmtUnlocked;
        Object value = null;
        try {
            RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.storeMgr;
            ManagedConnection mconn = storeMgr.getConnection(om);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                StatementMappingIndex ownerIdx = this.getMappingParams.getMappingForParameter("owner");
                int numParams = ownerIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    ownerIdx.getMapping().setObject(om, (Object)ps, ownerIdx.getParameterPositionsForOccurrence(paramInstance), ownerSM.getObject());
                }
                StatementMappingIndex keyIdx = this.getMappingParams.getMappingForParameter("key");
                numParams = keyIdx.getNumberOfParameterOccurrences();
                for (int paramInstance = 0; paramInstance < numParams; ++paramInstance) {
                    keyIdx.getMapping().setObject(om, (Object)ps, keyIdx.getParameterPositionsForOccurrence(paramInstance), key);
                }
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        boolean found = rs.next();
                        if (!found) {
                            throw new NoSuchElementException();
                        }
                        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            if (this.valueMapping instanceof SerialisedPCMapping || this.valueMapping instanceof SerialisedReferenceMapping || this.valueMapping instanceof EmbeddedKeyPCMapping) {
                                int ownerFieldNumber = ((JoinTable)this.mapTable).getOwnerMemberMetaData().getAbsoluteFieldNumber();
                                value = this.valueMapping.getObject(om, (Object)rs, param, ownerSM, ownerFieldNumber);
                            } else {
                                value = this.valueMapping.getObject(om, (Object)rs, param);
                            }
                        } else if (this.valueMapping instanceof ReferenceMapping) {
                            int[] param = new int[this.valueMapping.getNumberOfDatastoreFields()];
                            for (int i = 0; i < param.length; ++i) {
                                param[i] = i + 1;
                            }
                            value = this.valueMapping.getObject(om, (Object)rs, param);
                        } else {
                            ResultObjectFactory rof = storeMgr.newResultObjectFactory(this.vmd, this.getMappingDef, false, null, this.clr.classForName(this.valueType));
                            value = rof.getObject(om, (Object)rs);
                        }
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056014", (Object)stmt), (Throwable)e);
        }
        return value;
    }

    protected SQLStatement getSQLStatementForGet(StateManager ownerSM) {
        SQLExpression keyVal;
        SQLExpression keyExpr;
        SQLStatement sqlStmt = null;
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        Class valueCls = clr.classForName(this.valueType);
        RDBMSStoreManager storeMgr = (RDBMSStoreManager)this.storeMgr;
        if (this.ownerMemberMetaData.getMap().getMapType() == MapMetaData.MapType.MAP_TYPE_KEY_IN_VALUE) {
            this.getMappingDef = new StatementClassMapping();
            if (this.valueTable.getDiscriminatorMetaData() != null && this.valueTable.getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
                if (ClassUtils.isReferenceType((Class)valueCls)) {
                    String[] clsNames = storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.valueType, clr);
                    Class[] cls = new Class[clsNames.length];
                    for (int i = 0; i < clsNames.length; ++i) {
                        cls[i] = clr.classForName(clsNames[i]);
                    }
                    sqlStmt = new DiscriminatorStatementGenerator(storeMgr, cls, true, null, null).getStatement();
                } else {
                    sqlStmt = new DiscriminatorStatementGenerator(storeMgr, valueCls, true, null, null).getStatement();
                }
                this.iterateUsingDiscriminator = true;
            } else {
                UnionStatementGenerator stmtGen = new UnionStatementGenerator(storeMgr, valueCls, true, null, null);
                stmtGen.setOption("selectNucleusType");
                this.getMappingDef.setNucleusTypeColumnName("NUCLEUS_TYPE");
                sqlStmt = stmtGen.getStatement();
            }
            SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.getMappingDef, ownerSM.getObjectManager().getFetchPlan(), sqlStmt.getPrimaryTable(), this.vmd, 0);
        } else {
            sqlStmt = new SQLStatement(storeMgr, this.mapTable, null, null);
            if (this.vmd != null) {
                NucleusLogger.PERSISTENCE.info((Object)(">> FKMapStore VALUE_IN_KEY and value is persistable in " + this.valueTable));
                SQLTable valueSqlTbl = sqlStmt.leftOuterJoin(sqlStmt.getPrimaryTable(), this.valueMapping, (DatastoreContainerObject)this.valueTable, null, this.valueTable.getIDMapping(), null, null);
                SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(sqlStmt, this.getMappingDef, ownerSM.getObjectManager().getFetchPlan(), valueSqlTbl, this.vmd, 0);
            } else {
                sqlStmt.select(sqlStmt.getPrimaryTable(), this.valueMapping, null);
            }
        }
        SQLExpressionFactory exprFactory = storeMgr.getSQLExpressionFactory();
        SQLTable ownerSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(sqlStmt, sqlStmt.getPrimaryTable(), this.ownerMapping);
        SQLExpression ownerExpr = exprFactory.newExpression(sqlStmt, ownerSqlTbl, this.ownerMapping);
        SQLExpression ownerVal = exprFactory.newLiteralParameter(sqlStmt, this.ownerMapping, null, "OWNER");
        sqlStmt.whereAnd(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null, "KEY");
            sqlStmt.whereAnd(new BooleanExpression(keyExpr, Expression.OP_LIKE, keyVal), true);
        } else {
            keyExpr = exprFactory.newExpression(sqlStmt, sqlStmt.getPrimaryTable(), this.keyMapping);
            keyVal = exprFactory.newLiteralParameter(sqlStmt, this.keyMapping, null, "KEY");
            sqlStmt.whereAnd(keyExpr.eq(keyVal), true);
        }
        int inputParamNum = 1;
        StatementMappingIndex ownerIdx = new StatementMappingIndex(this.ownerMapping);
        StatementMappingIndex keyIdx = new StatementMappingIndex(this.keyMapping);
        if (sqlStmt.getNumberOfUnions() > 0) {
            for (int j = 0; j < sqlStmt.getNumberOfUnions() + 1; ++j) {
                int[] ownerPositions = new int[this.ownerMapping.getNumberOfDatastoreFields()];
                for (int k = 0; k < ownerPositions.length; ++k) {
                    ownerPositions[k] = inputParamNum++;
                }
                ownerIdx.addParameterOccurrence(ownerPositions);
                int[] keyPositions = new int[this.keyMapping.getNumberOfDatastoreFields()];
                for (int k = 0; k < keyPositions.length; ++k) {
                    keyPositions[k] = inputParamNum++;
                }
                keyIdx.addParameterOccurrence(keyPositions);
            }
        } else {
            int[] ownerPositions = new int[this.ownerMapping.getNumberOfDatastoreFields()];
            for (int k = 0; k < ownerPositions.length; ++k) {
                ownerPositions[k] = inputParamNum++;
            }
            ownerIdx.addParameterOccurrence(ownerPositions);
            int[] keyPositions = new int[this.keyMapping.getNumberOfDatastoreFields()];
            for (int k = 0; k < keyPositions.length; ++k) {
                keyPositions[k] = inputParamNum++;
            }
            keyIdx.addParameterOccurrence(keyPositions);
        }
        this.getMappingParams = new StatementParameterMapping();
        this.getMappingParams.addMappingForParameter("owner", ownerIdx);
        this.getMappingParams.addMappingForParameter("key", keyIdx);
        return sqlStmt;
    }

    protected MapKeySetStore newMapKeySetStore() {
        return new RDBMSMapKeySetStore((DatastoreContainerObject)this.valueTable, (MapStore)this, this.clr, this.ownerMapping, this.keyMapping, this.ownerMemberMetaData);
    }

    protected MapValueSetStore newMapValueSetStore() {
        return new RDBMSMapValueSetStore(this.valueTable, (MapStore)this, this.clr, this.ownerMapping, this.valueMapping, this.ownerMemberMetaData);
    }

    protected MapEntrySetStore newMapEntrySetStore() {
        return new RDBMSMapEntrySetStore((DatastoreContainerObject)this.valueTable, (MapStore)this, this.clr, this.ownerMapping, this.keyMapping, this.valueMapping, this.ownerMemberMetaData);
    }
}

