/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreElementContainer;
import org.datanucleus.store.mapped.SecondaryDatastoreClass;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.DiscriminatorLongMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.sql.SQLJoin;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLTableGroup;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.table.JoinTable;

public class SQLStatementHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PreparedStatement getPreparedStatementForSQLStatement(SQLStatement sqlStmt, ObjectManager om, ManagedConnection mconn, String resultSetType, String resultSetConcurrency) throws SQLException {
        SQLText sqlText = sqlStmt.getSelectStatement();
        SQLController sqlControl = ((RDBMSStoreManager)om.getStoreManager()).getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(mconn, sqlText.toString(), resultSetType, resultSetConcurrency);
        boolean done = false;
        try {
            sqlText.applyParametersToStatement(om, ps);
            done = true;
        }
        finally {
            if (!done) {
                sqlControl.closeStatement(mconn, ps);
            }
        }
        return ps;
    }

    public static SQLTable getSQLTableForMappingOfTable(SQLStatement stmt, SQLTable sqlTbl, JavaTypeMapping mapping) {
        DatastoreContainerObject table = sqlTbl.getTable();
        if (table instanceof SecondaryDatastoreClass || table instanceof JoinTable) {
            SQLTable mappingSqlTbl;
            if (mapping.getDatastoreContainer() != null && (mappingSqlTbl = stmt.getTable(mapping.getDatastoreContainer(), sqlTbl.getGroupName())) != null) {
                return mappingSqlTbl;
            }
            return sqlTbl;
        }
        DatastoreClass sourceTbl = (DatastoreClass)sqlTbl.getTable();
        DatastoreClass mappingTbl = null;
        mappingTbl = mapping.getDatastoreContainer() != null ? (DatastoreClass)mapping.getDatastoreContainer() : sourceTbl.getBaseDatastoreClassWithMember(mapping.getMemberMetaData());
        if (mappingTbl == sourceTbl) {
            return sqlTbl;
        }
        SQLTable mappingSqlTbl = stmt.getTable((DatastoreContainerObject)mappingTbl, sqlTbl.getGroupName());
        if (mappingSqlTbl == null) {
            boolean forceLeftOuter = false;
            SQLTableGroup tableGrp = stmt.getTableGroup(sqlTbl.getGroupName());
            if (tableGrp.getJoinType() == SQLJoin.JoinType.LEFT_OUTER_JOIN) {
                forceLeftOuter = true;
            }
            if (mappingTbl instanceof SecondaryDatastoreClass) {
                boolean innerJoin = true;
                JoinMetaData joinmd = ((SecondaryDatastoreClass)mappingTbl).getJoinMetaData();
                if (joinmd != null && joinmd.isOuter() && !forceLeftOuter) {
                    innerJoin = false;
                }
                mappingSqlTbl = innerJoin && !forceLeftOuter ? stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)mappingTbl, null, mappingTbl.getIDMapping(), null, sqlTbl.getGroupName()) : stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)mappingTbl, null, mappingTbl.getIDMapping(), null, sqlTbl.getGroupName());
            } else {
                mappingSqlTbl = forceLeftOuter ? stmt.leftOuterJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)mappingTbl, null, mappingTbl.getIDMapping(), null, sqlTbl.getGroupName()) : stmt.innerJoin(sqlTbl, sqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)mappingTbl, null, mappingTbl.getIDMapping(), null, sqlTbl.getGroupName());
            }
        }
        return mappingSqlTbl;
    }

    public static void selectIdentityOfCandidateInStatement(SQLStatement stmt, StatementClassMapping mappingDefinition, AbstractClassMetaData candidateCmd) {
        List<SQLStatement> unionStmts;
        JavaTypeMapping discrimMapping;
        DatastoreClass candidateTbl = (DatastoreClass)stmt.getPrimaryTable().getTable();
        if (candidateCmd.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping idMapping = candidateTbl.getDataStoreObjectIdMapping();
            int[] colNumbers = stmt.select(stmt.getPrimaryTable(), idMapping, "DN_DATASTOREID", false);
            if (mappingDefinition != null) {
                StatementMappingIndex datastoreIdIdx = new StatementMappingIndex(idMapping);
                datastoreIdIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_DATASTORE_ID, datastoreIdIdx);
            }
        } else if (candidateCmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] pkPositions = candidateCmd.getPKMemberPositions();
            for (int i = 0; i < pkPositions.length; ++i) {
                AbstractMemberMetaData pkMmd = candidateCmd.getMetaDataForManagedMemberAtAbsolutePosition(pkPositions[i]);
                JavaTypeMapping pkMapping = candidateTbl.getMemberMapping(pkMmd);
                int[] colNumbers = stmt.select(stmt.getPrimaryTable(), pkMapping, "DN_APPID", false);
                if (mappingDefinition == null) continue;
                StatementMappingIndex appIdIdx = new StatementMappingIndex(pkMapping);
                appIdIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(pkPositions[i], appIdIdx);
            }
        }
        JavaTypeMapping verMapping = candidateTbl.getVersionMapping(true);
        if (verMapping != null) {
            SQLTable versionSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, stmt.getPrimaryTable(), verMapping);
            int[] colNumbers = stmt.select(versionSqlTbl, verMapping, "DN_VERSION", false);
            if (mappingDefinition != null) {
                StatementMappingIndex versionIdx = new StatementMappingIndex(verMapping);
                versionIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_VERSION, versionIdx);
            }
        }
        if ((discrimMapping = candidateTbl.getDiscriminatorMapping(true)) != null) {
            SQLTable discrimSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, stmt.getPrimaryTable(), discrimMapping);
            int[] colNumbers = stmt.select(discrimSqlTbl, discrimMapping, "DN_DISCRIM", false);
            if (mappingDefinition != null) {
                StatementMappingIndex discrimIdx = new StatementMappingIndex(discrimMapping);
                discrimIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_DISCRIMINATOR, discrimIdx);
            }
        }
        if ((unionStmts = stmt.getUnions()) != null) {
            for (SQLStatement unionStmt : unionStmts) {
                SQLStatementHelper.selectIdentityOfCandidateInStatement(unionStmt, null, candidateCmd);
            }
        }
    }

    public static void selectFetchPlanOfCandidateInStatement(SQLStatement stmt, StatementClassMapping mappingDefinition, AbstractClassMetaData candidateCmd, FetchPlan fetchPlan, int maxFetchDepth) {
        SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(stmt, mappingDefinition, fetchPlan, stmt.getPrimaryTable(), candidateCmd, maxFetchDepth);
    }

    public static void selectFetchPlanOfSourceClassInStatement(SQLStatement stmt, StatementClassMapping mappingDefinition, FetchPlan fetchPlan, SQLTable sourceSqlTbl, AbstractClassMetaData sourceCmd, int maxFetchDepth) {
        JavaTypeMapping discrimMapping;
        JavaTypeMapping verMapping;
        int[] fieldNumbers;
        DatastoreClass sourceTbl = (DatastoreClass)sourceSqlTbl.getTable();
        if (fetchPlan != null) {
            fetchPlan.manageFetchPlanForClass(sourceCmd);
            FetchPlan.FetchPlanForClass fpc = fetchPlan.getFetchPlanForClass(sourceCmd);
            fieldNumbers = fpc.getFieldsInActualFetchPlan();
        } else {
            fieldNumbers = sourceCmd.getDFGMemberPositions();
        }
        ClassLoaderResolver clr = stmt.getRDBMSManager().getOMFContext().getClassLoaderResolver(null);
        for (int i = 0; i < fieldNumbers.length; ++i) {
            AbstractMemberMetaData mmd = sourceCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            SQLStatementHelper.selectMemberOfSourceInStatement(stmt, mappingDefinition, fetchPlan, sourceSqlTbl, mmd, clr, maxFetchDepth);
        }
        if (sourceCmd.getIdentityType() == IdentityType.DATASTORE) {
            JavaTypeMapping idMapping = sourceTbl.getDataStoreObjectIdMapping();
            int[] colNumbers = stmt.select(sourceSqlTbl, idMapping, null);
            if (mappingDefinition != null) {
                StatementMappingIndex datastoreIdIdx = new StatementMappingIndex(idMapping);
                datastoreIdIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_DATASTORE_ID, datastoreIdIdx);
            }
        }
        if ((verMapping = sourceTbl.getVersionMapping(true)) != null) {
            SQLTable versionSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, sourceSqlTbl, verMapping);
            int[] colNumbers = stmt.select(versionSqlTbl, verMapping, null);
            if (mappingDefinition != null) {
                StatementMappingIndex versionIdx = new StatementMappingIndex(verMapping);
                versionIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_VERSION, versionIdx);
            }
        }
        if ((discrimMapping = sourceTbl.getDiscriminatorMapping(true)) != null) {
            SQLTable discrimSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, sourceSqlTbl, discrimMapping);
            int[] colNumbers = stmt.select(discrimSqlTbl, discrimMapping, null);
            if (mappingDefinition != null) {
                StatementMappingIndex discrimIdx = new StatementMappingIndex(discrimMapping);
                discrimIdx.setColumnPositions(colNumbers);
                mappingDefinition.addMappingForMember(StatementClassMapping.MEMBER_DISCRIMINATOR, discrimIdx);
            }
        }
    }

    public static void selectMemberOfSourceInStatement(SQLStatement stmt, StatementClassMapping mappingDefinition, FetchPlan fetchPlan, SQLTable sourceSqlTbl, AbstractMemberMetaData mmd, ClassLoaderResolver clr, int maxFetchPlanLimit) {
        boolean selectSubobjects = false;
        if (maxFetchPlanLimit > 0) {
            selectSubobjects = true;
        }
        String tableGroupName = sourceSqlTbl.getGroupName() + "." + mmd.getName();
        JavaTypeMapping m = sourceSqlTbl.getTable().getMemberMapping(mmd);
        if (m != null && m.includeInFetchStatement()) {
            int relationType = mmd.getRelationType(clr);
            RDBMSStoreManager storeMgr = stmt.getRDBMSManager();
            MetaDataManager mmgr = storeMgr.getMetaDataManager();
            StatementMappingIndex stmtMapping = new StatementMappingIndex(m);
            if (m.getNumberOfDatastoreFields() > 0) {
                AbstractClassMetaData relatedCmd;
                SQLTable sqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, sourceSqlTbl, m);
                int[] colNumbers = stmt.select(sqlTbl, m, null);
                stmtMapping.setColumnPositions(colNumbers);
                if (selectSubobjects && (relationType == 1 || relationType == 2 && mmd.getMappedBy() == null) && !mmd.isSerialized() && !mmd.isEmbedded() && (relatedCmd = storeMgr.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr)) != null) {
                    SQLTable relatedSqlTbl;
                    DatastoreClass relatedTbl = storeMgr.getDatastoreClass(relatedCmd.getFullClassName(), clr);
                    if (relatedTbl == null) {
                        AbstractClassMetaData[] ownerParentCmds = storeMgr.getClassesManagingTableForClass(mmd.getAbstractClassMetaData(), clr);
                        if (ownerParentCmds.length > 1) {
                            throw new NucleusUserException("Relation (" + mmd.getFullFieldName() + ") with multiple related tables (using subclass-table). Not supported");
                        }
                        relatedTbl = storeMgr.getDatastoreClass(ownerParentCmds[0].getFullClassName(), clr);
                    }
                    if ((relatedSqlTbl = stmt.getTable((DatastoreContainerObject)relatedTbl, null)) == null) {
                        relatedSqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(stmt, m, sqlTbl, relatedTbl.getIDMapping(), (DatastoreContainerObject)relatedTbl, null, null, tableGroupName);
                    }
                    StatementClassMapping subMappingDefinition = new StatementClassMapping(mmd.getClassName(), mmd.getName());
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(stmt, subMappingDefinition, fetchPlan, relatedSqlTbl, relatedCmd, maxFetchPlanLimit - 1);
                    if (mappingDefinition != null) {
                        mappingDefinition.addMappingDefinitionForMember(mmd.getAbsoluteFieldNumber(), subMappingDefinition);
                    }
                }
            } else if (relationType == 2 && mmd.getMappedBy() != null) {
                AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(clr);
                AbstractMemberMetaData relatedMmd = relatedMmds[0];
                String[] clsNames = null;
                if (mmd.getType().isInterface()) {
                    if (mmd.getFieldTypes() != null && mmd.getFieldTypes().length == 1) {
                        Class fldTypeCls = clr.classForName(mmd.getFieldTypes()[0]);
                        clsNames = fldTypeCls.isInterface() ? mmgr.getClassesImplementingInterface(mmd.getFieldTypes()[0], clr) : new String[]{mmd.getFieldTypes()[0]};
                    }
                    if (clsNames == null) {
                        clsNames = mmgr.getClassesImplementingInterface(mmd.getTypeName(), clr);
                    }
                } else {
                    clsNames = new String[]{mmd.getTypeName()};
                }
                DatastoreClass relatedTbl = storeMgr.getDatastoreClass(clsNames[0], clr);
                JavaTypeMapping relatedMapping = relatedTbl.getMemberMapping(relatedMmd);
                JavaTypeMapping relatedDiscrimMapping = relatedTbl.getDiscriminatorMapping(true);
                Object[] discrimValues = null;
                JavaTypeMapping relatedTypeMapping = null;
                AbstractClassMetaData relatedCmd = relatedMmd.getAbstractClassMetaData();
                if (!(relatedDiscrimMapping == null || relatedCmd.getSuperAbstractClassMetaData() == null && relatedCmd.getFullClassName().equals(mmd.getTypeName()))) {
                    List discValueList = null;
                    for (int i = 0; i < clsNames.length; ++i) {
                        List values = SQLStatementHelper.getDiscriminatorValuesForMember(clsNames[i], relatedDiscrimMapping, storeMgr, clr);
                        if (discValueList == null) {
                            discValueList = values;
                            continue;
                        }
                        discValueList.addAll(values);
                    }
                    discrimValues = discValueList.toArray(new Object[discValueList.size()]);
                } else if (relatedTbl != relatedMapping.getDatastoreContainer()) {
                    relatedTypeMapping = relatedTbl.getIDMapping();
                }
                SQLTable relatedSqlTbl = null;
                if (relatedTypeMapping == null) {
                    relatedSqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(stmt, sourceSqlTbl.getTable().getIDMapping(), sourceSqlTbl, relatedMapping, (DatastoreContainerObject)relatedTbl, null, discrimValues, tableGroupName);
                    int[] colNumbers = stmt.select(relatedSqlTbl, relatedTbl.getIDMapping(), null);
                    stmtMapping.setColumnPositions(colNumbers);
                } else {
                    DatastoreClass relationTbl = (DatastoreClass)relatedMapping.getDatastoreContainer();
                    if (relatedTbl != relatedMapping.getDatastoreContainer()) {
                        if (relatedMapping.isNullable()) {
                            relatedSqlTbl = stmt.leftOuterJoin(sourceSqlTbl, sourceSqlTbl.getTable().getIDMapping(), relatedMapping.getDatastoreContainer(), null, relatedMapping, null, tableGroupName);
                            relatedSqlTbl = stmt.innerJoin(relatedSqlTbl, relatedMapping.getDatastoreContainer().getIDMapping(), (DatastoreContainerObject)relatedTbl, null, relatedTbl.getIDMapping(), null, tableGroupName);
                        } else {
                            relatedSqlTbl = stmt.innerJoin(sourceSqlTbl, sourceSqlTbl.getTable().getIDMapping(), relatedMapping.getDatastoreContainer(), null, relatedMapping, null, tableGroupName);
                            relatedSqlTbl = stmt.innerJoin(relatedSqlTbl, relatedMapping.getDatastoreContainer().getIDMapping(), (DatastoreContainerObject)relatedTbl, null, relatedTbl.getIDMapping(), null, tableGroupName);
                        }
                    } else {
                        relatedSqlTbl = SQLStatementHelper.addJoinForOneToOneRelation(stmt, sourceSqlTbl.getTable().getIDMapping(), sourceSqlTbl, relatedMapping, (DatastoreContainerObject)relationTbl, null, null, tableGroupName);
                    }
                    relatedSqlTbl = SQLStatementHelper.getSQLTableForMappingOfTable(stmt, relatedSqlTbl, relatedTbl.getIDMapping());
                    int[] colNumbers = stmt.select(relatedSqlTbl, relatedTbl.getIDMapping(), null);
                    stmtMapping.setColumnPositions(colNumbers);
                }
                if (selectSubobjects && !mmd.isSerialized() && !mmd.isEmbedded()) {
                    StatementClassMapping subMappingDefinition = new StatementClassMapping(mmd.getName());
                    SQLStatementHelper.selectFetchPlanOfSourceClassInStatement(stmt, subMappingDefinition, fetchPlan, relatedSqlTbl, relatedMmd.getAbstractClassMetaData(), maxFetchPlanLimit - 1);
                    if (mappingDefinition != null) {
                        mappingDefinition.addMappingDefinitionForMember(mmd.getAbsoluteFieldNumber(), subMappingDefinition);
                    }
                }
            } else if (relationType == 6) {
                AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(clr);
                if (mmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                    DatastoreContainerObject joinTable = storeMgr.getDatastoreContainerObject(relatedMmds[0]);
                    DatastoreElementContainer collTable = (DatastoreElementContainer)joinTable;
                    JavaTypeMapping selectMapping = collTable.getOwnerMapping();
                    SQLTable joinSqlTbl = null;
                    if (stmt.getPrimaryTable().getTable() != joinTable) {
                        JavaTypeMapping referenceMapping = collTable.getElementMapping();
                        joinSqlTbl = stmt.leftOuterJoin(sourceSqlTbl, sourceSqlTbl.getTable().getIDMapping(), (DatastoreContainerObject)collTable, null, referenceMapping, null, tableGroupName);
                    } else {
                        joinSqlTbl = stmt.getPrimaryTable();
                    }
                    int[] colNumbers = stmt.select(joinSqlTbl, selectMapping, null);
                    stmtMapping.setColumnPositions(colNumbers);
                }
            }
            if (mappingDefinition != null) {
                mappingDefinition.addMappingForMember(mmd.getAbsoluteFieldNumber(), stmtMapping);
            }
        }
    }

    public static SQLTable addJoinForOneToOneRelation(SQLStatement stmt, JavaTypeMapping sourceMapping, SQLTable sourceSqlTbl, JavaTypeMapping targetMapping, DatastoreContainerObject targetTable, String targetAlias, Object[] discrimValues, String targetTablegroupName) {
        boolean nullable = true;
        if (sourceMapping != sourceSqlTbl.getTable().getIDMapping()) {
            nullable = sourceMapping.isNullable();
        }
        SQLTable targetSqlTbl = null;
        targetSqlTbl = nullable ? stmt.leftOuterJoin(sourceSqlTbl, sourceMapping, targetTable, targetAlias, targetMapping, discrimValues, targetTablegroupName) : stmt.innerJoin(sourceSqlTbl, sourceMapping, targetTable, targetAlias, targetMapping, discrimValues, targetTablegroupName);
        return targetSqlTbl;
    }

    public static BooleanExpression getExpressionForDiscriminatorForClass(SQLStatement stmt, String className, DiscriminatorMetaData dismd, JavaTypeMapping discriminatorMapping, SQLTable discrimSqlTbl) {
        Object discriminatorValue = className;
        if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
            OMFContext omfCtx = stmt.getRDBMSManager().getOMFContext();
            AbstractClassMetaData targetCmd = omfCtx.getMetaDataManager().getMetaDataForClass(className, omfCtx.getClassLoaderResolver(null));
            if (discriminatorMapping instanceof DiscriminatorLongMapping) {
                String strValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
                try {
                    discriminatorValue = Integer.valueOf(strValue);
                }
                catch (NumberFormatException nfe) {
                    throw new NucleusUserException("Discriminator for " + className + " is not integer-based but needs to be!");
                }
            } else {
                discriminatorValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
            }
        }
        SQLExpression discrExpr = stmt.getSQLExpressionFactory().newExpression(stmt, discrimSqlTbl, discriminatorMapping);
        SQLExpression discrVal = stmt.getSQLExpressionFactory().newLiteral(stmt, discriminatorMapping, discriminatorValue);
        return discrExpr.eq(discrVal);
    }

    public static List getDiscriminatorValuesForMember(String className, JavaTypeMapping discMapping, RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        ArrayList<String> discrimValues = new ArrayList<String>();
        DiscriminatorStrategy strategy = discMapping.getDatastoreContainer().getDiscriminatorMetaData().getStrategy();
        if (strategy == DiscriminatorStrategy.CLASS_NAME) {
            discrimValues.add(className);
            HashSet subclasses = storeMgr.getSubClassesForClass(className, true, clr);
            if (subclasses != null && subclasses.size() > 0) {
                discrimValues.addAll(subclasses);
            }
        } else if (strategy == DiscriminatorStrategy.VALUE_MAP) {
            MetaDataManager mmgr = storeMgr.getMetaDataManager();
            AbstractClassMetaData cmd = mmgr.getMetaDataForClass(className, clr);
            HashSet subclasses = storeMgr.getSubClassesForClass(className, true, clr);
            if (subclasses != null && subclasses.size() > 0) {
                discrimValues.add(cmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue());
                for (String subclassName : subclasses) {
                    AbstractClassMetaData subclassCmd = mmgr.getMetaDataForClass(subclassName, clr);
                    discrimValues.add(subclassCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue());
                }
            } else {
                discrimValues.add(cmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue());
            }
        }
        return discrimValues;
    }
}

