/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jdo.JDODataStoreException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.AbstractQueryResultIterator;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;
import org.datanucleus.util.StringUtils;
import org.datanucleus.util.WeakValueMap;

public final class ScrollableQueryResult
extends AbstractRDBMSQueryResult {
    private Map<Integer, Object> resultsObjsByIndex;

    public ScrollableQueryResult(Query query, ResultObjectFactory rof, ResultSet rs, Collection candidates) {
        block6: {
            int fetchSize;
            block7: {
                super(query, rof, rs);
                this.resultsObjsByIndex = null;
                if (candidates != null) {
                    throw new NucleusException("Unsupported Feature: Candidate Collection is only allowed using ForwardQueryResults").setFatal();
                }
                String ext = (String)query.getExtension("datanucleus.query.resultCacheType");
                this.resultsObjsByIndex = ext != null ? (ext.equalsIgnoreCase("soft") ? new SoftValueMap() : (ext.equalsIgnoreCase("weak") ? new WeakValueMap() : (ext.equalsIgnoreCase("hard") ? new HashMap<Integer, Object>() : (ext.equalsIgnoreCase("none") ? null : new WeakValueMap())))) : new WeakValueMap();
                if (this.resultsObjsByIndex == null) break block6;
                fetchSize = query.getFetchPlan().getFetchSize();
                if (query.getObjectManager().getTransaction().isActive() && fetchSize != -1) break block7;
                boolean hasMoreResults = true;
                int index = 0;
                while (hasMoreResults) {
                    try {
                        boolean rowExists = rs.absolute(index + 1);
                        if (!rowExists) {
                            hasMoreResults = false;
                            this.size = index;
                            continue;
                        }
                        this.getObjectForIndex(index);
                        ++index;
                    }
                    catch (SQLException sqle) {}
                }
                break block6;
            }
            if (fetchSize <= 0) break block6;
            for (int i = 0; i < fetchSize; ++i) {
                this.getObjectForIndex(i);
            }
        }
    }

    protected Object getObjectForIndex(int index) {
        Object obj;
        if (this.resultsObjsByIndex != null && (obj = this.resultsObjsByIndex.get(index)) != null) {
            return obj;
        }
        try {
            this.rs.absolute(index + 1);
            obj = this.rof.getObject(this.query.getObjectManager(), (Object)this.rs);
            JDBCUtils.logWarnings(this.rs);
            if (this.resultsObjsByIndex != null) {
                this.resultsObjsByIndex.put(index, obj);
            }
            return obj;
        }
        catch (SQLException sqe) {
            if (this.query.getObjectManager().getOMFContext().getApi().equalsIgnoreCase("JDO")) {
                throw new JDODataStoreException(LOCALISER.msg("052601", (Object)sqe));
            }
            throw new NucleusDataStoreException(LOCALISER.msg("052601", (Object)sqe));
        }
    }

    public synchronized void close() {
        if (this.resultsObjsByIndex != null) {
            this.resultsObjsByIndex.clear();
        }
        super.close();
    }

    protected void closingConnection() {
        if (this.loadResultsAtCommit && this.isOpen()) {
            NucleusLogger.QUERY.info((Object)LOCALISER.msg("052606", (Object)this.query.toString()));
            for (int i = 0; i < this.size(); ++i) {
                this.getObjectForIndex(i);
            }
        }
    }

    public Iterator iterator() {
        return new QueryResultIterator();
    }

    public ListIterator listIterator() {
        return new QueryResultIterator();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ScrollableQueryResult)) {
            return false;
        }
        ScrollableQueryResult other = (ScrollableQueryResult)((Object)o);
        if (this.rs != null) {
            return other.rs == this.rs;
        }
        if (this.query != null) {
            return other.query == this.query;
        }
        return StringUtils.toJVMIDString((Object)((Object)other)).equals(StringUtils.toJVMIDString((Object)((Object)this)));
    }

    public synchronized Object get(int index) {
        this.assertIsOpen();
        return this.getObjectForIndex(index);
    }

    protected int getSizeUsingMethod() {
        if (this.resultSizeMethod.equalsIgnoreCase("LAST")) {
            try {
                boolean hasLast = this.rs.last();
                if (!hasLast) {
                    return 0;
                }
                return this.rs.getRow();
            }
            catch (SQLException sqle) {
                throw new JDODataStoreException(LOCALISER.msg("052601", (Object)sqle));
            }
        }
        if (this.resultSizeMethod.equalsIgnoreCase("COUNT") && this.query.getCompilation() == null) {
            return this.getSizeUsingCount();
        }
        return super.getSizeUsingMethod();
    }

    public Object[] toArray() {
        return this.toArrayInternal(null);
    }

    public Object[] toArray(Object[] a) {
        if (a == null) {
            throw new NullPointerException("null argument is illegal!");
        }
        return this.toArrayInternal(a);
    }

    private Object[] toArrayInternal(Object[] a) {
        int size;
        ArrayList<Object> resultList;
        Object[] result;
        block13: {
            result = a;
            resultList = null;
            size = -1;
            try {
                size = this.size();
            }
            catch (Exception x) {
                size = -1;
                if (!NucleusLogger.QUERY.isDebugEnabled()) break block13;
                NucleusLogger.QUERY.debug((Object)"toArray: Could not determine size.", (Throwable)x);
            }
        }
        if (size >= 0 && (result == null || result.length < size)) {
            result = null;
            resultList = new ArrayList<Object>(size);
        }
        Iterator iterator = null;
        if (result != null) {
            iterator = this.iterator();
            int idx = -1;
            while (iterator.hasNext()) {
                if (++idx < result.length) {
                    result[idx] = iterator.next();
                    continue;
                }
                int capacity = result.length * 3 / 2 + 1;
                if (capacity < result.length) {
                    capacity = result.length;
                }
                resultList = new ArrayList(capacity);
                for (int i = 0; i < result.length; ++i) {
                    resultList.add(result[i]);
                }
                result = null;
                break;
            }
            if (result != null && ++idx < result.length) {
                result[idx] = null;
            }
        }
        if (result == null) {
            if (resultList == null) {
                resultList = new ArrayList();
            }
            if (iterator == null) {
                iterator = this.iterator();
            }
            while (iterator.hasNext()) {
                resultList.add(iterator.next());
            }
            result = a == null ? resultList.toArray() : resultList.toArray(a);
        }
        return result;
    }

    private class QueryResultIterator
    extends AbstractQueryResultIterator {
        private int iterRowNum = 0;

        private QueryResultIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            ScrollableQueryResult scrollableQueryResult = ScrollableQueryResult.this;
            synchronized (scrollableQueryResult) {
                if (!ScrollableQueryResult.this.isOpen()) {
                    return false;
                }
                return this.iterRowNum <= ScrollableQueryResult.this.size() - 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPrevious() {
            ScrollableQueryResult scrollableQueryResult = ScrollableQueryResult.this;
            synchronized (scrollableQueryResult) {
                if (!ScrollableQueryResult.this.isOpen()) {
                    return false;
                }
                return this.iterRowNum > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            ScrollableQueryResult scrollableQueryResult = ScrollableQueryResult.this;
            synchronized (scrollableQueryResult) {
                if (!ScrollableQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(LOCALISER.msg("052600"));
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No next element");
                }
                Object obj = ScrollableQueryResult.this.getObjectForIndex(this.iterRowNum);
                ++this.iterRowNum;
                return obj;
            }
        }

        public int nextIndex() {
            if (this.hasNext()) {
                return this.iterRowNum;
            }
            return ScrollableQueryResult.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object previous() {
            ScrollableQueryResult scrollableQueryResult = ScrollableQueryResult.this;
            synchronized (scrollableQueryResult) {
                if (!ScrollableQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(LOCALISER.msg("052600"));
                }
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No previous element");
                }
                --this.iterRowNum;
                return ScrollableQueryResult.this.getObjectForIndex(this.iterRowNum);
            }
        }

        public int previousIndex() {
            if (this.iterRowNum == 0) {
                return -1;
            }
            return this.iterRowNum - 1;
        }
    }
}

