/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.EnumExpression;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;

public class EnumLiteral
extends EnumExpression
implements SQLLiteral {
    private final Enum value;

    public EnumLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, boolean parameter) {
        super(stmt, null, mapping);
        this.isParameter = parameter;
        if (value == null) {
            this.value = null;
        } else if (value instanceof Enum) {
            this.value = (Enum)value;
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        this.delegate = this.isParameter ? (mapping.getJavaTypeForDatastoreMapping(0).equals(ClassNameConstants.JAVA_LANG_STRING) ? new StringLiteral(stmt, mapping, this.value.name(), false) : new IntegerLiteral(stmt, mapping, this.value.ordinal(), false)) : (mapping.getJavaTypeForDatastoreMapping(0).equals(ClassNameConstants.JAVA_LANG_STRING) ? new StringLiteral(stmt, mapping, this.value.name(), false) : new IntegerLiteral(stmt, mapping, this.value.ordinal(), false));
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isParameter() {
        return this.delegate.isParameter();
    }

    public void setNotParameter() {
        ((SQLLiteral)((Object)this.delegate)).setNotParameter();
    }
}

