/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.expression.AggregateExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public abstract class SimpleAggregateMethod
extends AbstractSQLMethod {
    protected abstract String getFunctionName();

    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (expr != null) {
            throw new NucleusException(LOCALISER.msg("060002", (Object)this.getFunctionName(), (Object)expr));
        }
        if (args == null || args.size() != 1) {
            throw new NucleusException(this.getFunctionName() + " is only supported with a single argument");
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.RESULT) {
            JavaTypeMapping m = null;
            if (args.get(0) instanceof SQLExpression) {
                SQLExpression argExpr = (SQLExpression)args.get(0);
                m = this.getMappingForClass(argExpr.getJavaTypeMapping().getJavaType());
            } else {
                m = this.getMappingForClass(this.getClassForMapping());
            }
            return new AggregateExpression(m, this.getFunctionName(), args);
        }
        throw new NucleusException(this.getFunctionName() + " is not supported on " + this.stmt.getQueryGenerator().getCompilationComponent());
    }

    protected abstract Class getClassForMapping();
}

