/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.util.StringUtils;

public class StringLiteral
extends StringExpression
implements SQLLiteral {
    private final String value;

    public StringLiteral(SQLStatement stmt, JavaTypeMapping mapping, Object value, boolean parameter) {
        super(stmt, null, mapping);
        this.isParameter = parameter;
        if (value == null) {
            this.value = null;
        } else if (value instanceof String) {
            this.value = (String)value;
        } else if (value instanceof Character) {
            this.value = ((Character)value).toString();
        } else {
            throw new NucleusException("Cannot create " + this.getClass().getName() + " for value of type " + (value != null ? value.getClass().getName() : null));
        }
        if (this.isParameter) {
            this.st.appendParameter(mapping, this.value);
        } else {
            this.setStatement();
        }
    }

    public void generateStatementWithoutQuotes() {
        this.st.clearStatement();
        this.st.append(StringUtils.replaceAll((String)this.value, (String)"'", (String)"''"));
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_EQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.equals(((StringLiteral)expr).value), false);
        }
        return super.eq(expr);
    }

    public BooleanExpression ne(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_NOTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), !this.value.equals(((StringLiteral)expr).value), false);
        }
        return super.ne(expr);
    }

    public BooleanExpression lt(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_LT, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) < 0, false);
        }
        return super.lt(expr);
    }

    public BooleanExpression le(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_LTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) <= 0, false);
        }
        return super.le(expr);
    }

    public BooleanExpression gt(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_GT, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) > 0, false);
        }
        return super.gt(expr);
    }

    public BooleanExpression ge(SQLExpression expr) {
        if (this.isParameter || expr.isParameter) {
            return new BooleanExpression(this, Expression.OP_GTEQ, expr);
        }
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.stmt, this.stmt.getSQLExpressionFactory().getMappingForType(Boolean.TYPE, false), this.value.compareTo(((StringLiteral)expr).value) >= 0, false);
        }
        return super.ge(expr);
    }

    public SQLExpression add(SQLExpression expr) {
        if (expr.isParameter || this.isParameter) {
            return super.add(expr);
        }
        if (expr instanceof StringLiteral) {
            return new StringLiteral(this.stmt, this.mapping, this.value.concat(((StringLiteral)expr).value), false);
        }
        if (expr instanceof CharacterLiteral) {
            return new StringLiteral(this.stmt, this.mapping, this.value.concat(((SQLLiteral)((Object)expr)).getValue().toString()), false);
        }
        if (expr instanceof IntegerLiteral || expr instanceof FloatingPointLiteral || expr instanceof BooleanLiteral) {
            return new StringLiteral(this.stmt, this.mapping, this.value.concat(((SQLLiteral)((Object)expr)).getValue().toString()), false);
        }
        return super.add(expr);
    }

    public void setNotParameter() {
        if (!this.isParameter) {
            return;
        }
        this.isParameter = false;
        this.st.clearStatement();
        this.setStatement();
    }

    protected void setStatement() {
        this.st.append('\'').append(StringUtils.replaceAll((String)this.value, (String)"'", (String)"''")).append('\'');
    }
}

