/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query2;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.StatementClassMapping;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.StatementNewObjectMapping;
import org.datanucleus.store.mapped.StatementResultMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryCompilerSyntaxException;
import org.datanucleus.store.query.QueryInterruptedException;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ResultClassROF;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.store.rdbms.query2.QueryToSQLMapper;
import org.datanucleus.store.rdbms.query2.RDBMSQueryCompilation;
import org.datanucleus.store.rdbms.sql.AbstractStatementGenerator;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLStatementHelper;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPQLQuery2
extends AbstractJPQLQuery {
    RDBMSQueryCompilation datastoreCompilation;

    public JPQLQuery2(ObjectManager om) {
        this(om, (JPQLQuery2)null);
    }

    public JPQLQuery2(ObjectManager om, JPQLQuery2 q) {
        super(om, (AbstractJPQLQuery)q);
    }

    public JPQLQuery2(ObjectManager om, String query) {
        super(om, query);
    }

    public void setImplicitParameter(int position, Object value) {
        if (this.datastoreCompilation != null && !this.datastoreCompilation.isPrecompilable()) {
            this.datastoreCompilation = null;
        }
        super.setImplicitParameter(position, value);
    }

    public void setImplicitParameter(String name, Object value) {
        if (this.datastoreCompilation != null && !this.datastoreCompilation.isPrecompilable()) {
            this.datastoreCompilation = null;
        }
        super.setImplicitParameter(name, value);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.candidateCollection != null) {
            return this.compilation != null;
        }
        return this.compilation != null && this.datastoreCompilation != null;
    }

    protected synchronized void compileInternal(boolean forExecute, Map parameterValues) {
        if (this.datastoreCompilation != null) {
            return;
        }
        if (this.type == 1) {
            throw new QueryCompilerSyntaxException("This implementation of JPQL doesn't yet support bulk updates");
        }
        if (this.type == 2) {
            throw new QueryCompilerSyntaxException("This implementation of JPQL doesn't yet support bulk deletes");
        }
        super.compileInternal(forExecute, parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null) {
            return;
        }
        if (this.candidateClass == null || this.candidateClassName == null) {
            this.candidateClass = this.compilation.getCandidateClass();
            this.candidateClassName = this.candidateClass.getName();
        }
        RDBMSManager storeMgr = (RDBMSManager)this.getStoreManager();
        ClassLoaderResolver clr = this.om.getClassLoaderResolver();
        DatastoreClass candidateTable = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
        AbstractClassMetaData acmd = this.getObjectManager().getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
        QueryManager qm = this.om.getOMFContext().getQueryManager();
        String datastoreId = "rdbms-" + storeMgr.getDatastoreAdapter().getVendorID();
        boolean caching = this.getBooleanExtensionProperty("datanucleus.query.cached", true);
        if (caching) {
            this.datastoreCompilation = (RDBMSQueryCompilation)qm.getDatastoreQueryCompilation(datastoreId, "JPQL", this.toString());
            if (this.datastoreCompilation != null) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021080", (Object)this.toString(), (Object)"JPQL", (Object)datastoreId));
                }
                return;
            }
        }
        this.datastoreCompilation = new RDBMSQueryCompilation();
        if (inMemory) {
            this.compileQueryToRetrieveCandidates(parameterValues, candidateTable, acmd);
        } else {
            this.compileQueryFull(parameterValues, candidateTable, acmd);
            if (this.result != null) {
                StatementResultMapping resultMapping = this.datastoreCompilation.getResultDefinition();
                for (int i = 0; i < resultMapping.getNumberOfResultExpressions(); ++i) {
                    StatementMappingIndex idx;
                    AbstractMemberMetaData mmd;
                    Object stmtMap = resultMapping.getMappingForResultExpression(i);
                    if (!(stmtMap instanceof StatementMappingIndex) || (mmd = (idx = (StatementMappingIndex)stmtMap).getMapping().getMemberMetaData()) == null || !mmd.hasCollection() && !mmd.hasMap()) continue;
                    throw new NucleusUserException("Result has member " + mmd.getFullFieldName() + " which is a container field and cannot be in the results");
                }
            }
        }
        if (this.resultClass != null && this.result != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    StatementResultMapping resultMapping = JPQLQuery2.this.datastoreCompilation.getResultDefinition();
                    if (QueryUtils.resultClassIsSimple((String)JPQLQuery2.this.resultClass.getName())) {
                        Class resultClassPrimitive;
                        if (resultMapping.getNumberOfResultExpressions() > 1) {
                            throw new NucleusUserException(LOCALISER.msg("021201", (Object)JPQLQuery2.this.resultClass.getName()));
                        }
                        Object stmtMap = resultMapping.getMappingForResultExpression(0);
                        StatementMappingIndex idx = (StatementMappingIndex)stmtMap;
                        Class exprType = idx.getMapping().getJavaType();
                        boolean typeConsistent = false;
                        if (exprType == JPQLQuery2.this.resultClass) {
                            typeConsistent = true;
                        } else if (exprType.isPrimitive() && (resultClassPrimitive = ClassUtils.getPrimitiveTypeForType((Class)JPQLQuery2.this.resultClass)) == exprType) {
                            typeConsistent = true;
                        }
                        if (!typeConsistent) {
                            throw new NucleusUserException(LOCALISER.msg("021202", (Object)JPQLQuery2.this.resultClass.getName(), (Object)exprType));
                        }
                    } else if (QueryUtils.resultClassIsUserType((String)JPQLQuery2.this.resultClass.getName())) {
                        Class[] ctrTypes = new Class[resultMapping.getNumberOfResultExpressions()];
                        for (int i = 0; i < ctrTypes.length; ++i) {
                            Object stmtMap = resultMapping.getMappingForResultExpression(i);
                            if (stmtMap instanceof StatementMappingIndex) {
                                ctrTypes[i] = ((StatementMappingIndex)stmtMap).getMapping().getJavaType();
                                continue;
                            }
                            if (!(stmtMap instanceof StatementNewObjectMapping)) continue;
                        }
                        Constructor ctr = ClassUtils.getConstructorWithArguments((Class)JPQLQuery2.this.resultClass, (Class[])ctrTypes);
                        if (ctr == null && !ClassUtils.hasDefaultConstructor((Class)JPQLQuery2.this.resultClass)) {
                            throw new NucleusUserException(LOCALISER.msg("021205", (Object)JPQLQuery2.this.resultClass.getName()));
                        }
                        if (ctr == null) {
                            for (int i = 0; i < resultMapping.getNumberOfResultExpressions(); ++i) {
                                Object stmtMap = resultMapping.getMappingForResultExpression(i);
                                if (stmtMap instanceof StatementMappingIndex) {
                                    Method putMethod;
                                    Method setMethod;
                                    StatementMappingIndex mapIdx = (StatementMappingIndex)stmtMap;
                                    AbstractMemberMetaData mmd = mapIdx.getMapping().getMemberMetaData();
                                    String fieldName = mapIdx.getColumnAlias();
                                    Class fieldType = mapIdx.getMapping().getJavaType();
                                    if (fieldName == null && mmd != null) {
                                        fieldName = mmd.getName();
                                    }
                                    if (fieldName == null) continue;
                                    Class<?> resultFieldType = null;
                                    boolean publicField = true;
                                    try {
                                        Field fld = JPQLQuery2.this.resultClass.getDeclaredField(fieldName);
                                        resultFieldType = fld.getType();
                                        if (!ClassUtils.typesAreCompatible((Class)fieldType, resultFieldType) && !ClassUtils.typesAreCompatible(resultFieldType, (Class)fieldType)) {
                                            throw new NucleusUserException(LOCALISER.msg("021211", (Object)fieldName, (Object)fieldType.getName(), (Object)resultFieldType.getName()));
                                        }
                                        if (!Modifier.isPublic(fld.getModifiers())) {
                                            publicField = false;
                                        }
                                    }
                                    catch (NoSuchFieldException nsfe) {
                                        publicField = false;
                                    }
                                    if (publicField || (setMethod = QueryUtils.getPublicSetMethodForFieldOfResultClass((Class)JPQLQuery2.this.resultClass, (String)fieldName, resultFieldType)) != null || (putMethod = QueryUtils.getPublicPutMethodForResultClass((Class)JPQLQuery2.this.resultClass)) != null) continue;
                                    throw new NucleusUserException(LOCALISER.msg("021212", (Object)JPQLQuery2.this.resultClass.getName(), (Object)fieldName));
                                }
                                if (!(stmtMap instanceof StatementNewObjectMapping)) continue;
                            }
                        }
                    }
                    return null;
                }
            });
        }
        boolean hasParams = false;
        if (this.explicitParameters != null) {
            hasParams = true;
        } else if (parameterValues != null && parameterValues.size() > 0) {
            hasParams = true;
        }
        if (!this.datastoreCompilation.isPrecompilable() || this.datastoreCompilation.getSQL().indexOf(63) < 0 && hasParams) {
            NucleusLogger.QUERY.debug((Object)"Not caching the datastore compilation since some parameters are evaluated during the compilation and aren't present in the final SQL");
        } else {
            this.om.getOMFContext().getQueryManager().addDatastoreQueryCompilation(datastoreId, "JPQL", this.toString(), (Object)this.datastoreCompilation);
        }
    }

    public String getSQL() {
        if (this.datastoreCompilation != null) {
            return this.datastoreCompilation.getSQL();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        if (this.candidateCollection != null && this.candidateCollection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Object results = null;
        boolean inMemory = this.evaluateInMemory();
        ManagedConnection mconn = this.om.getStoreManager().getConnection(this.om);
        try {
            long startTime;
            block20: {
                startTime = System.currentTimeMillis();
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JPQL", (Object)this.getSingleStringQuery(), null));
                }
                RDBMSManager storeMgr = (RDBMSManager)this.getStoreManager();
                ClassLoaderResolver clr = this.om.getClassLoaderResolver();
                DatastoreClass candidateTable = storeMgr.getDatastoreClass(this.candidateClass.getName(), clr);
                AbstractClassMetaData acmd = this.getObjectManager().getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
                if (this.candidateCollection != null) {
                    inMemory = true;
                    ArrayList candidates = new ArrayList(this.candidateCollection);
                    JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, clr);
                    results = resultMapper.execute(inMemory, inMemory, inMemory, inMemory, inMemory);
                } else {
                    try {
                        SQLController sqlControl = storeMgr.getSQLController();
                        PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, this.datastoreCompilation.getSQL(), (Query)this);
                        try {
                            RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this, false);
                            this.applyParametersToStatement(parameters, ps);
                            if (this.type != 0) break block20;
                            ResultSet rs = (ResultSet)this.performExecuteTask(new Object[]{sqlControl, mconn, ps});
                            AbstractRDBMSQueryResult qr = null;
                            try {
                                if (inMemory) {
                                    ResultObjectFactory rof = storeMgr.newResultObjectFactory(candidateTable, acmd, this.datastoreCompilation.getResultDefinitionForClass(), RDBMSQueryUtils.useUpdateLockForQuery((Query)this), false, this.getFetchPlan(), this.candidateClass);
                                    ArrayList<Object> candidates = new ArrayList<Object>();
                                    while (rs.next()) {
                                        candidates.add(rof.getObject(this.om, (Object)rs));
                                    }
                                    JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, clr);
                                    results = resultMapper.execute(true, true, true, true, true);
                                } else {
                                    ResultClassROF rof = null;
                                    rof = this.result != null ? new ResultClassROF(this.resultClass, this.datastoreCompilation.getResultDefinition()) : (this.resultClass != null ? new ResultClassROF(this.resultClass, this.datastoreCompilation.getResultDefinitionForClass()) : storeMgr.newResultObjectFactory(candidateTable, acmd, this.datastoreCompilation.getResultDefinitionForClass(), RDBMSQueryUtils.useUpdateLockForQuery((Query)this), false, this.getFetchPlan(), this.candidateClass));
                                    String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery((Query)this);
                                    qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult((Query)this, rof, rs, this.getResultDistinct() ? null : this.candidateCollection) : new ForwardQueryResult((Query)this, rof, rs, this.getResultDistinct() ? null : this.candidateCollection);
                                    final ScrollableQueryResult qr1 = qr;
                                    final ManagedConnection mconn1 = mconn;
                                    ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

                                        public void managedConnectionPreClose() {
                                        }

                                        public void managedConnectionPostClose() {
                                        }

                                        public void managedConnectionFlushed() {
                                            qr1.disconnect();
                                        }

                                        public void resourcePostClose() {
                                            mconn1.removeListener((ManagedConnectionResourceListener)this);
                                        }
                                    };
                                    mconn.addListener(listener);
                                    ((AbstractRDBMSQueryResult)qr).addConnectionListener(listener);
                                    results = qr;
                                }
                            }
                            finally {
                                if (qr == null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (QueryInterruptedException qie) {
                            ps.cancel();
                            throw qie;
                        }
                        catch (SQLException sqle) {
                            throw new NucleusException("Exception thrown in query", (Throwable)sqle);
                        }
                    }
                    catch (SQLException sqle) {
                        throw new NucleusException("Exception thrown in query", (Throwable)sqle);
                    }
                }
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }

    protected void assertSupportsCancel() {
    }

    protected Object performExecuteInternal(Object ... args) {
        SQLController sqlControl = (SQLController)args[0];
        ManagedConnection mconn = (ManagedConnection)args[1];
        PreparedStatement ps = (PreparedStatement)args[2];
        try {
            return sqlControl.executeStatementQuery(mconn, this.toString(), ps);
        }
        catch (SQLException sqle) {
            throw new NucleusDataStoreException("Exception thrown in query", (Throwable)sqle);
        }
    }

    private void compileQueryFull(Map parameters, DatastoreClass candidateTable, AbstractClassMetaData candidateCmd) {
        if (this.result != null) {
            this.datastoreCompilation.setResultDefinition(new StatementResultMapping());
        } else {
            this.datastoreCompilation.setResultDefinitionForClass(new StatementClassMapping(null));
        }
        RDBMSManager storeMgr = (RDBMSManager)this.getStoreManager();
        if (this.candidateCollection == null) {
            AbstractStatementGenerator stmtGen = null;
            if (candidateTable.getDiscriminatorMapping(true) != null || QueryUtils.resultHasOnlyAggregates((String)this.result)) {
                stmtGen = new DiscriminatorStatementGenerator(storeMgr, this.candidateClass, this.subclasses, null, "this");
            } else {
                stmtGen = new UnionStatementGenerator(storeMgr, this.candidateClass, this.subclasses, null, "this");
                if (this.result == null) {
                    stmtGen.setOption("selectNucleusType");
                    this.datastoreCompilation.getResultDefinitionForClass().setNucleusTypeColumnName("NUCLEUS_TYPE");
                }
            }
            SQLStatement stmt = stmtGen.getStatement();
            QueryToSQLMapper sqlMapper = new QueryToSQLMapper(stmt, this.compilation, parameters, this.datastoreCompilation.getResultDefinitionForClass(), this.datastoreCompilation.getResultDefinition(), candidateCmd, this.getFetchPlan(), this.datastoreCompilation.getParameterDefinition(), this.om);
            sqlMapper.compile();
            this.datastoreCompilation.setPrecompilable(sqlMapper.isPrecompilable());
            if (this.fromInclNo != 0L || this.toExclNo != Long.MAX_VALUE) {
                stmt.setRange(this.fromInclNo, this.toExclNo - this.fromInclNo);
            } else if (this.range != null) {
                // empty if block
            }
            boolean useUpdateLock = RDBMSQueryUtils.useUpdateLockForQuery((Query)this);
            stmt.addExtension("lock-for-update", new Boolean(useUpdateLock));
            if (this.type == 0) {
                this.datastoreCompilation.setSQL(stmt.getSelectStatement().toString());
            } else {
                if (this.type == 1) {
                    throw new NucleusException("DataNucleus doesnt currently support bulk update statements");
                }
                if (this.type == 2) {
                    throw new NucleusException("DataNucleus doesnt currently support bulk delete statements");
                }
            }
        }
    }

    private void compileQueryToRetrieveCandidates(Map parameters, DatastoreClass candidateTable, AbstractClassMetaData candidateCmd) {
        StatementClassMapping resultsDef = new StatementClassMapping(null);
        this.datastoreCompilation.setResultDefinitionForClass(resultsDef);
        RDBMSManager storeMgr = (RDBMSManager)this.getStoreManager();
        if (this.candidateCollection == null) {
            AbstractStatementGenerator stmtGen = null;
            if (candidateTable.getDiscriminatorMapping(false) != null) {
                stmtGen = new DiscriminatorStatementGenerator(storeMgr, this.candidateClass, this.subclasses, null, "this");
            } else {
                stmtGen = new UnionStatementGenerator(storeMgr, this.candidateClass, this.subclasses, null, "this");
                stmtGen.setOption("selectNucleusType");
                resultsDef.setNucleusTypeColumnName("NUCLEUS_TYPE");
            }
            SQLStatement stmt = stmtGen.getStatement();
            SQLStatementHelper.selectFetchPlanOfCandidateInStatement(stmt, this.datastoreCompilation.getResultDefinitionForClass(), this.getFetchPlan(), candidateCmd, 1);
            if (this.type == 0) {
                this.datastoreCompilation.setSQL(stmt.getSelectStatement().toString());
            } else {
                if (this.type == 1) {
                    throw new NucleusException("DataNucleus doesnt currently support bulk update statements");
                }
                if (this.type == 2) {
                    throw new NucleusException("DataNucleus doesnt currently support bulk delete statements");
                }
            }
        }
    }

    public void applyParametersToStatement(Map parameterValuesByName, PreparedStatement ps) throws SQLException {
        if (this.datastoreCompilation.getParameterDefinition() == null || this.datastoreCompilation.getParameterDefinition().isEmpty()) {
            return;
        }
        for (Map.Entry entry : parameterValuesByName.entrySet()) {
            Object paramValue = entry.getValue();
            StatementMappingIndex paramIdx = this.datastoreCompilation.getParameterDefinition().getMappingForParameter("" + entry.getKey());
            if (paramIdx == null) continue;
            for (int i = 0; i < paramIdx.getNumberOfParameterOccurrences(); ++i) {
                int[] positions = paramIdx.getParameterPositionsForOccurrence(i);
                JavaTypeMapping mapping = paramIdx.getMapping();
                if (paramValue == null) {
                    mapping.setObject(this.om, (Object)ps, positions, null);
                    continue;
                }
                if (mapping.getJavaType() == Boolean.class) {
                    mapping.setBoolean(this.om, (Object)ps, positions, ((Boolean)paramValue).booleanValue());
                    continue;
                }
                if (mapping.getJavaType() == Byte.class) {
                    mapping.setByte(this.om, (Object)ps, positions, ((Byte)paramValue).byteValue());
                    continue;
                }
                if (mapping.getJavaType() == Character.class) {
                    mapping.setChar(this.om, (Object)ps, positions, ((Character)paramValue).charValue());
                    continue;
                }
                if (mapping.getJavaType() == Double.class) {
                    mapping.setDouble(this.om, (Object)ps, positions, ((Double)paramValue).doubleValue());
                    continue;
                }
                if (mapping.getJavaType() == Float.class) {
                    mapping.setFloat(this.om, (Object)ps, positions, ((Float)paramValue).floatValue());
                    continue;
                }
                if (mapping.getJavaType() == Integer.class) {
                    mapping.setInt(this.om, (Object)ps, positions, ((Integer)paramValue).intValue());
                    continue;
                }
                if (mapping.getJavaType() == Long.class) {
                    mapping.setLong(this.om, (Object)ps, positions, ((Long)paramValue).longValue());
                    continue;
                }
                if (mapping.getJavaType() == Short.class) {
                    mapping.setShort(this.om, (Object)ps, positions, ((Short)paramValue).shortValue());
                    continue;
                }
                if (mapping.getJavaType() == String.class) {
                    mapping.setString(this.om, (Object)ps, positions, (String)paramValue);
                    continue;
                }
                mapping.setObject(this.om, (Object)ps, positions, paramValue);
            }
        }
    }

    public Set<String> getSupportedExtensions() {
        Set supported = super.getSupportedExtensions();
        supported.add("datanucleus.rdbms.query.resultSetType");
        supported.add("datanucleus.rdbms.query.resultSetConcurrency");
        supported.add("datanucleus.rdbms.query.useUpdateLock");
        return supported;
    }

    protected boolean applyRangeChecks() {
        boolean range_specified;
        boolean bl = range_specified = this.range != null || this.fromInclNo >= 0L && this.toExclNo >= 0L && (this.fromInclNo != 0L || this.toExclNo != Long.MAX_VALUE);
        if (!range_specified) {
            return false;
        }
        RDBMSManager storeMgr = (RDBMSManager)this.om.getStoreManager();
        RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        boolean using_limit_select_clause = dba.getRangeByLimitSelectClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_limit_where_clause = dba.getRangeByLimitWhereClause(this.fromInclNo, this.toExclNo).length() > 0;
        boolean using_rownum = dba.getRangeByRowNumberColumn().length() > 0;
        return range_specified && !using_limit_select_clause && !using_limit_where_clause && !using_rownum;
    }
}

