/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.query.AbstractRDBMSQueryResult;
import org.datanucleus.store.rdbms.query.ForwardQueryResult;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.query.ScrollableQueryResult;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class SQLEvaluator {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    Query query;
    ObjectManager om;
    ResultObjectFactory rof;
    Collection candidateCollection;

    public SQLEvaluator(Query query, ResultObjectFactory rof, Collection candidateCollection) {
        this.om = query.getObjectManager();
        this.query = query;
        this.rof = rof;
        this.candidateCollection = candidateCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(QueryExpression queryStmt) {
        AbstractRDBMSQueryResult qr;
        block18: {
            qr = null;
            boolean useUpdateLock = RDBMSQueryUtils.useUpdateLockForQuery(this.query);
            try {
                RDBMSManager storeMgr = (RDBMSManager)this.om.getStoreManager();
                ManagedConnection mconn = storeMgr.getConnection(this.om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    StatementText stmtText = null;
                    if (this.query.getType() == 0) {
                        stmtText = queryStmt.toStatementText(useUpdateLock);
                    } else {
                        if (this.query.getType() == 1) {
                            stmtText = queryStmt.toUpdateStatementText();
                            throw new NucleusException("DataNucleus doesnt currently support bulk update statements");
                        }
                        if (this.query.getType() == 2) {
                            stmtText = queryStmt.toDeleteStatementText();
                            throw new NucleusException("DataNucleus doesnt currently support bulk delete statements");
                        }
                    }
                    PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, stmtText, this.query);
                    try {
                        RDBMSQueryUtils.prepareStatementForExecution(ps, this.query, true);
                        if (this.query.getType() == 0) {
                            ResultSet rs = sqlControl.executeStatementQuery(mconn, stmtText.toString(), ps);
                            try {
                                String resultSetType = RDBMSQueryUtils.getResultSetTypeForQuery(this.query);
                                qr = resultSetType.equals("scroll-insensitive") || resultSetType.equals("scroll-sensitive") ? new ScrollableQueryResult(this.query, this.rof, rs, this.query.getResultDistinct() ? null : this.candidateCollection) : new ForwardQueryResult(this.query, this.rof, rs, this.query.getResultDistinct() ? null : this.candidateCollection);
                                final ScrollableQueryResult qr1 = qr;
                                final ManagedConnection mconn1 = mconn;
                                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

                                    public void managedConnectionPreClose() {
                                    }

                                    public void managedConnectionPostClose() {
                                    }

                                    public void managedConnectionFlushed() {
                                        qr1.disconnect();
                                    }

                                    public void resourcePostClose() {
                                        mconn1.removeListener((ManagedConnectionResourceListener)this);
                                    }
                                };
                                mconn.addListener(listener);
                                ((AbstractRDBMSQueryResult)qr).addConnectionListener(listener);
                                break block18;
                            }
                            finally {
                                if (qr == null) {
                                    rs.close();
                                }
                            }
                        }
                        int[] rcs = sqlControl.executeStatementUpdate(mconn, stmtText.toString(), ps, true);
                        NucleusLogger.JDO.info((Object)(">> Update statement returned " + rcs[0]));
                    }
                    finally {
                        if (qr == null) {
                            sqlControl.closeStatement(mconn, ps);
                        }
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("042007", (Object)queryStmt.toStatementText(useUpdateLock), (Object)e.getMessage()), (Throwable)e);
            }
        }
        return qr;
    }
}

