/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.util.Collection;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.AbstractMappingManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMappingFactory;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.JavaUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.MultiMap;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSMappingManager
extends AbstractMappingManager {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    MultiMap datastoreMappingsByJavaType;
    MultiMap datastoreMappingsByJDBCType;
    MultiMap datastoreMappingsBySQLType;

    public RDBMSMappingManager(MappedStoreManager storeMgr) {
        super(storeMgr);
    }

    public void loadDatastoreMapping(PluginManager mgr, ClassLoaderResolver clr, String vendorId) {
        if (this.datastoreMappingsByJavaType != null) {
            return;
        }
        this.datastoreMappingsByJDBCType = new MultiMap();
        this.datastoreMappingsBySQLType = new MultiMap();
        this.datastoreMappingsByJavaType = new MultiMap();
        ExtensionPoint exPoint = mgr.getExtensionPoint("org.datanucleus.store_datastoremapping");
        for (int i = 0; i < exPoint.getExtensions().length; ++i) {
            ConfigurationElement[] elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (int e = 0; e < elms.length; ++e) {
                String javaName = elms[e].getAttribute("java-type").trim();
                String rdbmsMappingClassName = elms[e].getAttribute("rdbms-mapping-class");
                String jdbcType = elms[e].getAttribute("jdbc-type");
                String sqlType = elms[e].getAttribute("sql-type");
                String defaultJava = elms[e].getAttribute("default");
                String javaVersion = elms[e].getAttribute("java-version");
                String javaVersionRestricted = elms[e].getAttribute("java-version-restricted");
                boolean defaultForJavaType = false;
                if (defaultJava != null && defaultJava.equalsIgnoreCase("true")) {
                    defaultForJavaType = Boolean.TRUE;
                }
                boolean javaRestricted = false;
                if (javaVersionRestricted != null && javaVersionRestricted.equalsIgnoreCase("true")) {
                    javaRestricted = Boolean.TRUE;
                }
                if (javaVersion == null || javaVersion.length() < 1) {
                    javaVersion = "1.3";
                }
                if ((!JavaUtils.isGreaterEqualsThan((String)javaVersion) || javaRestricted) && (!JavaUtils.isEqualsThan((String)javaVersion) || !javaRestricted)) continue;
                Class mappingType = null;
                if (StringUtils.isWhitespace((String)rdbmsMappingClassName)) continue;
                try {
                    mappingType = mgr.loadClass(elms[e].getExtension().getPlugin().getSymbolicName(), rdbmsMappingClassName);
                }
                catch (NucleusException jpe) {
                    NucleusLogger.METADATA.error((Object)LOCALISER.msg("041013", (Object)rdbmsMappingClassName));
                }
                HashSet<String> includes = new HashSet<String>();
                HashSet<String> excludes = new HashSet<String>();
                ConfigurationElement[] childElm = elms[e].getChildren();
                for (int j = 0; j < childElm.length; ++j) {
                    if (childElm[j].getName().equals("includes")) {
                        includes.add(childElm[j].getAttribute("vendor-id"));
                        continue;
                    }
                    if (!childElm[j].getName().equals("excludes")) continue;
                    excludes.add(childElm[j].getAttribute("vendor-id"));
                }
                if (excludes.contains(vendorId) || !includes.isEmpty() && !includes.contains(vendorId)) continue;
                this.registerDatastoreMapping(javaName, mappingType, jdbcType, sqlType, defaultForJavaType);
            }
        }
    }

    public void registerDatastoreMapping(String javaTypeName, Class datastoreMappingType, String jdbcType, String sqlType, boolean dflt) {
        boolean mappingRequired = true;
        Collection coll = (Collection)this.datastoreMappingsByJavaType.get((Object)javaTypeName);
        if (coll != null && coll.size() > 0) {
            for (RDBMSTypeMapping typeMapping : coll) {
                if (typeMapping.jdbcType.equals(jdbcType) && typeMapping.sqlType.equals(sqlType)) {
                    mappingRequired = false;
                    if (typeMapping.isDefault() == dflt) continue;
                    typeMapping.setDefault(dflt);
                    continue;
                }
                if (!dflt) continue;
                typeMapping.setDefault(false);
            }
        }
        if (mappingRequired) {
            RDBMSTypeMapping mapping = new RDBMSTypeMapping(datastoreMappingType, dflt, javaTypeName, jdbcType, sqlType);
            this.datastoreMappingsByJDBCType.put((Object)jdbcType, (Object)mapping);
            this.datastoreMappingsBySQLType.put((Object)sqlType, (Object)mapping);
            this.datastoreMappingsByJavaType.put((Object)javaTypeName, (Object)mapping);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER_RDBMS.msg("054009", (Object)javaTypeName, (Object)jdbcType, (Object)sqlType, (Object)datastoreMappingType.getName(), (Object)("" + dflt)));
            }
        }
    }

    public void deregisterDatastoreMappingsForJDBCType(String jdbcTypeName) {
        Collection coll = (Collection)this.datastoreMappingsByJDBCType.get((Object)jdbcTypeName);
        if (coll == null || coll.size() == 0) {
            return;
        }
        HashSet mappings = new HashSet(coll);
        for (RDBMSTypeMapping mapping : mappings) {
            this.datastoreMappingsByJavaType.remove((Object)mapping.javaType, (Object)mapping);
            this.datastoreMappingsBySQLType.remove((Object)mapping.sqlType, (Object)mapping);
            this.datastoreMappingsByJDBCType.remove((Object)mapping.jdbcType, (Object)mapping);
            if (!NucleusLogger.DATASTORE.isDebugEnabled()) continue;
            NucleusLogger.DATASTORE.debug((Object)LOCALISER_RDBMS.msg("054010", (Object)mapping.javaType, (Object)mapping.jdbcType, (Object)mapping.sqlType));
        }
    }

    protected Class getDatastoreMappingClass(String fieldName, String javaType, String jdbcType, String sqlType, ClassLoaderResolver clr) {
        RDBMSTypeMapping datastoreMapping = null;
        if (javaType == null) {
            return null;
        }
        javaType = ClassUtils.getWrapperTypeNameForPrimitiveTypeName((String)javaType);
        if (sqlType != null) {
            if (this.datastoreMappingsBySQLType.get((Object)sqlType.toUpperCase()) == null) {
                if (fieldName != null) {
                    throw new NucleusException(LOCALISER_RDBMS.msg("054001", (Object)javaType, (Object)sqlType, (Object)fieldName)).setFatal();
                }
                throw new NucleusException(LOCALISER_RDBMS.msg("054000", (Object)javaType, (Object)sqlType)).setFatal();
            }
            for (RDBMSTypeMapping sqlTypeMapping : (Collection)this.datastoreMappingsBySQLType.get((Object)sqlType.toUpperCase())) {
                if (!sqlTypeMapping.javaType.equals(javaType)) continue;
                datastoreMapping = sqlTypeMapping;
                break;
            }
        } else if (jdbcType != null) {
            if (this.datastoreMappingsByJDBCType.get((Object)jdbcType.toUpperCase()) == null) {
                if (fieldName != null) {
                    throw new NucleusException(LOCALISER_RDBMS.msg("054003", (Object)javaType, (Object)jdbcType, (Object)fieldName)).setFatal();
                }
                throw new NucleusException(LOCALISER_RDBMS.msg("054002", (Object)javaType, (Object)jdbcType)).setFatal();
            }
            for (RDBMSTypeMapping jdbcTypeMapping : (Collection)this.datastoreMappingsByJDBCType.get((Object)jdbcType.toUpperCase())) {
                if (!jdbcTypeMapping.javaType.equals(javaType)) continue;
                datastoreMapping = jdbcTypeMapping;
                break;
            }
            if (datastoreMapping == null) {
                if (fieldName != null) {
                    throw new NucleusException(LOCALISER_RDBMS.msg("054003", (Object)javaType, (Object)jdbcType, (Object)fieldName)).setFatal();
                }
                throw new NucleusException(LOCALISER_RDBMS.msg("054002", (Object)javaType, (Object)jdbcType)).setFatal();
            }
        }
        if (datastoreMapping == null) {
            String type = ClassUtils.getWrapperTypeNameForPrimitiveTypeName((String)javaType);
            Collection mappings = (Collection)this.datastoreMappingsByJavaType.get((Object)type);
            if (mappings == null) {
                Class javaTypeClass = clr.classForName(type);
                for (Class superClass = javaTypeClass.getSuperclass(); superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && mappings == null; superClass = superClass.getSuperclass()) {
                    mappings = (Collection)this.datastoreMappingsByJavaType.get((Object)superClass.getName());
                }
            }
            if (mappings != null) {
                if (mappings.size() == 1) {
                    datastoreMapping = (RDBMSTypeMapping)((Object)mappings.iterator().next());
                } else {
                    for (RDBMSTypeMapping rdbmsMapping : mappings) {
                        if (!rdbmsMapping.isDefault()) continue;
                        datastoreMapping = rdbmsMapping;
                        break;
                    }
                    if (datastoreMapping == null && mappings.size() > 0) {
                        datastoreMapping = (RDBMSTypeMapping)((Object)mappings.iterator().next());
                    }
                }
            }
        }
        if (datastoreMapping == null) {
            if (fieldName != null) {
                throw new NucleusException(LOCALISER_RDBMS.msg("054005", (Object)javaType, (Object)jdbcType, (Object)sqlType, (Object)fieldName)).setFatal();
            }
            throw new NucleusException(LOCALISER_RDBMS.msg("054004", (Object)javaType, (Object)jdbcType, (Object)sqlType)).setFatal();
        }
        return datastoreMapping.getMappingType();
    }

    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, AbstractMemberMetaData mmd, int index, DatastoreField column) {
        Class datastoreMappingClass = null;
        ClassLoaderResolver clr = this.storeMgr.getOMFContext().getClassLoaderResolver(null);
        if (mmd.getColumnMetaData().length > 0 && mmd.getColumnMetaData()[index].hasExtension("datastore-mapping-class")) {
            datastoreMappingClass = clr.classForName(mmd.getColumnMetaData()[index].getValueForExtension("datastore-mapping-class"));
        }
        if (datastoreMappingClass == null) {
            String javaType = mapping.getJavaTypeForDatastoreMapping(index);
            String jdbcType = null;
            String sqlType = null;
            if (mapping.getRoleForMember() == 4 || mapping.getRoleForMember() == 3) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getElementMetaData() != null ? mmd.getElementMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcType();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getCollection() != null && mmd.getCollection().isSerializedElement()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
                if (mmd.getArray() != null && mmd.getArray().isSerializedElement()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForMember() == 5) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getKeyMetaData() != null ? mmd.getKeyMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcType();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getMap().isSerializedKey()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForMember() == 6) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = mmd.getValueMetaData() != null ? mmd.getValueMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcType();
                    sqlType = colmds[index].getSqlType();
                }
                if (mmd.getMap().isSerializedValue()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else {
                if (mmd.getColumnMetaData().length > 0) {
                    jdbcType = mmd.getColumnMetaData()[index].getJdbcType();
                    sqlType = mmd.getColumnMetaData()[index].getSqlType();
                }
                if (mmd.isSerialized()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            }
            datastoreMappingClass = this.getDatastoreMappingClass(mmd.getFullFieldName(), javaType, jdbcType, sqlType, clr);
        }
        DatastoreMapping datastoreMapping = DatastoreMappingFactory.createMapping(datastoreMappingClass, (JavaTypeMapping)mapping, (MappedStoreManager)this.storeMgr, (DatastoreField)column);
        if (column != null) {
            column.setDatastoreMapping(datastoreMapping);
        }
        return datastoreMapping;
    }

    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, DatastoreField column, String javaType) {
        ClassLoaderResolver clr = this.storeMgr.getOMFContext().getClassLoaderResolver(null);
        Column col = (Column)column;
        String jdbcType = null;
        String sqlType = null;
        if (col != null && col.getColumnMetaData() != null) {
            jdbcType = col.getColumnMetaData().getJdbcType();
            sqlType = col.getColumnMetaData().getSqlType();
        }
        Class datastoreMappingClass = this.getDatastoreMappingClass(null, javaType, jdbcType, sqlType, clr);
        DatastoreMapping datastoreMapping = DatastoreMappingFactory.createMapping((Class)datastoreMappingClass, (JavaTypeMapping)mapping, (MappedStoreManager)this.storeMgr, (DatastoreField)column);
        if (column != null) {
            column.setDatastoreMapping(datastoreMapping);
        }
        return datastoreMapping;
    }

    public DatastoreField createDatastoreField(JavaTypeMapping mapping, String javaType, int datastoreFieldIndex) {
        ColumnMetaData[] colmds;
        AbstractMemberMetaData fmd = mapping.getMemberMetaData();
        int roleForField = mapping.getRoleForMember();
        DatastoreContainerObject datastoreContainer = mapping.getDatastoreContainer();
        ColumnMetaData colmd = null;
        AbstractMemberMetaData columnContainer = fmd;
        if (roleForField == 3 || roleForField == 4) {
            columnContainer = fmd.getElementMetaData();
        } else if (roleForField == 5) {
            columnContainer = fmd.getKeyMetaData();
        } else if (roleForField == 6) {
            columnContainer = fmd.getValueMetaData();
        }
        if (columnContainer != null && columnContainer.getColumnMetaData().length > datastoreFieldIndex) {
            colmd = columnContainer.getColumnMetaData()[datastoreFieldIndex];
            colmds = columnContainer.getColumnMetaData();
        } else {
            colmd = new ColumnMetaData();
            colmd.setName(fmd.getColumn());
            if (columnContainer != null) {
                columnContainer.addColumn(colmd);
                colmds = columnContainer.getColumnMetaData();
            } else {
                colmds = new ColumnMetaData[]{colmd};
            }
        }
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            if (roleForField == 3) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 3);
            } else if (roleForField == 4) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 4);
            } else if (roleForField == 5) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 5);
            } else if (roleForField == 6) {
                identifier = idFactory.newJoinTableFieldIdentifier(fmd, null, null, true, 6);
            } else {
                identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName());
                int i = 0;
                while (datastoreContainer.hasDatastoreField(identifier)) {
                    identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName() + "_" + i);
                    ++i;
                }
            }
            colmd.setName(identifier.getIdentifierName());
        } else {
            identifier = idFactory.newDatastoreFieldIdentifier(colmds[datastoreFieldIndex].getName(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), -1);
        }
        Column col = (Column)datastoreContainer.addDatastoreField(javaType, identifier, mapping, (MetaData)colmd);
        if (fmd.isPrimaryKey()) {
            col.setAsPrimaryKey();
        }
        if (this.storeMgr.isStrategyDatastoreAttributed(fmd.getValueStrategy(), false) && datastoreContainer instanceof DatastoreClass && (fmd.isPrimaryKey() && ((DatastoreClass)datastoreContainer).isBaseDatastoreClass() || !fmd.isPrimaryKey())) {
            col.setIdentity(true);
        }
        if (fmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("select-function"), 0);
        }
        if (fmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("insert-function"), 1);
        }
        if (fmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("update-function"), 2);
        }
        this.setDatastoreFieldNullability(fmd, colmd, col);
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    public DatastoreField createDatastoreField(JavaTypeMapping mapping, String javaType, ColumnMetaData colmd) {
        Column col;
        AbstractMemberMetaData fmd = mapping.getMemberMetaData();
        DatastoreContainerObject datastoreContainer = mapping.getDatastoreContainer();
        if (colmd == null) {
            colmd = new ColumnMetaData();
            colmd.setName(fmd.getColumn());
            fmd.addColumn(colmd);
        }
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        if (colmd.getName() == null) {
            DatastoreIdentifier identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName());
            int i = 0;
            while (datastoreContainer.hasDatastoreField(identifier)) {
                identifier = idFactory.newIdentifier(IdentifierType.COLUMN, fmd.getName() + "_" + i);
                ++i;
            }
            colmd.setName(identifier.getIdentifierName());
            col = (Column)datastoreContainer.addDatastoreField(javaType, identifier, mapping, (MetaData)colmd);
        } else {
            col = (Column)datastoreContainer.addDatastoreField(javaType, idFactory.newDatastoreFieldIdentifier(colmd.getName(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), -1), mapping, (MetaData)colmd);
        }
        this.setDatastoreFieldNullability(fmd, colmd, col);
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    public DatastoreField createDatastoreField(AbstractMemberMetaData mmd, DatastoreContainerObject datastoreContainer, JavaTypeMapping mapping, ColumnMetaData colmd, DatastoreField reference, ClassLoaderResolver clr) {
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            AbstractMemberMetaData[] relatedMmds = mmd.getRelatedMemberMetaData(clr);
            identifier = idFactory.newForeignKeyFieldIdentifier(relatedMmds != null ? relatedMmds[0] : null, mmd, reference.getIdentifier(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(mmd.getType()), 1);
            colmd.setName(identifier.getIdentifierName());
        } else {
            identifier = idFactory.newDatastoreFieldIdentifier(colmd.getName(), false, -1);
        }
        Column col = (Column)datastoreContainer.addDatastoreField(mmd.getType().getName(), identifier, mapping, (MetaData)colmd);
        reference.copyConfigurationTo((DatastoreField)col);
        if (mmd.isPrimaryKey()) {
            col.setAsPrimaryKey();
        }
        if (this.storeMgr.isStrategyDatastoreAttributed(mmd.getValueStrategy(), false) && (mmd.isPrimaryKey() && ((DatastoreClass)datastoreContainer).isBaseDatastoreClass() || !mmd.isPrimaryKey())) {
            col.setIdentity(true);
        }
        if (mmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("select-function"), 0);
        }
        if (mmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("insert-function"), 1);
        }
        if (mmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(mmd.getValueForExtension("update-function"), 2);
        }
        this.setDatastoreFieldNullability(mmd, colmd, col);
        if (mmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    private void setDatastoreFieldNullability(AbstractMemberMetaData mmd, ColumnMetaData colmd, DatastoreField field) {
        if (colmd != null && colmd.getAllowsNull() == null) {
            if (mmd.isPrimaryKey()) {
                colmd.setAllowsNull(new Boolean(false));
            } else if (!mmd.getType().isPrimitive() && mmd.getNullValue() != NullValue.EXCEPTION) {
                colmd.setAllowsNull(new Boolean(true));
            } else {
                colmd.setAllowsNull(new Boolean(false));
            }
            if (colmd.isAllowsNull()) {
                field.setNullable();
            }
        } else if (colmd != null && colmd.getAllowsNull() != null) {
            if (colmd.isAllowsNull()) {
                field.setNullable();
            }
        } else if (!mmd.isPrimaryKey() && !mmd.getType().isPrimitive() && mmd.getNullValue() != NullValue.EXCEPTION) {
            field.setNullable();
        }
    }

    protected class RDBMSTypeMapping
    extends AbstractMappingManager.TypeMapping {
        private String javaType;
        private String jdbcType;
        private String sqlType;

        public RDBMSTypeMapping(Class mappingType, boolean isDefault, String javaType, String jdbcType, String sqlType) {
            super((AbstractMappingManager)RDBMSMappingManager.this, mappingType, isDefault);
            this.javaType = javaType;
            this.jdbcType = jdbcType;
            this.sqlType = sqlType;
        }
    }
}

