/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.exceptions.NullValueException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.StringUtils;

public class IntegerRDBMSMapping
extends RDBMSMapping {
    protected IntegerRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public IntegerRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            Object[] validValues;
            this.column.checkPrimitive();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                String constraints = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
        }
        this.initTypeInfo();
    }

    public boolean isIntegerBased() {
        return true;
    }

    public SQLTypeInfo getTypeInfo() {
        return ((RDBMSManager)this.storeMgr).getSQLTypeInfoForJDBCType(4);
    }

    public void setChar(Object ps, int param, char value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"char", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public char getChar(Object rs, int param) {
        char value;
        try {
            value = (char)((ResultSet)rs).getInt(param);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"char", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"int", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"int", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setLong(Object ps, int param, long value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"long", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public long getLong(Object rs, int param) {
        long value;
        try {
            value = ((ResultSet)rs).getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"long", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null && !StringUtils.isWhitespace((String)this.column.getDefaultValue().toString())) {
                    ((PreparedStatement)ps).setInt(param, Integer.valueOf(this.column.getDefaultValue().toString()));
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().getDataType());
                }
            } else if (value instanceof Character) {
                String s = value.toString();
                ((PreparedStatement)ps).setInt(param, s.charAt(0));
            } else if (value instanceof String) {
                String s = (String)value;
                ((PreparedStatement)ps).setInt(param, s.charAt(0));
            } else if (value instanceof Long) {
                ((PreparedStatement)ps).setLong(param, (Long)value);
            } else {
                ((PreparedStatement)ps).setLong(param, ((Number)value).longValue());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public Object getObject(Object rs, int param) {
        Object value;
        try {
            long i = ((ResultSet)rs).getLong(param);
            value = this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_CHARACTER) ? (((ResultSet)rs).wasNull() ? null : new Character((char)i)) : (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_STRING) ? (((ResultSet)rs).wasNull() ? null : new Character((char)i).toString()) : (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_LONG) ? (Number)(((ResultSet)rs).wasNull() ? null : new Long(i)) : (Number)(((ResultSet)rs).wasNull() ? null : new Integer((int)i))));
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

