/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;

public class ExpressionUtils {
    public static NumericExpression getNumericExpression(SQLExpression expr) {
        RDBMSManager storeMgr = expr.getSQLStatement().getRDBMSManager();
        SQLExpressionFactory factory = storeMgr.getSQLExpressionFactory();
        DatabaseAdapter dba = expr.getSQLStatement().getDatabaseAdapter();
        if (expr instanceof CharacterLiteral) {
            char c = ((Character)((CharacterLiteral)expr).getValue()).charValue();
            BigInteger value = new BigInteger("" + c);
            return (NumericExpression)factory.newLiteral(expr.getSQLStatement(), storeMgr.getMappingManager().getMapping(value.getClass()), value);
        }
        if (expr instanceof SQLLiteral) {
            BigInteger value = new BigInteger((String)((SQLLiteral)((Object)expr)).getValue());
            return (NumericExpression)factory.newLiteral(expr.getSQLStatement(), storeMgr.getMappingManager().getMapping(value.getClass()), value);
        }
        ArrayList<SQLExpression> args = new ArrayList<SQLExpression>();
        args.add(expr);
        return new NumericExpression(expr.getJavaTypeMapping(), dba.getNumericConversionFunction(), args);
    }

    public static SQLExpression getLiteralForOne(SQLStatement stmt) {
        RDBMSManager storeMgr = stmt.getRDBMSManager();
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMapping(BigInteger.class);
        return storeMgr.getSQLExpressionFactory().newLiteral(stmt, mapping, BigInteger.ONE);
    }

    public static StringExpression getStringExpression(SQLExpression expr) {
        RDBMSManager storeMgr = expr.getSQLStatement().getRDBMSManager();
        JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(String.class, false);
        if (expr instanceof SQLLiteral) {
            return new StringLiteral(expr.getSQLStatement(), m, ((SQLLiteral)((Object)expr)).getValue().toString());
        }
        ArrayList<SQLExpression> args = new ArrayList<SQLExpression>();
        args.add(expr);
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        return new StringExpression(m, "CAST", args, (List)types);
    }
}

