/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.FetchStatement;
import org.datanucleus.store.mapped.StatementMappingForClass;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.rdbms.RDBMSFetchStatement;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.request.StatementMappingDefinition;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class LocateRequest
extends Request {
    private final StatementMappingDefinition stmtMappingDefinition = new StatementMappingDefinition();
    private String[] stmt;
    private final int[] pkFieldNumbers;

    public LocateRequest(DatastoreClass table) {
        super(table);
        RDBMSFetchStatement fetchStatement = new RDBMSFetchStatement((DatastoreContainerObject)table);
        FetchMappingConsumer consumer = new FetchMappingConsumer(fetchStatement);
        fetchStatement.select("1");
        table.provideDatastoreIdMappings((MappingConsumer)consumer);
        table.providePrimaryKeyMappings((MappingConsumer)consumer);
        this.stmt = new String[2];
        this.stmt[0] = fetchStatement.toString(false);
        this.stmt[1] = fetchStatement.toString(true);
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (this.stmt != null) {
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            Transaction tx = om.getTransaction();
            boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
            String statement = this.stmt[useUpdateLock ? 1 : 0];
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForQuery(mconn, statement);
                    try {
                        if (sm.getInternalObjectId() instanceof OID) {
                            StatementMappingIndex mapIdx = this.stmtMappingDefinition.getDatastoreId();
                            for (int i = 0; i < mapIdx.getNumberOfParameterOccurrences(); ++i) {
                                this.table.getDataStoreObjectIdMapping().setObject(om, (Object)ps, mapIdx.getParameterPositionsForOccurrence(i), sm.getInternalObjectId());
                            }
                        } else {
                            StatementMappingForClass mappingDefinition = new StatementMappingForClass(null);
                            StatementMappingIndex[] idxs = this.stmtMappingDefinition.getFields();
                            for (int i = 0; i < idxs.length; ++i) {
                                if (idxs[i] == null) continue;
                                mappingDefinition.addMappingForMember(i, idxs[i]);
                            }
                            sm.provideFields(this.pkFieldNumbers, storeMgr.getFieldManagerForStatementGeneration(sm, ps, mappingDefinition, false));
                        }
                        ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                        try {
                            if (!rs.next()) {
                                NucleusLogger.DATASTORE_RETRIEVE.info((Object)LOCALISER.msg("050018", sm.getInternalObjectId()));
                                throw new NucleusObjectNotFoundException("No such database row", sm.getInternalObjectId());
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                String msg = LOCALISER.msg("052220", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)statement, (Object)e.getMessage());
                NucleusLogger.DATASTORE_RETRIEVE.warn((Object)msg);
                ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
                exceptions.add(e);
                while ((e = e.getNextException()) != null) {
                    exceptions.add(e);
                }
                throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
    }

    private class FetchMappingConsumer
    implements MappingConsumer {
        private int paramIndex = 1;
        final FetchStatement fetchStmt;
        List pkFields = new ArrayList();
        boolean initialized = false;

        public FetchMappingConsumer(FetchStatement fetchStmt) {
            this.fetchStmt = fetchStmt;
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                LocateRequest.this.stmtMappingDefinition.setPrimaryKeys(new StatementMappingIndex[highestFieldNumber]);
                LocateRequest.this.stmtMappingDefinition.setFields(new StatementMappingIndex[highestFieldNumber]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            if (m.includeInFetchStatement()) {
                ((LocateRequest)LocateRequest.this).stmtMappingDefinition.getFields()[fmd.getAbsoluteFieldNumber()] = new StatementMappingIndex(m);
                if (fmd.isPrimaryKey()) {
                    int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField(m.getDataStoreMapping(j).getDatastoreField()) + " = ?");
                        this.pkFields.add(new Integer(fmd.getAbsoluteFieldNumber()));
                        ++this.paramIndex;
                    }
                    LocateRequest.this.stmtMappingDefinition.getFields()[fmd.getAbsoluteFieldNumber()].addParameterOccurrence(parametersIndex);
                }
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 2) {
                this.fetchStmt.andCondition(this.fetchStmt.referenceDatastoreField((DatastoreField)LocateRequest.this.key.getColumns().get(0)) + " = ?");
                StatementMappingIndex datastoreIdIdx = new StatementMappingIndex(m);
                int[] nArray = new int[]{this.paramIndex++};
                datastoreIdIdx.addParameterOccurrence(nArray);
                LocateRequest.this.stmtMappingDefinition.setDatastoreId(datastoreIdIdx);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.pkFields.get(i);
            }
            return fieldNumbers;
        }
    }
}

