/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.BooleanCharColumnExpression;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.CharacterExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.query.QueryStatement;

public class OracleQueryStatement
extends QueryStatement {
    public OracleQueryStatement(DatastoreContainerObject initialTable, DatastoreIdentifier alias, ClassLoaderResolver clr) {
        super(initialTable, alias, clr);
    }

    protected StatementText generateOrderingStatement() {
        String nlsSortOrder = "LATIN";
        String sortOrder = this.storeMgr.getOMFContext().getPersistenceConfiguration().getStringProperty("datanucleus.rdbms.oracleNlsSortOrder");
        if (sortOrder != null) {
            nlsSortOrder = sortOrder.toUpperCase();
        }
        StatementText orderByStmt = null;
        if (this.orderingExpressions != null && this.orderingExpressions.length > 0) {
            RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
            orderByStmt = new StatementText();
            boolean needsSelect = dba.supportsOption("IncludeOrderByColumnsInSelect");
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                if (i > 0) {
                    orderByStmt.append(',');
                }
                String orderingString = null;
                orderingString = needsSelect && !this.hasAggregateExpression ? "NUCORDER" + i : this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION);
                if (this.orderingExpressions[i] instanceof CharacterExpression && !nlsSortOrder.equals("BINARY")) {
                    orderByStmt.append("NLSSORT(").append(orderingString).append(", 'NLS_SORT = ").append(nlsSortOrder).append("')");
                } else {
                    if (this.orderingExpressions[i] instanceof BooleanExpression && !(this.orderingExpressions[i] instanceof BooleanCharColumnExpression)) {
                        throw new NucleusException(LOCALISER.msg("052505")).setFatal();
                    }
                    orderByStmt.append(orderingString);
                }
                if (!this.orderingDirections[i]) continue;
                orderByStmt.append(" DESC");
            }
        }
        return orderByStmt;
    }
}

