/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.datanucleus.store.rdbms.sql.expression.ByteLiteral;
import org.datanucleus.store.rdbms.sql.expression.FloatingPointLiteral;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.IntegerLiteral;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class MathAcosMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (expr == null) {
            return new NullLiteral(expr.getSQLStatement(), null, (Object)null);
        }
        if (expr instanceof SQLLiteral) {
            if (expr instanceof ByteLiteral) {
                int originalValue = ((BigInteger)((ByteLiteral)expr).getValue()).intValue();
                BigInteger absValue = new BigInteger(String.valueOf(Math.acos(originalValue)));
                return new ByteLiteral(expr.getSQLStatement(), expr.getJavaTypeMapping(), absValue);
            }
            if (expr instanceof IntegerLiteral) {
                int originalValue = ((Number)((IntegerLiteral)expr).getValue()).intValue();
                Double absValue = new Double(Math.acos(originalValue));
                return new FloatingPointLiteral(expr.getSQLStatement(), expr.getJavaTypeMapping(), absValue);
            }
            if (expr instanceof FloatingPointLiteral) {
                double originalValue = ((BigDecimal)((FloatingPointLiteral)expr).getValue()).doubleValue();
                Double absValue = new Double(Math.acos(originalValue));
                return new FloatingPointLiteral(expr.getSQLStatement(), expr.getJavaTypeMapping(), absValue);
            }
            throw new IllegalExpressionOperationException("Math.acos()", expr);
        }
        return expr.getSQLStatement().getRDBMSManager().getSQLExpressionFactory().invokeMethod(null, "acos", expr, args);
    }
}

