/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.sql.expression.IllegalExpressionOperationException;
import org.datanucleus.store.rdbms.sql.expression.NullLiteral;
import org.datanucleus.store.rdbms.sql.expression.ObjectExpression;
import org.datanucleus.store.rdbms.sql.expression.ObjectLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;

public class JDOHelperGetObjectIdMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        if (expr == null) {
            return new NullLiteral(expr.getSQLStatement(), null, (Object)null);
        }
        if (expr instanceof SQLLiteral) {
            RDBMSManager storeMgr = expr.getSQLStatement().getRDBMSManager();
            ApiAdapter api = storeMgr.getApiAdapter();
            Object id = api.getIdForObject(((SQLLiteral)((Object)expr)).getValue());
            if (id == null) {
                return new NullLiteral(expr.getSQLStatement(), null, (Object)null);
            }
            JavaTypeMapping m = this.getMappingForClass(id.getClass());
            return new ObjectLiteral(expr.getSQLStatement(), m, id);
        }
        if (ObjectExpression.class.isAssignableFrom(expr.getClass())) {
            if (((ObjectExpression)expr).getJavaTypeMapping() instanceof PersistenceCapableMapping) {
                // empty if block
            }
            return expr;
        }
        throw new IllegalExpressionOperationException("JDOHelper.getObjectId", expr);
    }
}

