/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.expression.ExpressionHelper;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.scostore.AbstractSetStoreSpecialization;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.mapped.scostore.MapValueSetStore;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.RDBMSAbstractSetStoreSpecialization;
import org.datanucleus.store.rdbms.sql.DiscriminatorStatementGenerator;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.UnionStatementGenerator;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.util.ClassUtils;

class RDBMSMapValueSetStore
extends MapValueSetStore {
    private String findKeyStmt;
    private String clearStmt;

    RDBMSMapValueSetStore(MapTable mapTable, MapStore mapStore, ClassLoaderResolver clr, RDBMSManager storeMgr) {
        super((DatastoreContainerObject)mapTable, mapStore, clr, mapTable.getOwnerMapping(), mapTable.getKeyMapping(), mapTable.getValueMapping(), (AbstractSetStoreSpecialization)new RDBMSAbstractSetStoreSpecialization(LOCALISER, clr, storeMgr));
    }

    RDBMSMapValueSetStore(DatastoreClass valueTable, JavaTypeMapping ownerMapping, JavaTypeMapping valueMapping, MapStore mapStore, ClassLoaderResolver clr, AbstractMemberMetaData fmd, RDBMSManager storeMgr) {
        super(valueTable, ownerMapping, valueMapping, mapStore, clr, fmd, (AbstractSetStoreSpecialization)new RDBMSAbstractSetStoreSpecialization(LOCALISER, clr, storeMgr));
    }

    protected void postInit() {
        if (this.keyMapping != null) {
            this.findKeyStmt = this.getFindKeyStmt();
        } else {
            this.clearStmt = null;
            this.findKeyStmt = null;
        }
    }

    protected boolean canClear() {
        return this.clearStmt != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(StateManager sm, Object element) {
        if (this.findKeyStmt == null) {
            throw new UnsupportedOperationException("Cannot remove from an inverse map through its value set");
        }
        Object key = null;
        boolean keyExists = false;
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.getStoreMgr().getConnection(om);
            SQLController sqlControl = this.getStoreMgr().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, this.findKeyStmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(sm, om, ps, jdbcPosition, (BaseContainerStore)this);
                    jdbcPosition = BackingStoreHelper.populateElementInStatement(om, ps, element, jdbcPosition, this.elementMapping);
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, this.findKeyStmt, ps);
                    try {
                        if (rs.next()) {
                            key = this.keyMapping.getObject(om, (Object)rs, ExpressionHelper.getParametersIndex((int)1, (JavaTypeMapping)this.keyMapping));
                            keyExists = true;
                        }
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Request failed to check if set contains an element: " + this.findKeyStmt, (Throwable)e);
        }
        if (keyExists) {
            this.mapStore.remove(sm, key);
            return true;
        }
        return false;
    }

    private String getFindKeyStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT ");
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
        }
        stmt.append(" FROM ");
        stmt.append(this.containerTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    protected SQLStatement getSQLStatementForSelectAll(StateManager ownerSM) {
        SQLStatement sqlStmt = null;
        RDBMSManager storeMgr = (RDBMSManager)this.storeMgr;
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        Class elementCls = clr.classForName(this.elementType);
        if (this.emd != null && this.emd.getDiscriminatorStrategy() != null && this.emd.getDiscriminatorStrategy() != DiscriminatorStrategy.NONE && this.containerTable instanceof DatastoreClass) {
            if (ClassUtils.isReferenceType((Class)clr.classForName(this.elementType))) {
                String[] clsNames = storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.elementType, clr);
                Class[] cls = new Class[clsNames.length];
                for (int j = 0; j < clsNames.length; ++j) {
                    cls[j] = clr.classForName(clsNames[j]);
                }
                DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(storeMgr, cls, true, null, null);
                sqlStmt = stmtGen.getStatement();
            } else {
                DiscriminatorStatementGenerator stmtGen = new DiscriminatorStatementGenerator(storeMgr, elementCls, true, null, null);
                sqlStmt = stmtGen.getStatement();
            }
            DatastoreClass sourceTable = storeMgr.getDatastoreClass(this.elementType, clr);
            if (this.containerTable != sourceTable) {
                sqlStmt.innerJoin(sqlStmt.getPrimaryTable(), sqlStmt.getPrimaryTable().getTable().getIDMapping(), this.containerTable, null, this.elementMapping, null, null);
            }
            this.iterateUsingDiscriminator = true;
        } else {
            UnionStatementGenerator stmtGen = new UnionStatementGenerator(storeMgr, elementCls, true, null, null, this.containerTable, null, this.elementMapping);
            sqlStmt = stmtGen.getStatement();
        }
        return sqlStmt;
    }

    private RDBMSManager getStoreMgr() {
        return (RDBMSManager)this.storeMgr;
    }
}

