/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.fieldmanager.DynamicSchemaFieldManager;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.request.RequestIdentifier;
import org.datanucleus.store.rdbms.request.RequestType;
import org.datanucleus.store.rdbms.table.SecondaryTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;

public class RDBMSPersistenceHandler
implements StorePersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    protected final MappedStoreManager storeMgr;
    private Map<RequestIdentifier, Request> requestsByID = Collections.synchronizedMap(new SoftValueMap());
    private Map<String, Class> requestClassByType = new HashMap<String, Class>();

    public RDBMSPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (MappedStoreManager)storeMgr;
        try {
            PluginManager pluginMgr = storeMgr.getOMFContext().getPluginManager();
            ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
            PersistenceConfiguration conf = storeMgr.getOMFContext().getPersistenceConfiguration();
            ConfigurationElement elem = null;
            String key = conf.getStringProperty("datanucleus.rdbms.request.insert");
            elem = pluginMgr.getConfigurationElementForExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.INSERT.toString(), key});
            Class cls = clr.classForName(elem.getAttribute("class"));
            this.requestClassByType.put(RequestType.INSERT.toString(), cls);
            key = conf.getStringProperty("datanucleus.rdbms.request.update");
            elem = pluginMgr.getConfigurationElementForExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.UPDATE.toString(), key});
            cls = clr.classForName(elem.getAttribute("class"));
            this.requestClassByType.put(RequestType.UPDATE.toString(), cls);
            key = conf.getStringProperty("datanucleus.rdbms.request.delete");
            elem = pluginMgr.getConfigurationElementForExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.DELETE.toString(), key});
            cls = clr.classForName(elem.getAttribute("class"));
            this.requestClassByType.put(RequestType.DELETE.toString(), cls);
            key = conf.getStringProperty("datanucleus.rdbms.request.fetch");
            elem = pluginMgr.getConfigurationElementForExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.FETCH.toString(), key});
            cls = clr.classForName(elem.getAttribute("class"));
            this.requestClassByType.put(RequestType.FETCH.toString(), cls);
            key = conf.getStringProperty("datanucleus.rdbms.request.locate");
            elem = pluginMgr.getConfigurationElementForExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.LOCATE.toString(), key});
            cls = clr.classForName(elem.getAttribute("class"));
            this.requestClassByType.put(RequestType.LOCATE.toString(), cls);
        }
        catch (Exception e) {
            throw new NucleusException("Attempt to find request types to be used gave exception", (Throwable)e);
        }
    }

    public void close() {
        this.requestsByID.clear();
        this.requestsByID = null;
    }

    public void insertObject(StateManager sm) {
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            NucleusLogger.JDO.debug((Object)">> RDBMSPersistenceHandler - checking dynamic schema");
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager((RDBMSManager)this.storeMgr, sm);
            sm.provideFields(sm.getLoadedFieldNumbers(), (FieldManager)dynamicSchemaFM);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                NucleusLogger.JDO.debug((Object)">> RDBMSPersistenceHandler - schema updates performed so invalidating all requests");
                this.requestsByID.clear();
            }
            NucleusLogger.JDO.debug((Object)">> RDBMSPersistenceHandler - check of dynamic schema DONE");
        }
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        String className = sm.getObject().getClass().getName();
        DatastoreClass dc = this.storeMgr.getDatastoreClass(className, clr);
        if (dc == null) {
            AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(sm.getObject().getClass(), clr);
            if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                throw new NucleusUserException(LOCALISER.msg("032013", (Object)className));
            }
            throw new NucleusException(LOCALISER.msg("032014", (Object)className, (Object)cmd.getInheritanceMetaData().getStrategy())).setFatal();
        }
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementInsertCount();
        }
        this.insertTable(dc, sm, clr);
    }

    private void insertTable(DatastoreClass table, StateManager sm, ClassLoaderResolver clr) {
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.insertTable(supertable, sm, clr);
        }
        Request req = this.getInsertRequest(table, sm.getObject().getClass(), clr);
        req.execute(sm);
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryTable secTable : secondaryTables) {
                this.insertTable((DatastoreClass)secTable, sm, clr);
            }
        }
    }

    private Request getInsertRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.INSERT, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            Class reqCls = this.requestClassByType.get(RequestType.INSERT.toString());
            req = (Request)ClassUtils.newInstance((Class)reqCls, (Class[])new Class[]{DatastoreClass.class, Class.class, ClassLoaderResolver.class}, (Object[])new Object[]{table, cls, clr});
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        AbstractMemberMetaData[] fmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            if (sm.getPcObjectType() != 0) {
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < fmds.length; ++i) {
                    if (i > 0) {
                        str.append(',');
                    }
                    str.append(fmds[i].getName());
                }
                NucleusLogger.PERSISTENCE.info((Object)("Request to load fields \"" + str.toString() + "\" of class " + sm.getClassMetaData().getFullClassName() + " but object is embedded, so ignored"));
            } else {
                if (this.storeMgr.getRuntimeManager() != null) {
                    this.storeMgr.getRuntimeManager().incrementFetchCount();
                }
                ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
                DatastoreClass table = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
                Request req = this.getFetchRequest(table, fmds, sm.getObject().getClass(), clr);
                req.execute(sm);
            }
        }
    }

    private Request getFetchRequest(DatastoreClass table, AbstractMemberMetaData[] mmds, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, mmds, RequestType.FETCH, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            Class reqCls = this.requestClassByType.get(RequestType.FETCH.toString());
            req = (Request)ClassUtils.newInstance((Class)reqCls, (Class[])new Class[]{DatastoreClass.class, AbstractMemberMetaData[].class, Class.class, ClassLoaderResolver.class}, (Object[])new Object[]{table, mmds, cls, clr});
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            NucleusLogger.JDO.debug((Object)"Checking for dynamic schema changes ...");
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager((RDBMSManager)this.storeMgr, sm);
            sm.provideFields(fieldNumbers, (FieldManager)dynamicSchemaFM);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                NucleusLogger.JDO.debug((Object)"Schema updates performed so invalidating all requests");
                this.requestsByID.clear();
            }
            NucleusLogger.JDO.debug((Object)"Check of dynamic schema DONE");
        }
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        AbstractMemberMetaData[] fmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
            ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
            DatastoreClass dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
            this.updateTable(dc, sm, clr, fmds);
        }
    }

    private void updateTable(DatastoreClass table, StateManager sm, ClassLoaderResolver clr, AbstractMemberMetaData[] fieldMetaData) {
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.updateTable(supertable, sm, clr, fieldMetaData);
        }
        Request req = this.getUpdateRequest(table, fieldMetaData, sm.getObject().getClass(), clr);
        req.execute(sm);
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryTable secTable : secondaryTables) {
                this.updateTable((DatastoreClass)secTable, sm, clr, fieldMetaData);
            }
        }
    }

    private Request getUpdateRequest(DatastoreClass table, AbstractMemberMetaData[] mmds, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, mmds, RequestType.UPDATE, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            Class reqCls = this.requestClassByType.get(RequestType.UPDATE.toString());
            req = (Request)ClassUtils.newInstance((Class)reqCls, (Class[])new Class[]{DatastoreClass.class, AbstractMemberMetaData[].class, Class.class, ClassLoaderResolver.class}, (Object[])new Object[]{table, mmds, cls, clr});
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementDeleteCount();
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreClass dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        this.deleteTable(dc, sm, clr);
    }

    private void deleteTable(DatastoreClass table, StateManager sm, ClassLoaderResolver clr) {
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryTable secTable : secondaryTables) {
                this.deleteTable((DatastoreClass)secTable, sm, clr);
            }
        }
        Request req = this.getDeleteRequest(table, sm.getObject().getClass(), clr);
        req.execute(sm);
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.deleteTable(supertable, sm, clr);
        }
    }

    private Request getDeleteRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.DELETE, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            Class reqCls = this.requestClassByType.get(RequestType.DELETE.toString());
            req = (Request)ClassUtils.newInstance((Class)reqCls, (Class[])new Class[]{DatastoreClass.class, Class.class, ClassLoaderResolver.class}, (Object[])new Object[]{table, cls, clr});
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void locateObject(StateManager sm) {
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreClass table = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        Request req = this.getLocateRequest(table, sm.getObject().getClass().getName());
        req.execute(sm);
    }

    private Request getLocateRequest(DatastoreClass table, String className) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.LOCATE, className);
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            Class reqCls = this.requestClassByType.get(RequestType.LOCATE.toString());
            req = (Request)ClassUtils.newInstance((Class)reqCls, (Class[])new Class[]{DatastoreClass.class}, (Object[])new Object[]{table});
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequests() {
        Map<RequestIdentifier, Request> map = this.requestsByID;
        synchronized (map) {
            this.requestsByID.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestsForTable(DatastoreClass table) {
        Map<RequestIdentifier, Request> map = this.requestsByID;
        synchronized (map) {
            HashSet<RequestIdentifier> keySet = new HashSet<RequestIdentifier>(this.requestsByID.keySet());
            for (RequestIdentifier reqId : keySet) {
                if (reqId.getTable() != table) continue;
                this.requestsByID.remove(reqId);
            }
        }
    }
}

