/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.ConnectionFactoryNotFoundException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.exceptions.UnsupportedConnectionFactoryException;
import org.datanucleus.store.rdbms.ConnectionProviderPriorityList;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.RDBMSStoreHelper;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.datasource.DataNucleusDataSourceFactory;
import org.datanucleus.transaction.TransactionUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)RDBMSManager.class.getClassLoader());
    Object[] dataSource;
    OMFContext omfContext;
    Map options = new HashMap();
    String poolingType = null;

    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        this.omfContext = omfContext;
        PersistenceConfiguration config = omfContext.getPersistenceConfiguration();
        if (resourceType.equals("tx")) {
            this.initDataSourceTx(config);
        } else {
            this.initDataSourceNonTx(config);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initDataSourceTx(PersistenceConfiguration config) {
        this.options.put("resource-type", this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.connection.resourceType"));
        if (config.hasProperty("datanucleus.ConnectionFactory")) {
            Object cf = config.getProperty("datanucleus.ConnectionFactory");
            if (!(cf instanceof DataSource) && !(cf instanceof XADataSource)) {
                throw new UnsupportedConnectionFactoryException(cf);
            }
            this.dataSource = new DataSource[1];
            this.dataSource[0] = cf;
            return;
        } else if (config.hasProperty("datanucleus.ConnectionFactoryName")) {
            String[] connectionFactoryNames = StringUtils.split((String)config.getStringProperty("datanucleus.ConnectionFactoryName"), (String)",");
            this.dataSource = new DataSource[connectionFactoryNames.length];
            for (int i = 0; i < connectionFactoryNames.length; ++i) {
                this.dataSource[i] = this.lookupDataSource(connectionFactoryNames[i]);
            }
            return;
        } else {
            this.dataSource = new DataSource[1];
            String poolingType = this.getPoolingType();
            try {
                DataNucleusDataSourceFactory dataSourceFactory = (DataNucleusDataSourceFactory)this.omfContext.getPluginManager().createExecutableExtension("org.datanucleus.datasource", "name", poolingType, "class-name", null, null);
                if (dataSourceFactory == null) {
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("047003", (Object)poolingType)).setFatal();
                }
                this.dataSource[0] = dataSourceFactory.makePooledDataSource(this.omfContext);
                if (!NucleusLogger.CONNECTION.isDebugEnabled()) return;
                NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("047008", (Object)"transactional", (Object)poolingType));
                return;
            }
            catch (ClassNotFoundException cnfe) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("047003", (Object)poolingType), (Throwable)cnfe).setFatal();
            }
            catch (Exception e) {
                if (!(e instanceof InvocationTargetException)) throw new NucleusException(LOCALISER_RDBMS.msg("047004", (Object)poolingType, (Object)e.getMessage()), (Throwable)e).setFatal();
                InvocationTargetException ite = (InvocationTargetException)e;
                throw new NucleusException(LOCALISER_RDBMS.msg("047004", (Object)poolingType, (Object)ite.getTargetException().getMessage()), ite.getTargetException()).setFatal();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initDataSourceNonTx(PersistenceConfiguration config) {
        this.options.put("resource-type", this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.connection2.resourceType"));
        if (config.hasProperty("datanucleus.ConnectionFactory2")) {
            Object cf2 = config.getProperty("datanucleus.ConnectionFactory2");
            if (!(cf2 instanceof DataSource) && !(cf2 instanceof XADataSource)) {
                throw new UnsupportedConnectionFactoryException(cf2);
            }
            this.dataSource = new DataSource[1];
            this.dataSource[0] = cf2;
            return;
        } else if (config.hasProperty("datanucleus.ConnectionFactory2Name")) {
            String[] connectionFactoryNames = StringUtils.split((String)config.getStringProperty("datanucleus.ConnectionFactory2Name"), (String)",");
            this.dataSource = new DataSource[connectionFactoryNames.length];
            for (int i = 0; i < connectionFactoryNames.length; ++i) {
                this.dataSource[i] = this.lookupDataSource(connectionFactoryNames[i]);
            }
            return;
        } else if (config.hasProperty("datanucleus.ConnectionURL")) {
            this.dataSource = new DataSource[1];
            String poolingType = this.getPoolingType();
            try {
                DataNucleusDataSourceFactory dataSourceFactory = (DataNucleusDataSourceFactory)this.omfContext.getPluginManager().createExecutableExtension("org.datanucleus.datasource", "name", poolingType, "class-name", null, null);
                if (dataSourceFactory == null) {
                    throw new NucleusUserException(LOCALISER_RDBMS.msg("047003", (Object)poolingType)).setFatal();
                }
                this.dataSource[0] = dataSourceFactory.makePooledDataSource(this.omfContext);
                if (!NucleusLogger.CONNECTION.isDebugEnabled()) return;
                NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("047008", (Object)"nontransactional", (Object)poolingType));
                return;
            }
            catch (ClassNotFoundException cnfe) {
                throw new NucleusUserException(LOCALISER_RDBMS.msg("047003", (Object)poolingType), (Throwable)cnfe).setFatal();
            }
            catch (Exception e) {
                if (!(e instanceof InvocationTargetException)) throw new NucleusException(LOCALISER_RDBMS.msg("047004", (Object)poolingType, (Object)e.getMessage()), (Throwable)e).setFatal();
                InvocationTargetException ite = (InvocationTargetException)e;
                throw new NucleusException(LOCALISER_RDBMS.msg("047004", (Object)poolingType, (Object)ite.getTargetException().getMessage()), ite.getTargetException()).setFatal();
            }
        } else {
            this.initDataSourceTx(config);
        }
    }

    public String getPoolingType() {
        if (this.poolingType != null) {
            return this.poolingType;
        }
        PersistenceConfiguration config = this.omfContext.getPersistenceConfiguration();
        this.poolingType = config.getStringProperty("datanucleus.connectionPoolingType");
        ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(null);
        if (this.poolingType == null) {
            try {
                clr.classForName("org.datanucleus.store.rdbms.datasource.dbcp.DBCPDataSourceFactory");
                clr.classForName("org.apache.commons.pool.ObjectPool");
                clr.classForName("org.apache.commons.dbcp.ConnectionFactory");
                this.poolingType = "DBCP";
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
        }
        if (this.poolingType == null) {
            try {
                clr.classForName("org.datanucleus.store.rdbms.datasource.c3p0.C3P0DataSourceFactory");
                clr.classForName("com.mchange.v2.c3p0.ComboPooledDataSource");
                this.poolingType = "C3P0";
            }
            catch (ClassNotResolvedException cnre) {
                // empty catch block
            }
        }
        if (this.poolingType == null) {
            try {
                clr.classForName("org.datanucleus.store.rdbms.datasource.proxool.ProxoolDataSourceFactory");
                clr.classForName("org.logicalcobwebs.proxool.ProxoolDriver");
                clr.classForName("org.apache.commons.logging.Log");
                this.poolingType = "Proxool";
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
        }
        if (this.poolingType == null || this.poolingType.equalsIgnoreCase("None")) {
            this.poolingType = "default";
        }
        return this.poolingType;
    }

    public ManagedConnection getConnection(ObjectManager om, Map options) {
        HashMap addedOptions = new HashMap();
        if (options != null) {
            addedOptions.putAll(options);
        }
        addedOptions.putAll(this.options);
        ManagedConnectionImpl connection = (ManagedConnectionImpl)this.omfContext.getConnectionManager().allocateConnection((ConnectionFactory)this, om, addedOptions);
        connection.incrementUseCount();
        return connection;
    }

    public ManagedConnection createManagedConnection(ObjectManager om, Map transactionOptions) {
        return new ManagedConnectionImpl(transactionOptions);
    }

    private Object lookupDataSource(String name) {
        Object obj;
        try {
            obj = new InitialContext().lookup(name);
        }
        catch (NamingException e) {
            throw new ConnectionFactoryNotFoundException(name, (Exception)e);
        }
        if (!(obj instanceof DataSource) && !(obj instanceof XADataSource)) {
            throw new UnsupportedConnectionFactoryException(obj);
        }
        return obj;
    }

    class EmulatedXAResource
    implements XAResource {
        Connection conn;

        EmulatedXAResource(Connection conn) {
            this.conn = conn;
        }

        public void commit(Xid xid, boolean flags) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is committing for transaction " + xid.toString() + " with flags " + flags));
            try {
                this.conn.commit();
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " committed connection for transaction " + xid.toString() + " with flags " + flags));
            }
            catch (SQLException e) {
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " failed to commit connection for transaction " + xid.toString() + " with flags " + flags));
                XAException xe = new XAException(StringUtils.getStringFromStackTrace((Throwable)e));
                xe.initCause(e);
                throw xe;
            }
        }

        public void end(Xid xid, int flags) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is ending for transaction " + xid.toString() + " with flags " + flags));
        }

        public void forget(Xid arg0) throws XAException {
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean isSameRM(XAResource xares) throws XAException {
            return this == xares;
        }

        public int prepare(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is preparing for transaction " + xid.toString()));
            return 0;
        }

        public Xid[] recover(int flags) throws XAException {
            throw new XAException("Unsupported operation");
        }

        public void rollback(Xid xid) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is rolling back for transaction " + xid.toString()));
            try {
                this.conn.rollback();
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " rolled back connection for transaction " + xid.toString()));
            }
            catch (SQLException e) {
                NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " failed to rollback connection for transaction " + xid.toString()));
                XAException xe = new XAException(StringUtils.getStringFromStackTrace((Throwable)e));
                xe.initCause(e);
                throw xe;
            }
        }

        public boolean setTransactionTimeout(int arg0) throws XAException {
            return false;
        }

        public void start(Xid xid, int flags) throws XAException {
            NucleusLogger.CONNECTION.debug((Object)("Managed connection " + this.toString() + " is starting for transaction " + xid.toString() + " with flags " + flags));
        }
    }

    class ManagedConnectionImpl
    implements ManagedConnection {
        Object conn;
        boolean managed = false;
        boolean locked = false;
        int isolation;
        List listeners = new ArrayList();
        int useCount = 0;

        ManagedConnectionImpl(Map transactionOptions) {
            this.isolation = transactionOptions != null && transactionOptions.get("transaction.isolation") != null ? ((Number)transactionOptions.get("transaction.isolation")).intValue() : TransactionUtils.getTransactionIsolationLevelForName((String)ConnectionFactoryImpl.this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.transactionIsolation"));
        }

        void incrementUseCount() {
            ++this.useCount;
        }

        public void release() {
            if (!this.managed) {
                --this.useCount;
                if (this.useCount == 0) {
                    this.close();
                }
            }
        }

        public XAResource getXAResource() {
            if (this.getConnection() instanceof Connection) {
                return new EmulatedXAResource((Connection)this.getConnection());
            }
            try {
                return ((XAConnection)this.getConnection()).getXAResource();
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }

        public Object getConnection() {
            if (this.conn == null) {
                Connection cnx;
                block23: {
                    cnx = null;
                    try {
                        RDBMSManager storeMgr = (RDBMSManager)ConnectionFactoryImpl.this.omfContext.getStoreManager();
                        if (storeMgr != null && storeMgr.getDatastoreAdapter() != null) {
                            RDBMSAdapter rdba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
                            int reqdIsolationLevel = this.isolation;
                            if (rdba.getRequiredTransactionIsolationLevel() >= 0) {
                                reqdIsolationLevel = rdba.getRequiredTransactionIsolationLevel();
                            }
                            DataSource[] ds = (DataSource[])ConnectionFactoryImpl.this.dataSource;
                            cnx = new ConnectionProviderPriorityList().getConnection(ds);
                            boolean succeeded = false;
                            try {
                                if (reqdIsolationLevel == 0) {
                                    if (!cnx.getAutoCommit()) {
                                        NucleusLogger.CONNECTION.debug((Object)("Setting autocommit=true to connection: " + cnx.toString()));
                                        cnx.setAutoCommit(true);
                                    }
                                } else {
                                    if (cnx.getAutoCommit()) {
                                        NucleusLogger.CONNECTION.debug((Object)("Setting autocommit=false to connection: " + cnx.toString()));
                                        cnx.setAutoCommit(false);
                                    }
                                    if (RDBMSStoreHelper.supportsTransactionIsolation(rdba, reqdIsolationLevel)) {
                                        int currentIsolationLevel = cnx.getTransactionIsolation();
                                        if (currentIsolationLevel != reqdIsolationLevel) {
                                            NucleusLogger.CONNECTION.debug((Object)("Setting transaction isolation " + TransactionUtils.getNameForTransactionIsolationLevel((int)reqdIsolationLevel) + " to connection: " + cnx.toString()));
                                            cnx.setTransactionIsolation(reqdIsolationLevel);
                                        }
                                    } else {
                                        NucleusLogger.DATASTORE.warn((Object)LOCALISER_RDBMS.msg("051008", (long)reqdIsolationLevel));
                                    }
                                }
                                succeeded = true;
                                if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                    NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052002", (Object)cnx.toString(), (Object)TransactionUtils.getNameForTransactionIsolationLevel((int)reqdIsolationLevel)));
                                }
                                if (reqdIsolationLevel != this.isolation && this.isolation == 0 && !cnx.getAutoCommit()) {
                                    NucleusLogger.CONNECTION.debug((Object)("Setting autocommit=true to connection: " + cnx.toString()));
                                    cnx.setAutoCommit(true);
                                }
                                break block23;
                            }
                            catch (SQLException e) {
                                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                            }
                            finally {
                                if (!succeeded && !cnx.isClosed()) {
                                    String cnxStr = cnx.toString();
                                    cnx.close();
                                    if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                                        NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052003", (Object)cnxStr));
                                    }
                                }
                            }
                        }
                        cnx = ((DataSource)ConnectionFactoryImpl.this.dataSource[0]).getConnection();
                        if (cnx == null) {
                            String msg = LOCALISER_RDBMS.msg("052000", ConnectionFactoryImpl.this.dataSource[0]);
                            NucleusLogger.CONNECTION.error((Object)msg);
                            throw new NucleusDataStoreException(msg);
                        }
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052001", (Object)cnx.toString()));
                        }
                    }
                    catch (SQLException e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                }
                this.conn = cnx;
            }
            return this.conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            Connection conn = null;
            if (this.conn != null && this.conn instanceof Connection) {
                conn = (Connection)this.conn;
            } else if (this.conn != null && this.conn instanceof XAConnection) {
                try {
                    conn = ((XAConnection)this.conn).getConnection();
                }
                catch (SQLException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    if (!(this.managed || conn.isClosed() || conn.getAutoCommit())) {
                        conn.commit();
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052005", (Object)conn.toString()));
                        }
                    }
                    if (!conn.isClosed()) {
                        String connStr = conn.toString();
                        conn.close();
                        if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                            NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052003", (Object)connStr));
                        }
                    } else if (NucleusLogger.CONNECTION.isDebugEnabled()) {
                        NucleusLogger.CONNECTION.debug((Object)LOCALISER_RDBMS.msg("052004", (Object)conn.toString()));
                    }
                }
                catch (SQLException e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
                }
            }
            finally {
                this.listeners.clear();
            }
            this.conn = null;
        }

        public void setManagedResource() {
            this.managed = true;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void lock() {
            this.locked = true;
        }

        public void unlock() {
            this.locked = false;
        }

        public void addListener(ManagedConnectionResourceListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ManagedConnectionResourceListener listener) {
            this.listeners.remove(listener);
        }

        public String toString() {
            return "[" + super.toString() + ", " + this.conn + "]";
        }

        public void flush() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionFlushed();
            }
        }
    }
}

