/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.PrimaryKeyMetaData;
import org.datanucleus.store.mapped.ColumnCreator;
import org.datanucleus.store.mapped.DatastoreElementContainer;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.ElementContainerTable;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class CollectionTable
extends ElementContainerTable
implements DatastoreElementContainer {
    public CollectionTable(DatastoreIdentifier tableName, AbstractMemberMetaData fmd, RDBMSManager storeMgr) {
        super(tableName, fmd, storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        PrimaryKeyMetaData pkmd;
        super.initialize(clr);
        PrimaryKeyMetaData primaryKeyMetaData = pkmd = this.fmd.getJoinMetaData() != null ? this.fmd.getJoinMetaData().getPrimaryKeyMetaData() : null;
        boolean pkColsSpecified = pkmd != null ? pkmd.getColumnMetaData() != null : false;
        boolean pkRequired = this.requiresPrimaryKey();
        boolean elementPC = this.fmd.hasCollection() && this.fmd.getCollection().getElementClassMetaData() != null;
        Class elementClass = clr.classForName(this.getElementType());
        if (this.isSerialisedElement() || this.isEmbeddedElementPC() || this.isEmbeddedElement() && !elementPC || ClassUtils.isReferenceType((Class)elementClass)) {
            this.elementMapping = this.storeMgr.getMappingManager().getMapping(this, this.fmd, this.dba, clr, 3);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.elementMapping);
            }
        } else {
            ColumnMetaData[] elemColmd = null;
            AbstractMemberMetaData[] relatedMmds = this.fmd.getRelatedMemberMetaData(clr);
            ElementMetaData elemmd = this.fmd.getElementMetaData();
            if (elemmd != null && elemmd.getColumnMetaData() != null && elemmd.getColumnMetaData().length > 0) {
                elemColmd = elemmd.getColumnMetaData();
            } else if (relatedMmds != null && relatedMmds[0].getJoinMetaData() != null && relatedMmds[0].getJoinMetaData().getColumnMetaData() != null && relatedMmds[0].getJoinMetaData().getColumnMetaData().length > 0) {
                elemColmd = relatedMmds[0].getJoinMetaData().getColumnMetaData();
            }
            this.elementMapping = ColumnCreator.createColumnsForJoinTables(elementClass, this.fmd, elemColmd, this.storeMgr, this, false, false, 3, clr);
            if (this.fmd.hasExtension("allow-nulls") && this.fmd.getValueForExtension("allow-nulls").equalsIgnoreCase("true")) {
                for (int i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                    Column elementCol = (Column)this.elementMapping.getDataStoreMapping(i).getDatastoreField();
                    elementCol.setNullable();
                }
            }
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.elementMapping);
            }
        }
        boolean orderRequired = false;
        if (this.fmd.getOrderMetaData() != null) {
            if (this.fmd.getOrderMetaData().isIndexedList()) {
                orderRequired = true;
            }
        } else if (List.class.isAssignableFrom(this.fmd.getType())) {
            orderRequired = true;
        } else if (this.requiresPrimaryKey() && !pkColsSpecified) {
            if (this.isEmbeddedElementPC()) {
                if (this.fmd.getCollection().getElementClassMetaData().getIdentityType() != IdentityType.APPLICATION) {
                    orderRequired = true;
                }
            } else if (this.isSerialisedElement()) {
                orderRequired = true;
            } else if (this.elementMapping instanceof ReferenceMapping) {
                ReferenceMapping refMapping = (ReferenceMapping)this.elementMapping;
                if (refMapping.getJavaTypeMapping().length > 1) {
                    orderRequired = true;
                }
            } else if (!(this.elementMapping instanceof PersistenceCapableMapping)) {
                Column elementCol = (Column)this.elementMapping.getDataStoreMapping(0).getDatastoreField();
                if (!((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).isValidPrimaryKeyType(elementCol.getJdbcType())) {
                    orderRequired = true;
                }
            }
        }
        if (orderRequired) {
            DatastoreIdentifier id;
            ColumnMetaData orderColmd = null;
            if (this.fmd.getOrderMetaData() != null && this.fmd.getOrderMetaData().getColumnMetaData() != null && this.fmd.getOrderMetaData().getColumnMetaData().length > 0) {
                orderColmd = this.fmd.getOrderMetaData().getColumnMetaData()[0];
                if (orderColmd.getName() == null) {
                    orderColmd = new ColumnMetaData(orderColmd);
                    if (this.fmd.hasExtension("adapter-column-name")) {
                        orderColmd.setName(this.fmd.getValueForExtension("adapter-column-name"));
                    } else {
                        id = this.storeMgr.getIdentifierFactory().newIndexFieldIdentifier(this.fmd);
                        orderColmd.setName(id.getIdentifierName());
                    }
                }
            } else if (this.fmd.hasExtension("adapter-column-name")) {
                orderColmd = new ColumnMetaData(this.fmd.getValueForExtension("adapter-column-name"));
            } else {
                id = this.storeMgr.getIdentifierFactory().newIndexFieldIdentifier(this.fmd);
                orderColmd = new ColumnMetaData(id.getIdentifierName());
            }
            this.orderMapping = this.storeMgr.getMappingManager().getMapping(Integer.TYPE);
            ColumnCreator.createIndexColumn(this.orderMapping, this.storeMgr, clr, this, orderColmd, pkRequired && !pkColsSpecified);
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                this.debugMapping(this.orderMapping);
            }
        }
        if (pkRequired) {
            if (pkColsSpecified) {
                this.applyUserPrimaryKeySpecification(pkmd);
            } else if (orderRequired) {
                this.orderMapping.getDataStoreMapping(0).getDatastoreField().setAsPrimaryKey();
            } else {
                for (int i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                    this.elementMapping.getDataStoreMapping(i).getDatastoreField().setAsPrimaryKey();
                }
            }
        }
        this.state = 2;
    }

    public String getElementType() {
        return this.fmd.getCollection().getElementType();
    }

    public boolean isSerialisedElement() {
        return this.fmd.getCollection() != null && this.fmd.getCollection().isSerializedElement();
    }

    public boolean isEmbeddedElement() {
        if (this.fmd.getCollection() != null && this.fmd.getCollection().isSerializedElement()) {
            return false;
        }
        return this.fmd.getCollection() != null && this.fmd.getCollection().isEmbeddedElement();
    }

    public boolean isSerialisedElementPC() {
        return this.fmd.getCollection() != null && this.fmd.getCollection().isSerializedElement() && this.fmd.getCollection().getElementClassMetaData() != null;
    }

    public boolean isEmbeddedElementPC() {
        if (this.fmd.getCollection() != null && this.fmd.getCollection().isSerializedElement()) {
            return false;
        }
        return this.fmd.getElementMetaData() != null && this.fmd.getElementMetaData().getEmbeddedMetaData() != null;
    }

    protected boolean requiresPrimaryKey() {
        if (this.fmd.getOrderMetaData() != null && !this.fmd.getOrderMetaData().isIndexedList()) {
            return false;
        }
        return super.requiresPrimaryKey();
    }
}

