/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractClassTable
extends TableImpl {
    protected Map<AbstractMemberMetaData, JavaTypeMapping> fieldMappingsMap = new HashMap<AbstractMemberMetaData, JavaTypeMapping>();
    protected JavaTypeMapping datastoreIDMapping;
    protected JavaTypeMapping[] pkMappings;
    protected JavaTypeMapping idMapping;
    protected JavaTypeMapping versionMapping;
    protected VersionMetaData versionMetaData;
    protected DiscriminatorMetaData discriminatorMetaData;
    protected JavaTypeMapping discriminatorMapping;
    protected int highestFieldNumber = 0;

    public AbstractClassTable(DatastoreIdentifier tableName, RDBMSManager storeMgr) {
        super(tableName, storeMgr);
    }

    public DatastoreContainerObject getPrimaryDatastoreContainerObject() {
        return this;
    }

    protected abstract void initializePK(ClassLoaderResolver var1);

    public boolean managesField(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        return this.getMappingForFieldName(fieldName) != null;
    }

    protected JavaTypeMapping getMappingForFieldName(String fieldName) {
        Set<AbstractMemberMetaData> fields = this.fieldMappingsMap.keySet();
        for (AbstractMemberMetaData fmd : fields) {
            if (!fmd.getFullFieldName().equals(fieldName)) continue;
            return this.fieldMappingsMap.get(fmd);
        }
        return null;
    }

    public boolean managesMapping(JavaTypeMapping mapping) {
        Collection<JavaTypeMapping> mappings = this.fieldMappingsMap.values();
        return mappings.contains(mapping);
    }

    final void addApplicationIdUsingClassTableId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, ClassLoaderResolver clr, AbstractClassMetaData cmd) {
        ColumnMetaData[] userdefinedCols = null;
        int nextUserdefinedCol = 0;
        if (columnContainer != null) {
            userdefinedCols = columnContainer.getColumnMetaData();
        }
        this.pkMappings = new JavaTypeMapping[cmd.getPKMemberPositions().length];
        for (int i = 0; i < cmd.getPKMemberPositions().length; ++i) {
            AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
            JavaTypeMapping mapping = refTable.getFieldMapping(fmd);
            if (mapping == null) {
                throw new NucleusUserException("Cannot find mapping for field " + fmd.getFullFieldName() + " in table " + ((Object)refTable).toString() + " " + StringUtils.objectArrayToString((Object[])refTable.getDatastoreFields()));
            }
            JavaTypeMapping masterMapping = this.storeMgr.getMappingManager().getMapping(clr.classForName(mapping.getType()));
            masterMapping.setFieldInformation(fmd, this);
            this.pkMappings[i] = masterMapping;
            for (int j = 0; j < mapping.getNumberOfDatastoreFields(); ++j) {
                JavaTypeMapping m = masterMapping;
                DatastoreField refColumn = mapping.getDataStoreMapping(j).getDatastoreField();
                if (mapping instanceof PersistenceCapableMapping) {
                    m = this.storeMgr.getMappingManager().getMapping(clr.classForName(refColumn.getJavaTypeMapping().getType()));
                    ((PersistenceCapableMapping)masterMapping).addJavaTypeMapping(m);
                }
                ColumnMetaData userdefinedColumn = null;
                if (userdefinedCols != null) {
                    for (int k = 0; k < userdefinedCols.length; ++k) {
                        if (!((Object)refColumn.getIdentifier()).toString().equals(userdefinedCols[k].getTarget())) continue;
                        userdefinedColumn = userdefinedCols[k];
                        break;
                    }
                    if (userdefinedColumn == null && nextUserdefinedCol < userdefinedCols.length) {
                        userdefinedColumn = userdefinedCols[nextUserdefinedCol++];
                    }
                }
                DatastoreField idColumn = null;
                idColumn = userdefinedColumn != null ? this.addDatastoreField(refColumn.getStoredJavaType(), this.storeMgr.getIdentifierFactory().newIdentifier(1, userdefinedColumn.getName()), m, (MetaData)refColumn.getColumnMetaData()) : this.addDatastoreField(refColumn.getStoredJavaType(), refColumn.getIdentifier(), m, (MetaData)refColumn.getColumnMetaData());
                if (mapping != null && mapping.getDataStoreMapping(j).getDatastoreField().getColumnMetaData() != null) {
                    refColumn.copyConfigurationTo(idColumn);
                }
                idColumn.setAsPrimaryKey();
                this.getStoreManager().getMappingManager().createDatastoreMapping(m, idColumn, refColumn.getJavaTypeMapping().getType());
            }
            int absoluteFieldNumber = fmd.getAbsoluteFieldNumber();
            if (absoluteFieldNumber <= this.highestFieldNumber) continue;
            this.highestFieldNumber = absoluteFieldNumber;
        }
    }

    void addDatastoreId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, AbstractClassMetaData cmd) {
        this.datastoreIDMapping = new OIDMapping();
        this.datastoreIDMapping.initialize(this.dba, cmd.getFullClassName());
        ColumnMetaData colmd = null;
        colmd = columnContainer == null ? new ColumnMetaData((String)null) : (columnContainer.getColumnMetaData().length < 1 ? new ColumnMetaData((String)null) : columnContainer.getColumnMetaData()[0]);
        if (colmd.getName() == null) {
            if (refTable != null) {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(refTable.getIdentifier().getIdentifierName(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(OID.class), 1).getIdentifierName());
            } else {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(this.identifier.getIdentifierName(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(OID.class), 0).getIdentifierName());
            }
        }
        Column idColumn = (Column)this.addDatastoreField(OID.class.getName(), this.storeMgr.getIdentifierFactory().newIdentifier(1, colmd.getName()), this.datastoreIDMapping, (MetaData)colmd);
        idColumn.setAsPrimaryKey();
        String strategyName = cmd.getIdentityMetaData().getValueStrategy().toString();
        if (cmd.getIdentityMetaData().getValueStrategy().equals((Object)IdentityStrategy.CUSTOM)) {
            strategyName = cmd.getIdentityMetaData().getValueStrategy().getCustomName();
        }
        Class poidClass = Long.class;
        ConfigurationElement elem = this.storeMgr.getOMFContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategyName, "true"});
        if (elem == null) {
            elem = this.storeMgr.getOMFContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeMgr.getStoreManagerKey()});
        }
        if (elem != null) {
            String generatorClassName = elem.getAttribute("class-name");
            Class generatorClass = this.getStoreManager().getOMFContext().getClassLoaderResolver(null).classForName(generatorClassName);
            try {
                poidClass = (Class)generatorClass.getMethod("getStorageClass", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                NucleusLogger.VALUEGENERATION.warn((Object)("Error retrieving storage class for POID generator " + generatorClassName + " " + e.getMessage()));
            }
        }
        this.storeMgr.getMappingManager().createDatastoreMapping(this.datastoreIDMapping, idColumn, poidClass.getName());
        if (this.isObjectIDDatastoreAttributed() && this instanceof DatastoreClass && ((DatastoreClass)((Object)this)).isBaseDatastoreClass()) {
            idColumn.setIdentity(true);
        }
        if (idColumn.isIdentity() && !this.dba.supportsOption("IdentityColumns")) {
            throw new NucleusException(LOCALISER.msg("057020", (Object)cmd.getFullClassName(), (Object)"datastore-identity")).setFatal();
        }
    }

    protected void addFieldMapping(JavaTypeMapping fieldMapping) {
        AbstractMemberMetaData fmd = fieldMapping.getFieldMetaData();
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            StringBuffer columnsStr = new StringBuffer();
            for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    columnsStr.append(",");
                }
                columnsStr.append(fieldMapping.getDataStoreMapping(i).getDatastoreField());
            }
            if (fieldMapping.getNumberOfDatastoreFields() == 0) {
                columnsStr.append("[none]");
            }
            StringBuffer datastoreMappingTypes = new StringBuffer();
            for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    datastoreMappingTypes.append(',');
                }
                datastoreMappingTypes.append(fieldMapping.getDataStoreMapping(i).getClass().getName());
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("057010", (Object)fmd.getFullFieldName(), (Object)columnsStr.toString(), (Object)fieldMapping.getClass().getName(), (Object)datastoreMappingTypes.toString()));
        }
        this.fieldMappingsMap.put(fmd, fieldMapping);
        int absoluteFieldNumber = fmd.getAbsoluteFieldNumber();
        if (absoluteFieldNumber > this.highestFieldNumber) {
            this.highestFieldNumber = absoluteFieldNumber;
        }
    }

    public abstract IdentityType getIdentityType();

    public abstract boolean isObjectIDDatastoreAttributed();

    public JavaTypeMapping getDataStoreObjectIdMapping() {
        this.assertIsInitialized();
        return this.datastoreIDMapping;
    }

    public JavaTypeMapping getVersionMapping(boolean allowSuperclasses) {
        return this.versionMapping;
    }

    public JavaTypeMapping getDiscriminatorMapping(boolean allowSuperclasses) {
        return this.discriminatorMapping;
    }

    public final void provideDatastoreIdMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            consumer.consumeMapping(this.getDataStoreObjectIdMapping(), 2);
        }
    }

    public abstract void providePrimaryKeyMappings(MappingConsumer var1);

    public final void provideNonPrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        Set<AbstractMemberMetaData> fieldNumbersSet = this.fieldMappingsMap.keySet();
        for (AbstractMemberMetaData fmd : fieldNumbersSet) {
            JavaTypeMapping fieldMapping = this.fieldMappingsMap.get(fmd);
            if (fieldMapping == null || fmd.isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, fmd);
        }
    }

    public void provideMappingsForFields(MappingConsumer consumer, AbstractMemberMetaData[] fieldMetaData, boolean includeSecondaryTables) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        for (int i = 0; i < fieldMetaData.length; ++i) {
            JavaTypeMapping fieldMapping = this.fieldMappingsMap.get(fieldMetaData[i]);
            if (fieldMapping == null || fieldMetaData[i].isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, fieldMetaData[i]);
        }
    }

    public final void provideVersionMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getVersionMapping(false) != null) {
            consumer.consumeMapping(this.getVersionMapping(false), 1);
        }
    }

    public final void provideDiscriminatorMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getDiscriminatorMapping(false) != null) {
            consumer.consumeMapping(this.getDiscriminatorMapping(false), 3);
        }
    }
}

