/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.mapped.mapping.SerialisedMapping;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.SQLWarnings;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.rdbms.query.UnionIteratorStatement;
import org.datanucleus.store.rdbms.scostore.AbstractMapStore;
import org.datanucleus.store.rdbms.scostore.MapEntrySetStore;
import org.datanucleus.store.rdbms.scostore.MapKeySetStore;
import org.datanucleus.store.rdbms.scostore.MapValueSetStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.MapTable;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class JoinMapStore
extends AbstractMapStore {
    private final String putStmt;
    private final String updateStmt;
    private final String removeStmt;
    private final String clearStmt;
    private SetStore keySetStore = null;
    private SetStore valueSetStore = null;
    private SetStore entrySetStore = null;
    protected final JavaTypeMapping adapterMapping;
    protected ClassLoaderResolver clr;

    public JoinMapStore(MapTable mapTable, ClassLoaderResolver clr) {
        super((StoreManager)mapTable.getStoreManager());
        this.clr = clr;
        this.mapTable = mapTable;
        this.setOwnerMemberMetaData(mapTable.getOwnerFieldMetaData());
        this.ownerMapping = mapTable.getOwnerMapping();
        this.keyMapping = mapTable.getKeyMapping();
        this.valueMapping = mapTable.getValueMapping();
        this.adapterMapping = mapTable.getOrderMapping();
        this.keyType = mapTable.getKeyType();
        this.keysAreEmbedded = mapTable.isEmbeddedKey();
        this.keysAreSerialised = mapTable.isSerialisedKey();
        this.valueType = mapTable.getValueType();
        this.valuesAreEmbedded = mapTable.isEmbeddedValue();
        this.valuesAreSerialised = mapTable.isSerialisedValue();
        Class key_class = clr.classForName(this.keyType);
        this.kmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(key_class, clr);
        Class value_class = clr.classForName(this.valueType);
        if (ClassUtils.isReferenceType((Class)value_class)) {
            NucleusLogger.PERSISTENCE.warn((Object)LOCALISER.msg("056066", (Object)value_class.getName()));
            this.vmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(value_class, null, clr);
            if (this.vmd != null) {
                this.valueType = value_class.getName();
                this.valueTable = this.storeMgr.getDatastoreClass(this.vmd.getFullClassName(), clr);
            }
        } else {
            this.vmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(value_class, clr);
            if (this.vmd != null) {
                this.valueType = this.vmd.getFullClassName();
                this.valueTable = this.valuesAreEmbedded ? null : this.storeMgr.getDatastoreClass(this.valueType, clr);
            }
        }
        this.initialiseStatements();
        this.putStmt = this.getPutStmt();
        this.updateStmt = this.getUpdateStmt();
        this.removeStmt = this.getRemoveStmt();
        this.clearStmt = this.getClearStmt();
    }

    private String getPutStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("INSERT INTO ");
        stmt.append(this.mapTable.toString());
        stmt.append(" (");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((Object)this.adapterMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
        }
        stmt.append(") VALUES (");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        if (this.adapterMapping != null) {
            for (i = 0; i < this.adapterMapping.getNumberOfDatastoreFields(); ++i) {
                stmt.append(",");
                stmt.append(((RDBMSMapping)this.adapterMapping.getDataStoreMapping(i)).getInsertionInputParameter());
            }
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(",");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getInsertionInputParameter());
        }
        stmt.append(") ");
        return stmt.toString();
    }

    private String getUpdateStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    private String getRemoveStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
            stmt.append(" AND ");
            stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    private String getClearStmt() {
        StringBuffer stmt = new StringBuffer();
        stmt.append("DELETE FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (int i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextIDForAdapterColumn(StateManager sm) {
        int nextID;
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.getSQLController();
            try {
                String stmt = this.getMaxAdapterColumnIdStmt();
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.associationStrategy.populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, stmt, ps);
                    try {
                        nextID = !rs.next() ? 1 : rs.getInt(1) + 1;
                        SQLWarnings.log(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056020", (Object)this.getMaxAdapterColumnIdStmt()), (Throwable)e);
        }
        return nextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(StateManager sm, Map m) {
        Map.Entry entry;
        Iterator iter;
        ManagedConnection mconn;
        ObjectManager om;
        if (m == null || m.size() == 0) {
            return;
        }
        HashSet puts = new HashSet();
        HashSet updates = new HashSet();
        for (Map.Entry e : m.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            this.validateKeyForWriting(sm, key);
            this.validateValueForWriting(sm, value);
            try {
                Object oldValue = this.getValue(sm, key);
                if (oldValue == value) continue;
                updates.add(e);
            }
            catch (NoSuchElementException nsee) {
                if (value == null) continue;
                puts.add(e);
            }
        }
        boolean batched = this.allowsBatching();
        if (puts.size() > 0) {
            try {
                om = sm.getObjectManager();
                mconn = this.storeMgr.getConnection(om);
                try {
                    iter = puts.iterator();
                    while (iter.hasNext()) {
                        entry = (Map.Entry)iter.next();
                        this.internalPut(sm, mconn, batched, entry.getKey(), entry.getValue(), !iter.hasNext());
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056016", (Object)this.putStmt), (Throwable)e);
            }
        }
        if (updates.size() > 0) {
            try {
                om = sm.getObjectManager();
                mconn = this.storeMgr.getConnection(om);
                try {
                    iter = updates.iterator();
                    while (iter.hasNext()) {
                        entry = (Map.Entry)iter.next();
                        this.internalUpdate(sm, mconn, batched, entry.getKey(), entry.getValue(), !iter.hasNext());
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056016", (Object)this.updateStmt), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(StateManager sm, Object key, Object value) {
        MapMetaData mapmd;
        Object oldValue;
        this.validateKeyForWriting(sm, key);
        this.validateValueForWriting(sm, value);
        boolean exists = false;
        try {
            oldValue = this.getValue(sm, key);
            exists = true;
        }
        catch (NoSuchElementException e) {
            oldValue = null;
            exists = false;
        }
        if (oldValue != value) {
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                try {
                    if (exists) {
                        this.internalUpdate(sm, mconn, false, key, value, true);
                    } else {
                        this.internalPut(sm, mconn, false, key, value, true);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056016", (Object)(exists ? this.updateStmt : this.putStmt)), (Throwable)e);
            }
        }
        if ((mapmd = this.ownerMemberMetaData.getMap()).isDependentValue() && !mapmd.isEmbeddedValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getObjectManager().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] internalPut(StateManager ownerSM, ManagedConnection conn, boolean batched, Object key, Object value, boolean executeNow) throws SQLException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.putStmt, false);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.valueMapping != null ? this.populateValueInStatement(om, ps, value, jdbcPosition) : this.populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, (JoinTable)this.mapTable);
            jdbcPosition = this.associationStrategy.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, this);
            if (this.adapterMapping != null) {
                long nextIDAdapter = this.getNextIDForAdapterColumn(ownerSM);
                this.adapterMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.adapterMapping), new Long(nextIDAdapter));
                jdbcPosition += this.adapterMapping.getNumberOfDatastoreFields();
            }
            jdbcPosition = this.populateKeyInStatement(om, ps, key, jdbcPosition);
            int[] nArray = sqlControl.executeStatementUpdate(conn, this.putStmt, ps, true);
            return nArray;
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdate(StateManager ownerSM, ManagedConnection conn, boolean batched, Object key, Object value, boolean executeNow) throws SQLException {
        ObjectManager om = ownerSM.getObjectManager();
        SQLController sqlControl = this.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.updateStmt, false);
        try {
            int jdbcPosition = 1;
            jdbcPosition = this.valueMapping != null ? this.populateValueInStatement(om, ps, value, jdbcPosition) : this.populateEmbeddedValueFieldsInStatement(ownerSM, value, ps, jdbcPosition, (JoinTable)this.mapTable);
            jdbcPosition = this.associationStrategy.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, this);
            jdbcPosition = this.populateKeyInStatement(om, ps, key, jdbcPosition);
            if (batched) {
                ps.addBatch();
            } else {
                sqlControl.executeStatementUpdate(conn, this.updateStmt, ps, true);
            }
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(StateManager sm, Object key) {
        boolean exists;
        Object oldValue;
        if (!this.validateKeyForReading(sm, key)) {
            return null;
        }
        try {
            oldValue = this.getValue(sm, key);
            exists = true;
        }
        catch (NoSuchElementException e) {
            oldValue = null;
            exists = false;
        }
        ObjectManager om = sm.getObjectManager();
        if (exists) {
            try {
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                SQLController sqlControl = this.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.removeStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = this.associationStrategy.populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                        jdbcPosition = this.populateKeyInStatement(om, ps, key, jdbcPosition);
                        sqlControl.executeStatementUpdate(mconn, this.removeStmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056012", (Object)this.removeStmt), (Throwable)e);
            }
        }
        MapMetaData mapmd = this.ownerMemberMetaData.getMap();
        ApiAdapter api = om.getApiAdapter();
        if (mapmd.isDependentKey() && !mapmd.isEmbeddedKey() && api.isPersistable(key)) {
            om.deleteObjectInternal(key);
        }
        if (mapmd.isDependentValue() && !mapmd.isEmbeddedValue() && api.isPersistable(oldValue) && !this.containsValue(sm, oldValue)) {
            om.deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        HashSet<Object> dependentElements = null;
        if (this.ownerMemberMetaData.getMap().isDependentKey() || this.ownerMemberMetaData.getMap().isDependentValue()) {
            dependentElements = new HashSet<Object>();
            ApiAdapter api = ownerSM.getObjectManager().getApiAdapter();
            Iterator iter = this.entrySetStore().iterator(ownerSM);
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                MapMetaData mapmd = this.ownerMemberMetaData.getMap();
                if (api.isPersistable(entry.getKey()) && mapmd.isDependentKey() && !mapmd.isEmbeddedKey()) {
                    dependentElements.add(entry.getKey());
                }
                if (!api.isPersistable(entry.getValue()) || !mapmd.isDependentValue() || mapmd.isEmbeddedValue()) continue;
                dependentElements.add(entry.getValue());
            }
        }
        try {
            ObjectManager om = ownerSM.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.clearStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.associationStrategy.populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, this);
                    sqlControl.executeStatementUpdate(mconn, this.clearStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)this.clearStmt), (Throwable)e);
        }
        if (dependentElements != null && dependentElements.size() > 0) {
            ownerSM.getObjectManager().deleteObjects(dependentElements.toArray());
        }
    }

    public synchronized SetStore keySetStore(ClassLoaderResolver clr) {
        if (this.keySetStore == null) {
            this.keySetStore = new MapKeySetStore((MapTable)this.mapTable, clr);
        }
        return this.keySetStore;
    }

    public synchronized SetStore valueSetStore(ClassLoaderResolver clr) {
        if (this.valueSetStore == null) {
            this.valueSetStore = new MapValueSetStore((MapTable)this.mapTable, this, clr);
        }
        return this.valueSetStore;
    }

    public synchronized SetStore entrySetStore() {
        if (this.entrySetStore == null) {
            this.entrySetStore = new MapEntrySetStore((MapTable)this.mapTable, this, this.clr);
        }
        return this.entrySetStore;
    }

    protected QueryExpression getGetStatement(StateManager ownerSm, Object key) {
        QueryExpression stmt = null;
        ClassLoaderResolver clr = ownerSm.getObjectManager().getClassLoaderResolver();
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            stmt = this.dba.newQueryStatement(this.mapTable, null, clr);
            stmt.select(this.valueMapping);
        } else {
            stmt = new UnionIteratorStatement(clr, clr.classForName(this.valueType), true, (StoreManager)this.storeMgr, clr.classForName(this.valueType), this.valueMapping, this.mapTable, false, null, true, false).getQueryStatement(null);
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            ScalarExpression keyExpr = this.keyMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            ScalarExpression keyVal = this.keyMapping.newLiteral(stmt, key).add(this.storeMgr.getMappingManager().getMapping(String.class).newLiteral(stmt, "%"));
            stmt.andCondition(new BooleanExpression(keyExpr, ScalarExpression.OP_LIKE, keyVal), true);
        } else {
            ScalarExpression keyExpr = this.keyMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            ScalarExpression keyVal = this.keyMapping.newLiteral(stmt, key);
            stmt.andCondition(keyExpr.eq(keyVal), true);
        }
        return stmt;
    }

    private String getMaxAdapterColumnIdStmt() {
        StringBuffer stmt = new StringBuffer();
        stmt.append("SELECT MAX(" + ((Object)this.adapterMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() + ")");
        stmt.append(" FROM ");
        stmt.append(this.mapTable.toString());
        stmt.append(" WHERE ");
        for (int i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(" AND ");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        return stmt.toString();
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass, DatastoreIdentifier candidateAlias) {
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            throw new NucleusUserException(LOCALISER.msg("056022"));
        }
        if (!this.clr.isAssignableFrom(this.valueType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, candidateClass);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreIdentifier mapTableAlias = this.storeMgr.getIdentifierFactory().newIdentifier(0, "map");
        QueryExpression stmt = this.dba.newQueryStatement(this.mapTable, mapTableAlias, clr);
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(candidateClass)) {
            stmt.select(mapTableAlias, this.valueMapping);
        } else {
            DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, clr);
            stmt.newTableExpression(candidateTable, stmt.getMainTableAlias());
            JavaTypeMapping valueTableID = candidateTable.getIDMapping();
            ScalarExpression valueMapExpr = this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
            ScalarExpression valueExpr = valueTableID.newScalarExpression(stmt, stmt.getMainTableExpression());
            stmt.innerJoin(valueExpr, valueMapExpr, stmt.getMainTableExpression(), true, true);
            stmt.select(valueTableID);
        }
        return stmt;
    }

    public ScalarExpression joinKeysTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias, Class filteredKeyType, ScalarExpression keyExpr, DatastoreIdentifier keyTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.keyType, filteredKeyType) && !clr.isAssignableFrom(filteredKeyType, this.keyType)) {
            throw new IncompatibleQueryElementTypeException(this.keyType, filteredKeyType == null ? null : filteredKeyType.getName());
        }
        LogicSetExpression mapTblExpr = stmt.newTableExpression(this.mapTable, mapTableAlias);
        ScalarExpression ownerMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        if (!parentStmt.hasCrossJoin(mapTblExpr)) {
            stmt.crossJoin(mapTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerMapExpr), true);
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredKeyType.getName())) {
            return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        if (this.keysAreEmbedded || this.keysAreSerialised) {
            return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        DatastoreClass keyTable = this.storeMgr.getDatastoreClass(filteredKeyType.getName(), stmt.getClassLoaderResolver());
        JavaTypeMapping keyTableID = keyTable.getIDMapping();
        LogicSetExpression keyTblExpr = stmt.getTableExpression(keyTableAlias);
        if (keyTblExpr == null) {
            keyTblExpr = stmt.newTableExpression(keyTable, keyTableAlias);
        }
        ScalarExpression keyMapExpr = this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        if (!parentStmt.hasCrossJoin(keyTblExpr)) {
            stmt.crossJoin(keyTblExpr, true);
        }
        if (keyExpr == null) {
            keyExpr = keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyTableAlias));
        }
        if (keyExpr.getLogicSetExpression() != null && !keyTable.equals(keyExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(keyMapExpr.eq(keyExpr), true);
            return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        ScalarExpression kExpr = keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyTableAlias));
        stmt.andCondition(keyMapExpr.eq(kExpr), true);
        return kExpr;
    }

    public ScalarExpression[] joinKeysValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias, Class filteredKeyType, Class filteredValueType, ScalarExpression keyExpr, ScalarExpression valExpr, DatastoreIdentifier keyTableAlias, DatastoreIdentifier valueTableAlias) {
        ScalarExpression[] qclKeyValues = new ScalarExpression[]{this.joinKeysTo(stmt, parentStmt, ownerMapping, ownerTe, mapTableAlias, filteredKeyType, keyExpr, keyTableAlias), this.joinValuesTo(stmt, parentStmt, ownerMapping, ownerTe, mapTableAlias, filteredValueType, valExpr, valueTableAlias)};
        return qclKeyValues;
    }

    public ScalarExpression joinValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapTableAlias, Class filteredValueType, ScalarExpression valExpr, DatastoreIdentifier valueTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.valueType, filteredValueType) && !clr.isAssignableFrom(filteredValueType, this.valueType)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, filteredValueType == null ? null : filteredValueType.getName());
        }
        LogicSetExpression mapTblExpr = stmt.newTableExpression(this.mapTable, mapTableAlias);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        if (!parentStmt.hasCrossJoin(mapTblExpr)) {
            stmt.crossJoin(mapTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerMapExpr), true);
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredValueType.getName())) {
            return this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        if (this.valuesAreEmbedded || this.valuesAreSerialised) {
            return this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        DatastoreClass valueTable = this.storeMgr.getDatastoreClass(filteredValueType.getName(), stmt.getClassLoaderResolver());
        JavaTypeMapping valueTableID = valueTable.getIDMapping();
        LogicSetExpression valueTblExpr = stmt.getTableExpression(valueTableAlias);
        if (valueTblExpr == null) {
            valueTblExpr = stmt.newTableExpression(valueTable, valueTableAlias);
        }
        ScalarExpression valueMapExpr = this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        if (!parentStmt.hasCrossJoin(valueTblExpr)) {
            stmt.crossJoin(valueTblExpr, true);
        }
        if (valExpr == null) {
            valExpr = valueTableID.newScalarExpression(stmt, stmt.getTableExpression(valueTableAlias));
        }
        if (valExpr.getLogicSetExpression() != null && !valueTable.equals(valExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(valueMapExpr.eq(valExpr), true);
            return this.valueMapping.newScalarExpression(stmt, stmt.getTableExpression(mapTableAlias));
        }
        ScalarExpression valueExpr = valueTableID.newScalarExpression(stmt, stmt.getTableExpression(valueTableAlias));
        stmt.andCondition(valueMapExpr.eq(valueExpr), true);
        return valueExpr;
    }
}

