/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerHelper;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.MapMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.exceptions.ClassDefinitionException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.mapped.mapping.SerialisedMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.DiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.rdbms.query.UnionIteratorStatement;
import org.datanucleus.store.rdbms.scostore.AbstractMapStore;
import org.datanucleus.store.rdbms.scostore.MapEntrySetStore;
import org.datanucleus.store.rdbms.scostore.MapKeySetStore;
import org.datanucleus.store.rdbms.scostore.MapValueSetStore;
import org.datanucleus.store.scostore.SetStore;
import org.datanucleus.util.ClassUtils;

public class FKMapStore
extends AbstractMapStore {
    private final int ownerFieldNumber;
    private int keyFieldNumber = -1;
    private int valueFieldNumber = -1;
    private final String updateFkStmt;
    private SetStore keySetStore = null;
    private SetStore valueSetStore = null;
    private SetStore entrySetStore = null;

    public FKMapStore(AbstractMemberMetaData fmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super((StoreManager)storeMgr);
        this.setOwnerMemberMetaData(fmd);
        String ownerFieldName = fmd.getMappedBy();
        MapMetaData mmd = (MapMetaData)fmd.getContainer();
        if (mmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056002", (Object)fmd.getFullFieldName()));
        }
        boolean keyStoredInValue = false;
        if (fmd.getKeyMetaData() != null && fmd.getKeyMetaData().getMappedBy() != null) {
            keyStoredInValue = true;
        } else if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() == null) {
            throw new NucleusUserException(LOCALISER.msg("056071", (Object)fmd.getFullFieldName()));
        }
        this.keyType = mmd.getKeyType();
        this.valueType = mmd.getValueType();
        Class keyClass = clr.classForName(this.keyType);
        Class valueClass = clr.classForName(this.valueType);
        ApiAdapter api = this.getStoreManager().getApiAdapter();
        if (keyStoredInValue && !api.isPersistable(valueClass)) {
            throw new NucleusUserException(LOCALISER.msg("056072", (Object)fmd.getFullFieldName(), (Object)this.valueType));
        }
        if (!keyStoredInValue && !api.isPersistable(keyClass)) {
            throw new NucleusUserException(LOCALISER.msg("056073", (Object)fmd.getFullFieldName(), (Object)this.keyType));
        }
        if (keyStoredInValue) {
            this.vmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(valueClass, clr);
            if (this.vmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056070", (Object)this.valueType, (Object)fmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.valueType, clr);
            this.valueMapping = storeMgr.getDatastoreClass(this.valueType, clr).getIDMapping();
            this.valuesAreEmbedded = false;
            this.valuesAreSerialised = false;
            if (fmd.getMappedBy() != null) {
                AbstractMemberMetaData vofmd = this.vmd.getMetaDataForMember(ownerFieldName);
                if (vofmd == null) {
                    throw new NucleusUserException(LOCALISER.msg("056067", (Object)fmd.getFullFieldName(), (Object)ownerFieldName, (Object)valueClass.getName()));
                }
                if (!clr.isAssignableFrom(vofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                    throw new NucleusUserException(LOCALISER.msg("056068", (Object)fmd.getFullFieldName(), (Object)vofmd.getFullFieldName(), (Object)vofmd.getTypeName(), (Object)fmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.vmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = this.valueTable.getFieldMapping(vofmd);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.valueType, (Object)ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new NucleusUserException(LOCALISER.msg("056055", (Object)ownerFieldName, (Object)this.valueType, (Object)vofmd.getTypeName(), (Object)fmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(fmd, 5);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("056056", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.valueType));
                }
            }
            AbstractMemberMetaData vkfmd = null;
            if ((fmd.getKeyMetaData() == null || fmd.getKeyMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056050", (Object)valueClass.getName()));
            }
            String key_field_name = fmd.getKeyMetaData().getMappedBy();
            if (key_field_name != null && (vkfmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForMember(valueClass, clr, key_field_name)) == null) {
                throw new NucleusUserException(LOCALISER.msg("056052", (Object)valueClass.getName(), (Object)key_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("056050", (Object)fmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible((Class)vkfmd.getType(), (String)this.keyType, (ClassLoaderResolver)clr)) {
                throw new NucleusUserException(LOCALISER.msg("056051", (Object)fmd.getFullFieldName(), (Object)this.keyType, (Object)vkfmd.getType().getName()));
            }
            String keyFieldName = vkfmd.getName();
            this.keyFieldNumber = this.vmd.getAbsolutePositionOfMember(keyFieldName);
            this.keyMapping = this.valueTable.getFieldMapping(this.vmd.getMetaDataForManagedMemberAtAbsolutePosition(this.keyFieldNumber));
            if (this.keyMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056053", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.valueType, (Object)keyFieldName));
            }
            if (!this.keyMapping.hasSimpleDatastoreRepresentation()) {
                throw new NucleusUserException("Invalid field type for map key field: " + fmd.getClassName() + "." + fmd.getName());
            }
            this.keysAreEmbedded = this.isEmbeddedMapping(this.keyMapping);
            this.keysAreSerialised = this.isEmbeddedMapping(this.keyMapping);
            this.mapTable = this.valueTable;
            if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.mapTable) {
                this.mapTable = this.ownerMapping.getDatastoreContainer();
            }
        } else {
            this.kmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(keyClass, clr);
            if (this.kmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056069", (Object)this.keyType, (Object)fmd.getFullFieldName()));
            }
            this.valueTable = storeMgr.getDatastoreClass(this.keyType, clr);
            this.keyMapping = storeMgr.getDatastoreClass(this.keyType, clr).getIDMapping();
            this.keysAreEmbedded = false;
            this.keysAreSerialised = false;
            if (fmd.getMappedBy() != null) {
                AbstractMemberMetaData kofmd = this.kmd.getMetaDataForMember(ownerFieldName);
                if (kofmd == null) {
                    throw new NucleusUserException(LOCALISER.msg("056067", (Object)fmd.getFullFieldName(), (Object)ownerFieldName, (Object)keyClass.getName()));
                }
                if (!ClassUtils.typesAreCompatible((Class)kofmd.getType(), (String)fmd.getAbstractClassMetaData().getFullClassName(), (ClassLoaderResolver)clr)) {
                    throw new NucleusUserException(LOCALISER.msg("056068", (Object)fmd.getFullFieldName(), (Object)kofmd.getFullFieldName(), (Object)kofmd.getTypeName(), (Object)fmd.getAbstractClassMetaData().getFullClassName()));
                }
                this.ownerFieldNumber = this.kmd.getAbsolutePositionOfMember(ownerFieldName);
                this.ownerMapping = this.valueTable.getFieldMapping(kofmd);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.InverseOwnerMappedByFieldNotPresent", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.keyType, (Object)ownerFieldName));
                }
                if (this.isEmbeddedMapping(this.ownerMapping)) {
                    throw new NucleusUserException(LOCALISER.msg("056055", (Object)ownerFieldName, (Object)this.keyType, (Object)kofmd.getTypeName(), (Object)fmd.getClassName()));
                }
            } else {
                this.ownerFieldNumber = -1;
                this.ownerMapping = this.valueTable.getExternalMapping(fmd, 5);
                if (this.ownerMapping == null) {
                    throw new NucleusUserException(LOCALISER.msg("056056", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.keyType));
                }
            }
            AbstractMemberMetaData vkfmd = null;
            if ((fmd.getValueMetaData() == null || fmd.getValueMetaData().getMappedBy() == null) && vkfmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056057", (Object)keyClass.getName()));
            }
            String value_field_name = fmd.getValueMetaData().getMappedBy();
            if (value_field_name != null && (vkfmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForMember(keyClass, clr, value_field_name)) == null) {
                throw new NucleusUserException(LOCALISER.msg("056059", (Object)keyClass.getName(), (Object)value_field_name));
            }
            if (vkfmd == null) {
                throw new ClassDefinitionException(LOCALISER.msg("056057", (Object)fmd.getFullFieldName()));
            }
            if (!ClassUtils.typesAreCompatible((Class)vkfmd.getType(), (String)this.valueType, (ClassLoaderResolver)clr)) {
                throw new NucleusUserException(LOCALISER.msg("056058", (Object)fmd.getFullFieldName(), (Object)this.valueType, (Object)vkfmd.getType().getName()));
            }
            String valueFieldName = vkfmd.getName();
            this.valueFieldNumber = this.kmd.getAbsolutePositionOfMember(valueFieldName);
            this.valueMapping = this.valueTable.getFieldMapping(this.kmd.getMetaDataForManagedMemberAtAbsolutePosition(this.valueFieldNumber));
            if (this.valueMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056054", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.keyType, (Object)valueFieldName));
            }
            if (!this.valueMapping.hasSimpleDatastoreRepresentation()) {
                throw new NucleusUserException("Invalid field type for map value field: " + fmd.getClassName() + "." + fmd.getName());
            }
            this.valuesAreEmbedded = this.isEmbeddedMapping(this.valueMapping);
            this.valuesAreSerialised = this.isEmbeddedMapping(this.valueMapping);
            this.mapTable = this.valueTable;
            if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.mapTable) {
                this.mapTable = this.ownerMapping.getDatastoreContainer();
            }
        }
        this.initialiseStatements();
        this.updateFkStmt = this.getUpdateFkStmt();
    }

    private String getUpdateFkStmt() {
        int i;
        StringBuffer stmt = new StringBuffer();
        stmt.append("UPDATE ");
        stmt.append(this.mapTable.toString());
        stmt.append(" SET ");
        for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            stmt.append(" = ");
            stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        if (this.keyFieldNumber >= 0) {
            for (i = 0; i < this.valueMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.valueMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.valueMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        } else {
            for (i = 0; i < this.keyMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.keyMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.keyMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateValueFk(StateManager sm, Object value, Object owner) {
        boolean retval;
        if (value == null) {
            return false;
        }
        this.validateValueForWriting(sm, value);
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(1, this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(1, this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.associationStrategy.populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                    }
                    jdbcPosition = this.populateValueInStatement(om, ps, value, jdbcPosition);
                    sqlControl.executeStatementUpdate(mconn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateKeyFk(StateManager sm, Object key, Object owner) {
        boolean retval;
        if (key == null) {
            return false;
        }
        this.validateKeyForWriting(sm, key);
        ObjectManager om = sm.getObjectManager();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(1, this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        } else {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(1, this.ownerMapping), null);
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.associationStrategy.populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                    }
                    jdbcPosition = this.populateKeyInStatement(om, ps, key, jdbcPosition);
                    sqlControl.executeStatementUpdate(mconn, this.updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)this.updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    protected QueryExpression getGetStatement(StateManager ownerSm, Object key) {
        ClassLoaderResolver clr = ownerSm.getObjectManager().getClassLoaderResolver();
        Class valueCls = clr.classForName(this.valueType);
        QueryExpression stmt = null;
        if (this.valueTable.getDiscriminatorMetaData() != null && this.valueTable.getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            if (ClassUtils.isReferenceType((Class)clr.classForName(this.ownerMemberMetaData.getMap().getValueType()))) {
                String[] clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.ownerMemberMetaData.getMap().getValueType(), clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, (StoreManager)this.storeMgr, true).getQueryStatement(null);
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{valueCls}, true, (StoreManager)this.storeMgr, true).getQueryStatement(null);
            }
            this.iterateUsingDiscriminator = true;
        } else {
            stmt = new UnionIteratorStatement(clr, valueCls, true, (StoreManager)this.storeMgr, valueCls, this.valueMapping, this.valueTable, false, null, true, false).getQueryStatement(null);
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.keyMapping instanceof SerialisedMapping) {
            ScalarExpression keyExpr = this.keyMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            ScalarExpression keyVal = this.keyMapping.newLiteral(stmt, key).add(this.storeMgr.getMappingManager().getMapping(String.class).newLiteral(stmt, "%"));
            stmt.andCondition(new BooleanExpression(keyExpr, ScalarExpression.OP_LIKE, keyVal), true);
        } else {
            ScalarExpression keyExpr = this.keyMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            ScalarExpression keyVal = this.keyMapping.newLiteral(stmt, key);
            stmt.andCondition(keyExpr.eq(keyVal), true);
        }
        return stmt;
    }

    protected void validateValueType(ClassLoaderResolver clr, Object value) {
        if (value == null) {
            throw new NullPointerException(LOCALISER.msg("056063"));
        }
        super.validateValueType(clr, value);
    }

    public Object put(StateManager sm, final Object newKey, Object newValue) {
        if (this.keyFieldNumber >= 0) {
            this.validateKeyForWriting(sm, newKey);
            this.validateValueType(sm.getObjectManager().getClassLoaderResolver(), newValue);
        } else {
            this.validateKeyType(sm.getObjectManager().getClassLoaderResolver(), newKey);
            this.validateValueForWriting(sm, newValue);
        }
        Object oldValue = this.get(sm, newKey);
        if (oldValue != newValue) {
            if (this.vmd != null) {
                if (oldValue != null) {
                    this.removeValue(sm, newKey, oldValue);
                }
                ObjectManager om = sm.getObjectManager();
                final Object newOwner = sm.getObject();
                if (om.getApiAdapter().isPersistent(newValue)) {
                    PersistenceCapable newValuePC = (PersistenceCapable)newValue;
                    if (om != ObjectManagerHelper.getObjectManager((Object)newValue)) {
                        throw new NucleusUserException(LOCALISER.msg("RDBMS.SCO.Map.WriteValudInvalidWithDifferentPM"), newValuePC.jdoGetObjectId());
                    }
                    StateManager vsm = om.findStateManager(newValue);
                    if (this.ownerFieldNumber >= 0) {
                        om.getApiAdapter().isLoaded(vsm, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.setObjectField(newValuePC, this.ownerFieldNumber, oldOwner, newOwner);
                    } else {
                        this.updateValueFk(sm, newValue, newOwner);
                    }
                    om.getApiAdapter().isLoaded(vsm, this.keyFieldNumber);
                    Object oldKey = vsm.provideField(this.keyFieldNumber);
                    vsm.setObjectField(newValuePC, this.keyFieldNumber, oldKey, newKey);
                } else {
                    om.persistObjectInternal(newValue, new FieldValues(){

                        public void fetchFields(StateManager vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceField(FKMapStore.this.ownerFieldNumber, newOwner, true);
                            }
                            vsm.replaceField(FKMapStore.this.keyFieldNumber, newKey, true);
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, null, -1, 0);
                    if (this.ownerFieldNumber < 0) {
                        this.updateValueFk(sm, newValue, newOwner);
                    }
                }
            } else {
                ObjectManager om = sm.getObjectManager();
                PersistenceCapable pcNewKey = (PersistenceCapable)newKey;
                final Object newOwner = sm.getObject();
                if (om.getApiAdapter().isPersistent((Object)pcNewKey)) {
                    if (om != ObjectManagerHelper.getObjectManager((Object)pcNewKey)) {
                        throw new NucleusUserException(LOCALISER.msg("056060"), om.getApiAdapter().getIdForObject((Object)pcNewKey));
                    }
                    StateManager vsm = om.findStateManager((Object)pcNewKey);
                    if (this.ownerFieldNumber >= 0) {
                        om.getApiAdapter().isLoaded(vsm, this.ownerFieldNumber);
                        Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                        vsm.setObjectField(pcNewKey, this.ownerFieldNumber, oldOwner, newOwner);
                    } else {
                        this.updateKeyFk(sm, pcNewKey, newOwner);
                    }
                    om.getApiAdapter().isLoaded(vsm, this.valueFieldNumber);
                    oldValue = vsm.provideField(this.valueFieldNumber);
                    vsm.setObjectField(pcNewKey, this.valueFieldNumber, oldValue, newValue);
                } else {
                    final Object newValueObj = newValue;
                    om.persistObjectInternal(newKey, new FieldValues(){

                        public void fetchFields(StateManager vsm) {
                            if (FKMapStore.this.ownerFieldNumber >= 0) {
                                vsm.replaceField(FKMapStore.this.ownerFieldNumber, newOwner, true);
                            }
                            vsm.replaceField(FKMapStore.this.valueFieldNumber, newValueObj, true);
                        }

                        public void fetchNonLoadedFields(StateManager sm) {
                        }

                        public FetchPlan getFetchPlanForLoading() {
                            return null;
                        }
                    }, null, -1, 0);
                    if (this.ownerFieldNumber < 0) {
                        this.updateKeyFk(sm, pcNewKey, newOwner);
                    }
                }
            }
        }
        if (this.ownerMemberMetaData.getMap().isDependentValue() && oldValue != null && !this.containsValue(sm, oldValue)) {
            sm.getObjectManager().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    public Object remove(StateManager sm, Object key) {
        Object oldValue = this.get(sm, key);
        if (this.keyFieldNumber >= 0) {
            if (oldValue != null) {
                this.removeValue(sm, key, oldValue);
                sm.getObjectManager().flushInternal(false);
            }
        } else {
            sm.getObjectManager().deleteObjectInternal(key);
        }
        if (this.ownerMemberMetaData.getMap().isDependentKey()) {
            sm.getObjectManager().deleteObjectInternal(key);
        }
        if (this.ownerMemberMetaData.getMap().isDependentValue()) {
            sm.getObjectManager().deleteObjectInternal(oldValue);
        }
        return oldValue;
    }

    private void removeValue(StateManager sm, Object key, Object oldValue) {
        ObjectManager om = sm.getObjectManager();
        if (this.keyMapping.isNullable()) {
            PersistenceCapable pcOldValue = (PersistenceCapable)oldValue;
            StateManager vsm = om.findStateManager((Object)pcOldValue);
            vsm.setObjectField(pcOldValue, this.keyFieldNumber, key, null);
            vsm.replaceField(this.keyFieldNumber, null, true);
            if (this.ownerFieldNumber >= 0) {
                Object oldOwner = vsm.provideField(this.ownerFieldNumber);
                vsm.setObjectField(pcOldValue, this.ownerFieldNumber, oldOwner, null);
                vsm.replaceField(this.ownerFieldNumber, null, true);
            } else {
                this.updateValueFk(sm, pcOldValue, null);
            }
        } else {
            om.deleteObjectInternal(oldValue);
        }
    }

    public void clear(StateManager sm) {
        Iterator iter = this.keySetStore(sm.getObjectManager().getClassLoaderResolver()).iterator(sm);
        while (iter.hasNext()) {
            this.remove(sm, iter.next());
        }
    }

    public void clearKeyOfValue(StateManager sm, Object key, Object oldValue) {
        ObjectManager om = sm.getObjectManager();
        if (this.keyMapping.isNullable()) {
            StateManager vsm = om.findStateManager(oldValue);
            PersistenceCapable oldValuePC = (PersistenceCapable)oldValue;
            if (!om.getApiAdapter().isDeleted((Object)oldValuePC)) {
                vsm.setObjectField(oldValuePC, this.keyFieldNumber, key, null);
                vsm.replaceField(this.keyFieldNumber, null, true);
                vsm.makeDirty(this.keyFieldNumber);
            }
        } else {
            om.deleteObjectInternal(oldValue);
        }
    }

    public synchronized SetStore keySetStore(ClassLoaderResolver clr) {
        return this.keySetStore == null ? new MapKeySetStore(this.valueTable, this.ownerMapping, this.keyMapping, clr, this.ownerMemberMetaData) : this.keySetStore;
    }

    public synchronized SetStore valueSetStore(ClassLoaderResolver clr) {
        return this.valueSetStore == null ? new MapValueSetStore(this.valueTable, this.ownerMapping, this.valueMapping, this, clr, this.ownerMemberMetaData) : this.valueSetStore;
    }

    public synchronized SetStore entrySetStore() {
        return this.entrySetStore == null ? new MapEntrySetStore(this.valueTable, this.ownerMapping, this.keyMapping, this.valueMapping, this) : this.entrySetStore;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass, DatastoreIdentifier candidateAlias) {
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.valueType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, candidateClass);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, clr);
        QueryExpression stmt = this.dba.newQueryStatement(candidateTable, null, clr);
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal));
        stmt.select(this.valueMapping);
        return stmt;
    }

    public ScalarExpression joinKeysTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression te, DatastoreIdentifier mapTableAlias, Class filteredKeyType, ScalarExpression kExpr, DatastoreIdentifier keyTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.keyType, filteredKeyType) && !clr.isAssignableFrom(filteredKeyType, this.keyType)) {
            throw new IncompatibleQueryElementTypeException(this.keyType, filteredKeyType.getName());
        }
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, te);
        DatastoreIdentifier containerRangeVar = mapTableAlias;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = keyTableAlias;
        }
        stmt.newTableExpression(this.mapTable, containerRangeVar);
        ScalarExpression ownerMapExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.andCondition(ownerExpr.eq(ownerMapExpr), true);
        if (!this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredKeyType.getName())) {
            DatastoreClass filteredKeyTable = this.storeMgr.getDatastoreClass(filteredKeyType.getName(), stmt.getClassLoaderResolver());
            JavaTypeMapping keyTableID = filteredKeyTable.getIDMapping();
            stmt.newTableExpression(filteredKeyTable, keyTableAlias);
            ScalarExpression keyMapExpr = this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            ScalarExpression keyExpr = keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyTableAlias));
            stmt.innerJoin(keyExpr, keyMapExpr, stmt.getTableExpression(keyTableAlias), true, true);
            return keyTableID.newScalarExpression(stmt, stmt.getTableExpression(keyTableAlias));
        }
        return this.keyMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }

    public ScalarExpression joinValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredValueType, ScalarExpression valExpr, DatastoreIdentifier valueRangeVar) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.valueType, filteredValueType) && !clr.isAssignableFrom(filteredValueType, this.valueType)) {
            throw new IncompatibleQueryElementTypeException(this.valueType, filteredValueType.getName());
        }
        DatastoreClass filteredValueTable = this.storeMgr.getDatastoreClass(filteredValueType.getName(), stmt.getClassLoaderResolver());
        stmt.newTableExpression(filteredValueTable, valueRangeVar);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        DatastoreIdentifier containerRangeVar = mapRangeVar;
        if (stmt.getTableExpression(containerRangeVar) == null) {
            containerRangeVar = valueRangeVar;
        }
        ScalarExpression ownerValueExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
        stmt.newTableExpression(this.valueTable, containerRangeVar);
        stmt.andCondition(ownerExpr.eq(ownerValueExpr), true);
        JavaTypeMapping valueTableID = filteredValueTable.getIDMapping();
        return valueTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }

    public ScalarExpression[] joinKeysValuesTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier mapRangeVar, Class filteredKeyType, Class filteredValueType, ScalarExpression keyExpr, ScalarExpression valExpr, DatastoreIdentifier keyRangeVar, DatastoreIdentifier valueRangeVar) {
        ScalarExpression[] qclKeyValues = new ScalarExpression[]{this.joinKeysTo(stmt, parentStmt, ownerMapping, ownerTe, mapRangeVar, filteredKeyType, keyExpr, keyRangeVar), this.joinValuesTo(stmt, parentStmt, ownerMapping, ownerTe, mapRangeVar, filteredValueType, valExpr, valueRangeVar)};
        return qclKeyValues;
    }
}

