/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.FetchPlan;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.OrderMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.query.DiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.rdbms.query.UnionIteratorStatement;
import org.datanucleus.store.rdbms.scostore.AbstractListStore;
import org.datanucleus.store.rdbms.scostore.BaseContainerStore;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class FKListStore
extends AbstractListStore {
    private final int ownerFieldNumber;
    private String unsetStmt;
    private String removeAtNullifyStmt;
    private String clearNullifyStmt;
    private String updateFkStmt;

    public FKListStore(AbstractMemberMetaData fmd, RDBMSManager storeMgr, ClassLoaderResolver clr) {
        super((StoreManager)storeMgr, clr);
        this.setOwnerMemberMetaData(fmd);
        CollectionMetaData colmd = fmd.getCollection();
        if (colmd == null) {
            throw new NucleusUserException(LOCALISER.msg("056001", (Object)fmd.getFullFieldName()));
        }
        this.elementType = colmd.getElementType();
        Class element_class = clr.classForName(this.elementType);
        if (ClassUtils.isReferenceType((Class)element_class)) {
            this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForImplementationOfReference(element_class, null, clr);
            if (this.emd != null) {
                this.elementType = this.emd.getFullClassName();
            }
        } else {
            this.emd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
        }
        if (this.emd == null) {
            throw new NucleusUserException(LOCALISER.msg("056003", (Object)element_class.getName(), (Object)fmd.getFullFieldName()));
        }
        this.elementInfo = this.getElementInformationForClass();
        if (this.elementInfo != null && this.elementInfo.length > 1) {
            throw new NucleusUserException(LOCALISER.msg("056031", (Object)this.ownerMemberMetaData.getFullFieldName()));
        }
        this.elementMapping = this.elementInfo[0].getDatastoreClass().getIDMapping();
        this.elementsAreEmbedded = false;
        this.elementsAreSerialised = false;
        String mappedByFieldName = fmd.getMappedBy();
        if (mappedByFieldName != null) {
            AbstractMemberMetaData eofmd = this.emd.getMetaDataForMember(mappedByFieldName);
            if (eofmd == null) {
                throw new NucleusUserException(LOCALISER.msg("056024", (Object)fmd.getFullFieldName(), (Object)mappedByFieldName, (Object)element_class.getName()));
            }
            if (!clr.isAssignableFrom(eofmd.getType(), fmd.getAbstractClassMetaData().getFullClassName())) {
                throw new NucleusUserException(LOCALISER.msg("056025", (Object)fmd.getFullFieldName(), (Object)eofmd.getFullFieldName(), (Object)eofmd.getTypeName(), (Object)fmd.getAbstractClassMetaData().getFullClassName()));
            }
            String ownerFieldName = eofmd.getName();
            this.ownerFieldNumber = this.emd.getAbsolutePositionOfMember(ownerFieldName);
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getFieldMapping(eofmd);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056029", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType, (Object)ownerFieldName));
            }
            if (this.isEmbeddedMapping(this.ownerMapping)) {
                throw new NucleusUserException(LOCALISER.msg("056026", (Object)ownerFieldName, (Object)this.elementType, (Object)eofmd.getTypeName(), (Object)fmd.getClassName()));
            }
        } else {
            this.ownerFieldNumber = -1;
            this.ownerMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 5);
            if (this.ownerMapping == null) {
                throw new NucleusUserException(LOCALISER.msg("056030", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType));
            }
        }
        this.orderMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 4);
        if (fmd.getOrderMetaData() != null && !fmd.getOrderMetaData().isIndexedList()) {
            this.indexedList = false;
        }
        if (this.orderMapping == null && this.indexedList) {
            throw new NucleusUserException(LOCALISER.msg("056041", (Object)fmd.getAbstractClassMetaData().getFullClassName(), (Object)fmd.getName(), (Object)this.elementType));
        }
        this.relationDiscriminatorMapping = this.elementInfo[0].getDatastoreClass().getExternalMapping(fmd, 6);
        if (this.relationDiscriminatorMapping != null) {
            this.relationDiscriminatorValue = fmd.getValueForExtension("relation-discriminator-value");
            if (this.relationDiscriminatorValue == null) {
                this.relationDiscriminatorValue = fmd.getFullFieldName();
            }
        }
        this.containerTable = this.elementInfo[0].getDatastoreClass();
        if (fmd.getMappedBy() != null && this.ownerMapping.getDatastoreContainer() != this.containerTable) {
            this.containerTable = this.ownerMapping.getDatastoreContainer();
        }
        this.listName = "inverseList";
    }

    protected String getSetStmt() {
        if (this.setStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            stmt.append(this.containerTable.toString());
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            this.setStmt = stmt.toString();
        }
        return this.setStmt;
    }

    protected String getUnsetStmt() {
        if (this.unsetStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            stmt.append(this.containerTable.toString());
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = NULL");
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append("=-1");
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.unsetStmt = stmt.toString();
        }
        return this.unsetStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(StateManager sm, int index, Object element, boolean allowDependentField) {
        this.validateElementForWriting(sm, element, -1);
        Object o = this.get(sm, index);
        String setStmt = this.getSetStmt();
        String unsetStmt = this.getUnsetStmt();
        try {
            ObjectManager om = sm.getObjectManager();
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, unsetStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                    if (this.orderMapping != null) {
                        jdbcPosition = this.populateOrderInStatement(om, ps, index, jdbcPosition);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, this);
                    }
                    sqlControl.executeStatementUpdate(mconn, unsetStmt, ps, true);
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
                PreparedStatement ps2 = sqlControl.getStatementForUpdate(mconn, setStmt, false);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(sm, om, ps2, jdbcPosition, this);
                    if (this.orderMapping != null) {
                        jdbcPosition = this.populateOrderInStatement(om, ps2, index, jdbcPosition);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateRelationDiscriminatorInStatement(om, ps2, jdbcPosition, this);
                    }
                    jdbcPosition = this.populateElementInStatement(om, ps2, element, jdbcPosition);
                    sqlControl.executeStatementUpdate(mconn, setStmt, ps2, true);
                }
                finally {
                    ps2.close();
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056015", (Object)setStmt), (Throwable)e);
        }
        if (this.ownerMemberMetaData.getCollection().isDependentElement() && allowDependentField && o != null) {
            sm.getObjectManager().deleteObjectInternal(o);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateElementFk(StateManager sm, Object element, Object owner, int index) {
        boolean retval;
        if (element == null) {
            return false;
        }
        ObjectManager om = sm.getObjectManager();
        String updateFkStmt = this.getUpdateFkStmt();
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(om);
            SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, updateFkStmt, false);
                try {
                    int jdbcPosition = 1;
                    if (this.elementInfo.length > 1) {
                        this.storeMgr.getDatastoreClass(element.getClass().getName(), this.clr);
                    }
                    if (owner == null) {
                        if (this.ownerMemberMetaData != null) {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), null);
                        } else {
                            this.ownerMapping.setObject(om, ps, Mappings.getParametersIndex(jdbcPosition, this.ownerMapping), null, sm, this.ownerMemberMetaData.getAbsoluteFieldNumber());
                        }
                        jdbcPosition += this.ownerMapping.getNumberOfDatastoreFields();
                    } else {
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(sm, om, ps, jdbcPosition, this);
                    }
                    if (this.orderMapping != null) {
                        jdbcPosition = this.populateOrderInStatement(om, ps, index, jdbcPosition);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, this);
                    }
                    jdbcPosition = this.populateElementInStatement(om, ps, element, jdbcPosition);
                    sqlControl.executeStatementUpdate(mconn, updateFkStmt, ps, true);
                    retval = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056027", (Object)updateFkStmt), (Throwable)e);
        }
        return retval;
    }

    private String getUpdateFkStmt() {
        if (this.updateFkStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(this.containerTable.toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(",");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.elementMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.elementMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.elementMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            this.updateFkStmt = stmt.toString();
        }
        return this.updateFkStmt;
    }

    public void update(StateManager sm, Collection coll) {
        if (coll == null || coll.isEmpty()) {
            this.clear(sm);
            return;
        }
        ArrayList existing = new ArrayList();
        Iterator elemIter = this.iterator(sm);
        while (elemIter.hasNext()) {
            Object elem = elemIter.next();
            if (!coll.contains(elem)) {
                this.remove(sm, elem, -1, true);
                continue;
            }
            existing.add(elem);
        }
        if (((Object)existing).equals(coll)) {
            return;
        }
        this.clear(sm);
        this.addAll(sm, coll, 0);
    }

    protected QueryExpression getIteratorStatement(StateManager ownerSM, int start_index, int end_index) {
        if (this.elementInfo == null) {
            return null;
        }
        ClassLoaderResolver clr = ownerSM.getObjectManager().getClassLoaderResolver();
        QueryExpression stmt = null;
        if (this.elementInfo.length == 1 && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData() != null && this.elementInfo[0].getDatastoreClass().getDiscriminatorMetaData().getStrategy() != DiscriminatorStrategy.NONE) {
            if (ClassUtils.isReferenceType((Class)clr.classForName(this.ownerMemberMetaData.getCollection().getElementType()))) {
                String[] clsNames = this.storeMgr.getOMFContext().getMetaDataManager().getClassesImplementingInterface(this.ownerMemberMetaData.getCollection().getElementType(), clr);
                Class[] cls = new Class[clsNames.length];
                for (int i = 0; i < clsNames.length; ++i) {
                    cls[i] = clr.classForName(clsNames[i]);
                }
                stmt = new DiscriminatorIteratorStatement(clr, cls, true, (StoreManager)this.storeMgr, true).getQueryStatement(null);
            } else {
                stmt = new DiscriminatorIteratorStatement(clr, new Class[]{clr.classForName(this.elementInfo[0].getClassName())}, true, (StoreManager)this.storeMgr, true).getQueryStatement(null);
            }
            this.iterateUsingDiscriminator = true;
        } else {
            for (int i = 0; i < this.elementInfo.length; ++i) {
                int elementNo = i;
                Class elementCls = clr.classForName(this.elementType);
                QueryExpression subStmt = new UnionIteratorStatement(clr, elementCls, true, (StoreManager)this.storeMgr, elementCls, this.elementMapping, this.elementInfo[elementNo].getDatastoreClass(), false, null, true, false).getQueryStatement(null);
                if (stmt == null) {
                    stmt = subStmt;
                    continue;
                }
                stmt.union(subStmt);
            }
        }
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, ownerSM.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal), true);
        if (this.relationDiscriminatorMapping != null) {
            ScalarExpression distinguisherExpr = this.relationDiscriminatorMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
            ScalarExpression distinguisherVal = this.relationDiscriminatorMapping.newLiteral(stmt, this.relationDiscriminatorValue);
            stmt.andCondition(distinguisherExpr.eq(distinguisherVal), true);
        }
        if (this.indexedList) {
            ScalarExpression indexVal;
            ScalarExpression indexExpr;
            boolean returning_range = false;
            if (start_index == -1 && end_index == -1) {
                returning_range = true;
            } else if (start_index == end_index && start_index >= 0) {
                indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
                indexVal = this.orderMapping.newLiteral(stmt, new Integer(start_index));
                stmt.andCondition(indexExpr.eq(indexVal), true);
            } else {
                returning_range = true;
                if (start_index >= 0) {
                    indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
                    indexVal = this.orderMapping.newLiteral(stmt, new Integer(start_index));
                    stmt.andCondition(indexExpr.gteq(indexVal), true);
                }
                if (end_index >= 0) {
                    indexExpr = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
                    indexVal = this.orderMapping.newLiteral(stmt, new Integer(end_index));
                    stmt.andCondition(indexExpr.lt(indexVal), true);
                }
            }
            if (returning_range) {
                ScalarExpression[] exprIndex = new ScalarExpression[this.orderMapping.getNumberOfDatastoreFields()];
                boolean[] descendingOrder = new boolean[this.orderMapping.getNumberOfDatastoreFields()];
                exprIndex = this.orderMapping.newScalarExpression(stmt, stmt.getMainTableExpression()).getExpressionList().toArray();
                stmt.setOrdering(exprIndex, descendingOrder);
            }
        } else {
            DatastoreClass elementTbl = this.elementInfo[0].getDatastoreClass();
            OrderMetaData.FieldOrder[] orderComponents = this.ownerMemberMetaData.getOrderMetaData().getFieldOrders();
            for (int i = 0; i < orderComponents.length; ++i) {
                String fieldName = orderComponents[i].getFieldName();
                JavaTypeMapping fieldMapping = elementTbl.getFieldMapping(this.elementInfo[0].getAbstractClassMetaData().getMetaDataForMember(fieldName));
                ScalarExpression[] exprIndex = new ScalarExpression[fieldMapping.getNumberOfDatastoreFields()];
                boolean[] descendingOrder = new boolean[fieldMapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < descendingOrder.length; ++j) {
                    descendingOrder[j] = !orderComponents[i].isForward();
                }
                exprIndex = fieldMapping.newScalarExpression(stmt, stmt.getMainTableExpression()).getExpressionList().toArray();
                stmt.setOrdering(exprIndex, descendingOrder);
            }
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalAdd(StateManager sm, int startAt, boolean atEnd, Collection c, int size) {
        if (c == null || c.size() == 0) {
            return true;
        }
        int currentListSize = 0;
        currentListSize = size < 0 ? this.size(sm) : size;
        boolean shiftingElements = true;
        if (atEnd || startAt == currentListSize) {
            shiftingElements = false;
            startAt = currentListSize;
        }
        boolean elementsNeedPositioning = false;
        int position = startAt;
        Iterator elementIter = c.iterator();
        while (elementIter.hasNext()) {
            boolean inserted;
            if (shiftingElements) {
                position = -1;
            }
            if (!(inserted = this.validateElementForWriting(sm, elementIter.next(), position)) || shiftingElements) {
                elementsNeedPositioning = true;
            }
            if (shiftingElements) continue;
            ++position;
        }
        if (shiftingElements) {
            try {
                ObjectManager om = sm.getObjectManager();
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                int shift = c.size();
                try {
                    for (int i = currentListSize - 1; i >= startAt; --i) {
                        this.internalShift(sm, mconn, false, i, shift, true);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)this.getShiftStmt()), (Throwable)e);
            }
        }
        if (shiftingElements || elementsNeedPositioning) {
            for (Object element : c) {
                this.updateElementFk(sm, element, sm.getObject(), startAt);
                ++startAt;
            }
        }
        return true;
    }

    protected String getRemoveAtNullifyStmt() {
        if (this.removeAtNullifyStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(this.containerTable.toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=NULL");
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(", ");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=-1");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.orderMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.removeAtNullifyStmt = stmt.toString();
        }
        return this.removeAtNullifyStmt;
    }

    protected boolean internalRemove(StateManager sm, Object element, int size) {
        if (this.indexedList) {
            int index = this.indexOf(sm, element);
            if (index == -1) {
                return false;
            }
            this.removeAt(sm, index, size);
        } else if (this.ownerMapping.isNullable()) {
            ObjectManager om = sm.getObjectManager();
            StateManager elementSM = om.findStateManager(element);
            if (this.ownerMemberMetaData.getRelationType(this.clr) == 4 && om.getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships")) {
                elementSM.replaceField(this.ownerMemberMetaData.getRelatedMemberMetaData(this.clr)[0].getAbsoluteFieldNumber(), null, true);
                if (sm.getObjectManager().isFlushing()) {
                    elementSM.flush();
                }
            } else {
                this.updateElementFk(sm, element, null, -1);
            }
        } else {
            sm.getObjectManager().deleteObjectInternal(element);
        }
        return true;
    }

    protected void manageRemovalOfElement(StateManager ownerSM, Object element) {
    }

    protected void removeAt(StateManager sm, int index, int size) {
        String stmt = null;
        if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056043"));
            stmt = this.getRemoveAtNullifyStmt();
        } else {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056042"));
            stmt = this.getRemoveAtStmt();
        }
        this.internalRemoveAt(sm, index, stmt, size);
    }

    protected String getClearNullifyStmt() {
        if (this.clearNullifyStmt == null) {
            int i;
            StringBuffer stmt = new StringBuffer();
            stmt.append("UPDATE ");
            if (this.elementInfo.length > 1) {
                stmt.append("?");
            } else {
                stmt.append(this.containerTable.toString());
            }
            stmt.append(" SET ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(", ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=NULL");
            }
            if (this.orderMapping != null) {
                for (i = 0; i < this.orderMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(", ");
                    stmt.append(((Object)this.orderMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString() + "=-1");
                }
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(", ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append("=NULL");
                }
            }
            stmt.append(" WHERE ");
            for (i = 0; i < this.ownerMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    stmt.append(" AND ");
                }
                stmt.append(((Object)this.ownerMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                stmt.append(" = ");
                stmt.append(((RDBMSMapping)this.ownerMapping.getDataStoreMapping(i)).getUpdateInputParameter());
            }
            if (this.relationDiscriminatorMapping != null) {
                for (i = 0; i < this.relationDiscriminatorMapping.getNumberOfDatastoreFields(); ++i) {
                    stmt.append(" AND ");
                    stmt.append(((Object)this.relationDiscriminatorMapping.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
                    stmt.append(" = ");
                    stmt.append(((RDBMSMapping)this.relationDiscriminatorMapping.getDataStoreMapping(i)).getUpdateInputParameter());
                }
            }
            this.clearNullifyStmt = stmt.toString();
        }
        return this.clearNullifyStmt;
    }

    protected String getSizeStmt() {
        return this.getRDBMSAssociationStrategy().getSizeStmt(this);
    }

    protected String getContainsStmt() {
        return super.getContainsStmt();
    }

    protected String getClearStmt() {
        return this.getRDBMSAssociationStrategy().getClearStmt(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(StateManager ownerSM) {
        boolean deleteElements = false;
        ObjectManager om = ownerSM.getObjectManager();
        if (this.ownerMemberMetaData.getCollection().isDependentElement()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056034"));
            deleteElements = true;
        } else if (this.ownerMapping.isNullable() && this.orderMapping == null) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056036"));
            deleteElements = false;
        } else if (this.ownerMapping.isNullable() && this.orderMapping != null && this.orderMapping.isNullable()) {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056036"));
            deleteElements = false;
        } else {
            NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("056035"));
            deleteElements = true;
        }
        if (deleteElements) {
            Iterator elementsIter = this.iterator(ownerSM);
            if (elementsIter != null) {
                while (elementsIter.hasNext()) {
                    Object element = elementsIter.next();
                    if (om.getApiAdapter().isPersistable(element) && om.getApiAdapter().isDeleted(element)) {
                        StateManager objSM = om.findStateManager(element);
                        objSM.flush();
                        continue;
                    }
                    om.deleteObjectInternal(element);
                }
            }
        } else {
            String clearNullifyStmt = this.getClearNullifyStmt();
            try {
                ManagedConnection mconn = this.storeMgr.getConnection(om);
                SQLController sqlControl = this.getRDBMSAssociationStrategy().getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, clearNullifyStmt, false);
                    try {
                        int jdbcPosition = 1;
                        jdbcPosition = this.getRDBMSAssociationStrategy().populateOwnerInStatement(ownerSM, om, ps, jdbcPosition, this);
                        if (this.relationDiscriminatorMapping != null) {
                            jdbcPosition = this.getRDBMSAssociationStrategy().populateRelationDiscriminatorInStatement(om, ps, jdbcPosition, this);
                        }
                        sqlControl.executeStatementUpdate(mconn, clearNullifyStmt, ps, true);
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("056013", (Object)clearNullifyStmt), (Throwable)e);
            }
        }
    }

    protected boolean validateElementForWriting(final StateManager sm, Object element, final int index) {
        final Object newOwner = sm.getObject();
        boolean inserted = super.validateElementForWriting(sm, element, new FieldValues(){

            public void fetchFields(StateManager esm) {
                boolean isPersistentInterface = FKListStore.this.storeMgr.getOMFContext().getMetaDataManager().isPersistentInterface(FKListStore.this.elementType);
                DatastoreClass elementTable = null;
                elementTable = isPersistentInterface ? FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.storeMgr.getOMFContext().getMetaDataManager().getImplementationNameForPersistentInterface(FKListStore.this.elementType), FKListStore.this.clr) : FKListStore.this.storeMgr.getDatastoreClass(FKListStore.this.elementType, FKListStore.this.clr);
                if (elementTable == null) {
                    AbstractClassMetaData[] managingCmds = FKListStore.this.storeMgr.getClassesManagingTableForClass(FKListStore.this.emd, FKListStore.this.clr);
                    if (managingCmds != null && managingCmds.length == 1) {
                        elementTable = FKListStore.this.storeMgr.getDatastoreClass(managingCmds[0].getFullClassName(), FKListStore.this.clr);
                    } else {
                        throw new NucleusUserException("Field " + FKListStore.this.ownerMemberMetaData.getFullFieldName() + " is a List with element using subclass-table strategy BUT there are more than 1 subclass with table. This is not yet supported by JPOX");
                    }
                }
                if (elementTable != null) {
                    JavaTypeMapping externalFKMapping = elementTable.getExternalMapping(FKListStore.this.ownerMemberMetaData, 5);
                    if (externalFKMapping != null) {
                        esm.setAssociatedValue((Object)externalFKMapping, sm.getObject());
                    }
                    if (FKListStore.this.relationDiscriminatorMapping != null) {
                        esm.setAssociatedValue((Object)FKListStore.this.relationDiscriminatorMapping, (Object)FKListStore.this.relationDiscriminatorValue);
                    }
                    if (FKListStore.this.orderMapping != null && index >= 0) {
                        if (FKListStore.this.ownerMemberMetaData.getOrderMetaData() != null && FKListStore.this.ownerMemberMetaData.getOrderMetaData().getMappedBy() != null) {
                            Number indexValue = null;
                            indexValue = FKListStore.this.orderMapping.getFieldMetaData().getTypeName().equals(ClassNameConstants.JAVA_LANG_LONG) || FKListStore.this.orderMapping.getFieldMetaData().getTypeName().equals(ClassNameConstants.LONG) ? (Number)new Long(index) : (Number)new Integer(index);
                            esm.replaceField(FKListStore.this.orderMapping.getFieldMetaData().getAbsoluteFieldNumber(), (Object)indexValue, true);
                        } else {
                            esm.setAssociatedValue((Object)FKListStore.this.orderMapping, (Object)new Integer(index));
                        }
                    }
                }
                if (FKListStore.this.ownerFieldNumber >= 0 && sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getBooleanProperty("datanucleus.manageRelationships")) {
                    Object currentOwner = esm.provideField(FKListStore.this.ownerFieldNumber);
                    if (currentOwner == null) {
                        NucleusLogger.JDO.info((Object)BaseContainerStore.LOCALISER.msg("056037", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)FKListStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)esm.getObject())));
                        esm.replaceField(FKListStore.this.ownerFieldNumber, newOwner, true);
                    } else if (currentOwner != newOwner && sm.getReferencedPC() == null) {
                        throw new NucleusUserException(BaseContainerStore.LOCALISER.msg("056038", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)FKListStore.this.ownerMemberMetaData.getFullFieldName(), (Object)StringUtils.toJVMIDString((Object)esm.getObject()), (Object)StringUtils.toJVMIDString((Object)currentOwner)));
                    }
                }
            }

            public void fetchNonLoadedFields(StateManager sm2) {
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        });
        return inserted;
    }

    public QueryExpression newQueryStatement(StateManager sm, String candidateClass, DatastoreIdentifier candidateAlias) {
        if (!sm.getObjectManager().getClassLoaderResolver().isAssignableFrom(this.elementType, candidateClass)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, candidateClass);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreClass candidateTable = this.storeMgr.getDatastoreClass(candidateClass, clr);
        QueryExpression stmt = this.dba.newQueryStatement(candidateTable, null, clr);
        ScalarExpression ownerExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression ownerVal = this.ownerMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(ownerExpr.eq(ownerVal));
        stmt.select(this.elementMapping);
        return stmt;
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier listTableAlias, Class filteredElementType, ScalarExpression elementExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        ScalarExpression ownerExpr;
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType)) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        DatastoreClass filteredElementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), clr);
        if (stmt.getTableExpression(elementTableAlias) == null) {
            stmt.newTableExpression(filteredElementTable, elementTableAlias);
        }
        DatastoreIdentifier containerRangeVar = listTableAlias;
        if (existsQuery) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
        } else if (parentStmt != stmt) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        } else if (elementExpr.getLogicSetExpression().getMainTable() == filteredElementTable) {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                containerRangeVar = elementTableAlias;
            }
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        } else {
            if (stmt.getTableExpression(containerRangeVar) == null) {
                stmt.newTableExpression(this.containerTable, containerRangeVar);
            }
            ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
            ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
            stmt.innerJoin(ownerExpr, ownerSetExpr, stmt.getTableExpression(containerRangeVar), true, true);
        }
        JavaTypeMapping elementTableID = filteredElementTable.getIDMapping();
        return elementTableID.newScalarExpression(stmt, stmt.getTableExpression(containerRangeVar));
    }
}

