/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.state.ActivityState;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.RDBMSAdapter;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.SecondaryTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class InsertRequest
extends Request {
    private static final int IDPARAMNUMBER = 1;
    private final MappingCallbacks[] callbacks;
    private final int[] insertFieldNumbers;
    private final int[] pkFieldNumbers;
    private final int[] reachableFieldNumbers;
    private final int[] relationFieldNumbers;
    private final String insertStmt;
    private boolean hasIdentityColumn = false;
    private StatementExpressionIndex[] statementExpressionIndex;
    private StatementExpressionIndex[] retrievedStatementExpressionIndex;
    private StatementExpressionIndex versionStatementExpressionIndex;
    private StatementExpressionIndex discriminatorStatementExpressionIndex;
    private StatementExpressionIndex[] externalFKStatementExpressionIndex;
    private StatementExpressionIndex[] externalFKDiscrimStatementExpressionIndex;
    private StatementExpressionIndex[] externalOrderStatementExpressionIndex;
    private boolean batch = false;

    public InsertRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        super(table);
        AbstractClassMetaData cmd = table.getStoreManager().getOMFContext().getMetaDataManager().getMetaDataForClass(cls, clr);
        InsertMappingConsumer consumer = new InsertMappingConsumer(clr, cmd, 1);
        table.provideDatastoreIdMappings(consumer);
        table.provideNonPrimaryKeyMappings(consumer);
        table.providePrimaryKeyMappings(consumer);
        table.provideVersionMappings(consumer);
        table.provideDiscriminatorMappings(consumer);
        table.provideExternalMappings(consumer, 5);
        table.provideExternalMappings(consumer, 6);
        table.provideExternalMappings(consumer, 4);
        table.provideUnmappedDatastoreFields(consumer);
        this.callbacks = consumer.getMappingCallbacks().toArray(new MappingCallbacks[consumer.getMappingCallbacks().size()]);
        this.statementExpressionIndex = consumer.getStatementExpressionIndex();
        this.versionStatementExpressionIndex = consumer.getVersionStatementExpressionIndex();
        this.discriminatorStatementExpressionIndex = consumer.getDiscriminatorStatementExpressionIndex();
        this.externalFKStatementExpressionIndex = consumer.getExternalFKStatementExpressionIndex();
        this.externalFKDiscrimStatementExpressionIndex = consumer.getExternalFKDiscrimStatementExpressionIndex();
        this.externalOrderStatementExpressionIndex = consumer.getExternalOrderStatementExpressionIndex();
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
        if (table.getIdentityType() == IdentityType.APPLICATION && this.pkFieldNumbers.length < 1 && !this.hasIdentityColumn) {
            throw new NucleusException(LOCALISER.msg("052200", (Object)cmd.getFullClassName())).setFatal();
        }
        this.insertFieldNumbers = consumer.getInsertFieldNumbers();
        this.retrievedStatementExpressionIndex = consumer.getReachableStatementIndex();
        this.reachableFieldNumbers = consumer.getReachableFieldNumbers();
        this.relationFieldNumbers = consumer.getRelationFieldNumbers();
        this.insertStmt = consumer.getInsertStmt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052207", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.table));
        }
        try {
            VersionMetaData vermd = this.table.getVersionMetaData();
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            if (vermd != null && vermd.getFieldName() != null) {
                AbstractMemberMetaData verfmd = ((AbstractClassMetaData)vermd.getParent()).getMetaDataForMember(vermd.getFieldName());
                Object currentVersion = om.getApiAdapter().getVersion(sm);
                if (currentVersion instanceof Integer) {
                    currentVersion = new Long(((Integer)currentVersion).longValue());
                }
                Object nextOptimisticVersion = this.table.getVersionMetaData().getNextVersion(currentVersion);
                if (verfmd.getType() == Integer.class || verfmd.getType() == Integer.TYPE) {
                    nextOptimisticVersion = new Integer(((Long)nextOptimisticVersion).intValue());
                }
                sm.replaceField(verfmd.getAbsoluteFieldNumber(), nextOptimisticVersion, false);
            }
            sm.changeActivityState(ActivityState.INSERTING);
            SQLController sqlControl = storeMgr.getSQLController();
            ManagedConnection mconn = storeMgr.getConnection(om);
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, this.insertStmt, this.batch);
                try {
                    int i;
                    Object nextOptimisticVersion;
                    if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                        if (!this.table.isObjectIDDatastoreAttributed() || !this.table.isBaseDatastoreClass()) {
                            int[] paramNumber = new int[]{1};
                            this.table.getDataStoreObjectIdMapping().setObject(om, ps, paramNumber, sm.getInternalObjectId());
                        }
                    } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                        sm.provideFields(this.pkFieldNumbers, (FieldManager)new ParameterSetter(sm, ps, this.statementExpressionIndex, true));
                    }
                    int numberOfFieldsToProvide = 0;
                    for (int i2 = 0; i2 < this.insertFieldNumbers.length; ++i2) {
                        if (this.insertFieldNumbers[i2] >= sm.getHighestFieldNumber()) continue;
                        ++numberOfFieldsToProvide;
                    }
                    int j = 0;
                    int[] classFieldNumbers = new int[numberOfFieldsToProvide];
                    for (int i3 = 0; i3 < this.insertFieldNumbers.length; ++i3) {
                        if (this.insertFieldNumbers[i3] < sm.getHighestFieldNumber()) {
                            classFieldNumbers[j++] = this.insertFieldNumbers[i3];
                            continue;
                        }
                        StatementExpressionIndex stmtExprIndex = this.statementExpressionIndex[this.insertFieldNumbers[i3]];
                        stmtExprIndex.getMapping().setDefault(om, ps, stmtExprIndex.getParameterIndex());
                    }
                    sm.provideFields(classFieldNumbers, (FieldManager)new ParameterSetter(sm, ps, this.statementExpressionIndex, true));
                    if (this.table.getVersionMapping(false) != null) {
                        Object currentVersion = om.getApiAdapter().getVersion(sm);
                        nextOptimisticVersion = this.table.getVersionMetaData().getNextVersion(currentVersion);
                        this.table.getVersionMapping(false).setObject(om, ps, this.versionStatementExpressionIndex.getParameterIndex(), nextOptimisticVersion);
                        sm.setTransactionalVersion(nextOptimisticVersion);
                    } else if (vermd != null && vermd.getFieldName() != null) {
                        Object currentVersion = om.getApiAdapter().getVersion(sm);
                        nextOptimisticVersion = this.table.getVersionMetaData().getNextVersion(currentVersion);
                        sm.setTransactionalVersion(nextOptimisticVersion);
                    }
                    if (this.table.getDiscriminatorMapping(false) != null) {
                        DiscriminatorMetaData dismd = this.table.getDiscriminatorMetaData();
                        if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                            this.table.getDiscriminatorMapping(false).setObject(om, ps, this.discriminatorStatementExpressionIndex.getParameterIndex(), sm.getObject().getClass().getName());
                        } else if (dismd.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                            dismd = sm.getClassMetaData().getInheritanceMetaData().getDiscriminatorMetaData();
                            this.table.getDiscriminatorMapping(false).setObject(om, ps, this.discriminatorStatementExpressionIndex.getParameterIndex(), dismd.getValue());
                        }
                    }
                    if (this.externalFKStatementExpressionIndex != null) {
                        for (int i4 = 0; i4 < this.externalFKStatementExpressionIndex.length; ++i4) {
                            Object fkValue = sm.getAssociatedValue((Object)this.externalFKStatementExpressionIndex[i4].getMapping());
                            if (fkValue != null) {
                                AbstractMemberMetaData ownerFmd = this.table.getMetaDataForExternalMapping(this.externalFKStatementExpressionIndex[i4].getMapping(), 5);
                                this.externalFKStatementExpressionIndex[i4].getMapping().setObject(om, ps, this.externalFKStatementExpressionIndex[i4].getParameterIndex(), fkValue, null, ownerFmd.getAbsoluteFieldNumber());
                                continue;
                            }
                            this.externalFKStatementExpressionIndex[i4].getMapping().setObject(om, ps, this.externalFKStatementExpressionIndex[i4].getParameterIndex(), null);
                        }
                    }
                    if (this.externalFKDiscrimStatementExpressionIndex != null) {
                        for (int i5 = 0; i5 < this.externalFKDiscrimStatementExpressionIndex.length; ++i5) {
                            Object discrimValue = sm.getAssociatedValue((Object)this.externalFKDiscrimStatementExpressionIndex[i5].getMapping());
                            this.externalFKDiscrimStatementExpressionIndex[i5].getMapping().setObject(om, ps, this.externalFKDiscrimStatementExpressionIndex[i5].getParameterIndex(), discrimValue);
                        }
                    }
                    if (this.externalOrderStatementExpressionIndex != null) {
                        for (int i6 = 0; i6 < this.externalOrderStatementExpressionIndex.length; ++i6) {
                            Object orderValue = sm.getAssociatedValue((Object)this.externalOrderStatementExpressionIndex[i6].getMapping());
                            if (orderValue == null) {
                                orderValue = new Integer(-1);
                            }
                            this.externalOrderStatementExpressionIndex[i6].getMapping().setObject(om, ps, this.externalOrderStatementExpressionIndex[i6].getParameterIndex(), orderValue);
                        }
                    }
                    sqlControl.executeStatementUpdate(mconn, this.insertStmt, ps, !this.batch);
                    if (this.hasIdentityColumn) {
                        Object newId = this.getInsertedDatastoreIdentity(om, sqlControl, sm, mconn, ps);
                        if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("052206", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), newId));
                        }
                        sm.setPostStoreNewObjectId(newId);
                    }
                    storeMgr.setObjectIsInsertedToLevel(sm, this.table);
                    for (int i7 = 0; i7 < this.relationFieldNumbers.length; ++i7) {
                        Object value = sm.provideField(this.relationFieldNumbers[i7]);
                        if (value == null || !om.getApiAdapter().isDetached(value)) continue;
                        Object valueAttached = om.persistObjectInternal(value, null, null, -1, 0);
                        sm.replaceField(this.relationFieldNumbers[i7], valueAttached, false);
                    }
                    int numberOfReachableFields = 0;
                    for (i = 0; i < this.reachableFieldNumbers.length; ++i) {
                        if (this.reachableFieldNumbers[i] >= sm.getHighestFieldNumber()) continue;
                        ++numberOfReachableFields;
                    }
                    classFieldNumbers = new int[numberOfReachableFields];
                    j = 0;
                    for (i = 0; i < this.reachableFieldNumbers.length; ++i) {
                        if (this.reachableFieldNumbers[i] < sm.getHighestFieldNumber()) {
                            classFieldNumbers[j++] = this.reachableFieldNumbers[i];
                            continue;
                        }
                        StatementExpressionIndex stmtExprIndex = this.retrievedStatementExpressionIndex[this.reachableFieldNumbers[i]];
                        stmtExprIndex.getMapping().setDefault(om, ps, stmtExprIndex.getParameterIndex());
                    }
                    sm.provideFields(classFieldNumbers, (FieldManager)new ParameterSetter(sm, ps, this.retrievedStatementExpressionIndex, true));
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            String msg = LOCALISER.msg("052208", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)this.insertStmt, (Object)e.getMessage());
            NucleusLogger.DATASTORE_PERSIST.warn((Object)msg);
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            exceptions.add(e);
            while ((e = e.getNextException()) != null) {
                exceptions.add(e);
            }
            throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            try {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052209", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getFullFieldName()));
                }
                this.callbacks[i].postInsert(sm);
                continue;
            }
            catch (NotYetFlushedException e) {
                sm.updateFieldAfterInsert(e.getPersistable(), ((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getAbsoluteFieldNumber());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInsertedDatastoreIdentity(ObjectManager om, SQLController sqlControl, StateManager sm, ManagedConnection mconn, PreparedStatement ps) throws SQLException {
        Object datastoreId = null;
        MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        if (((RDBMSAdapter)storeMgr.getDatastoreAdapter()).supportsOption("GetGeneratedKeysStatement")) {
            ResultSet rs = null;
            try {
                rs = ps.getGeneratedKeys();
                if (rs != null && rs.next()) {
                    datastoreId = rs.getObject(1);
                }
            }
            catch (Throwable e) {
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        if (datastoreId == null) {
            String columnName = null;
            JavaTypeMapping idMapping = this.table.getIDMapping();
            if (idMapping != null) {
                for (int i = 0; i < idMapping.getNumberOfDatastoreFields(); ++i) {
                    Column col = (Column)idMapping.getDataStoreMapping(i).getDatastoreField();
                    if (!col.isIdentity()) continue;
                    columnName = ((Object)col.getIdentifier()).toString();
                    break;
                }
            }
            String autoIncStmt = ((RDBMSAdapter)storeMgr.getDatastoreAdapter()).getAutoIncrementStmt((Table)((Object)this.table), columnName);
            PreparedStatement psAutoIncrement = sqlControl.getStatementForQuery(mconn, autoIncStmt);
            ResultSet rs = null;
            try {
                rs = sqlControl.executeStatementQuery(mconn, autoIncStmt, psAutoIncrement);
                if (rs.next()) {
                    datastoreId = rs.getObject(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (psAutoIncrement != null) {
                    psAutoIncrement.close();
                }
            }
        }
        if (datastoreId == null) {
            throw new NucleusDataStoreException(LOCALISER.msg("052205", (Object)this.table));
        }
        return datastoreId;
    }

    private class InsertMappingConsumer
    implements MappingConsumer {
        List insertFields = new ArrayList();
        List pkFields = new ArrayList();
        List reachableFields = new ArrayList();
        List relationFields = new ArrayList();
        StringBuffer columnNames = new StringBuffer();
        StringBuffer columnValues = new StringBuffer();
        Map assignedColumns = new HashMap();
        List mc = new ArrayList();
        boolean initialized = false;
        int paramIndex;
        private StatementExpressionIndex[] statementExpressionIndex;
        private StatementExpressionIndex[] retrievedStatementExpressionIndex;
        private StatementExpressionIndex versionStatementExpressionIndex;
        private StatementExpressionIndex discriminatorStatementExpressionIndex;
        private StatementExpressionIndex[] externalFKStmtExprIndex;
        private StatementExpressionIndex[] externalFKDiscrimStmtExprIndex;
        private StatementExpressionIndex[] externalOrderStmtExprIndex;
        private final ClassLoaderResolver clr;
        private final AbstractClassMetaData cmd;

        public InsertMappingConsumer(ClassLoaderResolver clr, AbstractClassMetaData cmd, int initialParamIndex) {
            this.clr = clr;
            this.cmd = cmd;
            this.paramIndex = initialParamIndex;
        }

        public void preConsumeMapping(int highestFieldNumber) {
            if (!this.initialized) {
                this.statementExpressionIndex = new StatementExpressionIndex[highestFieldNumber];
                this.retrievedStatementExpressionIndex = new StatementExpressionIndex[highestFieldNumber];
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            block22: {
                int relationType;
                block23: {
                    int relationType2;
                    block24: {
                        if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                            return;
                        }
                        if (!m.includeInInsertStatement()) break block22;
                        if (m.getNumberOfDatastoreFields() != 0 || !(m instanceof PersistenceCapableMapping) && !(m instanceof ReferenceMapping)) break block23;
                        this.retrievedStatementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                        this.retrievedStatementExpressionIndex[fmd.getAbsoluteFieldNumber()].setMapping(m);
                        relationType2 = fmd.getRelationType(this.clr);
                        if (relationType2 != 2) break block24;
                        if (fmd.getMappedBy() != null) {
                            this.reachableFields.add(new Integer(fmd.getAbsoluteFieldNumber()));
                        }
                        break block22;
                    }
                    if (relationType2 != 6) break block22;
                    AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                    if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) break block22;
                    this.reachableFields.add(new Integer(fmd.getAbsoluteFieldNumber()));
                    break block22;
                }
                if (fmd.hasExtension("insertable") && fmd.getValueForExtension("insertable").equalsIgnoreCase("false")) {
                    return;
                }
                ColumnMetaData[] colmds = fmd.getColumnMetaData();
                if (colmds != null && colmds.length > 0) {
                    for (int i = 0; i < colmds.length; ++i) {
                        if (colmds[i].getInsertable()) continue;
                        return;
                    }
                }
                if ((relationType = fmd.getRelationType(this.clr)) == 2) {
                    if (fmd.getMappedBy() == null) {
                        // empty if block
                    }
                } else if (relationType == 6) {
                    AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(this.clr);
                    if (fmd.getJoinMetaData() == null && relatedMmds[0].getJoinMetaData() == null) {
                        this.relationFields.add(new Integer(fmd.getAbsoluteFieldNumber()));
                    }
                }
                this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
                this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setMapping(m);
                int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                for (int j = 0; j < parametersIndex.length; ++j) {
                    Column c = (Column)m.getDataStoreMapping(j).getDatastoreField();
                    DatastoreIdentifier columnId = c.getIdentifier();
                    if (!this.assignedColumns.containsKey(((Object)columnId).toString())) {
                        if (InsertRequest.this.table instanceof SecondaryTable || !InsertRequest.this.table.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false) && !c.isIdentity() || !InsertRequest.this.table.isBaseDatastoreClass()) {
                            if (this.columnNames.length() > 0) {
                                this.columnNames.append(',');
                                this.columnValues.append(',');
                            }
                            this.columnNames.append(columnId);
                            this.columnValues.append(((RDBMSMapping)m.getDataStoreMapping(j)).getInsertionInputParameter());
                            if (((RDBMSMapping)m.getDataStoreMapping(j)).insertValuesOnInsert()) {
                                Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                                if (fmd.isPrimaryKey()) {
                                    if (!this.pkFields.contains(abs_field_num)) {
                                        this.pkFields.add(abs_field_num);
                                    }
                                } else if (!this.insertFields.contains(abs_field_num)) {
                                    this.insertFields.add(abs_field_num);
                                }
                                ++this.paramIndex;
                            }
                            this.assignedColumns.put(((Object)c.getIdentifier()).toString(), new Integer(fmd.getAbsoluteFieldNumber()));
                        } else {
                            InsertRequest.this.hasIdentityColumn = true;
                        }
                    } else {
                        parametersIndex[j] = (Integer)this.assignedColumns.get(((Object)c.getIdentifier()).toString());
                    }
                    this.statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setParameterIndex(parametersIndex);
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                if (InsertRequest.this.table.getVersionMapping(false) != null) {
                    String val = ((RDBMSMapping)InsertRequest.this.table.getVersionMapping(false).getDataStoreMapping(0)).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(((Column)InsertRequest.this.table.getVersionMapping(false).getDataStoreMapping(0).getDatastoreField()).getIdentifier());
                    this.columnValues.append(val);
                    this.versionStatementExpressionIndex = new StatementExpressionIndex();
                    this.versionStatementExpressionIndex.setMapping(InsertRequest.this.table.getVersionMapping(false));
                    int[] param = new int[]{this.paramIndex++};
                    this.versionStatementExpressionIndex.setParameterIndex(param);
                } else {
                    this.versionStatementExpressionIndex = null;
                }
            } else if (mappingType == 3) {
                if (InsertRequest.this.table.getDiscriminatorMapping(false) != null) {
                    String val = ((RDBMSMapping)InsertRequest.this.table.getDiscriminatorMapping(false).getDataStoreMapping(0)).getUpdateInputParameter();
                    if (this.columnNames.length() > 0) {
                        this.columnNames.append(',');
                        this.columnValues.append(',');
                    }
                    this.columnNames.append(((Column)InsertRequest.this.table.getDiscriminatorMapping(false).getDataStoreMapping(0).getDatastoreField()).getIdentifier());
                    this.columnValues.append(val);
                    this.discriminatorStatementExpressionIndex = new StatementExpressionIndex();
                    this.discriminatorStatementExpressionIndex.setMapping(InsertRequest.this.table.getDiscriminatorMapping(false));
                    int[] param = new int[]{this.paramIndex++};
                    this.discriminatorStatementExpressionIndex.setParameterIndex(param);
                } else {
                    this.discriminatorStatementExpressionIndex = null;
                }
            } else if (mappingType == 2) {
                if (InsertRequest.this.table.getIdentityType() == IdentityType.DATASTORE) {
                    if (!InsertRequest.this.table.isObjectIDDatastoreAttributed() || !InsertRequest.this.table.isBaseDatastoreClass()) {
                        Iterator iterator = InsertRequest.this.key.getColumns().iterator();
                        if (this.columnNames.length() > 0) {
                            this.columnNames.append(',');
                            this.columnValues.append(',');
                        }
                        this.columnNames.append(((Object)((Column)iterator.next()).getIdentifier()).toString());
                        this.columnValues.append("?");
                        ++this.paramIndex;
                    } else {
                        InsertRequest.this.hasIdentityColumn = true;
                    }
                }
            } else if (mappingType == 5) {
                this.externalFKStmtExprIndex = this.processExternalMapping(m, this.statementExpressionIndex, this.externalFKStmtExprIndex);
            } else if (mappingType == 6) {
                this.externalFKDiscrimStmtExprIndex = this.processExternalMapping(m, this.statementExpressionIndex, this.externalFKDiscrimStmtExprIndex);
            } else if (mappingType == 4) {
                this.externalOrderStmtExprIndex = this.processExternalMapping(m, this.statementExpressionIndex, this.externalOrderStmtExprIndex);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
            if (this.columnNames.length() > 0) {
                this.columnNames.append(',');
                this.columnValues.append(',');
            }
            Column col = (Column)fld;
            this.columnNames.append(fld.getIdentifier());
            ColumnMetaData colmd = col.getColumnMetaData();
            String value = colmd.getInsertValue();
            if (colmd.getJdbcType().equals("VARCHAR") || colmd.getJdbcType().equals("CHAR")) {
                value = "\"" + value + "\"";
            }
            this.columnValues.append(value);
        }

        private StatementExpressionIndex[] processExternalMapping(JavaTypeMapping mapping, StatementExpressionIndex[] fieldStmtExprIndex, StatementExpressionIndex[] stmtExprIndex) {
            int i;
            for (int i2 = 0; i2 < fieldStmtExprIndex.length; ++i2) {
                if (fieldStmtExprIndex[i2] == null || fieldStmtExprIndex[i2].getMapping() != mapping) continue;
                return stmtExprIndex;
            }
            int pos = 0;
            if (stmtExprIndex == null) {
                stmtExprIndex = new StatementExpressionIndex[1];
                pos = 0;
            } else {
                for (int i3 = 0; i3 < stmtExprIndex.length; ++i3) {
                    if (stmtExprIndex[i3].getMapping() != mapping) continue;
                    return stmtExprIndex;
                }
                StatementExpressionIndex[] tmpStmtExprIndex = stmtExprIndex;
                stmtExprIndex = new StatementExpressionIndex[tmpStmtExprIndex.length + 1];
                for (i = 0; i < tmpStmtExprIndex.length; ++i) {
                    stmtExprIndex[i] = tmpStmtExprIndex[i];
                }
                pos = tmpStmtExprIndex.length;
            }
            stmtExprIndex[pos] = new StatementExpressionIndex();
            stmtExprIndex[pos].setMapping(mapping);
            int[] param = new int[mapping.getNumberOfDatastoreFields()];
            for (i = 0; i < mapping.getNumberOfDatastoreFields(); ++i) {
                if (this.columnNames.length() > 0) {
                    this.columnNames.append(',');
                    this.columnValues.append(',');
                }
                this.columnNames.append(((Column)mapping.getDataStoreMapping(i).getDatastoreField()).getIdentifier());
                this.columnValues.append(((RDBMSMapping)mapping.getDataStoreMapping(i)).getUpdateInputParameter());
                ++this.paramIndex;
            }
            stmtExprIndex[pos].setParameterIndex(param);
            return stmtExprIndex;
        }

        public List getMappingCallbacks() {
            return this.mc;
        }

        public int[] getInsertFieldNumbers() {
            int[] fieldNumbers = new int[this.insertFields.size()];
            for (int i = 0; i < this.insertFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.insertFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.pkFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getReachableFieldNumbers() {
            int[] fieldNumbers = new int[this.reachableFields.size()];
            for (int i = 0; i < this.reachableFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.reachableFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getRelationFieldNumbers() {
            int[] fieldNumbers = new int[this.relationFields.size()];
            for (int i = 0; i < this.relationFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.relationFields.get(i);
            }
            return fieldNumbers;
        }

        public StatementExpressionIndex[] getStatementExpressionIndex() {
            return this.statementExpressionIndex;
        }

        public StatementExpressionIndex[] getReachableStatementIndex() {
            return this.retrievedStatementExpressionIndex;
        }

        public StatementExpressionIndex getVersionStatementExpressionIndex() {
            return this.versionStatementExpressionIndex;
        }

        public StatementExpressionIndex getDiscriminatorStatementExpressionIndex() {
            return this.discriminatorStatementExpressionIndex;
        }

        public StatementExpressionIndex[] getExternalFKStatementExpressionIndex() {
            return this.externalFKStmtExprIndex;
        }

        public StatementExpressionIndex[] getExternalFKDiscrimStatementExpressionIndex() {
            return this.externalFKDiscrimStmtExprIndex;
        }

        public StatementExpressionIndex[] getExternalOrderStatementExpressionIndex() {
            return this.externalOrderStmtExprIndex;
        }

        public String getInsertStmt() {
            if (this.columnNames.length() > 0 && this.columnValues.length() > 0) {
                return "INSERT INTO " + ((Object)InsertRequest.this.table).toString() + " (" + this.columnNames + ") VALUES (" + this.columnValues + ")";
            }
            return ((RDBMSAdapter)InsertRequest.this.table.getStoreManager().getDatastoreAdapter()).getInsertStatementForNoColumns((Table)((Object)InsertRequest.this.table));
        }
    }
}

