/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.oracle;

import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.sql.CLOB;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreFieldDefinitionException;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.rdbms.RDBMSFetchStatement;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.mapping.ClobRDBMSMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;

public class OracleClobRDBMSMapping
extends ClobRDBMSMapping {
    protected OracleClobRDBMSMapping(MappedStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public OracleClobRDBMSMapping(JavaTypeMapping mapping, MappedStoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null && !this.column.isUnlimitedLength()) {
            throw new DatastoreFieldDefinitionException("Invalid length specified for CLOB column " + this.column + ", must be 'unlimited'");
        }
        this.initTypeInfo();
    }

    public SQLTypeInfo getTypeInfo() {
        return ((RDBMSManager)this.storeMgr).getSQLTypeInfoForJDBCType(2005);
    }

    public String getInsertionInputParameter() {
        return "EMPTY_CLOB()";
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public String getUpdateInputParameter() {
        return "EMPTY_CLOB()";
    }

    public boolean insertValuesOnInsert() {
        return false;
    }

    public String getString(Object rs, int param) {
        String value;
        block8: {
            value = null;
            try {
                char[] cbuf = null;
                Clob clob = ((ResultSet)rs).getClob(param);
                if (clob == null) break block8;
                StringBuffer sbuf = new StringBuffer();
                Reader reader = clob.getCharacterStream();
                try {
                    int BUFF_SIZE = 4096;
                    cbuf = new char[4096];
                    int charsRead = reader.read(cbuf);
                    while (-1 != charsRead) {
                        sbuf.append(cbuf, 0, charsRead);
                        Arrays.fill(cbuf, '\u0000');
                        charsRead = reader.read(cbuf);
                    }
                }
                catch (IOException e) {
                    throw new NucleusDataStoreException("Error reading Oracle CLOB object: param = " + param, (Throwable)e);
                }
                value = sbuf.toString();
                if (value.length() == 0) {
                    value = null;
                } else if (value.equals(this.getDatabaseAdapter().getSurrogateForEmptyStrings())) {
                    value = "";
                }
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER.msg("RDBMSMapping.UnableToGetParam", (Object)"String", (Object)("" + param)), (Throwable)e);
            }
        }
        return value;
    }

    public Object getObject(Object rs, int param) {
        return this.getString(rs, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateClobColumn(StateManager sm, DatastoreContainerObject datastoreContainer, DatastoreMapping mapping, String value) {
        StateManager[] embeddedOwners;
        RDBMSFetchStatement fetchStmt = new RDBMSFetchStatement(datastoreContainer);
        fetchStmt.select(mapping.getDatastoreField());
        JavaTypeMapping idMapping = datastoreContainer.getIDMapping();
        for (int i = 0; i < idMapping.getNumberOfDatastoreFields(); ++i) {
            fetchStmt.andCondition(fetchStmt.referenceDatastoreField(idMapping.getDataStoreMapping(i).getDatastoreField()) + " = ?");
        }
        String textStmt = fetchStmt.toString(true);
        if (sm.getPcObjectType() != 0 && (embeddedOwners = sm.getEmbeddedOwners()) != null) {
            sm = embeddedOwners[0];
        }
        try {
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            ManagedConnection mconn = storeMgr.getConnection(om);
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, textStmt);
                try {
                    Object pcObject = sm.getObject();
                    idMapping.setObject(om, ps, Mappings.getParametersIndex(1, idMapping), pcObject);
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, textStmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new NucleusObjectNotFoundException("No such database row", sm.getInternalObjectId());
                        }
                        int jdbcMajorVersion = ((DatabaseAdapter)datastoreContainer.getStoreManager().getDatastoreAdapter()).getDriverMajorVersion();
                        if (jdbcMajorVersion < 10) {
                            CLOB clob = (CLOB)rs.getClob(1);
                            if (clob != null) {
                                clob.putString(1L, value);
                            }
                        } else {
                            Clob clob = rs.getClob(1);
                            if (clob != null) {
                                clob.setString(1L, value);
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException("Update of CLOB value failed: " + textStmt, (Throwable)e);
        }
    }
}

