/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.math.BigInteger;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.CharacterLiteral;
import org.datanucleus.store.mapped.expression.FloatingPointLiteral;
import org.datanucleus.store.mapped.expression.IntegerLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StatementText;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.StringUtils;

public class StringLiteral
extends StringExpression
implements Literal {
    private final String value;
    Object rawValue;
    private StatementText stUsingParameter = new StatementText();

    public StringLiteral(QueryExpression qs, JavaTypeMapping mapping, char value) {
        this(qs, mapping, String.valueOf(value));
    }

    public StringLiteral(QueryExpression qs, JavaTypeMapping mapping, String value) {
        super(qs);
        this.mapping = mapping;
        this.value = value;
        this.st.append('\'').append(StringUtils.replaceAll((String)value, (String)"'", (String)"''")).append('\'');
        if (mapping == null) {
            this.stUsingParameter.appendParameter(qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(String.class, false, false, qs.getClassLoaderResolver()), value);
        } else {
            this.stUsingParameter.appendParameter(mapping, value);
        }
    }

    public void generateStatementWithoutQuotes() {
        this.st.clearStatement();
        this.st.append(StringUtils.replaceAll((String)this.value, (String)"'", (String)"''"));
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, StringExpression.class);
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.equals(((StringLiteral)expr).value));
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        this.assertValidTypeForParameterComparison(expr, StringExpression.class);
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, !this.value.equals(((StringLiteral)expr).value));
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((StringLiteral)expr).value) < 0);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((StringLiteral)expr).value) <= 0);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((StringLiteral)expr).value) > 0);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.compareTo(((StringLiteral)expr).value) >= 0);
        }
        return super.gteq(expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (expr instanceof StringLiteral) {
            return new StringLiteral(this.qs, this.mapping, this.value.concat(((StringLiteral)expr).value));
        }
        if (expr instanceof CharacterLiteral) {
            return new StringLiteral(this.qs, this.mapping, this.value.concat(((Literal)((Object)expr)).getValue().toString()));
        }
        if (expr instanceof IntegerLiteral || expr instanceof FloatingPointLiteral || expr instanceof BooleanLiteral) {
            return new StringLiteral(this.qs, this.mapping, this.value.concat(((Literal)((Object)expr)).getValue().toString()));
        }
        return super.add(expr);
    }

    public BooleanExpression endsWithMethod(ScalarExpression str) {
        if (str instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.endsWith(((StringLiteral)str).value));
        }
        return super.endsWithMethod(str);
    }

    public NumericExpression indexOfMethod(ScalarExpression str) {
        if (str instanceof StringLiteral) {
            return new IntegerLiteral(this.qs, this.mapping, BigInteger.valueOf(this.value.indexOf(((StringLiteral)str).value)));
        }
        return super.indexOfMethod(str);
    }

    public NumericExpression lengthMethod() {
        return new IntegerLiteral(this.qs, this.mapping, BigInteger.valueOf(this.value.length()));
    }

    public BooleanExpression startsWithMethod(ScalarExpression str) {
        if (str instanceof StringLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.startsWith(((StringLiteral)str).value));
        }
        return super.startsWithMethod(str);
    }

    public BooleanExpression startsWithMethod(ScalarExpression str, ScalarExpression toffset) {
        if (str instanceof StringLiteral && toffset instanceof IntegerLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.startsWith(((StringLiteral)str).value, ((Number)((IntegerLiteral)toffset).getValue()).intValue()));
        }
        return super.startsWithMethod(str, toffset);
    }

    public StringExpression substringMethod(NumericExpression begin) {
        if (begin instanceof IntegerLiteral) {
            return new StringLiteral(this.qs, this.mapping, this.value.substring(((Number)((IntegerLiteral)begin).getValue()).intValue()));
        }
        return super.substringMethod(begin);
    }

    public StringExpression substringMethod(NumericExpression begin, NumericExpression end) {
        if (begin instanceof IntegerLiteral && end instanceof IntegerLiteral) {
            return new StringLiteral(this.qs, this.mapping, this.value.substring(((Number)((IntegerLiteral)begin).getValue()).intValue(), ((Number)((IntegerLiteral)end).getValue()).intValue()));
        }
        return super.substringMethod(begin, end);
    }

    public StringExpression toLowerCaseMethod() {
        return new StringLiteral(this.qs, this.mapping, this.value.toLowerCase());
    }

    public StringExpression toUpperCaseMethod() {
        return new StringLiteral(this.qs, this.mapping, this.value.toUpperCase());
    }

    public StringExpression trimMethod() {
        return new StringLiteral(this.qs, this.mapping, this.value.trim());
    }

    public StatementText toStatementText(int mode) {
        if (mode == ScalarExpression.FILTER) {
            return this.stUsingParameter;
        }
        return super.toStatementText(mode);
    }

    public void setRawValue(Object val) {
        this.rawValue = val;
    }

    public Object getRawValue() {
        return this.rawValue;
    }
}

