/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.MappedStoreData;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.mapped.mapping.Mappings;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.TableImpl;

public class SchemaTable
extends TableImpl {
    private JavaTypeMapping classMapping = null;
    private JavaTypeMapping tableMapping = null;
    private JavaTypeMapping typeMapping = null;
    private JavaTypeMapping ownerMapping = null;
    private JavaTypeMapping versionMapping = null;
    private JavaTypeMapping interfaceNameMapping = null;
    private String insertStmt = null;
    private String deleteStmt = null;
    private String deleteAllStmt = null;
    private String fetchAllStmt = null;
    private String fetchStmt = null;

    public SchemaTable(RDBMSManager storeMgr, String tableName) {
        super(storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier(tableName != null ? tableName : "NUCLEUS_TABLES"), storeMgr);
    }

    public void initialize(ClassLoaderResolver clr) {
        this.assertIsUninitialized();
        IdentifierFactory idFactory = this.storeMgr.getIdentifierFactory();
        MappingManager mgr = this.getStoreManager().getMappingManager();
        this.classMapping = this.dba.getMapping(String.class, this.storeMgr);
        Column class_column = (Column)this.addDatastoreField(String.class.getName(), idFactory.newDatastoreFieldIdentifier("CLASS_NAME"), this.classMapping, null);
        mgr.createDatastoreMapping(this.classMapping, this.storeMgr, class_column, String.class.getName());
        class_column.getColumnMetaData().setLength(128);
        class_column.getColumnMetaData().setJdbcType("VARCHAR");
        class_column.setAsPrimaryKey();
        this.tableMapping = this.dba.getMapping(String.class, this.storeMgr);
        Column table_column = (Column)this.addDatastoreField(String.class.getName(), idFactory.newDatastoreFieldIdentifier("TABLE_NAME"), this.tableMapping, null);
        mgr.createDatastoreMapping(this.tableMapping, this.storeMgr, table_column, String.class.getName());
        table_column.getColumnMetaData().setLength(128);
        table_column.getColumnMetaData().setJdbcType("VARCHAR");
        this.typeMapping = this.dba.getMapping(String.class, this.storeMgr);
        Column type_column = (Column)this.addDatastoreField(String.class.getName(), idFactory.newDatastoreFieldIdentifier("TYPE"), this.typeMapping, null);
        mgr.createDatastoreMapping(this.typeMapping, this.storeMgr, type_column, String.class.getName());
        type_column.getColumnMetaData().setLength(4);
        type_column.getColumnMetaData().setJdbcType("VARCHAR");
        this.ownerMapping = this.dba.getMapping(String.class, this.storeMgr);
        Column owner_column = (Column)this.addDatastoreField(String.class.getName(), idFactory.newDatastoreFieldIdentifier("OWNER"), this.ownerMapping, null);
        mgr.createDatastoreMapping(this.ownerMapping, this.storeMgr, owner_column, String.class.getName());
        owner_column.getColumnMetaData().setLength(2);
        owner_column.getColumnMetaData().setJdbcType("VARCHAR");
        this.versionMapping = this.dba.getMapping(String.class, this.storeMgr);
        Column version_column = (Column)this.addDatastoreField(String.class.getName(), idFactory.newDatastoreFieldIdentifier("VERSION"), this.versionMapping, null);
        mgr.createDatastoreMapping(this.versionMapping, this.storeMgr, version_column, String.class.getName());
        version_column.getColumnMetaData().setLength(20);
        version_column.getColumnMetaData().setJdbcType("VARCHAR");
        this.interfaceNameMapping = this.dba.getMapping(String.class, this.storeMgr);
        Column interfaceName_column = (Column)this.addDatastoreField(String.class.getName(), idFactory.newDatastoreFieldIdentifier("INTERFACE_NAME"), this.interfaceNameMapping, null);
        mgr.createDatastoreMapping(this.interfaceNameMapping, this.storeMgr, interfaceName_column, String.class.getName());
        interfaceName_column.getColumnMetaData().setLength(255);
        interfaceName_column.getColumnMetaData().setJdbcType("VARCHAR");
        interfaceName_column.setNullable();
        this.insertStmt = "INSERT INTO " + this.identifier.getFullyQualifiedName(false) + " (" + class_column.getIdentifier() + "," + table_column.getIdentifier() + "," + type_column.getIdentifier() + "," + owner_column.getIdentifier() + "," + version_column.getIdentifier() + "," + interfaceName_column.getIdentifier() + ") VALUES (?,?,?,?,?,?)";
        this.deleteStmt = "DELETE FROM " + this.identifier.getFullyQualifiedName(false) + " WHERE " + idFactory.getIdentifierInAdapterCase("CLASS_NAME") + "=?";
        this.deleteAllStmt = "DELETE FROM " + this.identifier.getFullyQualifiedName(false);
        this.fetchAllStmt = "SELECT " + class_column.getIdentifier() + "," + table_column.getIdentifier() + "," + type_column.getIdentifier() + "," + owner_column.getIdentifier() + "," + version_column.getIdentifier() + "," + interfaceName_column.getIdentifier() + " FROM " + this.identifier.getFullyQualifiedName(false) + " ORDER BY " + table_column.getIdentifier();
        this.fetchStmt = "SELECT 1 FROM " + this.identifier.getFullyQualifiedName(false) + " WHERE " + idFactory.getIdentifierInAdapterCase("CLASS_NAME") + " = ? ";
        this.state = 2;
    }

    public JavaTypeMapping getIDMapping() {
        throw new NucleusException("Attempt to get ID mapping of SchemaTable!").setFatal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getAllClasses(ManagedConnection conn) throws SQLException {
        HashSet<MappedStoreData> schema_data = new HashSet<MappedStoreData>();
        if (SchemaTable.isOutputtingDDL() && !this.tableExists((Connection)conn.getConnection())) {
            return schema_data;
        }
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, this.fetchAllStmt);
        try {
            ResultSet rs = sqlControl.executeStatementQuery(conn, this.fetchAllStmt, ps);
            try {
                while (rs.next()) {
                    MappedStoreData data = new MappedStoreData(rs.getString(1), rs.getString(2), rs.getString(4).equals("1"), rs.getString(3).equals("FCO") ? 1 : 2, rs.getString(6));
                    schema_data.add(data);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
        return schema_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClass(MappedStoreData data, ManagedConnection conn) throws SQLException {
        if (SchemaTable.isOutputtingDDL()) {
            return;
        }
        if (this.hasClass(data, conn)) {
            return;
        }
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.insertStmt, false);
        try {
            int jdbc_id = 1;
            this.classMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id, this.classMapping), data.getName());
            this.tableMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id += this.classMapping.getNumberOfDatastoreFields(), this.tableMapping), data.hasTable() ? data.getTableName() : "");
            this.typeMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id += this.tableMapping.getNumberOfDatastoreFields(), this.typeMapping), data.isFCO() ? "FCO" : "SCO");
            this.ownerMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id += this.typeMapping.getNumberOfDatastoreFields(), this.ownerMapping), data.isTableOwner() ? "1" : "0");
            this.versionMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id += this.ownerMapping.getNumberOfDatastoreFields(), this.versionMapping), "DataNucleus");
            this.interfaceNameMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id += this.versionMapping.getNumberOfDatastoreFields(), this.interfaceNameMapping), data.getInterfaceName());
            jdbc_id += this.interfaceNameMapping.getNumberOfDatastoreFields();
            sqlControl.executeStatementUpdate(conn, this.insertStmt, ps, true);
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasClass(StoreData data, ManagedConnection conn) throws SQLException {
        if (!this.tableExists((Connection)conn.getConnection())) {
            return false;
        }
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForQuery(conn, this.fetchStmt);
        try {
            int jdbc_id = 1;
            this.tableMapping.setString(null, ps, Mappings.getParametersIndex(jdbc_id, this.tableMapping), data.getName());
            ResultSet rs = sqlControl.executeStatementQuery(conn, this.fetchStmt, ps);
            try {
                if (rs.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteClass(String class_name, ManagedConnection conn) throws SQLException {
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.deleteStmt, false);
        try {
            ps.setString(1, class_name);
            sqlControl.executeStatementUpdate(conn, this.deleteStmt, ps, true);
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllClasses(ManagedConnection conn) throws SQLException {
        SQLController sqlControl = this.storeMgr.getSQLController();
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.deleteAllStmt, false);
        try {
            sqlControl.executeStatementUpdate(conn, this.deleteAllStmt, ps, true);
        }
        finally {
            sqlControl.closeStatement(conn, ps);
        }
    }

    private boolean tableExists(Connection conn) throws SQLException {
        try {
            this.exists(conn, false);
            return true;
        }
        catch (MissingTableException mte) {
            return false;
        }
    }

    public JavaTypeMapping getFieldMapping(AbstractMemberMetaData fmd) {
        return null;
    }
}

