/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.request;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.exceptions.NotYetFlushedException;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingCallbacks;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.fieldmanager.ParameterSetter;
import org.datanucleus.store.rdbms.mapping.RDBMSMapping;
import org.datanucleus.store.rdbms.request.MappingStatementIndex;
import org.datanucleus.store.rdbms.request.VersionCheckRequest;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class UpdateRequest
extends VersionCheckRequest {
    private final String updateStmt;
    private final String updateStmtOptimistic;
    private final MappingCallbacks[] callbacks;
    private MappingStatementIndex mappingStatementIndex = new MappingStatementIndex();
    private final int[] updateFieldNumbers;
    private final int[] pkFieldNumbers;

    public UpdateRequest(DatastoreClass table, AbstractMemberMetaData[] reqFieldMetaData, Class cls, ClassLoaderResolver clr) {
        super(table, cls, clr);
        AbstractMemberMetaData[] updateFmds;
        UpdateMappingConsumer consumer = new UpdateMappingConsumer(this.cmd);
        if (this.versionMetaData != null) {
            if (this.versionMetaData.getFieldName() != null) {
                updateFmds = new AbstractMemberMetaData[reqFieldMetaData.length + 1];
                for (int i = 0; i < reqFieldMetaData.length; ++i) {
                    updateFmds[i] = reqFieldMetaData[i];
                }
                updateFmds[updateFmds.length - 1] = this.cmd.getMetaDataForMember(this.versionMetaData.getFieldName());
                table.provideMappingsForFields(consumer, updateFmds, false);
            } else {
                table.provideMappingsForFields(consumer, reqFieldMetaData, false);
                table.provideVersionMappings(consumer);
            }
        } else {
            table.provideMappingsForFields(consumer, reqFieldMetaData, false);
        }
        consumer.setWhereClauseConsumption(true);
        table.providePrimaryKeyMappings(consumer);
        table.provideDatastoreIdMappings(consumer);
        this.updateStmt = consumer.getStatement();
        if (this.versionMetaData != null) {
            if (this.versionMetaData.getFieldName() != null) {
                updateFmds = new AbstractMemberMetaData[]{this.cmd.getMetaDataForMember(this.versionMetaData.getFieldName())};
                table.provideMappingsForFields(consumer, updateFmds, false);
            } else {
                table.provideVersionMappings(consumer);
            }
        }
        this.updateStmtOptimistic = consumer.getStatement();
        this.callbacks = consumer.getMappingCallbacks().toArray(new MappingCallbacks[consumer.getMappingCallbacks().size()]);
        this.pkFieldNumbers = consumer.getPrimaryKeyFieldNumbers();
        this.updateFieldNumbers = consumer.getUpdateFieldNumbers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StateManager sm) {
        String stmt = null;
        ObjectManager om = sm.getObjectManager();
        boolean optimisticChecks = this.versionMetaData != null && om.getTransaction().getOptimistic() && this.versionChecks;
        stmt = optimisticChecks ? this.updateStmtOptimistic : this.updateStmt;
        if (stmt != null) {
            if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < this.updateFieldNumbers.length; ++i) {
                    if (fieldStr.length() > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(this.updateFieldNumbers[i]).getName());
                }
                if (this.versionMetaData != null && this.versionMetaData.getFieldName() == null) {
                    if (fieldStr.length() > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append("[VERSION]");
                }
                NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052214", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)fieldStr.toString(), (Object)this.table));
            }
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            boolean batch = false;
            try {
                ManagedConnection mconn = storeMgr.getConnection(om);
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, batch);
                    try {
                        int[] rcs;
                        Object currentVersion = sm.getTransactionalVersion(sm.getObject());
                        Object nextVersion = null;
                        if (this.versionMetaData != null) {
                            if (this.versionMetaData.getFieldName() != null) {
                                AbstractMemberMetaData verfmd = this.cmd.getMetaDataForMember(this.table.getVersionMetaData().getFieldName());
                                if (currentVersion instanceof Integer) {
                                    currentVersion = new Long(((Integer)currentVersion).longValue());
                                }
                                nextVersion = this.versionMetaData.getNextVersion(currentVersion);
                                if (verfmd.getType() == Integer.class || verfmd.getType() == Integer.TYPE) {
                                    nextVersion = new Integer(((Long)nextVersion).intValue());
                                }
                                sm.replaceField(verfmd.getAbsoluteFieldNumber(), nextVersion, false);
                            } else {
                                nextVersion = this.versionMetaData.getNextVersion(currentVersion);
                            }
                            sm.setTransactionalVersion(nextVersion);
                        }
                        if (this.updateFieldNumbers != null) {
                            sm.provideFields(this.updateFieldNumbers, (FieldManager)new ParameterSetter(sm, ps, this.mappingStatementIndex.getFields(), true));
                        }
                        if (this.versionMetaData != null && this.versionMetaData.getFieldName() == null) {
                            this.table.getVersionMapping(false).setObject(om, ps, this.mappingStatementIndex.getVersion().getParameterIndex(), nextVersion);
                        }
                        if (this.table.getIdentityType() == IdentityType.DATASTORE) {
                            this.table.getDataStoreObjectIdMapping().setObject(om, ps, this.mappingStatementIndex.getDatastoreId().getParameterIndex(), sm.getInternalObjectId());
                        } else if (this.table.getIdentityType() == IdentityType.APPLICATION) {
                            sm.provideFields(this.pkFieldNumbers, (FieldManager)new ParameterSetter(sm, ps, this.mappingStatementIndex.getPrimaryKeys(), true));
                        }
                        if (optimisticChecks) {
                            if (currentVersion == null) {
                                String msg = LOCALISER.msg("052201", sm.getInternalObjectId(), (Object)this.table);
                                NucleusLogger.PERSISTENCE.error((Object)msg);
                                throw new NucleusException(msg);
                            }
                            JavaTypeMapping verMapping = this.mappingStatementIndex.getVersion2().getMapping();
                            verMapping.setObject(om, ps, this.mappingStatementIndex.getVersion2().getParameterIndex(), currentVersion);
                        }
                        if ((rcs = sqlControl.executeStatementUpdate(mconn, stmt, ps, !batch))[0] == 0 && optimisticChecks) {
                            String msg = LOCALISER.msg("052203", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)("" + sm.getTransactionalVersion(sm.getObject())));
                            NucleusLogger.PERSISTENCE.error((Object)msg);
                            throw new NucleusOptimisticException(msg, sm.getObject());
                        }
                    }
                    finally {
                        sqlControl.closeStatement(mconn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                String msg = LOCALISER.msg("052215", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)stmt, (Object)StringUtils.getStringFromStackTrace((Throwable)e));
                NucleusLogger.DATASTORE_PERSIST.error((Object)msg);
                ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
                exceptions.add(e);
                while ((e = e.getNextException()) != null) {
                    exceptions.add(e);
                }
                throw new NucleusDataStoreException(msg, exceptions.toArray(new Throwable[exceptions.size()]));
            }
        }
        for (int i = 0; i < this.callbacks.length; ++i) {
            try {
                if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
                    NucleusLogger.PERSISTENCE.debug((Object)LOCALISER.msg("052216", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), (Object)((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getFullFieldName()));
                }
                this.callbacks[i].postUpdate(sm);
                continue;
            }
            catch (NotYetFlushedException e) {
                sm.updateFieldAfterInsert(e.getPersistable(), ((JavaTypeMapping)((Object)this.callbacks[i])).getFieldMetaData().getAbsoluteFieldNumber());
            }
        }
    }

    private class UpdateMappingConsumer
    implements MappingConsumer {
        boolean initialized = false;
        int paramIndex = 1;
        int highestFieldNumber = 0;
        List updateFields = new ArrayList();
        List pkFields = new ArrayList();
        List mc = new ArrayList();
        StringBuffer columnAssignments = new StringBuffer();
        Map assignedColumns = new HashMap();
        StringBuffer where = new StringBuffer();
        private final AbstractClassMetaData cmd;
        private boolean whereClauseConsumption = false;

        public UpdateMappingConsumer(AbstractClassMetaData cmd) {
            this.cmd = cmd;
        }

        public void setWhereClauseConsumption(boolean whereClause) {
            this.whereClauseConsumption = whereClause;
        }

        public int getHighestFieldNumber() {
            return this.highestFieldNumber;
        }

        public void preConsumeMapping(int highest) {
            if (!this.initialized) {
                this.highestFieldNumber = highest;
                UpdateRequest.this.mappingStatementIndex.setPrimaryKeys(new StatementExpressionIndex[highest]);
                UpdateRequest.this.mappingStatementIndex.setFields(new StatementExpressionIndex[highest]);
                this.initialized = true;
            }
        }

        public void consumeMapping(JavaTypeMapping m, AbstractMemberMetaData fmd) {
            if (!fmd.getAbstractClassMetaData().isSameOrAncestorOf(this.cmd)) {
                return;
            }
            if (m.includeInUpdateStatement()) {
                if (fmd.hasExtension("updateable") && fmd.getValueForExtension("updateable").equalsIgnoreCase("false")) {
                    return;
                }
                ColumnMetaData[] colmds = fmd.getColumnMetaData();
                if (colmds != null && colmds.length > 0) {
                    for (int i = 0; i < colmds.length; ++i) {
                        if (colmds[i].getUpdateable()) continue;
                        return;
                    }
                }
                Integer abs_field_num = new Integer(fmd.getAbsoluteFieldNumber());
                int[] parametersIndex = new int[m.getNumberOfDatastoreFields()];
                StatementExpressionIndex sei = new StatementExpressionIndex();
                sei.setMapping(m);
                sei.setParameterIndex(parametersIndex);
                if (fmd.isPrimaryKey()) {
                    ((UpdateRequest)UpdateRequest.this).mappingStatementIndex.getPrimaryKeys()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        if (this.where.length() > 0) {
                            this.where.append(" AND ");
                        }
                        String condition = m.getDataStoreMapping(j).getDatastoreField().getIdentifier() + "=" + ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                        this.where.append(condition);
                        if (!this.pkFields.contains(abs_field_num)) {
                            this.pkFields.add(abs_field_num);
                        }
                        ++this.paramIndex;
                    }
                } else if (this.whereClauseConsumption) {
                    UpdateRequest.this.mappingStatementIndex.setVersion2(sei);
                    ++this.paramIndex;
                    String inputParam = ((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter();
                    String condition = " AND " + m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam;
                    this.where.append(condition);
                } else {
                    ((UpdateRequest)UpdateRequest.this).mappingStatementIndex.getFields()[fmd.getAbsoluteFieldNumber()] = sei;
                    for (int j = 0; j < parametersIndex.length; ++j) {
                        if (!this.assignedColumns.containsKey(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString())) {
                            if (this.columnAssignments.length() > 0) {
                                this.columnAssignments.append(", ");
                            }
                            String param = ((RDBMSMapping)m.getDataStoreMapping(j)).getUpdateInputParameter();
                            this.columnAssignments.append(m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).append("=").append(param);
                            if (param.indexOf("?") > -1) {
                                if (!this.updateFields.contains(abs_field_num)) {
                                    this.updateFields.add(abs_field_num);
                                }
                                ++this.paramIndex;
                            }
                            this.assignedColumns.put(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString(), new Integer(fmd.getAbsoluteFieldNumber()));
                            continue;
                        }
                        parametersIndex[j] = (Integer)this.assignedColumns.get(((Object)m.getDataStoreMapping(j).getDatastoreField().getIdentifier()).toString());
                    }
                }
            }
            if (m instanceof MappingCallbacks) {
                this.mc.add(m);
            }
        }

        public void consumeMapping(JavaTypeMapping m, int mappingType) {
            if (mappingType == 1) {
                String inputParam = ((RDBMSMapping)m.getDataStoreMapping(0)).getUpdateInputParameter();
                int[] param = new int[]{this.paramIndex++};
                StatementExpressionIndex versStmtIdx = null;
                if (this.whereClauseConsumption) {
                    versStmtIdx = UpdateRequest.this.mappingStatementIndex.getVersion2();
                    String condition = " AND " + m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam;
                    this.where.append(condition);
                } else {
                    versStmtIdx = UpdateRequest.this.mappingStatementIndex.getVersion();
                    String condition = m.getDataStoreMapping(0).getDatastoreField().getIdentifier() + "=" + inputParam;
                    if (this.columnAssignments.length() > 0) {
                        this.columnAssignments.append(", ");
                    }
                    this.columnAssignments.append(condition);
                }
                versStmtIdx.setMapping(m);
                versStmtIdx.setParameterIndex(param);
            } else if (mappingType == 2) {
                String condition = ((DatastoreField)UpdateRequest.this.key.getColumns().get(0)).getIdentifier() + "=?";
                this.where.append(condition);
                int[] param = new int[]{this.paramIndex++};
                UpdateRequest.this.mappingStatementIndex.getDatastoreId().setParameterIndex(param);
            }
        }

        public void consumeUnmappedDatastoreField(DatastoreField fld) {
        }

        public List getMappingCallbacks() {
            return this.mc;
        }

        public int[] getUpdateFieldNumbers() {
            int[] fieldNumbers = new int[this.updateFields.size()];
            for (int i = 0; i < this.updateFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.updateFields.get(i);
            }
            return fieldNumbers;
        }

        public int[] getPrimaryKeyFieldNumbers() {
            int[] fieldNumbers = new int[this.pkFields.size()];
            for (int i = 0; i < this.pkFields.size(); ++i) {
                fieldNumbers[i] = (Integer)this.pkFields.get(i);
            }
            return fieldNumbers;
        }

        public String getStatement() {
            if (this.columnAssignments.length() < 1) {
                return null;
            }
            return "UPDATE " + ((Object)UpdateRequest.this.table).toString() + " SET " + this.columnAssignments + " WHERE " + this.where;
        }
    }
}

