/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.MetaDataStringLiteral;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.query.AbstractIteratorStatement;
import org.datanucleus.store.rdbms.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class UnionIteratorStatement
extends AbstractIteratorStatement {
    Class sourceType = null;
    JavaTypeMapping sourceMapping = null;
    DatastoreContainerObject sourceTable = null;
    boolean sourceJoin = false;
    boolean joinToExcludeTargetSubclasses = true;
    Boolean withMetadata = null;
    boolean allowsNull = false;

    public UnionIteratorStatement(ClassLoaderResolver clr, Class candidateType, boolean includeSubclasses, StoreManager storeMgr, Class sourceType, JavaTypeMapping sourceMapping, DatastoreContainerObject sourceTable, boolean sourceJoin, Boolean withMetadata, boolean joinToExcludeTargetSubclasses, boolean allowsNull) {
        super(candidateType, clr, includeSubclasses, storeMgr);
        this.sourceType = sourceType;
        this.sourceMapping = sourceMapping;
        this.sourceTable = sourceTable;
        this.sourceJoin = sourceJoin;
        this.joinToExcludeTargetSubclasses = joinToExcludeTargetSubclasses;
        this.withMetadata = withMetadata;
        this.allowsNull = allowsNull;
        if (!sourceType.isAssignableFrom(candidateType)) {
            if (candidateType.isInterface()) {
                if (!candidateType.isAssignableFrom(sourceType)) {
                    throw new IncompatibleQueryElementTypeException(this.candidateFullClassName, sourceType.getName());
                }
            } else {
                throw new IncompatibleQueryElementTypeException(sourceType.getName(), candidateType.getName());
            }
        }
        if (!sourceTable.equals(this.candidateTable) && !includeSubclasses) {
            NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("033003", (Object)this, (Object)this.candidateFullClassName));
        }
    }

    public QueryExpression getQueryStatement(DatastoreIdentifier candidateAlias) {
        String queryCandidateClassName;
        HashSet subclasses;
        block15: {
            if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(this.candidateFullClassName)) {
                QueryExpression qs = this.dba.newQueryStatement(this.sourceTable, candidateAlias, this.clr);
                qs.select(this.sourceMapping);
                return qs;
            }
            if (this.candidateTable == null) {
                AbstractClassMetaData acmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.candidateFullClassName, this.clr);
                AbstractClassMetaData[] subclassCmds = this.storeMgr.getClassesManagingTableForClass(acmd, this.clr);
                if (subclassCmds != null && subclassCmds.length == 1) {
                    this.candidateTable = this.storeMgr.getDatastoreClass(subclassCmds[0].getFullClassName(), this.clr);
                    this.candidateFullClassName = subclassCmds[0].getFullClassName();
                } else {
                    throw new NucleusUserException("Attempt to create iterator for class " + this.candidateFullClassName + " that is using \"subclass-table\" inheritance strategy and that doesnt have only 1 subclass." + " This is not currently supported");
                }
            }
            if (!this.includeSubclasses && this.withMetadata == null) {
                this.withMetadata = Boolean.FALSE;
            }
            subclasses = null;
            if (this.includeSubclasses) {
                subclasses = this.storeMgr.getSubClassesForClass(this.candidateFullClassName, true, this.clr);
                Iterator iter = subclasses.iterator();
                while (iter.hasNext()) {
                    String subclassName = (String)iter.next();
                    try {
                        Class subclass = this.clr.classForName(subclassName);
                        if (!Modifier.isAbstract(subclass.getModifiers())) continue;
                        iter.remove();
                    }
                    catch (Exception e) {
                        iter.remove();
                    }
                }
            }
            queryCandidateClassName = this.candidateFullClassName;
            try {
                Class candidateClass = this.clr.classForName(this.candidateFullClassName);
                if (!Modifier.isAbstract(candidateClass.getModifiers())) break block15;
                Iterator iter = subclasses.iterator();
                while (iter.hasNext()) {
                    String subclassName = (String)iter.next();
                    DatastoreClass subclassTable = this.storeMgr.getDatastoreClass(subclassName, this.clr);
                    if (subclassTable != this.candidateTable) continue;
                    queryCandidateClassName = subclassName;
                    iter.remove();
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        QueryExpression stmt = this.getQueryForElement(queryCandidateClassName, this.candidateTable, false, candidateAlias);
        if (this.includeSubclasses) {
            for (String subCandidateType : subclasses) {
                DatastoreClass subCandidateTable = this.storeMgr.getDatastoreClass(subCandidateType, this.clr);
                if (subCandidateTable == null) continue;
                QueryExpression stmt_subclass = this.getQueryForElement(subCandidateType, subCandidateTable, false, candidateAlias);
                stmt.union(stmt_subclass);
            }
        }
        if (this.allowsNull && this.sourceTable instanceof JoinTable) {
            QueryExpression nullStmt = this.getQueryForElement(this.candidateFullClassName, this.storeMgr.getDatastoreClass(this.candidateFullClassName, this.clr), true, candidateAlias);
            ScalarExpression elemIdExpr = this.sourceMapping.newScalarExpression(nullStmt, nullStmt.getMainTableExpression());
            nullStmt.andCondition(new NullLiteral(nullStmt).eq(elemIdExpr));
            stmt.union(nullStmt);
        }
        return stmt;
    }

    private QueryExpression getQueryForElement(String targetElementType, DatastoreClass targetElementTable, boolean allowNull, DatastoreIdentifier candidateId) {
        QueryExpression stmt;
        JavaTypeMapping discriminatorMapping = null;
        DiscriminatorMetaData discriminatorMetaData = null;
        LogicSetExpression discriminatorTableExpr = null;
        if (this.sourceTable instanceof JoinTable) {
            stmt = this.dba.newQueryStatement(this.sourceTable, candidateId, this.clr);
            DatastoreIdentifier targetTableIdentifier = this.joinSourceToTargetElement(stmt, targetElementTable, allowNull);
            discriminatorMapping = targetElementTable.getDiscriminatorMapping(false);
            discriminatorMetaData = targetElementTable.getDiscriminatorMetaData();
            discriminatorTableExpr = stmt.getTableExpression(targetTableIdentifier);
            if (this.joinToExcludeTargetSubclasses) {
                this.joinToExcludeTargetWhenSubElementsExists(stmt, this.sourceMapping, targetElementType);
            }
        } else {
            stmt = this.dba.newQueryStatement(this.candidateTable, candidateId, this.clr);
            discriminatorMapping = this.sourceTable.getDiscriminatorMapping(false);
            discriminatorMetaData = this.sourceTable.getDiscriminatorMetaData();
            discriminatorTableExpr = stmt.getMainTableExpression();
            if (!((Object)targetElementTable).toString().equals(this.sourceTable.toString()) && !this.candidateTable.getType().equals(targetElementType) || this.sourceJoin) {
                if (this.sourceJoin) {
                    this.joinTargetToSourceElement(stmt, targetElementTable, false);
                } else {
                    this.joinSourceToTargetElement(stmt, targetElementTable, false);
                }
            }
            if (this.joinToExcludeTargetSubclasses) {
                this.joinToExcludeTargetWhenSubElementsExists(stmt, this.candidateTable.getIDMapping(), targetElementType);
            }
        }
        if (discriminatorMapping != null && discriminatorMetaData.getStrategy() != DiscriminatorStrategy.NONE) {
            String discriminatorValue = targetElementType;
            if (discriminatorMetaData.getStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                AbstractClassMetaData targetCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(targetElementType, this.clr);
                discriminatorValue = targetCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue();
            }
            ScalarExpression discrExpr = discriminatorMapping.newScalarExpression(stmt, discriminatorTableExpr);
            ScalarExpression discrVal = discriminatorMapping.newLiteral(stmt, discriminatorValue);
            stmt.andCondition(discrExpr.eq(discrVal));
        }
        if (this.withMetadata == null || this.withMetadata.booleanValue()) {
            this.selectMetadata(stmt, targetElementType, allowNull);
        }
        return stmt;
    }

    private DatastoreIdentifier joinSourceToTargetElement(QueryExpression stmt, DatastoreClass elementTargetTable, boolean leftOuterJoin) {
        DatastoreIdentifier targetTableIdentifier = stmt.getStoreManager().getIdentifierFactory().newIdentifier(0, "ELEMENT");
        LogicSetExpression teTargetElement = stmt.newTableExpression(elementTargetTable, targetTableIdentifier);
        ScalarExpression sourceExpr = this.sourceMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression targetExpr = elementTargetTable.getIDMapping().newScalarExpression(stmt, teTargetElement);
        if (leftOuterJoin) {
            stmt.leftOuterJoin(sourceExpr, targetExpr, teTargetElement, true);
        } else {
            stmt.innerJoin(sourceExpr, targetExpr, teTargetElement, true);
        }
        return targetTableIdentifier;
    }

    private void joinTargetToSourceElement(QueryExpression stmt, DatastoreClass elementTargetTable, boolean leftOuterJoin) {
        DatastoreIdentifier sourceTableIdentifier = stmt.getStoreManager().getIdentifierFactory().newIdentifier(0, "VALUE");
        LogicSetExpression teSourceElement = stmt.newTableExpression(this.sourceTable, sourceTableIdentifier);
        ScalarExpression sourceExpr = this.sourceMapping.newScalarExpression(stmt, teSourceElement);
        ScalarExpression targetExpr = elementTargetTable.getIDMapping().newScalarExpression(stmt, stmt.getMainTableExpression());
        if (leftOuterJoin) {
            stmt.leftOuterJoin(sourceExpr, targetExpr, teSourceElement, true);
        } else {
            stmt.innerJoin(sourceExpr, targetExpr, teSourceElement, true);
        }
    }

    private void joinToExcludeTargetWhenSubElementsExists(QueryExpression stmt, JavaTypeMapping targetElementMapping, String targetElementType) {
        Iterator iterTargetSubElementType = this.storeMgr.getSubClassesForClass(targetElementType, false, stmt.getClassLoaderResolver()).iterator();
        int subSequenceIdentifier = 0;
        while (iterTargetSubElementType.hasNext()) {
            String targetSubElementType = (String)iterTargetSubElementType.next();
            DatastoreClass cbtTargetSubElementType = this.storeMgr.getDatastoreClass(targetSubElementType, this.clr);
            DatastoreClass[] targetSubElementTypes = null;
            if (cbtTargetSubElementType == null) {
                AbstractClassMetaData targetSubCmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(targetSubElementType, stmt.getClassLoaderResolver());
                AbstractClassMetaData[] targetSubCmds = this.storeMgr.getClassesManagingTableForClass(targetSubCmd, this.clr);
                targetSubElementTypes = new DatastoreClass[targetSubCmds.length];
                for (int i = 0; i < targetSubCmds.length; ++i) {
                    targetSubElementTypes[i] = this.storeMgr.getDatastoreClass(targetSubCmds[i].getFullClassName(), this.clr);
                }
            } else {
                targetSubElementTypes = new DatastoreClass[]{cbtTargetSubElementType};
            }
            for (int i = 0; i < targetSubElementTypes.length; ++i) {
                if (((Object)targetSubElementTypes[i]).toString().equals(((Object)this.storeMgr.getDatastoreClass(targetElementType, this.clr)).toString())) continue;
                DatastoreIdentifier tiTargetSubElementType = this.storeMgr.getIdentifierFactory().newIdentifier(0, "SUBELEMENT" + subSequenceIdentifier++);
                QueryExpression targetQS = this.dba.newQueryStatement(targetSubElementTypes[i], tiTargetSubElementType, stmt.getClassLoaderResolver());
                LogicSetExpression teTargetSubElementType = targetQS.newTableExpression(targetSubElementTypes[i], tiTargetSubElementType);
                JavaTypeMapping targetMapping = targetSubElementTypes[i].getIDMapping();
                ScalarExpression targetElementExpr = targetElementMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
                ScalarExpression targetSubElementTypeExpr = targetMapping.newScalarExpression(stmt, teTargetSubElementType);
                stmt.leftOuterJoin(targetElementExpr, targetSubElementTypeExpr, teTargetSubElementType, true);
                ScalarExpression seTargetSubElementType = targetMapping.newScalarExpression(targetQS, teTargetSubElementType);
                stmt.andCondition(new NullLiteral(stmt).eq(seTargetSubElementType));
            }
        }
    }

    private void selectMetadata(QueryExpression stmt, String pcClass, boolean allowNull) {
        int maxClassNameLen = this.candidateFullClassName.length();
        boolean hasSubClasses = false;
        Iterator iterator = this.storeMgr.getSubClassesForClass(this.candidateFullClassName, true, this.clr).iterator();
        if (iterator.hasNext()) {
            hasSubClasses = true;
            while (iterator.hasNext()) {
                String nextClass = (String)iterator.next();
                if (nextClass.length() <= maxClassNameLen) continue;
                maxClassNameLen = nextClass.length();
            }
        }
        if (this.withMetadata == null && hasSubClasses || this.withMetadata != null && this.withMetadata.booleanValue()) {
            if (allowNull) {
                NullLiteral nullLtl = new NullLiteral(stmt);
                nullLtl.as("NUCMETADATA");
                stmt.selectScalarExpression(nullLtl);
            } else {
                String classname = pcClass;
                if (maxClassNameLen > classname.length()) {
                    classname = StringUtils.leftAlignedPaddedString((String)pcClass, (int)maxClassNameLen);
                }
                stmt.selectScalarExpression(new MetaDataStringLiteral(stmt, classname));
            }
        }
    }
}

