/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.key.PrimaryKey;

public class SAPDBAdapter
extends DatabaseAdapter {
    public SAPDBAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("BooleanExpression");
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.remove("AlterTableDropConstraint_Syntax");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.add("BitIsReallyBoolean");
        this.supportedOptions.add("OrderByUsingSelectColumnIndex");
        this.supportedOptions.remove("FkUpdateActionCascade");
        this.supportedOptions.remove("FkUpdateActionDefault");
        this.supportedOptions.remove("FkUpdateActionNull");
        this.supportedOptions.remove("FkUpdateActionRestrict");
    }

    public String getVendorID() {
        return "sapdb";
    }

    public String getSelectWithLockOption() {
        return "EXCLUSIVE LOCK";
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return "ALTER TABLE " + pk.getDatastoreContainerObject().toString() + " ADD " + pk;
    }

    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        Index idx = new Index(ck);
        idx.setName(ck.getName());
        return this.getCreateIndexStatement(idx, factory);
    }

    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        return "ALTER TABLE " + fk.getDatastoreContainerObject().toString() + " ADD " + fk;
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        if (min != null && min.length() > 0) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null && max.length() > 0) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null && start.length() > 0) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null && increment.length() > 0) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cache_size != null && cache_size.length() > 0) {
            stmt.append(" CACHE " + cache_size);
        } else {
            stmt.append(" NOCACHE");
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new NucleusUserException(LOCALISER.msg("051028"));
        }
        StringBuffer stmt = new StringBuffer("SELECT ");
        stmt.append(sequence_name);
        stmt.append(".nextval FROM dual");
        return stmt.toString();
    }

    public NumericExpression getNumericExpressionForMethod(String method, ScalarExpression expr) {
        if (method.equalsIgnoreCase("length")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            return new NumericExpression("LENGTH", args);
        }
        return super.getNumericExpressionForMethod(method, expr);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(BigInteger.class, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(Integer.class, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTR", args);
    }
}

