/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreData;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.MetaDataStringLiteral;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.RDBMSStoreData;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.query.DiscriminatorIteratorStatement;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class RDBMSStoreHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdKeyUsingUnion(ObjectManager om, RDBMSManager storeMgr, Object id, List schemaDataOptions) {
        String className = null;
        if (schemaDataOptions == null || id == null || schemaDataOptions.size() == 0) {
            return null;
        }
        int metadata_id_len = 0;
        for (RDBMSStoreData schemaDataOption : schemaDataOptions) {
            metadata_id_len = Math.max(schemaDataOption.getName().length(), metadata_id_len);
        }
        QueryExpression qs_base = null;
        for (RDBMSStoreData schemaDataOption : schemaDataOptions) {
            ClassMetaData cmd = (ClassMetaData)schemaDataOption.getMetaData();
            QueryExpression qs = storeMgr.getDatastoreAdapter().newQueryStatement(schemaDataOption.getDatastoreContainerObject(), null, om.getClassLoaderResolver());
            String classname = StringUtils.leftAlignedPaddedString((String)schemaDataOption.getName(), (int)metadata_id_len);
            qs.selectScalarExpression(new MetaDataStringLiteral(qs, classname));
            Iterator subclass_iter = storeMgr.getSubClassesForClass(schemaDataOption.getName(), false, om.getClassLoaderResolver()).iterator();
            int subclasses_seq_id = 0;
            while (subclass_iter.hasNext()) {
                String subclass = (String)subclass_iter.next();
                DatastoreClass subclassTable = storeMgr.getDatastoreClass(subclass, om.getClassLoaderResolver());
                if (subclassTable == null || subclassTable.getIdentifier().equals(schemaDataOption.getDatastoreContainerObject().getIdentifier())) continue;
                DatastoreIdentifier subclassTableIdentifier = storeMgr.getIdentifierFactory().newIdentifier(0, "SUBCLASS" + subclasses_seq_id++);
                QueryExpression st = storeMgr.getDatastoreAdapter().newQueryStatement(subclassTable, subclassTableIdentifier, om.getClassLoaderResolver());
                LogicSetExpression table_expr_sub = st.newTableExpression(subclassTable, subclassTableIdentifier);
                JavaTypeMapping subMapping = subclassTable.getIDMapping();
                st.select(subclassTableIdentifier, subMapping);
                ScalarExpression subExpr = subMapping.newScalarExpression(qs, table_expr_sub);
                ScalarExpression schExpr = ((DatastoreClass)schemaDataOption.getDatastoreContainerObject()).getIDMapping().newScalarExpression(qs, qs.getMainTableExpression());
                qs.leftOuterJoin(subExpr, schExpr, table_expr_sub, true);
                qs.andCondition(new NullLiteral(qs).eq(subExpr));
            }
            JavaTypeMapping idMapping = ((DatastoreClass)schemaDataOption.getDatastoreContainerObject()).getIDMapping();
            Class pc_class = om.getClassLoaderResolver().classForName(schemaDataOption.getName());
            StateManager sm = StateManagerFactory.newStateManagerForHollow((ObjectManager)om, (Class)pc_class, (Object)id);
            ScalarExpression fieldExpr = idMapping.newScalarExpression(qs, qs.getMainTableExpression());
            ScalarExpression fieldValue = idMapping.newLiteral(qs, sm.getObject());
            qs.andCondition(fieldExpr.eq(fieldValue), true);
            JavaTypeMapping discrimMapping = schemaDataOption.getDatastoreContainerObject().getDiscriminatorMapping(false);
            DiscriminatorMetaData discrimMetaData = cmd.getInheritanceMetaData().getDiscriminatorMetaData();
            if (discrimMapping != null) {
                ScalarExpression discrimExpr = discrimMapping.newScalarExpression(qs, qs.getMainTableExpression());
                String value = null;
                if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                    value = schemaDataOption.getName();
                } else if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                    value = discrimMetaData.getValue();
                }
                ScalarExpression discrimValue = discrimMapping.newLiteral(qs, value);
                qs.andCondition(discrimExpr.eq(discrimValue), true);
            }
            if (qs_base == null) {
                qs_base = qs;
                continue;
            }
            qs_base.union(qs);
        }
        try {
            Transaction tx = om.getTransaction();
            ManagedConnection mconn = storeMgr.getConnection(om);
            SQLController sqlControl = storeMgr.getSQLController();
            boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
            String statement = storeMgr.getStatementTextForQuery(qs_base, useUpdateLock);
            try {
                PreparedStatement ps = storeMgr.getStatementForQuery(qs_base, om, mconn, useUpdateLock, null, null);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                    try {
                        if (rs != null) {
                            while (rs.next()) {
                                className = RDBMSQueryUtils.getClassNameFromMetaDataResultSetRow(rs);
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException sqe) {
            NucleusLogger.DATASTORE.error((Object)sqe);
            throw new NucleusDataStoreException(sqe.toString());
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdKeyUsingDiscriminator(ObjectManager om, RDBMSManager storeMgr, Object id, List schemaDataOptions) {
        Class primaryClass;
        String className = null;
        if (schemaDataOptions == null || schemaDataOptions.size() == 0 || id == null) {
            return null;
        }
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class objectClass = primaryClass = clr.classForName(((RDBMSStoreData)((Object)schemaDataOptions.get(0))).getName());
        if (Modifier.isAbstract(primaryClass.getModifiers())) {
            for (RDBMSStoreData data : schemaDataOptions) {
                Class dataClass = clr.classForName(data.getName());
                if (Modifier.isAbstract(dataClass.getModifiers())) continue;
                objectClass = dataClass;
                break;
            }
        }
        if (Modifier.isAbstract(objectClass.getModifiers())) {
            throw new NucleusException("Class " + objectClass.getName() + " is abstract, and a non abstract was expected.").setFatal();
        }
        DiscriminatorIteratorStatement discrimStmt = new DiscriminatorIteratorStatement(clr, new Class[]{primaryClass}, true, (StoreManager)storeMgr, true);
        DatastoreClass primaryTable = storeMgr.getDatastoreClass(primaryClass.getName(), clr);
        StoreData[] storeData = storeMgr.getStoreDataForDatastoreContainerObject(primaryTable.getIdentifier());
        boolean haveAllCandidates = true;
        for (int i = 0; i < storeData.length; ++i) {
            if (!(storeData[i] instanceof MappedStoreData)) continue;
            ClassTable tbl = (ClassTable)((MappedStoreData)storeData[i]).getDatastoreContainerObject();
            String[] managedClasses = tbl.getManagedClasses();
            for (int j = 0; j < managedClasses.length; ++j) {
                boolean managedClassFound = false;
                for (StoreData optionData : schemaDataOptions) {
                    if (!optionData.getName().equals(managedClasses[j])) continue;
                    managedClassFound = true;
                    break;
                }
                if (managedClassFound) continue;
                haveAllCandidates = false;
                break;
            }
            if (!haveAllCandidates) break;
        }
        if (haveAllCandidates) {
            discrimStmt.setRestrictDiscriminator(false);
        }
        QueryExpression stmt = discrimStmt.getQueryStatement(null);
        StateManager sm = StateManagerFactory.newStateManagerForHollow((ObjectManager)om, (Class)objectClass, (Object)id);
        JavaTypeMapping idMapping = primaryTable.getIDMapping();
        ScalarExpression fieldExpr = idMapping.newScalarExpression(stmt, stmt.getMainTableExpression());
        ScalarExpression fieldValue = idMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(fieldExpr.eq(fieldValue), true);
        try {
            Transaction tx = om.getTransaction();
            ManagedConnection mconn = storeMgr.getConnection(om);
            SQLController sqlControl = storeMgr.getSQLController();
            boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
            String statement = storeMgr.getStatementTextForQuery(stmt, useUpdateLock);
            try {
                PreparedStatement ps = storeMgr.getStatementForQuery(stmt, om, mconn, useUpdateLock, null, null);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(mconn, statement, ps);
                    try {
                        if (rs != null) {
                            while (rs.next()) {
                                className = RDBMSQueryUtils.getClassNameFromDiscriminatorResultSetRow(primaryTable, rs, om);
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException sqe) {
            NucleusLogger.DATASTORE.error((Object)sqe);
            throw new NucleusDataStoreException(sqe.toString());
        }
        return className;
    }

    public static boolean supportsTransactionIsolation(DatastoreAdapter dba, int level) {
        return level == 0 && dba.supportsOption("TxIsolationNone") || level == 2 && dba.supportsOption("TxIsolationReadCommitted") || level == 1 && dba.supportsOption("TxIsolationReadUncommitted") || level == 4 && dba.supportsOption("TxIsolationReadRepeatableRead") || level == 8 && dba.supportsOption("TxIsolationSerializable");
    }
}

