/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.HashMap;
import java.util.Map;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MultiMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.util.Localiser;

public class CorrespondentColumnsMapper {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.mapped.Localisation", (ClassLoader)MappedStoreManager.class.getClassLoader());
    private final Map columnMetaDataBySideBIdentifier = new HashMap();
    private final String columnsName;

    public CorrespondentColumnsMapper(ColumnMetaDataContainer columnContainer, ColumnMetaData[] colmds, JavaTypeMapping mappingSideB, boolean updateContainer) {
        if (columnContainer != null && colmds != null) {
            int i;
            int noOfUserColumns = colmds.length;
            StringBuffer str = new StringBuffer("Columns [");
            for (int i2 = 0; i2 < noOfUserColumns; ++i2) {
                str.append(colmds[i2].getName());
                if (i2 >= noOfUserColumns - 1) continue;
                str.append(", ");
            }
            str.append("]");
            this.columnsName = str.toString();
            if (noOfUserColumns > mappingSideB.getNumberOfDatastoreFields()) {
                throw new NucleusUserException(LOCALISER.msg("020003", (Object)this.columnsName, (Object)("" + noOfUserColumns), (Object)("" + mappingSideB.getNumberOfDatastoreFields()))).setFatal();
            }
            DatastoreIdentifier[] sideBidentifiers = new DatastoreIdentifier[mappingSideB.getNumberOfDatastoreFields()];
            boolean[] sideButilised = new boolean[mappingSideB.getNumberOfDatastoreFields()];
            for (int i3 = 0; i3 < mappingSideB.getNumberOfDatastoreFields(); ++i3) {
                sideBidentifiers[i3] = mappingSideB.getDataStoreMapping(i3).getDatastoreField().getIdentifier();
                sideButilised[i3] = false;
            }
            JavaTypeMapping[] sideBidMappings = null;
            sideBidMappings = mappingSideB instanceof PersistenceCapableMapping ? ((PersistenceCapableMapping)mappingSideB).getJavaTypeMapping() : ((MultiMapping)mappingSideB).getJavaTypeMapping();
            for (i = 0; i < noOfUserColumns; ++i) {
                int j;
                String targetFieldName;
                String targetColumnName = colmds[i].getTarget();
                if (targetColumnName == null && (targetFieldName = colmds[i].getTargetMember()) != null) {
                    for (j = 0; j < sideBidMappings.length; ++j) {
                        if (!sideBidMappings[j].getFieldMetaData().getName().equals(targetFieldName)) continue;
                        targetColumnName = sideBidMappings[j].getDataStoreMapping(0).getDatastoreField().getIdentifier().getIdentifier();
                        break;
                    }
                }
                if (targetColumnName == null) continue;
                boolean targetExists = false;
                for (j = 0; j < sideBidentifiers.length; ++j) {
                    if (!sideBidentifiers[j].getIdentifier().equalsIgnoreCase(targetColumnName) || sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    targetExists = true;
                    break;
                }
                if (targetExists) continue;
                throw new NucleusUserException(LOCALISER.msg("020004", (Object)this.columnsName, (Object)colmds[i].getName(), (Object)targetColumnName)).setFatal();
            }
            block5: for (i = 0; i < colmds.length; ++i) {
                if (colmds[i].getTarget() != null) continue;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    continue block5;
                }
            }
            for (i = colmds.length; i < mappingSideB.getNumberOfDatastoreFields(); ++i) {
                DatastoreIdentifier sideBidentifier = null;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    sideBidentifier = sideBidentifiers[j];
                    sideButilised[j] = true;
                    break;
                }
                if (sideBidentifier == null) {
                    throw new NucleusUserException(LOCALISER.msg("020005", (Object)this.columnsName, (Object)("" + i))).setFatal();
                }
                ColumnMetaData colmd = new ColumnMetaData((MetaData)columnContainer, (String)null);
                if (updateContainer) {
                    columnContainer.addColumn(colmd);
                }
                this.putColumn(sideBidentifier, colmd);
            }
        } else {
            this.columnsName = null;
            for (int i = 0; i < mappingSideB.getNumberOfDatastoreFields(); ++i) {
                DatastoreIdentifier sideBidentifier = mappingSideB.getDataStoreMapping(i).getDatastoreField().getIdentifier();
                ColumnMetaData colmd = new ColumnMetaData((MetaData)columnContainer, (String)null);
                this.putColumn(sideBidentifier, colmd);
            }
        }
    }

    public CorrespondentColumnsMapper(ColumnMetaDataContainer columnContainer, JavaTypeMapping mappingSideB, boolean updateContainer) {
        if (columnContainer != null) {
            int i;
            int noOfUserColumns = columnContainer.getColumnMetaData().length;
            ColumnMetaData[] colmds = columnContainer.getColumnMetaData();
            StringBuffer str = new StringBuffer("Columns [");
            for (int i2 = 0; i2 < noOfUserColumns; ++i2) {
                str.append(colmds[i2].getName());
                if (i2 >= noOfUserColumns - 1) continue;
                str.append(", ");
            }
            str.append("]");
            this.columnsName = str.toString();
            if (noOfUserColumns > mappingSideB.getNumberOfDatastoreFields()) {
                throw new NucleusUserException(LOCALISER.msg("020003", (Object)this.columnsName, (Object)("" + noOfUserColumns), (Object)("" + mappingSideB.getNumberOfDatastoreFields()))).setFatal();
            }
            DatastoreIdentifier[] sideBidentifiers = new DatastoreIdentifier[mappingSideB.getNumberOfDatastoreFields()];
            boolean[] sideButilised = new boolean[mappingSideB.getNumberOfDatastoreFields()];
            for (int i3 = 0; i3 < mappingSideB.getNumberOfDatastoreFields(); ++i3) {
                sideBidentifiers[i3] = mappingSideB.getDataStoreMapping(i3).getDatastoreField().getIdentifier();
                sideButilised[i3] = false;
            }
            JavaTypeMapping[] sideBidMappings = null;
            sideBidMappings = mappingSideB instanceof PersistenceCapableMapping ? ((PersistenceCapableMapping)mappingSideB).getJavaTypeMapping() : ((MultiMapping)mappingSideB).getJavaTypeMapping();
            for (i = 0; i < noOfUserColumns; ++i) {
                int j;
                String targetFieldName;
                String targetColumnName = colmds[i].getTarget();
                if (targetColumnName == null && (targetFieldName = colmds[i].getTargetMember()) != null) {
                    for (j = 0; j < sideBidMappings.length; ++j) {
                        if (!sideBidMappings[j].getFieldMetaData().getName().equals(targetFieldName)) continue;
                        targetColumnName = sideBidMappings[j].getDataStoreMapping(0).getDatastoreField().getIdentifier().getIdentifier();
                        break;
                    }
                }
                if (targetColumnName == null) continue;
                boolean targetExists = false;
                for (j = 0; j < sideBidentifiers.length; ++j) {
                    if (!sideBidentifiers[j].getIdentifier().equalsIgnoreCase(targetColumnName) || sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    targetExists = true;
                    break;
                }
                if (targetExists) continue;
                throw new NucleusUserException(LOCALISER.msg("020004", (Object)this.columnsName, (Object)colmds[i].getName(), (Object)targetColumnName)).setFatal();
            }
            block5: for (i = 0; i < colmds.length; ++i) {
                if (colmds[i].getTarget() != null) continue;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    this.putColumn(sideBidentifiers[j], colmds[i]);
                    sideButilised[j] = true;
                    continue block5;
                }
            }
            for (i = colmds.length; i < mappingSideB.getNumberOfDatastoreFields(); ++i) {
                DatastoreIdentifier sideBidentifier = null;
                for (int j = 0; j < sideBidentifiers.length; ++j) {
                    if (sideButilised[j]) continue;
                    sideBidentifier = sideBidentifiers[j];
                    sideButilised[j] = true;
                    break;
                }
                if (sideBidentifier == null) {
                    throw new NucleusUserException(LOCALISER.msg("020005", (Object)this.columnsName, (Object)("" + i))).setFatal();
                }
                ColumnMetaData colmd = new ColumnMetaData((MetaData)columnContainer, (String)null);
                if (updateContainer) {
                    columnContainer.addColumn(colmd);
                }
                this.putColumn(sideBidentifier, colmd);
            }
        } else {
            this.columnsName = null;
            for (int i = 0; i < mappingSideB.getNumberOfDatastoreFields(); ++i) {
                DatastoreIdentifier sideBidentifier = mappingSideB.getDataStoreMapping(i).getDatastoreField().getIdentifier();
                ColumnMetaData colmd = new ColumnMetaData((MetaData)columnContainer, (String)null);
                this.putColumn(sideBidentifier, colmd);
            }
        }
    }

    public ColumnMetaData getColumnMetaDataByIdentifier(DatastoreIdentifier name) {
        return (ColumnMetaData)this.columnMetaDataBySideBIdentifier.get(name);
    }

    private void putColumn(DatastoreIdentifier identifier, ColumnMetaData colmd) {
        if (this.columnMetaDataBySideBIdentifier.put(identifier, colmd) != null) {
            throw new NucleusUserException(LOCALISER.msg("020006", (Object)identifier, (Object)this.columnsName)).setFatal();
        }
    }
}

