/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ContainerMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.sco.SCO;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.store.exceptions.NoDatastoreMappingException;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public abstract class AbstractContainerMapping
extends SingleFieldMapping {
    protected String fieldName;
    protected MappedStoreManager storeMgr;

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.fieldName = fmd.getName();
        this.storeMgr = this.datastoreContainer.getStoreManager();
        ContainerMetaData conmd = fmd.getContainer();
        if (conmd == null) {
            throw new NucleusUserException(LOCALISER.msg("041023", (Object)fmd.getFullFieldName()));
        }
        if (!this.containerIsStoredInSingleColumn()) {
            this.storeMgr.newJoinDatastoreContainerObject(fmd, clr);
        }
    }

    protected void prepareDatastoreMapping() {
        if (this.containerIsStoredInSingleColumn()) {
            super.prepareDatastoreMapping();
        }
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return ClassNameConstants.JAVA_IO_SERIALIZABLE;
        }
        return super.getJavaTypeForDatastoreMapping(index);
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        if (this.fmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new NucleusException(this.failureMessage("setObject")).setFatal();
        }
        StateManager[] sms = null;
        ApiAdapter api = om.getApiAdapter();
        if (value != null) {
            HashSet<StateManager> smsColl = null;
            if (value instanceof Collection) {
                for (Object elem : (Collection)value) {
                    StateManager sm;
                    if (!api.isPersistable(elem) || (sm = om.findStateManager(elem)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet<StateManager>();
                    }
                    smsColl.add(sm);
                }
            } else if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    StateManager sm;
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (api.isPersistable(key) && (sm = om.findStateManager(key)) != null) {
                        if (smsColl == null) {
                            smsColl = new HashSet();
                        }
                        smsColl.add(sm);
                    }
                    if (!api.isPersistable(val) || (sm = om.findStateManager(val)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet();
                    }
                    smsColl.add(sm);
                }
            }
            if (smsColl != null) {
                sms = smsColl.toArray(new StateManager[smsColl.size()]);
            }
        }
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].setStoringPC();
            }
        }
        this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], value);
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].unsetStoringPC();
            }
        }
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (this.fmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new NucleusException(this.failureMessage("getObject")).setFatal();
        }
        return this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]);
    }

    public DatastoreContainerObject getDatastoreContainer() {
        if (this.containerIsStoredInSingleColumn()) {
            return this.datastoreContainer;
        }
        return null;
    }

    public int getNumberOfDatastoreFields() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getNumberOfDatastoreFields();
        }
        return 0;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDataStoreMapping(index);
        }
        throw new NoDatastoreMappingException(this.fieldName);
    }

    public DatastoreMapping[] getDataStoreMappings() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDataStoreMappings();
        }
        throw new NoDatastoreMappingException(this.fieldName);
    }

    protected boolean containerIsStoredInSingleColumn() {
        if (this.fmd != null && this.fmd.isSerialized()) {
            return true;
        }
        if (this.fmd != null && this.fmd.hasCollection() && SCOUtils.collectionHasSerialisedElements((AbstractMemberMetaData)this.fmd)) {
            return true;
        }
        if (this.fmd != null && this.fmd.hasMap() && SCOUtils.mapHasSerialisedKeysAndValues((AbstractMemberMetaData)this.fmd)) {
            return true;
        }
        if (this.fmd != null && this.fmd.hasArray() && SCOUtils.arrayIsStoredInSingleColumn((AbstractMemberMetaData)this.fmd)) {
            return !MetaDataUtils.getInstance().arrayStorableAsByteArrayInSingleColumn(this.fmd);
        }
        return false;
    }

    public boolean includeInFetchStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public boolean includeInUpdateStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public boolean includeInInsertStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public int hashCode() {
        return this.fmd == null || this.storeMgr == null ? super.hashCode() : this.fmd.hashCode() ^ ((Object)((Object)this.storeMgr)).hashCode();
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return null;
    }

    protected SCO replaceFieldWithWrapper(StateManager ownerSM, Object value, boolean forInsert, boolean forUpdate) {
        Class<List> type = this.fmd.getType();
        if (value != null) {
            type = value.getClass();
        } else if (this.fmd.getOrderMetaData() != null && type.isAssignableFrom(List.class)) {
            type = List.class;
        }
        SCO sco = SCOUtils.newSCOInstance((StateManager)ownerSM, (AbstractMemberMetaData)this.fmd, (Class)this.fmd.getType(), type, (Object)value, (boolean)forInsert, (boolean)forUpdate, (boolean)true);
        return sco;
    }

    public void postFetch(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        this.replaceFieldWithWrapper(sm, null, false, false);
    }
}

