/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.ObjectLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public class MapKeyLiteral
extends ScalarExpression {
    private final boolean isEmpty;
    private final boolean containsNull;
    private final DatastoreAdapter dba;
    private final Map map;
    private List scalarExpressions;

    public MapKeyLiteral(QueryExpression qs, JavaTypeMapping mapping, Map map) {
        super(qs);
        this.mapping = mapping;
        this.containsNull = map != null && map.containsValue(null);
        this.dba = qs.getStoreManager().getDatastoreAdapter();
        this.map = map;
        boolean bl = this.isEmpty = map == null || map.isEmpty() || map.size() == 1 && this.containsNull;
        if (!this.isEmpty) {
            this.st.append("(");
            this.scalarExpressions = new ArrayList();
            boolean hadPrev = false;
            Set keys = map.keySet();
            for (Object current : keys) {
                if (null == current) continue;
                JavaTypeMapping m = this.dba.getMapping(current.getClass(), qs.getStoreManager(), qs.getClassLoaderResolver());
                ScalarExpression expr = m.newLiteral(qs, current);
                this.st.append(hadPrev ? "," : "");
                this.st.append(expr);
                this.scalarExpressions.add(expr);
                hadPrev = true;
            }
            this.st.append(")");
        }
    }

    public BooleanExpression containsMethod(ScalarExpression expr) {
        if (this.isEmpty) {
            return new BooleanLiteral(this.qs, this.mapping, false);
        }
        ScalarExpression bExpr = null;
        for (int i = 0; i < this.scalarExpressions.size(); ++i) {
            bExpr = bExpr == null ? ((ScalarExpression)this.scalarExpressions.get(i)).eq(expr) : ((BooleanExpression)bExpr).ior(((ScalarExpression)this.scalarExpressions.get(i)).eq(expr));
        }
        bExpr.encloseWithInParentheses();
        return bExpr;
    }

    public ScalarExpression getMethod(ScalarExpression expr) {
        if (this.map == null) {
            return new NullLiteral(this.qs);
        }
        if (expr instanceof Literal) {
            Object value = this.map.get(((Literal)((Object)expr)).getValue());
            if (value == null) {
                return new NullLiteral(this.qs);
            }
            JavaTypeMapping m = this.dba.getMapping(value.getClass(), this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
            return new ObjectLiteral(this.qs, m, value);
        }
        throw new ScalarExpression.IllegalOperationException(this, "getMethod", expr);
    }

    public BooleanExpression isEmptyMethod() {
        return new BooleanLiteral(this.qs, this.mapping, this.isEmpty);
    }
}

