/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.query.Parser;
import org.datanucleus.util.Imports;

public class JPQLParser
extends Parser {
    public JPQLParser(String input, Imports imports) {
        super(input, imports);
    }

    public String parseIdentifier() {
        String identifier = super.parseIdentifier();
        if (identifier != null) {
            return identifier;
        }
        this.skipWS();
        char c = this.ci.current();
        if (!Character.isJavaIdentifierStart(c) && c != '?') {
            return null;
        }
        StringBuffer id = new StringBuffer();
        id.append(c);
        while (Character.isJavaIdentifierPart(c = this.ci.next())) {
            id.append(c);
        }
        return id.toString();
    }

    public Character parseCharacterLiteral() {
        this.skipWS();
        if (this.ci.current() != '\'') {
            return null;
        }
        char c = this.ci.next();
        if (c == '\uffff') {
            throw new NucleusUserException("Invalid character literal: " + this.input);
        }
        if (this.ci.next() != '\'') {
            throw new NucleusUserException("Invalid character literal: " + this.input);
        }
        this.ci.next();
        return new Character(c);
    }

    public String parseStringLiteral() {
        char c;
        this.skipWS();
        char quote = this.ci.current();
        if (quote != '\"' && quote != '\'') {
            return null;
        }
        StringBuffer lit = new StringBuffer();
        while ((c = this.ci.next()) != quote) {
            if (c == '\uffff') {
                throw new NucleusUserException("Invalid string literal: " + this.input);
            }
            lit.append(c);
        }
        this.ci.next();
        return lit.toString();
    }
}

