/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.TableExprAsJoins;
import org.datanucleus.store.mapped.expression.TableExprAsSubquery;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingManager;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.mapping.oracle.OracleRDBMSMappingManager;
import org.datanucleus.store.rdbms.query.Oracle99QueryStatement;
import org.datanucleus.store.rdbms.query.OracleQueryStatement;
import org.datanucleus.store.rdbms.schema.OracleTypeInfo;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.NucleusLogger;

public class OracleAdapter
extends DatabaseAdapter {
    public static final String ORACLE_8_RESERVED_WORDS = "ACCESS,AUDIT,CLUSTER,COMMENT,COMPRESS,EXCLUSIVE,FILE,IDENTIFIED,INCREMENT,INDEX,INITIAL,LOCK,LONG,MAXEXTENTS,MINUS,MLSLABEL,MODE,MODIFY,NOAUDIT,NOCOMPRESS,NOWAIT,NUMBER,OFFLINE,ONLINE,PCTFREE,RAW,RENAME,RESOURCE,ROWID,ROWNUM,SHARE,SUCCESSFUL,SYNONYM,SYSDATE,UID,VALIDATE,VARCHAR2,VALIDATE,VARCHAR2";
    public static final String ORACLE_9_RESERVED_WORDS = "ACCESS,CHAR,DEFAULT,ADD,CHECK,DELETE,ALL,CLUSTER,DESC,ALTER,COLUMN,DISTINCT,AND,COMMENT,DROP,ANY,COMPRESS,ELSE,AS,CONNECT,EXCLUSIVE,ASC,CREATE,EXISTS,AUDIT,CURRENT,FILE,BETWEEN,DATE,FLOAT,BY,DECIMAL,FOR,FROM,NOT,SHARE,GRANT,NOWAIT,SIZE,GROUP,NULL,SMALLINT,HAVING,NUMBER,START,IDENTIFIED,OF,SUCCESSFUL,IMMEDIATE,OFFLINE,SYNONYM,IN,ON,SYSDATE,INCREMENT,ONLINE,TABLE,INDEX,OPTION,THEN,INITIAL,OR,TO,INSERT,ORDER,TRIGGER,INTEGER,PCTFREE,UID,INTERSECT,PRIOR,UNION,INTO,PRIVILEGES,UNIQUE,IS,PUBLIC,UPDATE,LEVEL,RAW,USER,LIKE,RENAME,VALIDATE,LOCK,RESOURCE,VALUES,LONG,REVOKE,VARCHAR,MAXEXTENTS,ROW,VARCHAR2,MINUS,ROWID,VIEW,MLSLABEL,ROWNUM,WHENEVER,MODE,ROWS,WHERE,MODIFY,SELECT,WITH,NOAUDIT,SESSION,NOCOMPRESS,SET";
    public static final String ORACLE_10_RESERVED_WORDS = "ACCESS,ADD,ALL,ALTER,AND,ANY,AS,ASC,AUDIT,BETWEEN,BY,CHAR,CHECK,CLUSTER,COLUMN,COMMENT,COMPRESS,CONNECT,CREATE,CURRENT,DATE,DECIMAL,DEFAULT,DELETE,DESC,DISTINCT,DROP,ELSE,EXCLUSIVE,EXISTS,FILE,FLOAT,FOR,FROM,GRANT,GROUP,HAVING,IDENTIFIED,IMMEDIATE,IN,INCREMENT,INDEX,INITIAL,INSERT,INTEGER,INTERSECT,INTO,IS,LEVEL,LIKE,LOCK,LONG,MAXEXTENTS,MINUS,MLSLABEL,MODE,MODIFY,NOAUDIT,NOCOMPRESS,NOT,NOWAIT,NULL,NUMBER,OF,OFFLINE,ON,ONLINE,OPTION,OR,ORDER,PCTFREE,PRIOR,PRIVILEGES,PUBLIC,RAW,RENAME,RESOURCE,REVOKE,ROW,ROWID,ROWNUM,ROWS,SELECT,SESSION,SET,SHARE,SIZE,SMALLINT,START,SUCCESSFUL,SYNONYM,SYSDATE,TABLE,THEN,TO,TRIGGER,UID,UNION,UNIQUE,UPDATE,USER,VALIDATE,VALUES,VARCHAR,VARCHAR2,VIEW,WHENEVER,WHERE,WITH";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigInteger;

    public OracleAdapter(DatabaseMetaData metadata) {
        super(metadata);
        if (this.datastoreMajorVersion <= 8) {
            this.reservedKeywords.addAll(this.parseKeywordList(ORACLE_8_RESERVED_WORDS));
        } else if (this.datastoreMajorVersion == 9) {
            this.reservedKeywords.addAll(this.parseKeywordList(ORACLE_9_RESERVED_WORDS));
        } else if (this.datastoreMajorVersion >= 10) {
            this.reservedKeywords.addAll(this.parseKeywordList(ORACLE_10_RESERVED_WORDS));
        }
        this.supportedOptions.add("LockWithSelectForUpdate");
        this.supportedOptions.add("Sequences");
        this.supportedOptions.add("NullEqualsEmptyString");
        this.supportedOptions.remove("BooleanExpression");
        if (this.datastoreMajorVersion < 9) {
            this.supportedOptions.remove("ANSI_Join_Syntax");
        } else {
            this.supportedOptions.add("ANSI_Join_Syntax");
        }
    }

    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        OracleTypeInfo sqlType = new OracleTypeInfo("CLOB", 2005, 0x3FFFFFFF, "'", "'", null, 1, true, 0, false, false, false, "CLOB", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        sqlType = new OracleTypeInfo("DATE", 91, 7, null, null, null, 1, false, 3, false, false, false, "DATE", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)91, sqlType, true);
        sqlType = new OracleTypeInfo("DECIMAL", 3, 38, null, null, null, 1, false, 3, false, true, false, "NUMBER", -84, 127, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)3, sqlType, true);
        sqlType = new OracleTypeInfo("DOUBLE", 8, 38, null, null, null, 1, false, 3, false, true, false, "NUMBER", -84, 127, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)8, sqlType, true);
        sqlType = new OracleTypeInfo("SDO_GEOMETRY", 2002, 0, null, null, null, 1, false, 0, false, false, false, "SDO_GEOMETRY", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-123, sqlType, true);
        sqlType = new OracleTypeInfo("SYS.XMLTYPE", 2007, 0x3FFFFFFF, "'", "'", null, 1, true, 0, false, false, false, "SYS.XMLTYPE", 0, 0, 10);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2007, sqlType, true);
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new OracleTypeInfo(rs);
    }

    public String getVendorID() {
        return "oracle";
    }

    public String getSurrogateForEmptyStrings() {
        return "\u0001";
    }

    public String getCatalogName(Connection conn) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSchemaName(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        try {
            String string;
            String stmtText = "SELECT SYS_CONTEXT('USERENV', 'CURRENT_SCHEMA') FROM DUAL";
            ResultSet rs = stmt.executeQuery(stmtText);
            try {
                if (!rs.next()) {
                    throw new NucleusDataStoreException("No result returned from " + stmtText).setFatal();
                }
                string = rs.getString(1);
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return string;
        }
        finally {
            stmt.close();
        }
    }

    public boolean supportsForeignKeyDeleteAction(ForeignKey.FKAction action) {
        if (action == ForeignKey.CASCADE_ACTION) {
            return true;
        }
        return action == ForeignKey.NULL_ACTION;
    }

    public boolean supportsForeignKeyUpdateAction(ForeignKey.FKAction action) {
        return false;
    }

    public String getNonAnsiInnerJoinWhereClause(String col1, String col2) {
        if (this.datastoreMajorVersion < 9) {
            StringBuffer str = new StringBuffer();
            str.append(col1);
            str.append(" = ");
            str.append(col2);
            return str.toString();
        }
        return null;
    }

    public String getNonAnsiLeftOuterJoinWhereClause(String col1, String col2) {
        if (this.datastoreMajorVersion < 9) {
            StringBuffer str = new StringBuffer();
            str.append(col1);
            str.append(" = ");
            str.append(col2);
            str.append(" (+) ");
            return str.toString();
        }
        return null;
    }

    public String getNonAnsiRightOuterJoinWhereClause(String col1, String col2) {
        if (this.datastoreMajorVersion < 9) {
            StringBuffer str = new StringBuffer();
            str.append(col1);
            str.append(" (+) = ");
            str.append(col2);
            str.append(" ");
            return str.toString();
        }
        return null;
    }

    public ResultSet getExistingIndexes(Connection conn, String catalog, String schema, String table) throws SQLException {
        boolean isDriverBelow10_2_0_1;
        boolean bl = isDriverBelow10_2_0_1 = this.driverVersion.compareTo("10.2.0.1.0") < 0;
        if (isDriverBelow10_2_0_1 && this.isReservedKeyword(table)) {
            String GET_INDEXES_STMT = "SELECT null as table_cat, owner as table_schem, table_name, 0 as NON_UNIQUE, null as index_qualifier, null as index_name, 0 as type, 0 as ordinal_position, null as column_name, null as asc_or_desc, num_rows as cardinality, blocks as pages, null as filter_condition FROM all_tables WHERE table_name = ? AND owner = ? UNION SELECT null as table_cat, i.owner as table_schem, i.table_name, decode (i.uniqueness, 'UNIQUE', 0, 1), null as index_qualifier, i.index_name, 1 as type, c.column_position as ordinal_position, c.column_name, null as asc_or_desc, i.distinct_keys as cardinality, i.leaf_blocks as pages, null as filter_condition FROM all_indexes i, all_ind_columns c WHERE i.table_name = ? AND i.owner = ? AND i.index_name = c.index_name AND i.table_owner = c.table_owner AND i.table_name = c.table_name AND i.owner = c.index_owner ORDER BY non_unique, type, index_name, ordinal_position";
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Retrieving Oracle index info using the following SQL : " + GET_INDEXES_STMT));
            PreparedStatement stmt = conn.prepareStatement(GET_INDEXES_STMT);
            stmt.setString(1, table);
            stmt.setString(2, schema);
            stmt.setString(3, table);
            stmt.setString(4, schema);
            return stmt.executeQuery();
        }
        return super.getExistingIndexes(conn, catalog, schema, table);
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        if (this.datastoreMajorVersion >= 10) {
            return "DROP TABLE " + table.toString() + " CASCADE CONSTRAINTS PURGE";
        }
        return "DROP TABLE " + table.toString() + " CASCADE CONSTRAINTS";
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        if (sequence_name == null) {
            throw new UnsupportedOperationException("Adapter.SequenceNameNullNotSupported");
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        if (min != null && min.length() > 0) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null && max.length() > 0) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null && start.length() > 0) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null && increment.length() > 0) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cache_size != null && cache_size.length() > 0) {
            stmt.append(" CACHE " + cache_size);
        } else {
            stmt.append(" NOCACHE");
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new NucleusUserException(DatabaseAdapter.LOCALISER.msg("Adapter.SequenceNameNullNotSupported"));
        }
        StringBuffer stmt = new StringBuffer("SELECT ");
        stmt.append(sequence_name);
        stmt.append(".NEXTVAL from dual ");
        return stmt.toString();
    }

    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        String typeName = info.getTypeName();
        int dataType = -1;
        if (typeName == null) {
            dataType = 0;
        } else if (typeName.equals("ROWID")) {
            dataType = 4;
        } else if (typeName.equals("NUMBER") || typeName.equals("VARNUM")) {
            dataType = 2;
        } else if (typeName.equals("VARCHAR2")) {
            dataType = 12;
        } else if (typeName.equals("CHAR")) {
            dataType = 1;
        } else if (typeName.equals("DATE")) {
            dataType = 91;
        } else if (typeName.equals("CLOB") || typeName.equals("NCLOB")) {
            dataType = 2005;
        } else if (typeName.equals("BLOB")) {
            dataType = 2004;
        } else if (typeName.equals("LONG")) {
            dataType = -1;
        } else if (typeName.equals("LONG RAW")) {
            dataType = -4;
        } else if (typeName.equals("RAW")) {
            dataType = -3;
        } else if (typeName.startsWith("TIMESTAMP")) {
            dataType = 93;
        } else if (typeName.equals("FLOAT")) {
            dataType = 6;
        } else {
            NucleusLogger.DATASTORE.warn((Object)DatabaseAdapter.LOCALISER.msg("020191", (Object)typeName));
            dataType = 1111;
        }
        info.setDataType((short)dataType);
        return info;
    }

    public int getTransactionIsolationForSchemaCreation() {
        return 2;
    }

    public ResultSet getColumns(Connection conn, String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        StringBuffer columnsQuery = new StringBuffer();
        columnsQuery.append("SELECT NULL TABLE_CAT, OWNER TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, NULL DATA_TYPE, ");
        columnsQuery.append("DATA_TYPE TYPE_NAME, DECODE(DATA_TYPE,'NUMBER',DATA_PRECISION,DATA_LENGTH) COLUMN_SIZE, ");
        columnsQuery.append("0 BUFFER_LENGTH, DATA_SCALE DECIMAL_DIGITS, 10 NUM_PREC_RADIX, ");
        columnsQuery.append("DECODE(NULLABLE,'Y',1,0) NULLABLE, NULL REMARKS, NULL COLUMN_DEF, 0 SQL_DATA_TYPE, 0 SQL_DATETIME_SUB, ");
        columnsQuery.append("DATA_LENGTH CHAR_OCTET_LENGTH, COLUMN_ID ORDINAL_POSITION, DECODE(NULLABLE,'Y','YES','NO') IS_NULLABLE ");
        columnsQuery.append("FROM ALL_TAB_COLUMNS ");
        boolean outputWhere = false;
        if (schema != null && schema.length() > 0) {
            columnsQuery.append("WHERE OWNER LIKE '").append(schema.toUpperCase()).append("' ");
            outputWhere = true;
        }
        if (table != null) {
            if (!outputWhere) {
                columnsQuery.append("WHERE ");
                outputWhere = true;
            } else {
                columnsQuery.append("AND ");
            }
            if (table.length() > 0) {
                columnsQuery.append("TABLE_NAME LIKE '").append(table.toUpperCase()).append("' ");
            } else {
                columnsQuery.append("TABLE_NAME IS NULL ");
            }
        }
        columnsQuery.append("ORDER BY TABLE_SCHEM, TABLE_NAME, ORDINAL_POSITION ");
        NucleusLogger.DATASTORE_SCHEMA.debug((Object)("Retrieving Oracle column info using the following SQL : " + columnsQuery));
        Statement columnsStmt = conn.createStatement();
        ResultSet columnsResult = columnsStmt.executeQuery(columnsQuery.toString());
        columnsQuery = null;
        return columnsResult;
    }

    public MappingManager getNewMappingManager() {
        return new OracleRDBMSMappingManager();
    }

    public String getDatastoreDateStatement() {
        return "SELECT CURRENT_TIMESTAMP FROM DUAL";
    }

    public QueryExpression newQueryStatement(DatastoreContainerObject table, ClassLoaderResolver clr) {
        if (this.datastoreMajorVersion >= 9) {
            return new Oracle99QueryStatement(table, clr);
        }
        return new OracleQueryStatement(table, clr);
    }

    public QueryExpression newQueryStatement(DatastoreContainerObject table, DatastoreIdentifier rangeVar, ClassLoaderResolver clr) {
        if (this.datastoreMajorVersion >= 9) {
            return new Oracle99QueryStatement(table, rangeVar, clr);
        }
        return new OracleQueryStatement(table, rangeVar, clr);
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        if (this.datastoreMajorVersion >= 9) {
            return new TableExprAsJoins(qs, table, rangeVar);
        }
        return new TableExprAsSubquery(qs, table, rangeVar);
    }

    public NumericExpression getNumericExpressionForMethod(String method, ScalarExpression expr) {
        if (method.equalsIgnoreCase("length")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            return new NumericExpression("LENGTH", args);
        }
        if (method.equalsIgnoreCase("year")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, expr).newLiteral(expr.getQueryExpression(), "YYYY"));
            ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
            args1.add(new StringExpression("TO_CHAR", args));
            return new NumericExpression("TO_NUMBER", args1);
        }
        if (method.equalsIgnoreCase("month")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, expr).newLiteral(expr.getQueryExpression(), "MM"));
            ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
            args1.add(new StringExpression("TO_CHAR", args));
            JavaTypeMapping m = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OracleAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, expr);
            ScalarExpression integerLiteral = m.newLiteral(expr.getQueryExpression(), BigInteger.ONE);
            NumericExpression numExpr = new NumericExpression(new NumericExpression("TO_NUMBER", args1), ScalarExpression.OP_SUB, integerLiteral);
            numExpr.encloseWithInParentheses();
            return numExpr;
        }
        if (method.equalsIgnoreCase("day")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, expr).newLiteral(expr.getQueryExpression(), "DD"));
            ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
            args1.add(new StringExpression("TO_CHAR", args));
            return new NumericExpression("TO_NUMBER", args1);
        }
        if (method.equalsIgnoreCase("hour")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, expr).newLiteral(expr.getQueryExpression(), "HH24"));
            ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
            args1.add(new StringExpression("TO_CHAR", args));
            return new NumericExpression("TO_NUMBER", args1);
        }
        if (method.equalsIgnoreCase("minute")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, expr).newLiteral(expr.getQueryExpression(), "MI"));
            ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
            args1.add(new StringExpression("TO_CHAR", args));
            return new NumericExpression("TO_NUMBER", args1);
        }
        if (method.equalsIgnoreCase("second")) {
            ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
            args.add(expr);
            args.add(this.getMapping(class$java$lang$String == null ? (class$java$lang$String = OracleAdapter.class$("java.lang.String")) : class$java$lang$String, expr).newLiteral(expr.getQueryExpression(), "SS"));
            ArrayList<StringExpression> args1 = new ArrayList<StringExpression>();
            args1.add(new StringExpression("TO_CHAR", args));
            return new NumericExpression("TO_NUMBER", args1);
        }
        return super.getNumericExpressionForMethod(method, expr);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OracleAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OracleAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end.sub(begin));
        return new StringExpression("SUBSTR", args);
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new NumericExpression("MOD", args);
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = OracleAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(source);
        args.add(str);
        if (from != null) {
            args.add(new NumericExpression(from, ScalarExpression.OP_ADD, integerLiteral));
        }
        NumericExpression locateExpr = new NumericExpression("INSTR", args);
        return new NumericExpression(locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

